/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ClassType;
import recoder.abstraction.Method;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.MethodInfo;
import recoder.convenience.TreeWalker;
import recoder.java.Comment;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.StatementContainer;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.Assignment;
import recoder.java.expression.operator.New;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Return;
import recoder.kit.MiscKit;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.CrossReferenceSourceInfo;

public class ResolveGenerics
extends TwoPassTransformation {
    private final CompilationUnit cu;
    private List<TwoPassTransformation> parts;
    private List<ProgramElement> stuffToBeRemoved;
    private List<TwoPassTransformation> trParts;

    public ResolveGenerics(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cu = cu;
    }

    private static void analyze(ProgramFactory f, CrossReferenceSourceInfo ci, List<TypeParameterDeclaration> typeParams, List<ProgramElement> stuffToBeRemoved, List<IntroduceCast> casts, List<TypeParamRefReplacement> typeParamReferences) {
        int s = typeParams.size();
        for (int i = 0; i < s; ++i) {
            TypeReference repl;
            ClassType resolvedType;
            TypeParameterDeclaration tpd = typeParams.get(i);
            if (tpd.getBounds() == null || tpd.getBounds().size() == 0) {
                resolvedType = ci.getServiceConfiguration().getNameInfo().getJavaLangObject();
                repl = TypeKit.createTypeReference(ci, (Type)resolvedType, tpd);
            } else {
                resolvedType = (ClassType)ci.getType((TypeReference)tpd.getBounds().get(0));
                repl = ResolveGenerics.makeReplacement(f, tpd);
            }
            Type rt = tpd;
            do {
                List<TypeReference> tprl = ci.getReferences(rt);
                int t = tprl.size();
                for (int j = 0; j < t; ++j) {
                    TypeReference tr = tprl.get(j);
                    if (!(tr.getASTParent() instanceof TypeArgumentDeclaration)) {
                        typeParamReferences.add(new TypeParamRefReplacement(tr, repl.deepClone()));
                    } else {
                        stuffToBeRemoved.add(tr.getASTParent());
                    }
                    boolean alwaysCast = false;
                    while (tr.getASTParent() instanceof TypeArgumentDeclaration) {
                        tr = (TypeReference)tr.getASTParent().getASTParent();
                        alwaysCast = true;
                    }
                    if (!(tr.getASTParent() instanceof MethodDeclaration)) continue;
                    MethodDeclaration md = (MethodDeclaration)tr.getASTParent();
                    List<MemberReference> mrl = ci.getReferences(md);
                    block4: for (int k = 0; k < mrl.size(); ++k) {
                        Assignment as;
                        Type target;
                        MethodReference mr = (MethodReference)mrl.get(k);
                        NonTerminalProgramElement parent = mr.getASTParent();
                        if (parent instanceof MethodReference) {
                            ClassType tmpResolved = resolvedType;
                            MethodReference pr = (MethodReference)parent;
                            while (true) {
                                Type tmp;
                                ClassType target2;
                                if (!((target2 = ci.getMethod(pr).getContainingClassType()) == null || target2 instanceof TypeParameter || ci.isSubtype(tmpResolved, target2) && !alwaysCast)) {
                                    casts.add(new IntroduceCast(mr, TypeKit.createTypeReference(ci, (Type)target2, parent)));
                                }
                                if (!(pr.getReferenceSuffix() instanceof MethodReference) || !((tmp = ci.getType(pr)) instanceof ClassType)) continue block4;
                                tmpResolved = (ClassType)tmp;
                                mr = pr;
                                pr = (MethodReference)pr.getReferenceSuffix();
                            }
                        }
                        if (!(parent instanceof Expression) && !(parent instanceof VariableSpecification) && !(parent instanceof Return)) continue;
                        if (parent instanceof Return) {
                            while (!(parent instanceof MethodDeclaration)) {
                                parent = parent.getASTParent();
                            }
                            target = ((MethodDeclaration)parent).getReturnType();
                        } else {
                            target = ci.getType(parent);
                        }
                        if (!(target instanceof PrimitiveType || ci.isSubtype(resolvedType, (ClassType)target) || target instanceof TypeParameter)) {
                            casts.add(new IntroduceCast(mr, TypeKit.createTypeReference(ci, target, mr)));
                        }
                        if (!(parent instanceof Assignment) || (as = (Assignment)parent).getExpressionAt(0) != mr) continue;
                        casts.add(new IntroduceCast(as, TypeKit.createTypeReference(ci, target, as.getExpressionAt(1))));
                    }
                }
                rt = ci.getServiceConfiguration().getNameInfo().getArrayType(rt);
                repl.setDimensions(repl.getDimensions() + 1);
            } while (rt != null);
        }
    }

    private static TypeReference makeReplacement(ProgramFactory f, TypeParameterDeclaration tpd) {
        TypeReference repl = ((TypeReference)tpd.getBounds().get(0)).deepClone();
        if (tpd.getBoundCount() > 1) {
            StringBuffer text = new StringBuffer("/*");
            for (int x = 1; x < tpd.getBoundCount(); ++x) {
                text.append(" & ");
                text.append(tpd.getBoundName(x));
            }
            text.append(" */");
            repl.setComments(new ASTArrayList<Comment>(f.createComment(text.toString(), false)));
        }
        return repl;
    }

    @Override
    public ProblemReport analyze() {
        this.parts = new ArrayList<TwoPassTransformation>();
        this.stuffToBeRemoved = new ArrayList<ProgramElement>();
        this.trParts = new ArrayList<TwoPassTransformation>();
        TreeWalker tw = new TreeWalker(this.cu);
        while (tw.next()) {
            New n;
            TwoPassTransformation p;
            ProgramElement pe = tw.getProgramElement();
            NonTerminalProgramElement parent = pe.getASTParent();
            if (pe instanceof TypeDeclaration && !(pe instanceof TypeParameterDeclaration)) {
                p = new ResolveSingleGenericType(this.getServiceConfiguration(), (TypeDeclaration)pe);
                if (((ResolveSingleGenericType)p).analyze() == IDENTITY) continue;
                this.parts.add(p);
                continue;
            }
            if (pe instanceof MethodDeclaration) {
                p = new ResolveGenericMethod(this.getServiceConfiguration(), (MethodDeclaration)pe);
                if (((ResolveGenericMethod)p).analyze() == IDENTITY) continue;
                this.parts.add(p);
                continue;
            }
            if (pe instanceof TypeReference) {
                Type t;
                TypeReference tr = (TypeReference)pe;
                if (parent instanceof MethodDeclaration) {
                    CompilationUnit tcu;
                    Type t2;
                    MethodDeclaration md = (MethodDeclaration)parent;
                    if (md.getTypeReference() != tr || (t2 = this.getSourceInfo().getType(tr)) instanceof TypeDeclaration && !(t2 instanceof TypeParameterDeclaration) && (tcu = UnitKit.getCompilationUnit((TypeDeclaration)t2)) == this.cu) continue;
                    p = new ResolveMethodReturnType(this.getServiceConfiguration(), md);
                } else if (parent instanceof VariableDeclaration) {
                    CompilationUnit tcu;
                    t = this.getSourceInfo().getType(tr);
                    if (t instanceof TypeDeclaration && !(t instanceof TypeParameterDeclaration) && (tcu = UnitKit.getCompilationUnit((TypeDeclaration)t)) == this.cu) continue;
                    VariableDeclaration vd = (VariableDeclaration)parent;
                    p = new ResolveSingleVariableDeclaration(this.getServiceConfiguration(), vd);
                } else {
                    Method m;
                    if (parent instanceof InheritanceSpecification) {
                        t = this.getSourceInfo().getType(tr);
                        if (t instanceof TypeParameterDeclaration || tr.getTypeArguments() == null) continue;
                        List<Method> ml = ((InheritanceSpecification)parent).getParent().getAllMethods();
                        for (int i = 0; i < ml.size(); ++i) {
                            Method m2 = ml.get(i);
                            if (!(m2 instanceof MethodInfo) && UnitKit.getCompilationUnit((MethodDeclaration)m2) == this.cu || (p = new ResolveMethodReturnType(this.getServiceConfiguration(), m2)).analyze() == IDENTITY) continue;
                            this.trParts.add(p);
                        }
                        this.stuffToBeRemoved.addAll(tr.getTypeArguments());
                        continue;
                    }
                    if (!(parent instanceof MethodReference) || !(parent.getASTParent() instanceof MethodReference) || !((m = this.getSourceInfo().getMethod((MethodReference)parent.getASTParent())) instanceof MethodInfo) && UnitKit.getCompilationUnit((MethodDeclaration)m) == this.cu) continue;
                    p = new ResolveMethodReturnType(this.getServiceConfiguration(), m);
                }
                if (p.analyze() == IDENTITY) continue;
                this.trParts.add(p);
                continue;
            }
            if (!(pe instanceof New) || (n = (New)pe).getTypeReference().getTypeArguments() == null) continue;
            this.stuffToBeRemoved.addAll(n.getTypeReference().getTypeArguments());
        }
        if (this.parts.size() == 0 && this.stuffToBeRemoved.size() == 0) {
            return this.setProblemReport(IDENTITY);
        }
        return super.analyze();
    }

    @Override
    public void transform() {
        super.transform();
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            this.parts.get(i).transform();
        }
        for (TwoPassTransformation tp : this.trParts) {
            tp.transform();
        }
        for (ProgramElement pe : this.stuffToBeRemoved) {
            if (pe.getASTParent().getIndexOfChild(pe) == -1) continue;
            this.detach(pe);
        }
    }

    public static class ResolveSingleVariableDeclaration
    extends TwoPassTransformation {
        private final VariableDeclaration vd;
        private final TypeReference tr;
        private List<ProgramElement> stuffToBeRemoved;
        private List<IntroduceCast> casts;

        public ResolveSingleVariableDeclaration(CrossReferenceServiceConfiguration sc, VariableDeclaration vd) {
            super(sc);
            this.vd = vd;
            this.tr = vd.getTypeReference();
        }

        @Override
        public ProblemReport analyze() {
            if (this.tr.getTypeArguments() == null || this.tr.getTypeArguments().size() == 0) {
                return IDENTITY;
            }
            CrossReferenceSourceInfo ci = this.getCrossReferenceSourceInfo();
            this.stuffToBeRemoved = new ArrayList<ProgramElement>();
            this.stuffToBeRemoved.addAll(this.tr.getTypeArguments());
            this.casts = new ArrayList<IntroduceCast>();
            int s = this.vd.getVariables().size();
            for (int i = 0; i < s; ++i) {
                VariableSpecification vs = this.vd.getVariables().get(i);
                List<VariableReference> vrl = ci.getReferences(vs);
                int t = vrl.size();
                for (int j = 0; j < t; ++j) {
                    Type ty;
                    VariableReference vr = vrl.get(j);
                    NonTerminalProgramElement parent = vr.getASTParent();
                    while (parent instanceof MethodReference && (ty = ci.getType((MethodReference)parent)) instanceof ClassType) {
                        if (!(ty instanceof TypeParameter)) {
                            this.casts.add(new IntroduceCast((MethodReference)parent, TypeKit.createTypeReference(ci, ty, parent)));
                        }
                        parent = ((MethodReference)parent).getReferenceSuffix();
                    }
                }
            }
            return super.analyze();
        }

        @Override
        public void transform() {
            ProgramFactory f = this.getProgramFactory();
            for (IntroduceCast c : this.casts) {
                MiscKit.unindent(c.toBeCasted);
                if (c.toBeCasted.getASTParent().getIndexOfChild(c.toBeCasted) == -1 || c.toBeCasted.getASTParent() instanceof StatementContainer) continue;
                this.replace(c.toBeCasted, f.createParenthesizedExpression(f.createTypeCast(c.toBeCasted.deepClone(), c.castedType)));
            }
            for (ProgramElement pe : this.stuffToBeRemoved) {
                if (pe.getASTParent().getIndexOfChild(pe) == -1) continue;
                this.detach(pe);
            }
        }
    }

    public static class ResolveMethodReturnType
    extends TwoPassTransformation {
        private final Method md;
        private TypeReference tr;
        private List<ProgramElement> stuffToBeRemoved;
        private List<IntroduceCast> casts;

        public ResolveMethodReturnType(CrossReferenceServiceConfiguration sc, Method md) {
            super(sc);
            this.md = md;
            if (md instanceof MethodDeclaration) {
                this.tr = ((MethodDeclaration)md).getTypeReference();
            }
        }

        @Override
        public ProblemReport analyze() {
            Type returnType = this.md.getReturnType();
            if (!(returnType instanceof ParameterizedType) && !(returnType instanceof TypeParameter)) {
                return IDENTITY;
            }
            CrossReferenceSourceInfo ci = this.getCrossReferenceSourceInfo();
            this.stuffToBeRemoved = new ArrayList<ProgramElement>();
            if (this.md instanceof MethodDeclaration && this.tr.getTypeArguments() != null) {
                this.stuffToBeRemoved.addAll(this.tr.getTypeArguments());
            }
            this.casts = new ArrayList<IntroduceCast>();
            List<MemberReference> mrl = ci.getReferences(this.md);
            int t = mrl.size();
            for (int j = 0; j < t; ++j) {
                Type ty;
                MethodReference vr = (MethodReference)mrl.get(j);
                NonTerminalProgramElement parent = vr.getASTParent();
                while (parent instanceof MethodReference && (ty = ci.getType((MethodReference)parent)) instanceof ClassType) {
                    if (!(ty instanceof TypeParameter)) {
                        this.casts.add(new IntroduceCast(vr, TypeKit.createTypeReference(ci, this.getSourceInfo().getType(vr), parent)));
                    }
                    parent = ((MethodReference)parent).getReferenceSuffix();
                }
            }
            return super.analyze();
        }

        @Override
        public void transform() {
            ProgramFactory f = this.getProgramFactory();
            for (IntroduceCast c : this.casts) {
                MiscKit.unindent(c.toBeCasted);
                if (c.toBeCasted.getASTParent().getIndexOfChild(c.toBeCasted) == -1 || c.toBeCasted.getASTParent() instanceof StatementContainer) continue;
                this.replace(c.toBeCasted, f.createParenthesizedExpression(f.createTypeCast(c.toBeCasted.deepClone(), c.castedType)));
            }
            if (this.md instanceof MethodDeclaration) {
                for (ProgramElement pe : this.stuffToBeRemoved) {
                    if (pe.getASTParent().getIndexOfChild(pe) == -1) continue;
                    this.detach(pe);
                }
            }
        }
    }

    public static class ResolveGenericMethod
    extends TwoPassTransformation {
        private final MethodDeclaration md;
        private List<ProgramElement> stuffToBeRemoved;
        private List<IntroduceCast> casts;
        private List<TypeParamRefReplacement> typeParamReferences;

        public ResolveGenericMethod(CrossReferenceServiceConfiguration sc, MethodDeclaration md) {
            super(sc);
            this.md = md;
        }

        @Override
        public ProblemReport analyze() {
            List typeParams = this.md.getTypeParameters();
            if (typeParams == null || typeParams.size() == 0) {
                return this.setProblemReport(IDENTITY);
            }
            ProgramFactory f = this.getProgramFactory();
            this.stuffToBeRemoved = new ArrayList<ProgramElement>(100);
            this.casts = new ArrayList<IntroduceCast>();
            this.typeParamReferences = new ArrayList<TypeParamRefReplacement>();
            CrossReferenceSourceInfo ci = this.getCrossReferenceSourceInfo();
            ResolveGenerics.analyze(f, ci, typeParams, this.stuffToBeRemoved, this.casts, this.typeParamReferences);
            List<MemberReference> mrl = ci.getReferences(this.md);
            int s = mrl.size();
            for (int i = 0; i < s; ++i) {
                MethodReference mr = (MethodReference)mrl.get(i);
                ASTList<TypeArgumentDeclaration> typeArgs = mr.getTypeArguments();
                if (typeArgs == null || typeArgs.size() == 0) continue;
                this.stuffToBeRemoved.addAll(typeArgs);
            }
            this.stuffToBeRemoved.addAll(typeParams);
            return super.analyze();
        }

        @Override
        public void transform() {
            super.transform();
            if (this.getProblemReport() == IDENTITY) {
                return;
            }
            ProgramFactory f = this.getProgramFactory();
            for (IntroduceCast c : this.casts) {
                MiscKit.unindent(c.toBeCasted);
                if (c.toBeCasted.getASTParent() instanceof StatementContainer) continue;
                this.replace(c.toBeCasted, f.createParenthesizedExpression(f.createTypeCast(c.toBeCasted.deepClone(), c.castedType)));
            }
            for (TypeParamRefReplacement t : this.typeParamReferences) {
                MiscKit.unindent(t.replacement);
                this.replace(t.typeParamRef, t.replacement);
            }
            for (ProgramElement tbr : this.stuffToBeRemoved) {
                if (tbr.getASTParent().getChildPositionCode(tbr) == -1) continue;
                this.detach(tbr);
            }
            MiscKit.unindent(this.md);
        }
    }

    public static class ResolveSingleGenericType
    extends TwoPassTransformation {
        private final TypeDeclaration td;
        private List<ProgramElement> stuffToBeRemoved;
        private List<IntroduceCast> casts;
        private List<TypeParamRefReplacement> typeParamReferences;

        ResolveSingleGenericType(CrossReferenceServiceConfiguration sc, TypeDeclaration td) {
            super(sc);
            this.td = td;
        }

        @Override
        public ProblemReport analyze() {
            List typeParams = this.td.getTypeParameters();
            if (typeParams == null || typeParams.size() == 0) {
                return this.setProblemReport(IDENTITY);
            }
            this.stuffToBeRemoved = new ArrayList<ProgramElement>(100);
            this.casts = new ArrayList<IntroduceCast>();
            this.typeParamReferences = new ArrayList<TypeParamRefReplacement>();
            CrossReferenceSourceInfo ci = this.getCrossReferenceSourceInfo();
            ResolveGenerics.analyze(this.getProgramFactory(), ci, typeParams, this.stuffToBeRemoved, this.casts, this.typeParamReferences);
            List<TypeReference> trl = ci.getReferences(this.td);
            int s = trl.size();
            for (int i = 0; i < s; ++i) {
                TypeReference tr = trl.get(i);
                ASTList<TypeArgumentDeclaration> typeArgs = tr.getTypeArguments();
                if (typeArgs == null || typeArgs.size() == 0) continue;
                this.stuffToBeRemoved.addAll(typeArgs);
            }
            this.stuffToBeRemoved.addAll(typeParams);
            return super.analyze();
        }

        @Override
        public void transform() {
            super.transform();
            if (this.getProblemReport() == IDENTITY) {
                return;
            }
            ProgramFactory f = this.getProgramFactory();
            for (IntroduceCast c : this.casts) {
                MiscKit.unindent(c.toBeCasted);
                if (c.toBeCasted.getASTParent() instanceof StatementContainer) continue;
                this.replace(c.toBeCasted, f.createParenthesizedExpression(f.createTypeCast(c.toBeCasted.deepClone(), c.castedType)));
            }
            for (TypeParamRefReplacement t : this.typeParamReferences) {
                MiscKit.unindent(t.replacement);
                this.replace(t.typeParamRef, t.replacement);
            }
            for (ProgramElement tbr : this.stuffToBeRemoved) {
                if (tbr.getASTParent().getChildPositionCode(tbr) == -1) continue;
                this.detach(tbr);
            }
            MiscKit.unindent(this.td);
        }
    }

    private static class TypeParamRefReplacement {
        TypeReference typeParamRef;
        TypeReference replacement;

        TypeParamRefReplacement(TypeReference from, TypeReference to) {
            this.typeParamRef = from;
            this.replacement = to;
            this.replacement.setTypeArguments(null);
        }
    }

    private static class IntroduceCast {
        Expression toBeCasted;
        TypeReference castedType;

        IntroduceCast(Expression e, TypeReference tr) {
            this.toBeCasted = e;
            this.castedType = tr;
        }
    }
}

