/*
 * Decompiled with CFR 0.152.
 */
package recoder.kit.transformation.java5to4;

import java.util.ArrayList;
import java.util.List;
import recoder.CrossReferenceServiceConfiguration;
import recoder.ProgramFactory;
import recoder.abstraction.ArrayType;
import recoder.abstraction.Type;
import recoder.convenience.TreeWalker;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.ProgramElement;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.operator.NewArray;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.kit.ProblemReport;
import recoder.kit.TwoPassTransformation;
import recoder.kit.TypeKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;

public class ResolveVarArgs
extends TwoPassTransformation {
    private final CompilationUnit cu;
    private List<MethodDeclaration> varArgMeths;
    private List<MethodReference> refs;
    private List<List<Type>> sigs;
    private List<Type> lastParamTypes;

    public ResolveVarArgs(CrossReferenceServiceConfiguration sc, CompilationUnit cu) {
        super(sc);
        this.cu = cu;
    }

    @Override
    public ProblemReport analyze() {
        this.varArgMeths = new ArrayList<MethodDeclaration>();
        this.refs = new ArrayList<MethodReference>();
        this.sigs = new ArrayList<List<Type>>();
        this.lastParamTypes = new ArrayList<Type>();
        TreeWalker tw = new TreeWalker(this.cu);
        while (tw.next()) {
            MethodDeclaration md;
            ProgramElement pe = tw.getProgramElement();
            if (!(pe instanceof MethodDeclaration) || !(md = (MethodDeclaration)pe).isVarArgMethod()) continue;
            this.varArgMeths.add(md);
            this.lastParamTypes.add(this.getSourceInfo().getType(md.getParameterDeclarationAt(md.getParameterDeclarationCount() - 1).getTypeReference()));
            List<MemberReference> rl = this.getCrossReferenceSourceInfo().getReferences(md);
            int s = rl.size();
            for (int i = 0; i < s; ++i) {
                MethodReference toAdd = (MethodReference)rl.get(i);
                if (toAdd.getArguments() != null && toAdd.getArguments().size() == md.getParameterDeclarationCount()) {
                    int idx = toAdd.getArguments().size() - 1;
                    Type tt = this.getSourceInfo().getType(toAdd.getExpressionAt(idx));
                    if (tt instanceof ArrayType && tt.equals(this.getSourceInfo().getType(md.getParameterDeclarationAt(idx).getVariableSpecification()))) continue;
                }
                this.refs.add(toAdd);
                this.sigs.add(this.getSourceInfo().getMethod(toAdd).getSignature());
            }
        }
        return this.setProblemReport(NO_PROBLEM);
    }

    @Override
    public void transform() {
        super.transform();
        ProgramFactory f = this.getProgramFactory();
        int idx = 0;
        for (MethodReference mr : this.refs) {
            List<Type> sig = this.sigs.get(idx++);
            int from = sig.size() - 1;
            int cnt = mr.getArguments() == null ? 0 : mr.getArguments().size() - from;
            ASTArrayList<int> eml = new ASTArrayList<int>(cnt);
            for (int i = 0; i < cnt; ++i) {
                eml.add((int)((Expression)mr.getArguments().get(from + i)).deepClone());
            }
            ArrayInitializer ai = f.createArrayInitializer(eml);
            NewArray na = f.createNewArray(TypeKit.createTypeReference(f, sig.get(sig.size() - 1)), 0, ai);
            MethodReference repl = mr.deepClone();
            while (cnt-- > 0) {
                repl.getArguments().remove(repl.getArguments().size() - 1);
            }
            if (repl.getArguments() == null) {
                repl.setArguments(new ASTArrayList<boolean>(false));
            }
            repl.getArguments().add(na);
            repl.makeParentRoleValid();
            this.replace(mr, repl);
        }
        idx = 0;
        for (MethodDeclaration md : this.varArgMeths) {
            MethodDeclaration repl = md.deepClone();
            ASTList<ParameterDeclaration> pds = md.getParameters();
            ParameterDeclaration pd = (ParameterDeclaration)pds.get(pds.size() - 1);
            ParameterDeclaration newpd = f.createParameterDeclaration(TypeKit.createTypeReference(f, this.getNameInfo().createArrayType(this.lastParamTypes.get(idx++))), pd.getVariableSpecification().getIdentifier().deepClone());
            newpd.setVarArg(false);
            this.replace(repl.getParameterDeclarationAt(repl.getParameterDeclarationCount() - 1), newpd);
            repl.makeParentRoleValid();
            this.replace(md, repl);
        }
    }
}

