/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.LoopInitializer;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.ProgramElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.declaration.AnnotationElementValuePair;
import recoder.java.declaration.AnnotationPropertyDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.DeclarationSpecifier;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.LocalVariableDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Operator;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayLengthReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceInfix;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Assert;
import recoder.java.statement.Branch;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Default;
import recoder.java.statement.Else;
import recoder.java.statement.ExpressionJumpStatement;
import recoder.java.statement.Finally;
import recoder.java.statement.If;
import recoder.java.statement.LabelJumpStatement;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Then;
import recoder.java.statement.Try;
import recoder.kit.Transformation;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTArrayList;
import recoder.list.generic.ASTList;
import recoder.service.AttachChange;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ChangeHistoryListener;
import recoder.service.DetachChange;
import recoder.service.IllegalChangeReportException;
import recoder.service.ModelUpdateListener;
import recoder.service.NoSuchTransformationException;
import recoder.service.TreeChange;
import recoder.util.Debug;

public class ChangeHistory
extends AbstractService {
    private static final boolean DEBUG = false;
    private final Map<ProgramElement, TreeChange> root2change = new HashMap<ProgramElement, TreeChange>();
    private final EventObject updateEvent = new EventObject(this);
    private List<TreeChange> changeList = new ArrayList<TreeChange>();
    private boolean needsUpdate = false;
    private boolean isUpdating = false;
    private boolean delayedUpdate = false;
    private Object[] reportStack = new Object[8];
    private int reportCount = 0;
    private ChangeHistoryListener[] changeListeners = new ChangeHistoryListener[0];
    private ModelUpdateListener[] updateListeners = new ModelUpdateListener[0];

    public ChangeHistory(ServiceConfiguration config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeHistoryListener(ChangeHistoryListener chl) {
        ChangeHistoryListener[] changeHistoryListenerArray = this.changeListeners;
        synchronized (this.changeListeners) {
            ChangeHistoryListener[] newListeners = new ChangeHistoryListener[this.changeListeners.length + 1];
            System.arraycopy(this.changeListeners, 0, newListeners, 0, this.changeListeners.length);
            newListeners[this.changeListeners.length] = chl;
            this.changeListeners = newListeners;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeHistoryListener(ChangeHistoryListener chl) {
        ChangeHistoryListener[] changeHistoryListenerArray = this.changeListeners;
        synchronized (this.changeListeners) {
            for (int i = this.changeListeners.length - 1; i >= 0; --i) {
                if (this.changeListeners[i] != chl) continue;
                ChangeHistoryListener[] newListeners = new ChangeHistoryListener[this.changeListeners.length - 1];
                if (i > 0) {
                    System.arraycopy(this.changeListeners, 0, newListeners, 0, i);
                }
                if (i < this.changeListeners.length - 1) {
                    System.arraycopy(this.changeListeners, i + 1, newListeners, i, this.changeListeners.length - 1 - i);
                }
                this.changeListeners = newListeners;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelUpdateListener(ModelUpdateListener l) {
        ModelUpdateListener[] modelUpdateListenerArray = this.updateListeners;
        synchronized (this.updateListeners) {
            ModelUpdateListener[] newListeners = new ModelUpdateListener[this.updateListeners.length + 1];
            System.arraycopy(this.updateListeners, 0, newListeners, 0, this.updateListeners.length);
            newListeners[this.updateListeners.length] = l;
            this.updateListeners = newListeners;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelUpdateListener(ModelUpdateListener l) {
        ModelUpdateListener[] modelUpdateListenerArray = this.updateListeners;
        synchronized (this.updateListeners) {
            for (int i = this.updateListeners.length - 1; i >= 0; --i) {
                if (this.updateListeners[i] != l) continue;
                ModelUpdateListener[] newListeners = new ModelUpdateListener[this.updateListeners.length - 1];
                if (i > 0) {
                    System.arraycopy(this.updateListeners, 0, newListeners, 0, i);
                }
                if (i < this.updateListeners.length - 1) {
                    System.arraycopy(this.updateListeners, i + 1, newListeners, i, this.updateListeners.length - 1 - i);
                }
                this.updateListeners = newListeners;
                break;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void checkConflict(TreeChange oldChange, TreeChange newChange) {
        boolean sameParent;
        boolean bl = sameParent = newChange.getChangeRootParent() == oldChange.getChangeRootParent();
        if (oldChange instanceof AttachChange) {
            if (newChange instanceof AttachChange) {
                if (sameParent) {
                    this.root2change.put(oldChange.getChangeRoot(), oldChange);
                    this.changeList.remove(this.changeList.size() - 1);
                } else {
                    throw new IllegalChangeReportException("Duplicate attachment of one element in different places: " + newChange + " followed " + oldChange);
                }
            }
            if (newChange instanceof DetachChange && sameParent) {
                // empty if block
            }
        } else if (oldChange instanceof DetachChange) {
            if (!(newChange instanceof AttachChange) || sameParent) {
                // empty if block
            }
            if (!(newChange instanceof DetachChange) || sameParent) {
                // empty if block
            }
        }
    }

    public void attached(ProgramElement root) {
        Debug.assertNonnull(root);
        Debug.assertBoolean(root.getASTParent() != null || root instanceof CompilationUnit);
        AttachChange ac = new AttachChange(root);
        this.enqueueChange(ac);
        this.pushChange(ac);
    }

    public void detached(ProgramElement root, NonTerminalProgramElement parent, int pos) {
        Debug.assertNonnull(root);
        Debug.assertBoolean(parent != null || root instanceof CompilationUnit);
        DetachChange dc = new DetachChange(root, parent, pos);
        this.enqueueChange(dc);
        this.pushChange(dc);
    }

    public void detached(ProgramElement root, int pos) {
        this.detached(root, root.getASTParent(), pos);
    }

    public void replaced(ProgramElement root, ProgramElement replacement) {
        Debug.assertNonnull((Object)root, replacement);
        NonTerminalProgramElement parent = replacement.getASTParent();
        Debug.assertBoolean(parent != null || replacement instanceof CompilationUnit);
        AttachChange ac = new AttachChange(replacement);
        DetachChange dc = new DetachChange(root, ac);
        this.enqueueChange(dc);
        this.enqueueChange(ac);
        this.pushChange(dc);
        this.pushChange(ac);
    }

    private void enqueueChange(TreeChange tc) {
        this.changeList.add(tc);
        TreeChange duplicate = this.root2change.put(tc.getChangeRoot(), tc);
        if (duplicate != null) {
            this.checkConflict(duplicate, tc);
        }
        this.needsUpdate = true;
    }

    private TreeChange getTailChange() {
        int s = this.changeList.size();
        return s == 0 ? null : this.changeList.get(s - 1);
    }

    private void removeTailChange() {
        int s = this.changeList.size();
        TreeChange tc = this.changeList.get(s - 1);
        this.root2change.remove(tc.getChangeRoot());
        this.changeList.remove(s - 1);
        if (s == 1) {
            this.needsUpdate = false;
        }
    }

    private void normalize() {
        int s = this.changeList.size();
        for (int i = 0; i < s; ++i) {
            TreeChange tc = this.changeList.get(i);
            ProgramElement current = tc.getChangeRoot();
            for (NonTerminalProgramElement parent = tc.getChangeRootParent(); parent != null; parent = parent.getASTParent()) {
                current = parent;
                if (!this.root2change.containsKey(current)) continue;
                tc.setMinor(true);
                current = UnitKit.getCompilationUnit(current);
                break;
            }
            tc.setCompilationUnit((CompilationUnit)current);
        }
    }

    public final boolean needsUpdate() {
        return this.needsUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateModel() {
        if (!this.needsUpdate) {
            return;
        }
        if (this.isUpdating) {
            this.delayedUpdate = true;
            return;
        }
        ModelUpdateListener[] modelUpdateListenerArray = this.updateListeners;
        synchronized (this.updateListeners) {
            int i;
            int s = this.updateListeners.length;
            if (s > 0) {
                for (i = 0; i < s; ++i) {
                    this.updateListeners[i].modelUpdating(this.updateEvent);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            do {
                this.needsUpdate = false;
                this.isUpdating = true;
                this.normalize();
                ChangeHistoryEvent event = new ChangeHistoryEvent(this, this.changeList);
                this.changeList = new ArrayList<TreeChange>();
                this.root2change.clear();
                ChangeHistoryListener[] listeners = this.changeListeners;
                int s2 = listeners.length;
                for (i = 0; i < s2; ++i) {
                    listeners[i].modelChanged(event);
                }
                this.isUpdating = false;
                if (!this.delayedUpdate) break;
                this.delayedUpdate = false;
            } while (this.needsUpdate);
            modelUpdateListenerArray = this.updateListeners;
            synchronized (this.updateListeners) {
                s = this.updateListeners.length;
                if (s > 0) {
                    for (i = 0; i < s; ++i) {
                        this.updateListeners[i].modelUpdated(this.updateEvent);
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    private void pushChange(TreeChange tc) {
        this.push(tc);
    }

    private void push(Object transformationOrTreeChange) {
        if (this.reportCount == this.reportStack.length) {
            Object[] newt = new Object[this.reportCount * 2];
            System.arraycopy(this.reportStack, 0, newt, 0, this.reportCount);
            this.reportStack = newt;
        }
        this.reportStack[this.reportCount++] = transformationOrTreeChange;
    }

    public void begin(Transformation transformation) {
        this.push(transformation);
    }

    private void rollback(int position) {
        while (this.reportCount > position) {
            --this.reportCount;
            if (this.reportStack[this.reportCount] instanceof TreeChange) {
                TreeChange lastChange = (TreeChange)this.reportStack[this.reportCount];
                TreeChange undoChange = this.undo(lastChange);
                if (lastChange == this.getTailChange()) {
                    this.removeTailChange();
                } else {
                    this.enqueueChange(undoChange);
                }
            }
            this.reportStack[this.reportCount] = null;
        }
    }

    private int locate(Transformation transformation) {
        int position = this.reportCount;
        while (position >= 0 && this.reportStack[--position] != transformation) {
        }
        return position;
    }

    public void rollback(Transformation transformation) throws NoSuchTransformationException {
        int position = this.locate(transformation);
        if (position < 0) {
            throw new NoSuchTransformationException(transformation);
        }
        this.rollback(position);
    }

    public void rollback() {
        this.rollback(0);
    }

    public boolean isReported(Transformation transformation) {
        return this.locate(transformation) >= 0;
    }

    public void commit() {
        while (this.reportCount > 0) {
            this.reportStack[--this.reportCount] = null;
        }
    }

    private TreeChange undo(TreeChange tc) {
        ProgramElement child = tc.getChangeRoot();
        NonTerminalProgramElement parent = tc.getChangeRootParent();
        if (tc instanceof AttachChange) {
            DetachChange result;
            if (parent != null) {
                int position = parent.getChildPositionCode(child);
                parent.replaceChild(child, null);
                result = new DetachChange(child, parent, position);
            } else {
                result = new DetachChange(child, null, 0);
            }
            return result;
        }
        if (!(tc instanceof DetachChange)) {
            return null;
        }
        DetachChange dc = (DetachChange)tc;
        int pos = dc.getChangePositionCode();
        int role = pos & 0xF;
        int index = pos >> 4;
        if (parent == null) {
            CompilationUnit x = (CompilationUnit)child;
            x.setDataLocation(null);
        } else if (parent instanceof CompilationUnit) {
            CompilationUnit x = (CompilationUnit)parent;
            switch (role) {
                case 0: {
                    x.setPackageSpecification((PackageSpecification)child);
                    break;
                }
                case 1: {
                    ASTList<Import> list = x.getImports();
                    if (list == null) {
                        list = new ASTArrayList<Import>();
                        x.setImports(list);
                    }
                    list.add(index, (Import)child);
                    break;
                }
                case 2: {
                    ASTList<TypeDeclaration> list2 = x.getDeclarations();
                    if (list2 == null) {
                        list2 = new ASTArrayList<TypeDeclaration>();
                        x.setDeclarations(list2);
                    }
                    list2.add(index, (TypeDeclaration)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Import) {
            Import x = (Import)parent;
            switch (role) {
                case 0: {
                    x.setReference((TypeReferenceInfix)child);
                    break;
                }
                case 1: {
                    x.setStaticIdentifier((Identifier)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof PackageSpecification) {
            PackageSpecification x = (PackageSpecification)parent;
            switch (role) {
                case 0: {
                    x.setPackageReference((PackageReference)child);
                    break;
                }
                case 1: {
                    ASTList<AnnotationUseSpecification> rpel = x.getAnnotations();
                    if (rpel == null) {
                        rpel = new ASTArrayList<AnnotationUseSpecification>();
                        x.setAnnotations(rpel);
                    }
                    rpel.add(index, (AnnotationUseSpecification)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof StatementBlock) {
            StatementBlock x = (StatementBlock)parent;
            ASTList<Statement> list = x.getBody();
            if (list == null) {
                list = new ASTArrayList<Statement>();
                x.setBody(list);
            }
            list.add(index, (Statement)child);
        } else if (parent instanceof ClassDeclaration) {
            ClassDeclaration x = (ClassDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 2: {
                    x.setExtendedTypes((Extends)child);
                    break;
                }
                case 3: {
                    x.setImplementedTypes((Implements)child);
                    break;
                }
                case 4: {
                    ASTList<MemberDeclaration> list2 = x.getMembers();
                    if (list2 == null) {
                        list2 = new ASTArrayList<MemberDeclaration>();
                        x.setMembers(list2);
                    }
                    list2.add(index, (MemberDeclaration)child);
                    break;
                }
                case 5: {
                    ASTArrayList<TypeParameterDeclaration> list3 = x.getTypeParameters();
                    if (list3 == null) {
                        list3 = new ASTArrayList<TypeParameterDeclaration>();
                        x.setTypeParameters(list3);
                    }
                    list3.add(index, (TypeParameterDeclaration)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof EnumDeclaration) {
            EnumDeclaration x = (EnumDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 2: {
                    x.setImplementedTypes((Implements)child);
                    break;
                }
                case 3: {
                    ASTList<MemberDeclaration> list2 = x.getMembers();
                    if (list2 == null) {
                        list2 = new ASTArrayList<MemberDeclaration>();
                        x.setMembers(list2);
                    }
                    list2.add(index, (MemberDeclaration)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof ClassInitializer) {
            ClassInitializer x = (ClassInitializer)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setBody((StatementBlock)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof FieldDeclaration) {
            FieldDeclaration x = (FieldDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setTypeReference((TypeReference)child);
                    break;
                }
                case 2: {
                    ASTList<FieldSpecification> list2 = x.getFieldSpecifications();
                    if (list2 == null) {
                        list2 = new ASTArrayList<FieldSpecification>();
                        x.setFieldSpecifications(list2);
                    }
                    list2.add(index, (FieldSpecification)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof InheritanceSpecification) {
            InheritanceSpecification x = (InheritanceSpecification)parent;
            ASTList<TypeReference> list = x.getSupertypes();
            if (list == null) {
                list = new ASTArrayList<TypeReference>();
                x.setSupertypes(list);
            }
            list.add(index, (TypeReference)child);
        } else if (parent instanceof InterfaceDeclaration) {
            InterfaceDeclaration x = (InterfaceDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 2: {
                    x.setExtendedTypes((Extends)child);
                    break;
                }
                case 4: {
                    ASTList<MemberDeclaration> list2 = x.getMembers();
                    if (list2 == null) {
                        list2 = new ASTArrayList<MemberDeclaration>();
                        x.setMembers(list2);
                    }
                    list2.add(index, (MemberDeclaration)child);
                    break;
                }
                case 5: {
                    ASTArrayList<TypeParameterDeclaration> list3 = x.getTypeParameters();
                    if (list3 == null) {
                        list3 = new ASTArrayList<TypeParameterDeclaration>();
                        x.setTypeParameters(list3);
                    }
                    list3.add(index, (TypeParameterDeclaration)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof LocalVariableDeclaration) {
            LocalVariableDeclaration x = (LocalVariableDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list2 = x.getDeclarationSpecifiers();
                    if (list2 == null) {
                        list2 = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list2);
                    }
                    list2.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setTypeReference((TypeReference)child);
                    break;
                }
                case 2: {
                    ASTList<VariableSpecification> list3 = x.getVariableSpecifications();
                    if (list3 == null) {
                        list3 = new ASTArrayList<VariableSpecification>();
                        x.setVariableSpecifications(list3);
                    }
                    list3.add(index, (VariableSpecification)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof MethodDeclaration) {
            MethodDeclaration x = (MethodDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setTypeReference((TypeReference)child);
                    break;
                }
                case 2: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 3: {
                    ASTList<ParameterDeclaration> list2 = x.getParameters();
                    if (list2 == null) {
                        list2 = new ASTArrayList<ParameterDeclaration>();
                        x.setParameters(list2);
                    }
                    list2.add(index, (ParameterDeclaration)child);
                    break;
                }
                case 4: {
                    x.setThrown((Throws)child);
                    break;
                }
                case 5: {
                    x.setBody((StatementBlock)child);
                    break;
                }
                case 7: {
                    ASTArrayList<TypeParameterDeclaration> list3 = x.getTypeParameters();
                    if (list3 == null) {
                        list3 = new ASTArrayList<TypeParameterDeclaration>();
                        x.setTypeParameters(list3);
                    }
                    list3.add(index, (TypeParameterDeclaration)child);
                    break;
                }
                case 8: {
                    if (x instanceof AnnotationPropertyDeclaration) {
                        ((AnnotationPropertyDeclaration)x).setDefaultValue((Expression)child);
                        break;
                    }
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof ParameterDeclaration) {
            ParameterDeclaration x = (ParameterDeclaration)parent;
            switch (role) {
                case 0: {
                    ASTList<DeclarationSpecifier> list = x.getDeclarationSpecifiers();
                    if (list == null) {
                        list = new ASTArrayList<DeclarationSpecifier>();
                        x.setDeclarationSpecifiers(list);
                    }
                    list.add(index, (DeclarationSpecifier)child);
                    break;
                }
                case 1: {
                    x.setTypeReference((TypeReference)child);
                    break;
                }
                case 2: {
                    x.setVariableSpecification((VariableSpecification)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Throws) {
            Throws x = (Throws)parent;
            ASTList<TypeReference> list = x.getExceptions();
            if (list == null) {
                list = new ASTArrayList<TypeReference>();
                x.setExceptions(list);
            }
            list.add(index, (TypeReference)child);
        } else if (parent instanceof VariableSpecification) {
            VariableSpecification x = (VariableSpecification)parent;
            switch (role) {
                case 0: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 1: {
                    x.setInitializer((Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof ArrayInitializer) {
            ArrayInitializer x = (ArrayInitializer)parent;
            ASTList<Expression> list = x.getArguments();
            if (list == null) {
                list = new ASTArrayList<Expression>();
                x.setArguments(list);
            }
            list.add(index, (Expression)child);
        } else if (parent instanceof Operator) {
            Operator x = (Operator)parent;
            if (role == 0) {
                ASTList<Expression> list = x.getArguments();
                if (list == null) {
                    list = new ASTArrayList<Expression>();
                    x.setArguments(list);
                }
                list.add(index, (Expression)child);
            }
            if (parent instanceof TypeOperator) {
                TypeOperator y;
                if (parent instanceof New) {
                    y = (New)parent;
                    switch (role) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            y.setTypeReference((TypeReference)child);
                            break;
                        }
                        case 2: {
                            ((New)y).setReferencePrefix((ReferencePrefix)child);
                            break;
                        }
                        case 3: {
                            ((New)y).setClassDeclaration((ClassDeclaration)child);
                            break;
                        }
                        default: {
                            throw new IllegalChangeReportException("Illegal child role in " + dc);
                        }
                    }
                } else if (parent instanceof NewArray) {
                    y = (NewArray)parent;
                    switch (role) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            y.setTypeReference((TypeReference)child);
                            break;
                        }
                        case 3: {
                            ((NewArray)y).setArrayInitializer((ArrayInitializer)child);
                            break;
                        }
                        default: {
                            throw new IllegalChangeReportException("Illegal child role in " + dc);
                        }
                    }
                } else {
                    y = (TypeOperator)parent;
                    switch (role) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            y.setTypeReference((TypeReference)child);
                            break;
                        }
                        default: {
                            throw new IllegalChangeReportException("Illegal child role in " + dc);
                        }
                    }
                }
            }
        } else if (parent instanceof ArrayLengthReference) {
            ArrayLengthReference x = (ArrayLengthReference)parent;
            x.setReferencePrefix((ReferencePrefix)child);
        } else if (parent instanceof ArrayReference) {
            ArrayReference x = (ArrayReference)parent;
            switch (role) {
                case 0: {
                    x.setReferencePrefix((ReferencePrefix)child);
                    break;
                }
                case 1: {
                    ASTList<Expression> list = x.getDimensionExpressions();
                    if (list == null) {
                        list = new ASTArrayList<Expression>();
                        x.setDimensionExpressions(list);
                    }
                    list.add(index, (Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof FieldReference) {
            FieldReference x = (FieldReference)parent;
            switch (role) {
                case 0: {
                    x.setReferencePrefix((ReferencePrefix)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof VariableReference) {
            VariableReference x = (VariableReference)parent;
            x.setIdentifier((Identifier)child);
        } else if (parent instanceof MetaClassReference) {
            MetaClassReference x = (MetaClassReference)parent;
            x.setReferencePrefix((ReferencePrefix)child);
        } else if (parent instanceof MethodReference) {
            MethodReference x = (MethodReference)parent;
            switch (role) {
                case 0: {
                    x.setReferencePrefix((ReferencePrefix)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 2: {
                    ASTList<Expression> list = x.getArguments();
                    if (list == null) {
                        list = new ASTArrayList<Expression>();
                        x.setArguments(list);
                    }
                    list.add(index, (Expression)child);
                    break;
                }
                case 3: {
                    ASTList<TypeArgumentDeclaration> list2 = x.getTypeArguments();
                    if (list2 == null) {
                        list2 = new ASTArrayList<TypeArgumentDeclaration>();
                        x.setTypeArguments(list2);
                    }
                    list2.add(index, (TypeArgumentDeclaration)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof TypeReferenceInfix) {
            TypeReferenceInfix x = (TypeReferenceInfix)parent;
            switch (role) {
                case 0: {
                    x.setReferencePrefix((ReferencePrefix)child);
                    break;
                }
                case 1: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 2: {
                    if (x instanceof TypeReference) {
                        TypeReference y = (TypeReference)x;
                        ASTList<TypeArgumentDeclaration> list2 = y.getTypeArguments();
                        if (list2 == null) {
                            list2 = new ASTArrayList<TypeArgumentDeclaration>();
                            y.setTypeArguments(list2);
                        }
                        list2.add(index, (TypeArgumentDeclaration)child);
                        break;
                    }
                    if (x instanceof UncollatedReferenceQualifier) {
                        UncollatedReferenceQualifier y = (UncollatedReferenceQualifier)x;
                        ASTList<TypeArgumentDeclaration> list2 = y.getTypeArguments();
                        if (list2 == null) {
                            list2 = new ASTArrayList<TypeArgumentDeclaration>();
                            y.setTypeArguments(list2);
                        }
                        list2.add(index, (TypeArgumentDeclaration)child);
                        break;
                    }
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof EnumConstructorReference) {
            EnumConstructorReference x = (EnumConstructorReference)parent;
            switch (role) {
                case 0: {
                    x.setClassDeclaration((ClassDeclaration)child);
                    break;
                }
                case 1: {
                    ASTList<Expression> list = x.getArguments();
                    if (list == null) {
                        list = new ASTArrayList<Expression>();
                        x.setArguments(list);
                    }
                    list.add(index, (Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof SuperConstructorReference) {
            SuperConstructorReference x = (SuperConstructorReference)parent;
            switch (role) {
                case 0: {
                    x.setReferencePrefix((ReferencePrefix)child);
                    break;
                }
                case 1: {
                    ASTList<Expression> list = x.getArguments();
                    if (list == null) {
                        list = new ASTArrayList<Expression>();
                        x.setArguments(list);
                    }
                    list.add(index, (Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof SuperReference) {
            SuperReference x = (SuperReference)parent;
            x.setReferencePrefix((ReferencePrefix)child);
        } else if (parent instanceof ThisConstructorReference) {
            ThisConstructorReference x = (ThisConstructorReference)parent;
            ASTList<Expression> list = x.getArguments();
            if (list == null) {
                list = new ASTArrayList<Expression>();
                x.setArguments(list);
            }
            list.add(index, (Expression)child);
        } else if (parent instanceof ThisReference) {
            ThisReference x = (ThisReference)parent;
            x.setReferencePrefix((ReferencePrefix)child);
        } else if (parent instanceof LabelJumpStatement) {
            LabelJumpStatement x = (LabelJumpStatement)parent;
            x.setIdentifier((Identifier)child);
        } else if (parent instanceof Assert) {
            Assert x = (Assert)parent;
            switch (role) {
                case 0: {
                    x.setCondition((Expression)child);
                    break;
                }
                case 1: {
                    x.setMessage((Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Case) {
            Case x = (Case)parent;
            switch (role) {
                case 0: {
                    x.setExpression((Expression)child);
                    break;
                }
                case 1: {
                    ASTList<Statement> list = x.getBody();
                    if (list == null) {
                        list = new ASTArrayList<Statement>();
                        x.setBody(list);
                    }
                    list.add(index, (Statement)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Catch) {
            Catch x = (Catch)parent;
            switch (role) {
                case 0: {
                    x.setParameterDeclaration((ParameterDeclaration)child);
                    break;
                }
                case 1: {
                    x.setBody((StatementBlock)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Default) {
            Default x = (Default)parent;
            ASTList<Statement> list = x.getBody();
            if (list == null) {
                list = new ASTArrayList<Statement>();
                x.setBody(list);
            }
            list.add(index, (Statement)child);
        } else if (parent instanceof LoopStatement) {
            LoopStatement x = (LoopStatement)parent;
            switch (role) {
                case 0: {
                    ASTList<LoopInitializer> list = x.getInitializers();
                    if (list == null) {
                        list = new ASTArrayList<LoopInitializer>();
                        x.setInitializers(list);
                    }
                    list.add(index, (LoopInitializer)child);
                    break;
                }
                case 1: {
                    x.setGuard((Expression)child);
                    break;
                }
                case 2: {
                    ASTList<Expression> list2 = x.getUpdates();
                    if (list2 == null) {
                        list2 = new ASTArrayList<Expression>();
                        x.setUpdates(list2);
                    }
                    list2.add(index, (Expression)child);
                    break;
                }
                case 3: {
                    x.setBody((Statement)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Else) {
            Else x = (Else)parent;
            x.setBody((Statement)child);
        } else if (parent instanceof Finally) {
            Finally x = (Finally)parent;
            x.setBody((StatementBlock)child);
        } else if (parent instanceof If) {
            If x = (If)parent;
            switch (role) {
                case 0: {
                    x.setExpression((Expression)child);
                    break;
                }
                case 1: {
                    x.setThen((Then)child);
                    break;
                }
                case 2: {
                    x.setElse((Else)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof LabeledStatement) {
            LabeledStatement x = (LabeledStatement)parent;
            switch (role) {
                case 0: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 1: {
                    x.setBody((Statement)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof ExpressionJumpStatement) {
            ExpressionJumpStatement x = (ExpressionJumpStatement)parent;
            x.setExpression((Expression)child);
        } else if (parent instanceof Switch) {
            Switch x = (Switch)parent;
            switch (role) {
                case 0: {
                    x.setExpression((Expression)child);
                    break;
                }
                case 1: {
                    ASTList<Branch> list = x.getBranchList();
                    if (list == null) {
                        list = new ASTArrayList<Branch>();
                        x.setBranchList(list);
                    }
                    list.add(index, (Branch)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof SynchronizedBlock) {
            SynchronizedBlock x = (SynchronizedBlock)parent;
            switch (role) {
                case 0: {
                    x.setExpression((Expression)child);
                    break;
                }
                case 1: {
                    x.setBody((StatementBlock)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof Then) {
            Then x = (Then)parent;
            x.setBody((Statement)child);
        } else if (parent instanceof Try) {
            Try x = (Try)parent;
            switch (role) {
                case 0: {
                    x.setBody((StatementBlock)child);
                    break;
                }
                case 1: {
                    ASTList<Branch> list = x.getBranchList();
                    if (list == null) {
                        list = new ASTArrayList<Branch>();
                        x.setBranchList(list);
                    }
                    list.add(index, (Branch)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof AnnotationUseSpecification) {
            AnnotationUseSpecification x = (AnnotationUseSpecification)parent;
            switch (role) {
                case 0: {
                    x.setTypeReference((TypeReference)child);
                    break;
                }
                case 1: {
                    ASTArrayList<AnnotationElementValuePair> list = x.getElementValuePairs();
                    if (list == null) {
                        list = new ASTArrayList<AnnotationElementValuePair>();
                        x.setElementValuePairs(list);
                    }
                    list.add(index, (AnnotationElementValuePair)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof AnnotationElementValuePair) {
            AnnotationElementValuePair x = (AnnotationElementValuePair)parent;
            switch (role) {
                case 0: {
                    x.setElement((AnnotationPropertyReference)child);
                    break;
                }
                case 1: {
                    x.setElementValue((Expression)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof TypeArgumentDeclaration) {
            TypeArgumentDeclaration x = (TypeArgumentDeclaration)parent;
            x.setTypeReference((TypeReference)child);
        } else if (parent instanceof TypeParameterDeclaration) {
            TypeParameterDeclaration x = (TypeParameterDeclaration)parent;
            switch (role) {
                case 0: {
                    x.setIdentifier((Identifier)child);
                    break;
                }
                case 1: {
                    ASTList<TypeReference> list = x.getBounds();
                    if (list == null) {
                        list = new ASTArrayList<TypeReference>();
                        x.setBound(list);
                    }
                    list.add(index, (TypeReference)child);
                    break;
                }
                default: {
                    throw new IllegalChangeReportException("Illegal child role in " + dc);
                }
            }
        } else if (parent instanceof AnnotationPropertyReference) {
            AnnotationPropertyReference x = (AnnotationPropertyReference)parent;
            x.setIdentifier((Identifier)child);
        } else {
            throw new IllegalChangeReportException("Unknown parent type in " + dc);
        }
        AttachChange result = new AttachChange(child);
        return result;
    }
}

