/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.List;
import recoder.abstraction.ClassType;
import recoder.convenience.Format;
import recoder.convenience.Formats;
import recoder.util.Debug;

abstract class ClassTypeTopSort
implements Formats {
    private final List<ClassType> classesDFS = new ArrayList<ClassType>(32);
    private int[] indeg = new int[32];

    ClassTypeTopSort() {
    }

    protected abstract List<ClassType> getAdjacent(ClassType var1);

    private void initIndeg() {
        for (int i = 0; i < this.indeg.length; ++i) {
            this.indeg[i] = 0;
        }
    }

    private int incrIndeg(int index) {
        while (index >= this.indeg.length) {
            int[] n = new int[this.indeg.length * 2];
            System.arraycopy(this.indeg, 0, n, 0, this.indeg.length);
            this.indeg = n;
        }
        int n = index;
        int n2 = this.indeg[n] + 1;
        this.indeg[n] = n2;
        return n2;
    }

    private int decrIndeg(int index) {
        int n = index;
        int n2 = this.indeg[n] - 1;
        this.indeg[n] = n2;
        return n2;
    }

    private void addClass(ClassType c) {
        if (c != null) {
            int idx = this.classesDFS.indexOf(c);
            if (idx == -1) {
                this.classesDFS.add(c);
                idx = this.classesDFS.size() - 1;
                List<ClassType> neighbors = this.getAdjacent(c);
                int s = neighbors.size();
                for (int i = 0; i < s; ++i) {
                    this.addClass(neighbors.get(i));
                }
            }
            this.incrIndeg(idx);
        }
    }

    private void sort(ClassType c, List<ClassType> result) {
        if (c != null) {
            int idx = this.classesDFS.indexOf(c);
            if (idx == -1) {
                Debug.error(Format.toString("Could not find %c \"%s\" @%p in %f", c) + "\nList: " + Format.toString("%N", result) + "\n" + Debug.makeStackTrace());
                System.exit(0);
            }
            if (this.decrIndeg(idx) == 0) {
                result.add(c);
                List<ClassType> neighbors = this.getAdjacent(c);
                int s = neighbors.size();
                for (int i = 0; i < s; ++i) {
                    this.sort(neighbors.get(i), result);
                }
            }
        }
    }

    public List<ClassType> getAllTypes(ClassType c) {
        this.initIndeg();
        this.classesDFS.clear();
        this.addClass(c);
        ArrayList<ClassType> result = new ArrayList<ClassType>(this.classesDFS.size());
        this.sort(c, result);
        if (result.size() < this.classesDFS.size()) {
            throw new RuntimeException("Cyclic inheritance detected!");
        }
        return result;
    }
}

