/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.ServiceConfiguration;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.AnnotationUseInfo;
import recoder.bytecode.ByteCodeElement;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ConstructorInfo;
import recoder.bytecode.FieldInfo;
import recoder.bytecode.MethodInfo;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.convenience.Format;
import recoder.service.ByteCodeInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.MissingClassFileException;
import recoder.service.NameInfo;
import recoder.util.Debug;

public class DefaultByteCodeInfo
extends DefaultProgramModelInfo
implements ByteCodeInfo {
    private final Map<ProgramModelElement, ClassTypeContainer> element2container = new HashMap<ProgramModelElement, ClassTypeContainer>(256);
    private final Map<ClassTypeContainer, List<ClassType>> containedTypes = new HashMap<ClassTypeContainer, List<ClassType>>(32);
    private final Map<Method, List<Type>> method2signature = new HashMap<Method, List<Type>>(128);

    public DefaultByteCodeInfo(ServiceConfiguration config) {
        super(config);
    }

    private ByteCodeElement getByteCodeElement(ProgramModelElement pme) {
        if (pme instanceof ByteCodeElement) {
            return (ByteCodeElement)pme;
        }
        return null;
    }

    @Override
    public final ClassFile getClassFile(ClassType ct) {
        return (ClassFile)this.getByteCodeElement(ct);
    }

    @Override
    public final MethodInfo getMethodInfo(Method m) {
        return (MethodInfo)this.getByteCodeElement(m);
    }

    @Override
    public final ConstructorInfo getConstructorInfo(Constructor c) {
        return (ConstructorInfo)this.getByteCodeElement(c);
    }

    @Override
    public final FieldInfo getFieldInfo(Field f) {
        return (FieldInfo)this.getByteCodeElement(f);
    }

    public Type getType(ByteCodeElement bce) {
        List<TypeArgumentInfo> typeArgs;
        MethodInfo mi;
        Type result = null;
        String typeName = bce.getTypeName();
        if (bce instanceof MethodInfo) {
            mi = (MethodInfo)bce;
            List<? extends TypeParameter> tpl = mi.getContainingClassType().getTypeParameters();
            for (TypeParameter typeParameter : tpl) {
                if (!typeName.equals(typeParameter.getName())) continue;
                result = typeParameter;
            }
        }
        if (result == null) {
            result = this.getNameInfo().getType(typeName);
        }
        if (bce instanceof MethodInfo && (typeArgs = (mi = (MethodInfo)bce).getTypeArgumentsForReturnType()) != null && typeArgs.size() != 0) {
            result = result instanceof ArrayType ? this.makeParameterizedArrayType(result, typeArgs) : new ParameterizedType((ClassType)result, typeArgs);
        }
        return result;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        ByteCodeElement bci;
        Debug.assertNonnull(pme);
        Type result = null;
        result = pme instanceof Type ? (Type)pme : ((bci = this.getByteCodeElement(pme)) == null ? pme.getProgramModelInfo().getType(pme) : this.getType(bci));
        return result;
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        ProgramModelElement x = this.element2container.get(pme);
        while (x != null && !(x instanceof Package)) {
            x = this.element2container.get(x);
        }
        return (Package)x;
    }

    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        Debug.assertNonnull(ctc);
        if (ctc instanceof ByteCodeElement) {
            ArrayList ctl = this.containedTypes.get(ctc);
            return ctl == null ? new ArrayList(0) : ctl;
        }
        return ctc.getProgramModelInfo().getTypes(ctc);
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        return this.element2container.get(ct);
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof TypeParameterInfo) {
            TypeParameterInfo tp = (TypeParameterInfo)ct;
            ArrayList<ClassType> res = new ArrayList<ClassType>();
            if (tp.getBoundCount() == 0) {
                res.add(this.getNameInfo().getJavaLangObject());
            } else {
                for (int i = 0; i < tp.getBoundCount(); ++i) {
                    res.add(this.getNameInfo().getClassType(tp.getBoundName(i)));
                }
            }
            return res;
        }
        ClassFile cf = this.getClassFile(ct);
        if (cf == null) {
            return ct.getProgramModelInfo().getSupertypes(ct);
        }
        ClassFileCacheEntry cfce = (ClassFileCacheEntry)this.classTypeCache.get(ct);
        Debug.assertNonnull(cfce);
        Debug.assertNonnull(cfce.supertypes);
        return cfce.supertypes;
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return ((ClassFile)ct).getFieldInfos();
        }
        return ct.getProgramModelInfo().getFields(ct);
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return new ArrayList<Method>(((ClassFile)ct).getMethodInfos());
        }
        return ct.getProgramModelInfo().getMethods(ct);
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct) {
        Debug.assertNonnull(ct);
        if (ct instanceof ClassFile) {
            return ((ClassFile)ct).getConstructorInfos();
        }
        return ct.getProgramModelInfo().getConstructors(ct);
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        return (ClassType)this.element2container.get(m);
    }

    @Override
    public List<Type> getSignature(Method m) {
        List<Type> result;
        Debug.assertNonnull(m);
        MethodInfo mi = this.getMethodInfo(m);
        if (mi == null) {
            result = m.getProgramModelInfo().getSignature(m);
        } else {
            String[] ptypes = mi.getParameterTypeNames();
            int pcount = ptypes.length;
            if (pcount == 0) {
                result = new ArrayList<Type>(0);
            } else {
                result = this.method2signature.get(m);
                if (result == null) {
                    NameInfo ni = this.getNameInfo();
                    ArrayList<Type> res = new ArrayList<Type>(pcount);
                    for (int i = 0; i < pcount; ++i) {
                        Type t = null;
                        String basename = ptypes[i];
                        int dim = basename.indexOf(91);
                        if (dim != -1) {
                            basename = basename.substring(0, dim);
                        }
                        boolean checkClassTypeParameters = true;
                        List<TypeParameter> tpl = mi.getTypeParameters();
                        if (tpl != null) {
                            for (TypeParameter tp : tpl) {
                                if (!basename.equals(tp.getName())) continue;
                                t = tp;
                                if (dim != -1) {
                                    for (dim = (ptypes[i].length() - dim) / 2; dim != 0; --dim) {
                                        t = ni.createArrayType(tp);
                                    }
                                }
                                checkClassTypeParameters = false;
                                break;
                            }
                        }
                        if (checkClassTypeParameters) {
                            tpl = mi.getContainingClassType().getTypeParameters();
                            for (TypeParameter tp : tpl) {
                                if (!basename.equals(tp.getName())) continue;
                                t = tp;
                                if (dim == -1) break;
                                for (dim = (ptypes[i].length() - dim) / 2; dim != 0; --dim) {
                                    t = ni.createArrayType(tp);
                                }
                            }
                        }
                        if (t == null) {
                            t = ni.getType(ptypes[i]);
                        }
                        if (mi.getTypeArgumentsForParam(i) != null) {
                            t = t instanceof ArrayType ? this.makeParameterizedArrayType(t, mi.getTypeArgumentsForParam(i)) : new ParameterizedType((ClassType)t, mi.getTypeArgumentsForParam(i));
                        }
                        res.add(t);
                    }
                    result = res;
                    this.method2signature.put(m, result);
                }
            }
        }
        return result;
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        Debug.assertNonnull(m);
        MethodInfo mi = this.getMethodInfo(m);
        if (mi == null) {
            return m.getProgramModelInfo().getExceptions(m);
        }
        String[] etypes = mi.getExceptionsInfo();
        if (etypes == null || etypes.length == 0) {
            return new ArrayList<ClassType>(0);
        }
        ArrayList<ClassType> res = new ArrayList<ClassType>(etypes.length);
        NameInfo ni = this.getNameInfo();
        for (int i = 0; i < etypes.length; ++i) {
            res.add(ni.getClassType(etypes[i]));
        }
        return res;
    }

    @Override
    public Type getReturnType(Method m) {
        return this.getType(m);
    }

    @Override
    public void register(ClassFile cf) {
        ClassType jlo;
        String[] innerClasses;
        ClassTypeContainer ctc;
        Debug.assertNonnull(cf);
        ClassFileCacheEntry cfce = (ClassFileCacheEntry)this.classTypeCache.get(cf);
        if (cfce != null) {
            return;
        }
        if (cf.getName().equals("package-info")) {
            return;
        }
        cfce = new ClassFileCacheEntry();
        this.classTypeCache.put(cf, cfce);
        String classname = cf.getPhysicalName();
        NameInfo ni = this.getNameInfo();
        cf.setProgramModelInfo(this);
        ni.register(cf);
        int ldp = classname.lastIndexOf(36);
        if (ldp >= 0) {
            String outerClassName = classname.substring(0, ldp);
            classname = classname.substring(ldp + 1);
            ClassType outerClass = ni.getClassType(outerClassName.replace('$', '.'));
            if (outerClass == null) {
                do {
                    if ((ldp = outerClassName.lastIndexOf(36)) < 0 || (outerClassName = outerClassName.substring(0, ldp)).length() <= 0) continue;
                    outerClass = ni.getClassType(outerClassName.replace('$', '.'));
                } while (ldp >= 0 && outerClass == null);
            }
            if (outerClass instanceof ClassFile) {
                this.register((ClassFile)outerClass);
            } else {
                Debug.log("Found a non-ClassFile outer class of " + classname + ":" + Format.toString("%c %N", outerClass));
            }
            ctc = outerClass;
        } else {
            ldp = classname.lastIndexOf(46);
            String packageName = "";
            if (ldp != -1) {
                packageName = classname.substring(0, ldp);
            }
            ctc = ni.createPackage(packageName);
        }
        this.element2container.put(cf, ctc);
        if (ctc instanceof ByteCodeElement) {
            List<ClassType> ctl = this.containedTypes.get(ctc);
            if (ctl == null) {
                ctl = new ArrayList<ClassType>();
                this.containedTypes.put(ctc, ctl);
            }
            ctl.add(cf);
        }
        List<FieldInfo> fl = cf.getFieldInfos();
        int s = fl.size();
        for (int i = 0; i < s; ++i) {
            Field f = fl.get(i);
            f.setProgramModelInfo(this);
            this.element2container.put(f, cf);
            ni.register(f);
        }
        List<MethodInfo> ml = cf.getMethodInfos();
        int s2 = ml.size();
        for (int i = 0; i < s2; ++i) {
            Method m = ml.get(i);
            m.setProgramModelInfo(this);
            this.element2container.put(m, cf);
        }
        List<ConstructorInfo> cl = cf.getConstructorInfos();
        int s3 = cl.size();
        for (int i = 0; i < s3; ++i) {
            Constructor c = cl.get(i);
            c.setProgramModelInfo(this);
            this.element2container.put(c, cf);
        }
        if (cl.isEmpty() && !cf.isInterface() && !cf.isEnumType() && Character.isJavaIdentifierStart(cf.getName().charAt(0))) {
            Debug.log("No constructor defined in " + cf.getFullName());
        }
        if ((innerClasses = cf.getInnerClassNames()) != null) {
            String fullName = cf.getFullName();
            for (int i = 0; i < innerClasses.length; ++i) {
                String cn = innerClasses[i];
                if (cn.equals(fullName)) continue;
                ni.getClassType(cn);
            }
        }
        String sname = cf.getSuperClassName();
        String[] inames = cf.getInterfaceNames();
        ArrayList<ClassType> list = new ArrayList<ClassType>(inames.length + 1);
        if (sname != null) {
            ClassType ct = ni.getClassType(sname);
            if (ct == null) {
                this.getErrorHandler().reportError(new MissingClassFileException("Unknown byte code supertype " + sname + " in class " + cf.getFullName(), sname));
            } else {
                List<TypeArgumentInfo> tais = cf.getSuperClassTypeArguments();
                if (tais != null && tais.size() > 0) {
                    ct = new ParameterizedType(ct, tais);
                }
                list.add(ct);
            }
        }
        for (int i = 0; i < inames.length; ++i) {
            String iname = inames[i];
            ClassType ct = ni.getClassType(iname);
            if (ct == null) {
                this.getErrorHandler().reportError(new MissingClassFileException("Unknown byte code supertype " + iname + " in class " + cf.getFullName(), iname));
                continue;
            }
            List<TypeArgumentInfo> tais = cf.getSuperInterfaceTypeArguments(i);
            if (tais != null && tais.size() > 0) {
                ct = new ParameterizedType(ct, tais);
            }
            list.add(ct);
        }
        if (list.isEmpty() && cf != (jlo = ni.getJavaLangObject())) {
            list.add(jlo);
        }
        cfce.supertypes = list;
        for (int i = 0; i < list.size(); ++i) {
            this.registerSubtype(cf, (ClassType)list.get(i));
        }
    }

    @Override
    public Type getAnnotationType(AnnotationUseInfo au) {
        return this.getNameInfo().getType(au.getFullReferencedName());
    }

    static class ClassFileCacheEntry
    extends DefaultProgramModelInfo.ClassTypeCacheEntry {
        ClassFileCacheEntry() {
        }
    }
}

