/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ClassType;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.NonTerminalProgramElement;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.declaration.AnnotationElementValuePair;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.expression.operator.New;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MemberReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceContainer;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.service.AttachChange;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ClassTypeTopSort;
import recoder.service.CrossReferenceSourceInfo;
import recoder.service.DefaultNameInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.DefaultSourceInfo;
import recoder.service.DetachChange;
import recoder.service.ProgramModelInfo;
import recoder.service.TreeChange;
import recoder.service.UnresolvedReferenceException;
import recoder.util.Debug;
import recoder.util.ProgressEvent;

public class DefaultCrossReferenceSourceInfo
extends DefaultSourceInfo
implements CrossReferenceSourceInfo {
    private final Map<ProgramModelElement, Set<Reference>> element2references = new HashMap<ProgramModelElement, Set<Reference>>(256);

    public DefaultCrossReferenceSourceInfo(ServiceConfiguration config) {
        super(config);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void modelChanged(ChangeHistoryEvent changes) {
        ProgramElement pe;
        TreeChange tc;
        int i;
        TreeChange tc2;
        int i2;
        List<TreeChange> changed = changes.getChanges();
        int s = changed.size();
        int c = 0;
        this.listeners.fireProgressEvent(0, 3 * s, "Building Scopes");
        for (i2 = 0; i2 < s; ++i2) {
            tc2 = changed.get(i2);
            if (!(tc2 instanceof DetachChange)) continue;
            if (!tc2.isMinor()) {
                this.processChange(tc2);
            }
            this.listeners.fireProgressEvent(++c);
        }
        for (i2 = 0; i2 < s; ++i2) {
            tc2 = changed.get(i2);
            if (!(tc2 instanceof AttachChange)) continue;
            if (!tc2.isMinor()) {
                this.processChange(tc2);
            }
            this.listeners.fireProgressEvent(++c);
        }
        this.listeners.fireProgressEvent(c, "Resolving References");
        TreeWalker tw = new TreeWalker(null);
        for (i = 0; i < s; ++i) {
            tc = changed.get(i);
            if (!(tc instanceof DetachChange)) continue;
            if (!tc.isMinor()) {
                pe = tc.getChangeRoot();
                boolean rippleEffect = this.isPossiblyShowingRippleEffect(tc);
                if (pe instanceof TypeArgumentDeclaration) {
                    this.reset(true);
                    return;
                }
                if (pe instanceof Reference) {
                    if (rippleEffect) {
                        this.reset(true);
                        return;
                    }
                    this.deregisterReference((Reference)pe);
                } else {
                    if (pe instanceof ProgramModelElement || pe instanceof VariableDeclaration) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof InheritanceSpecification) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof AnnotationElementValuePair) {
                        this.reset(true);
                        return;
                    }
                }
                tw.reset(pe);
                tw.next();
                while (tw.next()) {
                    ProgramElement p = tw.getProgramElement();
                    if (!(p instanceof Reference)) continue;
                    this.deregisterReference((Reference)p);
                }
            }
            this.listeners.fireProgressEvent(++c);
        }
        for (i = 0; i < s; ++i) {
            tc = changed.get(i);
            if (!(tc instanceof AttachChange)) continue;
            if (!tc.isMinor()) {
                pe = tc.getChangeRoot();
                NonTerminalProgramElement pa = tc.getChangeRootParent();
                if (pe instanceof TypeArgumentDeclaration) {
                    this.reset(true);
                    return;
                }
                if (pe instanceof Reference) {
                    if (!(pe instanceof Expression) || this.isPossiblyShowingRippleEffect(tc)) {
                        this.reset(true);
                        return;
                    }
                } else {
                    if (pe instanceof ProgramModelElement || pe instanceof VariableDeclaration) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof InheritanceSpecification) {
                        this.reset(true);
                        return;
                    }
                    if (pe instanceof AnnotationElementValuePair) {
                        this.reset(true);
                        return;
                    }
                }
            }
            this.listeners.fireProgressEvent(++c);
        }
        i = 0;
        while (i < s) {
            tc = changed.get(i);
            if (!tc.isMinor() && tc instanceof AttachChange) {
                AttachChange ac = (AttachChange)tc;
                ProgramElement pe2 = ac.getChangeRoot();
                this.analyzeReferences(pe2);
            }
            this.listeners.fireProgressEvent(++c);
            ++i;
        }
        return;
    }

    private boolean isPossiblyShowingRippleEffect(TreeChange tc) {
        return true;
    }

    @Override
    public List<MemberReference> getReferences(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        Set<Reference> references = this.element2references.get(m);
        if (references == null) {
            return new ArrayList<MemberReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<MemberReference>(0);
        }
        ArrayList<MemberReference> result = new ArrayList<MemberReference>(s);
        for (Reference o : references) {
            result.add((MemberReference)o);
        }
        return result;
    }

    @Override
    public List<ConstructorReference> getReferences(Constructor c) {
        Debug.assertNonnull(c);
        this.updateModel();
        Set<Reference> references = this.element2references.get(c);
        if (references == null) {
            return new ArrayList<ConstructorReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<ConstructorReference>(0);
        }
        ArrayList<ConstructorReference> result = new ArrayList<ConstructorReference>(s);
        for (Reference o : references) {
            result.add((ConstructorReference)o);
        }
        return result;
    }

    @Override
    public List<VariableReference> getReferences(Variable v) {
        Debug.assertNonnull(v);
        this.updateModel();
        Set<Reference> references = this.element2references.get(v);
        if (references == null) {
            return new ArrayList<VariableReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<VariableReference>(0);
        }
        ArrayList<VariableReference> result = new ArrayList<VariableReference>(s);
        for (Reference o : references) {
            result.add((VariableReference)o);
        }
        return result;
    }

    @Override
    public List<FieldReference> getReferences(Field f) {
        Debug.assertNonnull(f);
        this.updateModel();
        Set<Reference> references = this.element2references.get(f);
        if (references == null) {
            return new ArrayList<FieldReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<FieldReference>(0);
        }
        ArrayList<FieldReference> result = new ArrayList<FieldReference>(s);
        for (Reference o : references) {
            result.add((FieldReference)o);
        }
        return result;
    }

    @Override
    public List<TypeReference> getReferences(Type t) {
        Debug.assertNonnull(t);
        this.updateModel();
        Set<Reference> references = this.element2references.get(t);
        if (references == null) {
            return new ArrayList<TypeReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<TypeReference>(0);
        }
        ArrayList<TypeReference> result = new ArrayList<TypeReference>(s);
        for (Reference r : references) {
            result.add((TypeReference)r);
        }
        return result;
    }

    @Override
    public List<PackageReference> getReferences(Package p) {
        Debug.assertNonnull(p);
        this.updateModel();
        Set<Reference> references = this.element2references.get(p);
        if (references == null) {
            return new ArrayList<PackageReference>(0);
        }
        int s = references.size();
        if (s == 0) {
            return new ArrayList<PackageReference>(0);
        }
        ArrayList<PackageReference> result = new ArrayList<PackageReference>(s);
        for (Reference pr : references) {
            result.add((PackageReference)pr);
        }
        return result;
    }

    private void registerReference(Reference ref, ProgramModelElement pme) {
        Set<Reference> set = this.element2references.get(pme);
        if (set == null) {
            set = new HashSet<Reference>(4);
            this.element2references.put(pme, set);
        }
        set.add(ref);
    }

    private void deregisterReference(Reference ref) {
        ProgramModelElement pme = (ProgramModelElement)this.reference2element.get(ref);
        if (pme == null) {
            return;
        }
        Set<Reference> set = this.element2references.get(pme);
        if (set == null) {
            return;
        }
        set.remove(ref);
    }

    private void analyzeReferences(ProgramElement pe) {
        if (pe instanceof NonTerminalProgramElement) {
            NonTerminalProgramElement nt = (NonTerminalProgramElement)pe;
            int c = nt.getChildCount();
            for (int i = 0; i < c; ++i) {
                this.analyzeReferences(nt.getChildAt(i));
            }
        } else {
            return;
        }
        if (pe instanceof Reference) {
            if (pe instanceof UncollatedReferenceQualifier) {
                try {
                    pe = this.resolveURQ((UncollatedReferenceQualifier)pe);
                }
                catch (ClassCastException cce) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f", pe), pe));
                }
            }
            if (pe instanceof VariableReference) {
                VariableReference vr = (VariableReference)pe;
                Variable v = this.getVariable(vr);
                if (v == null) {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f", vr), vr));
                    v = this.getNameInfo().getUnknownField();
                }
                this.registerReference(vr, v);
            } else if (pe instanceof TypeReference) {
                TypeReference tr = (TypeReference)pe;
                Type t = this.getType(tr);
                if (t instanceof ParameterizedType) {
                    t = ((ParameterizedType)t).getGenericType();
                }
                if (t != null && !(t instanceof DefaultNameInfo.UnknownClassType)) {
                    this.registerReference(tr, t);
                    if (t instanceof ClassType) {
                        TypeDeclaration subType = null;
                        TypeReferenceContainer parent = tr.getParent();
                        if (parent instanceof InheritanceSpecification) {
                            subType = ((InheritanceSpecification)parent).getParent();
                        } else if (parent instanceof New) {
                            subType = ((New)parent).getClassDeclaration();
                        }
                        if (subType != null) {
                            ClassType superType = (ClassType)t;
                            ProgramModelInfo pmi = superType.getProgramModelInfo();
                            ((DefaultProgramModelInfo)pmi).registerSubtype(subType, superType);
                        }
                    }
                }
            } else if (pe instanceof MethodReference) {
                MethodReference mr = (MethodReference)pe;
                Method m = this.getMethod(mr);
                this.registerReference(mr, m);
            } else if (pe instanceof ConstructorReference) {
                ConstructorReference cr = (ConstructorReference)pe;
                Constructor c = this.getConstructor(cr);
                this.registerReference(cr, c);
            } else if (pe instanceof AnnotationPropertyReference) {
                AnnotationPropertyReference apr = (AnnotationPropertyReference)pe;
                AnnotationProperty ap = this.getAnnotationProperty(apr);
                this.registerReference(apr, ap);
            } else if (pe instanceof PackageReference) {
                PackageReference pr = (PackageReference)pe;
                Package p = this.getPackage(pr);
                this.registerReference(pr, p);
            }
        }
    }

    public String information() {
        this.updateModel();
        int c1 = 0;
        int c2 = 0;
        int c3 = 0;
        int c4 = 0;
        int c5 = 0;
        int r1 = 0;
        int r2 = 0;
        int r3 = 0;
        int r4 = 0;
        int r5 = 0;
        for (ProgramModelElement pme : this.element2references.keySet()) {
            int size;
            Set<Reference> set = this.element2references.get(pme);
            int n = size = set == null ? 0 : set.size();
            if (pme instanceof Variable) {
                ++c1;
                r1 += size;
                continue;
            }
            if (pme instanceof Method) {
                if (pme instanceof Constructor) {
                    ++c3;
                    r3 += size;
                    continue;
                }
                ++c2;
                r2 += size;
                continue;
            }
            if (pme instanceof Type) {
                ++c4;
                r4 += size;
                continue;
            }
            if (!(pme instanceof Package)) continue;
            ++c5;
            r5 += size;
        }
        return c1 + " variables with " + r1 + " references\n" + c2 + " methods with " + r2 + " references\n" + c3 + " constructors with " + r3 + " references\n" + c4 + " types with " + r4 + " references\n" + c5 + " packages with " + r5 + " references";
    }

    private void reset(boolean fire) {
        super.reset();
        this.element2references.clear();
        SourceFileRepository sfr = this.serviceConfiguration.getSourceFileRepository();
        List<CompilationUnit> cul = sfr.getCompilationUnits();
        int c = 0;
        if (fire) {
            ProgressEvent pe = this.listeners.getLastProgressEvent();
            c = pe.getWorkDoneCount();
            this.listeners.fireProgressEvent(c, c + cul.size());
        }
        for (int i = cul.size() - 1; i >= 0; --i) {
            CompilationUnit cu = cul.get(i);
            this.analyzeReferences(cu);
            if (!fire) continue;
            this.listeners.fireProgressEvent(++c);
        }
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    class SubTypeTopSort
    extends ClassTypeTopSort {
        SubTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return DefaultCrossReferenceSourceInfo.this.getSubtypes(c);
        }
    }
}

