/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.ServiceConfiguration;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.DefaultConstructor;
import recoder.abstraction.Field;
import recoder.abstraction.ImplicitEnumMethod;
import recoder.abstraction.ImplicitEnumValueOf;
import recoder.abstraction.ImplicitEnumValues;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.NullType;
import recoder.abstraction.Package;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.java.declaration.EnumDeclaration;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.ImplicitElementInfo;
import recoder.util.Debug;

public class DefaultImplicitElementInfo
extends DefaultProgramModelInfo
implements ImplicitElementInfo {
    private final Map<ClassType, DefaultConstructor> type2defaultConstructor = new HashMap<ClassType, DefaultConstructor>();
    private final Map<EnumDeclaration, List<ImplicitEnumMethod>> type2implicitEnumMethods = new HashMap<EnumDeclaration, List<ImplicitEnumMethod>>();
    private List<ClassType> enumValueOfExceptions = null;

    public DefaultImplicitElementInfo(ServiceConfiguration config) {
        super(config);
    }

    @Override
    public DefaultConstructor getDefaultConstructor(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        DefaultConstructor cons = this.type2defaultConstructor.get(ct);
        if (cons == null) {
            cons = new DefaultConstructor(ct);
            cons.setProgramModelInfo(this);
            this.type2defaultConstructor.put(ct, cons);
        }
        return cons;
    }

    @Override
    public List<ImplicitEnumMethod> getImplicitEnumMethods(EnumDeclaration etd) {
        if (etd == null) {
            throw new NullPointerException();
        }
        this.updateModel();
        List<ImplicitEnumMethod> res = this.type2implicitEnumMethods.get(etd);
        if (res == null) {
            res = new ArrayList<ImplicitEnumMethod>(2);
            ImplicitEnumMethod meth = new ImplicitEnumValueOf(etd);
            meth.setProgramModelInfo(this);
            res.add(meth);
            meth = new ImplicitEnumValues(etd);
            meth.setProgramModelInfo(this);
            res.add(meth);
            this.type2implicitEnumMethods.put(etd, res);
        }
        return res;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        if (pme instanceof NullType || pme instanceof ArrayType || pme instanceof IntersectionType) {
            return (Type)pme;
        }
        if (pme instanceof Package) {
            return null;
        }
        return this.getReturnType((Method)pme);
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        if (pme instanceof Package) {
            return (Package)pme;
        }
        if (pme instanceof DefaultConstructor || pme instanceof ImplicitEnumMethod) {
            this.updateModel();
            return this.getContainingClassType((Method)pme).getPackage();
        }
        return null;
    }

    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        if (ctc instanceof Package) {
            return this.serviceConfiguration.getNameInfo().getTypes((Package)ctc);
        }
        if (ctc instanceof DefaultConstructor) {
            return new ArrayList(0);
        }
        return null;
    }

    @Override
    public List<ClassType> getAllTypes(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        if (ct instanceof IntersectionType) {
            return ct.getSupertypes();
        }
        return null;
    }

    @Override
    public List<ClassType> getAllSupertypes(ClassType ct) {
        if (ct instanceof NullType) {
            ArrayList<ClassType> result = new ArrayList<ClassType>(1);
            result.add(ct);
            return result;
        }
        if (ct instanceof IntersectionType) {
            return super.getAllSubtypes(ct);
        }
        return null;
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public List<Field> getAllFields(ClassType ct) {
        if (ct instanceof IntersectionType) {
            return super.getAllFields(ct);
        }
        return null;
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    @Override
    public List<Method> getAllMethods(ClassType ct) {
        if (ct instanceof IntersectionType) {
            return super.getAllMethods(ct);
        }
        return null;
    }

    public List<Constructor> getConstructors(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return null;
    }

    public boolean isInterface(ClassType ct) {
        assert (ct == this.getNameInfo().getNullType());
        return false;
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        if (m instanceof DefaultConstructor || m instanceof ImplicitEnumMethod) {
            return m.getContainingClassType();
        }
        return null;
    }

    @Override
    public List<Type> getSignature(Method m) {
        if (m instanceof ImplicitEnumValueOf) {
            ArrayList<Type> tal = new ArrayList<Type>(1);
            tal.add(this.getServiceConfiguration().getNameInfo().getJavaLangString());
            return tal;
        }
        return new ArrayList<Type>(0);
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        if (m instanceof ImplicitEnumValueOf) {
            if (this.enumValueOfExceptions == null) {
                this.enumValueOfExceptions = new ArrayList<ClassType>(2);
                this.enumValueOfExceptions.add(this.getNameInfo().getClassType("java.lang.IllegalArgumentException"));
                this.enumValueOfExceptions.add(this.getNameInfo().getClassType("java.lang.NullPointerException"));
            }
            return this.enumValueOfExceptions;
        }
        return new ArrayList<ClassType>(0);
    }

    @Override
    public Type getReturnType(Method m) {
        if (m instanceof ImplicitEnumValueOf) {
            return m.getContainingClassType();
        }
        if (m instanceof ImplicitEnumValues) {
            return this.getServiceConfiguration().getNameInfo().createArrayType(m.getContainingClassType());
        }
        return null;
    }
}

