/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.EnumConstant;
import recoder.abstraction.Field;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.NullType;
import recoder.abstraction.Package;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.abstraction.Variable;
import recoder.bytecode.ClassFile;
import recoder.bytecode.ReflectionImport;
import recoder.convenience.Format;
import recoder.io.ClassFileRepository;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.service.ByteCodeInfo;
import recoder.service.ImplicitElementInfo;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public class DefaultNameInfo
extends AbstractService
implements NameInfo,
PropertyChangeListener {
    private static final boolean DEBUG = false;
    private static final int NO_SEARCH = 0;
    private static final int SEARCH_SOURCE = 1;
    private static final int SEARCH_CLASS = 2;
    private static final int SEARCH_REFLECT = 3;
    private final Map<String, Type> name2type = new HashMap<String, Type>(128);
    private final Map<String, Field> name2field = new HashMap<String, Field>(128);
    private final HashMap<ClassType, ArrayList<ArrayType>> removedArrayCache = new HashMap(128);
    private final PrimitiveType booleanType;
    private final PrimitiveType byteType;
    private final PrimitiveType shortType;
    private final PrimitiveType longType;
    private final PrimitiveType intType;
    private final PrimitiveType floatType;
    private final PrimitiveType doubleType;
    private final PrimitiveType charType;
    private final ProgramModelElement unknownElement = new UnknownProgramModelElement();
    private final ClassType unknownClassType = new UnknownClassType();
    private final Type unknownType = this.unknownClassType;
    private final Package unknownPackage = new Package("<unknownPackage>", null);
    private final Method unknownMethod = new UnknownMethod();
    private final Constructor unknownConstructor = new UnknownConstructor();
    private final Variable unknownVariable = new UnknownVariable();
    private final Field unknownField = new UnknownField();
    private final AnnotationProperty unknownAnnotationProperty = new UnknownAnnotationProperty();
    private Map<String, Package> name2package = new HashMap<String, Package>(64);
    private ClassType nullType;
    private ClassType javaLangObject;
    private ClassType javaLangString;
    private ClassType javaLangClass;
    private ClassType javaLangCloneable;
    private ClassType javaIoSerializable;
    private ClassType javaLangRunnable;
    private ClassType javaLangBoolean;
    private ClassType javaLangByte;
    private ClassType javaLangCharacter;
    private ClassType javaLangShort;
    private ClassType javaLangInteger;
    private ClassType javaLangLong;
    private ClassType javaLangFloat;
    private ClassType javaLangDouble;
    private ClassType javaLangAnnotationAnnotation;
    private ClassType javaLangEnum;
    private int[] searchMode;

    public DefaultNameInfo(ServiceConfiguration config) {
        super(config);
        this.booleanType = this.createPrimitiveType("boolean");
        this.byteType = this.createPrimitiveType("byte");
        this.shortType = this.createPrimitiveType("short");
        this.longType = this.createPrimitiveType("long");
        this.intType = this.createPrimitiveType("int");
        this.floatType = this.createPrimitiveType("float");
        this.doubleType = this.createPrimitiveType("double");
        this.charType = this.createPrimitiveType("char");
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        this.nullType = new NullType(cfg.getImplicitElementInfo());
        this.createPackage("java.lang");
        cfg.getProjectSettings().addPropertyChangeListener(this);
        this.updateSearchMode();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changedProp = evt.getPropertyName();
        if (changedProp.equals("class.search.mode")) {
            this.updateSearchMode();
        }
    }

    private void updateSearchMode() {
        String prop = this.serviceConfiguration.getProjectSettings().getProperty("class.search.mode");
        if (prop == null) {
            prop = "";
        }
        this.searchMode = new int[prop.length()];
        block5: for (int i = 0; i < this.searchMode.length; ++i) {
            switch (prop.charAt(i)) {
                case 'S': 
                case 's': {
                    this.searchMode[i] = 1;
                    continue block5;
                }
                case 'C': 
                case 'c': {
                    this.searchMode[i] = 2;
                    continue block5;
                }
                case 'R': 
                case 'r': {
                    this.searchMode[i] = 3;
                    continue block5;
                }
                default: {
                    this.searchMode[i] = 0;
                }
            }
        }
    }

    private PrimitiveType createPrimitiveType(String name) {
        PrimitiveType res = new PrimitiveType(name, this.getImplicitElementInfo());
        this.name2type.put(res.getName(), res);
        return res;
    }

    final void updateModel() {
        this.serviceConfiguration.getChangeHistory().updateModel();
    }

    ClassFileRepository getClassFileRepository() {
        return this.serviceConfiguration.getClassFileRepository();
    }

    SourceFileRepository getSourceFileRepository() {
        return this.serviceConfiguration.getSourceFileRepository();
    }

    ByteCodeInfo getByteCodeInfo() {
        return this.serviceConfiguration.getByteCodeInfo();
    }

    SourceInfo getSourceInfo() {
        return this.serviceConfiguration.getSourceInfo();
    }

    ImplicitElementInfo getImplicitElementInfo() {
        return this.serviceConfiguration.getImplicitElementInfo();
    }

    @Override
    public void register(ClassType ct) {
        ArrayList<ArrayType> al;
        Debug.assertNonnull(ct);
        String name = ct.getFullName();
        Type ob = this.name2type.put(name, ct);
        if (ob != null && ob != ct && !(ob instanceof UnknownClassType)) {
            Debug.log("Internal Warning - Multiple registration of " + Format.toString("%N [%i]", ct) + Format.toString(" --- was: %N [%i]", ob));
        }
        if ((al = this.removedArrayCache.get(ct)) != null) {
            for (int i = 0; i < al.size(); ++i) {
                ArrayType at = al.get(i);
                at.makeNames();
                this.name2type.put(at.getFullName(), at);
            }
        }
    }

    @Override
    public void register(Field f) {
        Debug.assertNonnull(f);
        this.name2field.put(f.getFullName(), f);
    }

    @Override
    public ClassType getJavaLangObject() {
        if (this.javaLangObject == null) {
            this.javaLangObject = this.getClassType("java.lang.Object");
        }
        return this.javaLangObject;
    }

    @Override
    public ClassType getJavaLangString() {
        if (this.javaLangString == null) {
            this.javaLangString = this.getClassType("java.lang.String");
        }
        return this.javaLangString;
    }

    @Override
    public ClassType getJavaLangBoolean() {
        if (this.javaLangBoolean == null) {
            this.javaLangBoolean = this.getClassType("java.lang.Boolean");
        }
        return this.javaLangBoolean;
    }

    @Override
    public ClassType getJavaLangByte() {
        if (this.javaLangByte == null) {
            this.javaLangByte = this.getClassType("java.lang.Byte");
        }
        return this.javaLangByte;
    }

    @Override
    public ClassType getJavaLangCharacter() {
        if (this.javaLangCharacter == null) {
            this.javaLangCharacter = this.getClassType("java.lang.Character");
        }
        return this.javaLangCharacter;
    }

    @Override
    public ClassType getJavaLangShort() {
        if (this.javaLangShort == null) {
            this.javaLangShort = this.getClassType("java.lang.Short");
        }
        return this.javaLangShort;
    }

    @Override
    public ClassType getJavaLangInteger() {
        if (this.javaLangInteger == null) {
            this.javaLangInteger = this.getClassType("java.lang.Integer");
        }
        return this.javaLangInteger;
    }

    @Override
    public ClassType getJavaLangLong() {
        if (this.javaLangLong == null) {
            this.javaLangLong = this.getClassType("java.lang.Long");
        }
        return this.javaLangLong;
    }

    @Override
    public ClassType getJavaLangFloat() {
        if (this.javaLangFloat == null) {
            this.javaLangFloat = this.getClassType("java.lang.Float");
        }
        return this.javaLangFloat;
    }

    @Override
    public ClassType getJavaLangDouble() {
        if (this.javaLangDouble == null) {
            this.javaLangDouble = this.getClassType("java.lang.Double");
        }
        return this.javaLangDouble;
    }

    @Override
    public ClassType getJavaLangClass() {
        if (this.javaLangClass == null) {
            this.javaLangClass = this.getClassType("java.lang.Class");
        }
        return this.javaLangClass;
    }

    @Override
    public ClassType getJavaLangCloneable() {
        if (this.javaLangCloneable == null) {
            this.javaLangCloneable = this.getClassType("java.lang.Cloneable");
        }
        return this.javaLangCloneable;
    }

    public ClassType getJavaLangRunnable() {
        if (this.javaLangRunnable == null) {
            this.javaLangRunnable = this.getClassType("java.lang.Runnable");
        }
        return this.javaLangRunnable;
    }

    @Override
    public ClassType getJavaIoSerializable() {
        if (this.javaIoSerializable == null) {
            this.javaIoSerializable = this.getClassType("java.io.Serializable");
        }
        return this.javaIoSerializable;
    }

    @Override
    public ClassType getJavaLangAnnotationAnnotation() {
        if (this.javaLangAnnotationAnnotation == null) {
            this.javaLangAnnotationAnnotation = this.getClassType("java.lang.annotation.Annotation");
        }
        return this.javaLangAnnotationAnnotation;
    }

    @Override
    public ClassType getJavaLangEnum() {
        if (this.javaLangEnum == null) {
            this.javaLangEnum = this.getClassType("java.lang.Enum");
        }
        return this.javaLangEnum;
    }

    @Override
    public ClassType getNullType() {
        return this.nullType;
    }

    @Override
    public PrimitiveType getShortType() {
        return this.shortType;
    }

    @Override
    public PrimitiveType getByteType() {
        return this.byteType;
    }

    @Override
    public PrimitiveType getBooleanType() {
        return this.booleanType;
    }

    @Override
    public PrimitiveType getIntType() {
        return this.intType;
    }

    @Override
    public PrimitiveType getLongType() {
        return this.longType;
    }

    @Override
    public PrimitiveType getFloatType() {
        return this.floatType;
    }

    @Override
    public PrimitiveType getDoubleType() {
        return this.doubleType;
    }

    @Override
    public PrimitiveType getCharType() {
        return this.charType;
    }

    public boolean isPackage(String name) {
        this.updateModel();
        return this.name2package.get(name) != null;
    }

    @Override
    public Package createPackage(String name) {
        Package result = this.name2package.get(name);
        if (result == null) {
            result = new Package(name, this.serviceConfiguration.getImplicitElementInfo());
            this.name2package.put(result.getName(), result);
            int ldp = name.lastIndexOf(46);
            if (ldp > 0) {
                this.createPackage(name.substring(0, ldp));
            }
        }
        return result;
    }

    @Override
    public Package getPackage(String name) {
        Debug.assertNonnull(name);
        this.updateModel();
        return this.name2package.get(name);
    }

    @Override
    public List<Package> getPackages() {
        this.updateModel();
        int size = this.name2package.size();
        ArrayList<Package> result = new ArrayList<Package>(size);
        for (Package p : this.name2package.values()) {
            result.add(p);
        }
        return result;
    }

    @Override
    public ClassType getClassType(String name) {
        Type result = this.getType(name);
        if (result instanceof ClassType) {
            return (ClassType)result;
        }
        return null;
    }

    @Override
    public ArrayType createArrayType(Type basetype) {
        String aname = basetype.getFullName() + "[]";
        ArrayType result = (ArrayType)this.name2type.get(aname);
        if (result == null) {
            result = new ArrayType(basetype, this.serviceConfiguration.getImplicitElementInfo());
            this.name2type.put(result.getFullName(), result);
        }
        return result;
    }

    @Override
    public ArrayType createArrayType(Type basetype, int dimensions) {
        if (dimensions < 1) {
            throw new IllegalArgumentException("dimensions must be >= 1");
        }
        Type result = basetype;
        while (dimensions-- > 0) {
            result = this.createArrayType(result);
        }
        return (ArrayType)result;
    }

    @Override
    public ArrayType getArrayType(Type basetype) {
        Debug.assertNonnull(basetype);
        this.updateModel();
        String aname = basetype.getFullName() + "[]";
        return (ArrayType)this.name2type.get(aname);
    }

    @Override
    public Type getType(String name) {
        Debug.assertNonnull(name);
        this.updateModel();
        Type result = this.name2type.get(name);
        if (result != null && !name.equals(result.getFullName())) {
            this.name2type.remove(name);
            result = null;
        }
        if (result == this.unknownType) {
            return null;
        }
        if (result == null) {
            if (name.endsWith("]") && (result = this.getType(name.substring(0, name.length() - 2))) != null) {
                return this.createArrayType(result);
            }
            if (result == null && this.loadClass(name) && (result = this.name2type.get(name)) == this.unknownType) {
                return null;
            }
            this.name2type.put(name, result != null ? result : this.unknownType);
        }
        return result;
    }

    @Override
    public List<Type> getTypes() {
        this.updateModel();
        int size = this.name2type.size();
        ArrayList<Type> result = new ArrayList<Type>(size);
        for (Type t : this.name2type.values()) {
            if (t == this.unknownType) continue;
            result.add(t);
        }
        return result;
    }

    @Override
    public List<ClassType> getTypes(Package pkg) {
        Debug.assertNonnull(pkg);
        this.updateModel();
        ArrayList<ClassType> result = new ArrayList<ClassType>();
        List<Type> tl = this.getTypes();
        int s = tl.size();
        for (int i = 0; i < s; ++i) {
            ClassType ct;
            Type t = tl.get(i);
            if (!(t instanceof ClassType) || (ct = (ClassType)t).getContainer() != pkg) continue;
            result.add(ct);
        }
        return result;
    }

    @Override
    public List<ClassType> getClassTypes() {
        this.updateModel();
        ArrayList<ClassType> result = new ArrayList<ClassType>(this.name2type.size() - 8);
        List<Type> tl = this.getTypes();
        int s = tl.size();
        for (int i = 0; i < s; ++i) {
            Type t = tl.get(i);
            if (!(t instanceof ClassType)) continue;
            result.add((ClassType)t);
        }
        return result;
    }

    @Override
    public Field getField(String name) {
        String fname;
        Debug.assertNonnull(name);
        this.updateModel();
        Field result = this.name2field.get(name);
        if (result != null) {
            return result;
        }
        int ldp = name.lastIndexOf(46);
        if (ldp == -1) {
            return null;
        }
        ClassType ct = this.getClassType(name.substring(0, ldp));
        if (ct == null) {
            return null;
        }
        List<? extends Field> fields = ct.getFields();
        if (fields == null) {
            return null;
        }
        String shortname = name.substring(ldp + 1);
        for (int i = 0; !(i >= fields.size() || shortname.equals(fname = fields.get(i).getName()) && (result = fields.get(i)) != null); ++i) {
        }
        return result;
    }

    @Override
    public List<Field> getFields() {
        this.updateModel();
        int size = this.name2field.size();
        ArrayList<Field> result = new ArrayList<Field>(size);
        for (Field f : this.name2field.values()) {
            result.add(f);
        }
        return result;
    }

    private boolean loadClass(String classname) {
        boolean result = false;
        block5: for (int i = 0; !result && i < this.searchMode.length; ++i) {
            switch (this.searchMode[i]) {
                case 1: {
                    result = this.loadClassFromSourceCode(classname);
                    continue block5;
                }
                case 2: {
                    result = this.loadClassFromPrecompiledCode(classname);
                    continue block5;
                }
                case 3: {
                    result = this.loadClassByReflection(classname);
                    continue block5;
                }
            }
        }
        return result;
    }

    private boolean loadClassFromPrecompiledCode(String classname) {
        boolean result = false;
        ClassFileRepository cfr = this.getClassFileRepository();
        ClassFile cf = cfr.getClassFile(classname);
        if (cf != null) {
            this.getByteCodeInfo().register(cf);
            result = true;
        }
        return result;
    }

    private boolean loadClassFromSourceCode(String classname) {
        boolean result = false;
        CompilationUnit cu = null;
        try {
            int ldp;
            cu = this.getSourceFileRepository().getCompilationUnit(classname);
            if (cu == null && (ldp = classname.lastIndexOf(46)) >= 0) {
                String shortedname = classname.substring(0, ldp);
                return !this.name2package.containsKey(shortedname) && this.loadClassFromSourceCode(shortedname) && this.name2type.containsKey(classname);
            }
            if (cu != null) {
                this.getSourceInfo().register(cu);
                result = true;
            }
        }
        catch (Exception e) {
            Debug.error("Error trying to retrieve source file for type " + classname + "\nException was " + e);
            e.printStackTrace();
        }
        return result;
    }

    private boolean loadClassByReflection(String classname) {
        ClassFile cf = ReflectionImport.getClassFile(classname);
        if (cf != null) {
            this.getByteCodeInfo().register(cf);
            return true;
        }
        return false;
    }

    public String information() {
        int unknown = 0;
        for (Type t : this.name2type.values()) {
            if (t != this.unknownType) continue;
            ++unknown;
        }
        return this.name2package.size() + " packages with " + (this.name2type.size() - unknown) + " types (" + unknown + " were pure speculations) and " + this.name2field.size() + " fields";
    }

    @Override
    public void unregisterClassType(String fullname) {
        this.unregisterClassType(fullname, false);
    }

    void unregisterClassType(String fullname, boolean recycleArrayEntries) {
        Type array;
        Debug.assertNonnull(fullname);
        ClassType old = (ClassType)this.name2type.remove(fullname);
        fullname = (String)fullname + "[]";
        ArrayList<ArrayType> al = new ArrayList<ArrayType>();
        while ((array = this.name2type.remove(fullname)) != null) {
            if (recycleArrayEntries) {
                al.add((ArrayType)array);
            }
            fullname = (String)fullname + "[]";
        }
        if (recycleArrayEntries) {
            this.removedArrayCache.put(old, al);
        }
    }

    @Override
    public void unregisterField(String fullname) {
        Debug.assertNonnull(fullname);
        this.name2field.remove(fullname);
    }

    public void unregisterPackages() {
        HashMap<String, Package> n2p = new HashMap<String, Package>(64);
        List<ClassFile> cf = this.getClassFileRepository().getKnownClassFiles();
        for (int i = cf.size() - 1; i >= 0; --i) {
            ClassTypeContainer ctc = cf.get(i).getContainer();
            if (!(ctc instanceof Package)) continue;
            n2p.put(ctc.getFullName(), (Package)ctc);
        }
        this.name2package.clear();
        this.name2package = n2p;
    }

    @Override
    public ClassType getUnknownClassType() {
        return this.unknownClassType;
    }

    @Override
    public ProgramModelElement getUnknownElement() {
        return this.unknownElement;
    }

    @Override
    public Package getUnknownPackage() {
        return this.unknownPackage;
    }

    @Override
    public Method getUnknownMethod() {
        return this.unknownMethod;
    }

    @Override
    public Constructor getUnknownConstructor() {
        return this.unknownConstructor;
    }

    @Override
    public Variable getUnknownVariable() {
        return this.unknownVariable;
    }

    @Override
    public Field getUnknownField() {
        return this.unknownField;
    }

    @Override
    public Type getUnknownType() {
        return this.unknownType;
    }

    @Override
    public AnnotationProperty getUnknownAnnotationProperty() {
        return this.unknownAnnotationProperty;
    }

    void handleTypeRename(ClassType ct, String unregisterFrom, String registerTo) {
        Type removed;
        boolean register = false;
        boolean unregister = false;
        Type old = this.name2type.get(registerTo);
        if (old == null || old == this.unknownType) {
            register = true;
        }
        if ((old = this.name2type.get(unregisterFrom)) == ct) {
            unregister = true;
        }
        if (unregister) {
            this.name2type.remove(unregisterFrom);
        }
        String newArrayName = registerTo + "[]";
        String arrayRemove = unregisterFrom + "[]";
        while ((removed = this.name2type.remove(arrayRemove)) != null) {
            this.name2type.put(newArrayName, removed);
            arrayRemove = arrayRemove + "[]";
            newArrayName = newArrayName + "[]";
        }
        if (register) {
            this.register(ct);
        }
        this.name2type.put(unregisterFrom, this.unknownClassType);
        List<? extends Field> fl = ct.getFields();
        int fm = fl.size();
        for (int f = 0; f < fm; ++f) {
            Field currentField = fl.get(f);
            String fieldremove = unregisterFrom + "." + currentField.getName();
            if (unregister) {
                this.unregisterField(fieldremove);
            }
            if (!register) continue;
            this.register(currentField);
        }
    }

    class UnknownAnnotationProperty
    extends UnknownMethod
    implements AnnotationProperty {
        UnknownAnnotationProperty() {
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    class UnknownField
    extends UnknownMember
    implements Field {
        UnknownField() {
        }

        @Override
        public String getName() {
            return "<unknownField>";
        }

        @Override
        public Type getType() {
            return DefaultNameInfo.this.unknownType;
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return null;
        }
    }

    class UnknownVariable
    extends UnknownProgramModelElement
    implements Variable {
        UnknownVariable() {
        }

        @Override
        public String getName() {
            return "<unknownVariable>";
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public Type getType() {
            return DefaultNameInfo.this.unknownType;
        }
    }

    class UnknownConstructor
    extends UnknownMethod
    implements Constructor {
        UnknownConstructor() {
        }

        @Override
        public String getName() {
            return "<unknownConstructor>";
        }
    }

    class UnknownMethod
    extends UnknownMember
    implements Method {
        UnknownMethod() {
        }

        @Override
        public String getName() {
            return "<unknownMethod>";
        }

        @Override
        public Package getPackage() {
            return DefaultNameInfo.this.unknownPackage;
        }

        @Override
        public ClassTypeContainer getContainer() {
            return DefaultNameInfo.this.unknownClassType;
        }

        public List<ClassType> getTypes() {
            return new ArrayList<ClassType>(0);
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public List<ClassType> getExceptions() {
            return new ArrayList<ClassType>(0);
        }

        @Override
        public Type getReturnType() {
            return DefaultNameInfo.this.unknownType;
        }

        @Override
        public List<Type> getSignature() {
            return new ArrayList<Type>(0);
        }

        @Override
        public boolean isVarArgMethod() {
            return false;
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        @Override
        public List<? extends TypeParameter> getTypeParameters() {
            return null;
        }
    }

    class UnknownClassType
    extends UnknownMember
    implements ClassType {
        UnknownClassType() {
        }

        @Override
        public String getName() {
            return "<unknownClassType>";
        }

        @Override
        public ClassTypeContainer getContainer() {
            return null;
        }

        public List<ClassType> getTypes() {
            return new ArrayList<ClassType>(0);
        }

        @Override
        public Package getPackage() {
            return DefaultNameInfo.this.unknownPackage;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public boolean isOrdinaryInterface() {
            return false;
        }

        @Override
        public boolean isAnnotationType() {
            return true;
        }

        @Override
        public boolean isEnumType() {
            return false;
        }

        @Override
        public boolean isOrdinaryClass() {
            return true;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public List<ClassType> getSupertypes() {
            return new ArrayList<ClassType>(0);
        }

        @Override
        public List<ClassType> getAllSupertypes() {
            ArrayList<ClassType> result = new ArrayList<ClassType>();
            result.add(this);
            result.add(DefaultNameInfo.this.getJavaLangObject());
            return result;
        }

        @Override
        public List<? extends Field> getFields() {
            return DefaultNameInfo.this.getJavaLangObject().getFields();
        }

        @Override
        public List<Field> getAllFields() {
            return DefaultNameInfo.this.getJavaLangObject().getAllFields();
        }

        @Override
        public List<Method> getMethods() {
            return DefaultNameInfo.this.getJavaLangObject().getMethods();
        }

        @Override
        public List<Method> getAllMethods() {
            return DefaultNameInfo.this.getJavaLangObject().getAllMethods();
        }

        public List<Constructor> getConstructors() {
            return new ArrayList<Constructor>(0);
        }

        @Override
        public List<ClassType> getAllTypes() {
            return new ArrayList<ClassType>(0);
        }

        public List<AnnotationUseSpecification> getAnnotations() {
            return null;
        }

        public List<? extends EnumConstant> getEnumConstants() {
            return null;
        }

        public List<TypeParameterDeclaration> getTypeParameters() {
            return null;
        }
    }

    abstract class UnknownMember
    extends UnknownProgramModelElement
    implements Member {
        UnknownMember() {
        }

        @Override
        public ClassType getContainingClassType() {
            return DefaultNameInfo.this.unknownClassType;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isPrivate() {
            return false;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isStrictFp() {
            return false;
        }
    }

    class UnknownProgramModelElement
    implements ProgramModelElement {
        UnknownProgramModelElement() {
        }

        @Override
        public String getName() {
            return "<unkownElement>";
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        @Override
        public ProgramModelInfo getProgramModelInfo() {
            return null;
        }

        @Override
        public void setProgramModelInfo(ProgramModelInfo pmi) {
        }

        @Override
        public void validate() {
        }

        public UnknownProgramModelElement deepClone() {
            throw new UnsupportedOperationException("Cannot deep-clone implicit information");
        }
    }
}

