/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import recoder.AbstractService;
import recoder.ServiceConfiguration;
import recoder.TuningParameters;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.NullType;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.bytecode.TypeArgumentInfo;
import recoder.bytecode.TypeParameterInfo;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.reference.TypeReference;
import recoder.service.ChangeHistory;
import recoder.service.ClassTypeTopSort;
import recoder.service.CyclicInheritanceException;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.ProgramModelInfo;
import recoder.service.SourceInfo;
import recoder.util.Debug;

public abstract class DefaultProgramModelInfo
extends AbstractService
implements ProgramModelInfo,
TuningParameters {
    final Map<ClassType, ClassTypeCacheEntry> classTypeCache = new HashMap<ClassType, ClassTypeCacheEntry>(256);

    protected DefaultProgramModelInfo(ServiceConfiguration config) {
        super(config);
    }

    private static void removeRange(List list, int from) {
        for (int i = list.size() - 1; i >= from; --i) {
            list.remove(i);
        }
    }

    private static void removeRange(List list, int from, int to) {
        if (from > to) {
            int n = to;
            to ^= from;
            from ^= to;
            to = n ^ from;
        }
        int cnt = to - from;
        while (cnt-- > 0) {
            list.remove(from);
        }
    }

    final ChangeHistory getChangeHistory() {
        return this.serviceConfiguration.getChangeHistory();
    }

    ErrorHandler getErrorHandler() {
        return this.serviceConfiguration.getProjectSettings().getErrorHandler();
    }

    NameInfo getNameInfo() {
        return this.serviceConfiguration.getNameInfo();
    }

    protected final void updateModel() {
        this.getChangeHistory().updateModel();
    }

    void registerSubtype(ClassType subtype, ClassType supertype) {
        ClassTypeCacheEntry ctce;
        ProgramModelInfo pmi = supertype.getProgramModelInfo();
        if (pmi != this) {
            ((DefaultProgramModelInfo)pmi).registerSubtype(subtype, supertype);
        }
        if ((ctce = this.classTypeCache.get(supertype)) == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(supertype, ctce);
        }
        if (ctce.subtypes == null) {
            ctce.subtypes = new HashSet<ClassType>();
        }
        ctce.subtypes.add(subtype);
    }

    void removeSubtype(ClassType subtype, ClassType supertype) {
        ClassTypeCacheEntry ctce;
        ProgramModelInfo pmi = supertype.getProgramModelInfo();
        if (pmi != this) {
            ((DefaultProgramModelInfo)pmi).registerSubtype(subtype, supertype);
        }
        if ((ctce = this.classTypeCache.get(supertype)) != null && ctce.subtypes != null) {
            ctce.subtypes.remove(subtype);
        }
    }

    @Override
    public List<ClassType> getSubtypes(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getSubtypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.subtypes == null) {
            return new ArrayList<ClassType>(0);
        }
        int s = ctce.subtypes.size();
        ArrayList<ClassType> result = new ArrayList<ClassType>(s);
        for (ClassType subct : ctce.subtypes) {
            result.add(subct);
        }
        return result;
    }

    @Override
    public List<ClassType> getAllSubtypes(ClassType ct) {
        this.updateModel();
        List<ClassType> ctl = new SubTypeTopSort().getAllTypes(ct);
        ctl.remove(0);
        return ctl;
    }

    @Override
    public List<ClassType> getAllSupertypes(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllSupertypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        return ctce.allSupertypes;
    }

    private void computeAllSupertypes(ClassType ct, ClassTypeCacheEntry ctce) {
        ctce.allSupertypes = new SuperTypeTopSort().getAllTypes(ct);
    }

    @Override
    public List<Field> getAllFields(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllFields(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allFields == null) {
            this.computeAllFields(ct, ctce);
        }
        return ctce.allFields;
    }

    private void computeAllFields(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        int s = classes.size();
        ArrayList<Field> result = new ArrayList<Field>(s * 4);
        int result_size = 0;
        for (int i = 0; i < s; ++i) {
            ClassType c = classes.get(i);
            List<? extends Field> fl = c.getFields();
            if (fl == null) continue;
            int fs = fl.size();
            block1: for (int j = 0; j < fs; ++j) {
                Field f = fl.get(j);
                if (!this.isVisibleFor(f, ct)) continue;
                String fname = f.getName();
                for (int k = 0; k < result_size; ++k) {
                    Field rf = result.get(k);
                    if (rf.getName() == fname) continue block1;
                }
                result.add(f);
                ++result_size;
            }
        }
        result.trimToSize();
        ctce.allFields = result;
    }

    @Override
    public List<Method> getAllMethods(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllMethods(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allMethods == null) {
            this.computeAllMethods(ct, ctce);
        }
        return ctce.allMethods;
    }

    private void computeAllMethods(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        int s = classes.size();
        ArrayList<Method> result = new ArrayList<Method>(s * 8);
        int result_size = 0;
        for (int i = 0; i < s; ++i) {
            ClassType c = classes.get(i);
            List<Method> ml = c.getMethods();
            if (ml == null) continue;
            int ms = ml.size();
            block1: for (int j = 0; j < ms; ++j) {
                Method m = ml.get(j);
                if (!this.isVisibleFor(m, ct)) continue;
                List<Type> msig = m.getSignature();
                if (c instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)c;
                    ArrayList<Type> tmp = new ArrayList<Type>(msig.size());
                    for (int n = 0; n < msig.size(); ++n) {
                        Type t = msig.get(n);
                        if (t instanceof TypeParameter) {
                            int q;
                            for (q = 0; q < pt.getGenericType().getTypeParameters().size() && pt.getGenericType().getTypeParameters().get(q) != t; ++q) {
                            }
                            if (q < pt.getGenericType().getTypeParameters().size()) {
                                tmp.add(this.makeParameterizedType(pt.getTypeArgs().get(q)));
                                continue;
                            }
                            tmp.add(t);
                            continue;
                        }
                        tmp.add(t);
                    }
                    msig = tmp;
                }
                String mname = m.getName();
                for (int k = 0; k < result_size; ++k) {
                    List<Type> rsig;
                    Method rm = result.get(k);
                    if (rm.getName() == mname && (rsig = rm.getSignature()).equals(msig)) continue block1;
                }
                result.add(m);
                ++result_size;
            }
        }
        result.trimToSize();
        ctce.allMethods = result;
    }

    private Type makeParameterizedType(TypeArgument ta) {
        Type bt = null;
        switch (ta.getWildcardMode()) {
            case Super: 
            case Any: {
                bt = this.getNameInfo().getJavaLangObject();
                break;
            }
            case None: 
            case Extends: {
                bt = this.getBaseType(ta);
            }
        }
        if (ta.getTypeArguments() == null || ta.getTypeArguments().size() == 0) {
            return bt;
        }
        return new ParameterizedType((ClassType)bt, ta.getTypeArguments());
    }

    @Override
    public List<ClassType> getAllTypes(ClassType ct) {
        this.updateModel();
        ProgramModelInfo pmi = ct.getProgramModelInfo();
        if (pmi != this) {
            Debug.assertNonnull(pmi);
            return pmi.getAllTypes(ct);
        }
        ClassTypeCacheEntry ctce = this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.allMemberTypes == null) {
            this.computeAllMemberTypes(ct, ctce);
        }
        return ctce.allMemberTypes;
    }

    private void computeAllMemberTypes(ClassType ct, ClassTypeCacheEntry ctce) {
        if (ctce.allSupertypes == null) {
            this.computeAllSupertypes(ct, ctce);
        }
        List<ClassType> classes = ctce.allSupertypes;
        int s = classes.size();
        ArrayList<ClassType> result = new ArrayList<ClassType>(s);
        int result_size = 0;
        for (int i = 0; i < s; ++i) {
            ClassType c = classes.get(i);
            List<? extends ClassType> cl = c.getTypes();
            if (cl == null) continue;
            int cs = cl.size();
            block1: for (int j = 0; j < cs; ++j) {
                ClassType hc = cl.get(j);
                if (hc == ct || !this.isVisibleFor(hc, ct)) continue;
                String cname = hc.getName();
                for (int k = 0; k < result_size; ++k) {
                    ClassType rc = result.get(k);
                    if (rc.getName() == cname) continue block1;
                }
                result.add(hc);
                ++result_size;
            }
        }
        result.trimToSize();
        ctce.allMemberTypes = result;
    }

    @Override
    public PrimitiveType getPromotedType(PrimitiveType a, PrimitiveType b) {
        if (a == b) {
            return a;
        }
        NameInfo ni = this.getNameInfo();
        if (a == ni.getBooleanType() || b == ni.getBooleanType()) {
            return null;
        }
        if (a == ni.getDoubleType() || b == ni.getDoubleType()) {
            return ni.getDoubleType();
        }
        if (a == ni.getFloatType() || b == ni.getFloatType()) {
            return ni.getFloatType();
        }
        if (a == ni.getLongType() || b == ni.getLongType()) {
            return ni.getLongType();
        }
        return ni.getIntType();
    }

    @Override
    public boolean isWidening(PrimitiveType from, PrimitiveType to) {
        if (from == null || to == null) {
            return false;
        }
        if (from == to) {
            return true;
        }
        NameInfo ni = this.getNameInfo();
        if (from == ni.getBooleanType() || to == ni.getBooleanType()) {
            return false;
        }
        if (to == ni.getDoubleType()) {
            return true;
        }
        if (from == ni.getDoubleType()) {
            return false;
        }
        if (to == ni.getFloatType()) {
            return true;
        }
        if (from == ni.getFloatType()) {
            return false;
        }
        if (to == ni.getLongType()) {
            return true;
        }
        if (from == ni.getLongType()) {
            return false;
        }
        if (to == ni.getIntType()) {
            return true;
        }
        if (from == ni.getIntType()) {
            return false;
        }
        return from == ni.getByteType() && to == ni.getShortType();
    }

    @Override
    public boolean isWidening(ClassType from, ClassType to) {
        return this.isSubtype(from, to);
    }

    @Override
    public boolean isWidening(ArrayType from, ArrayType to) {
        Type toBase = to.getBaseType();
        if (toBase == this.getNameInfo().getJavaLangObject()) {
            return true;
        }
        Type fromBase = from.getBaseType();
        if (toBase instanceof PrimitiveType) {
            return toBase.equals(fromBase);
        }
        return this.isWidening(fromBase, toBase);
    }

    @Override
    public boolean isWidening(Type from, Type to) {
        if (from instanceof ClassType) {
            if (to instanceof ClassType) {
                return this.isWidening((ClassType)from, (ClassType)to);
            }
            return from instanceof NullType && (to instanceof ArrayType || to instanceof TypeParameter);
        }
        if (from instanceof PrimitiveType) {
            if (to instanceof PrimitiveType) {
                return this.isWidening((PrimitiveType)from, (PrimitiveType)to);
            }
        } else if (from instanceof ArrayType) {
            if (to instanceof ClassType) {
                NameInfo ni = this.getNameInfo();
                if (to == ni.getJavaLangObject()) {
                    return true;
                }
                if (to == ni.getJavaLangCloneable()) {
                    return true;
                }
                return to == ni.getJavaIoSerializable();
            }
            if (to instanceof ArrayType) {
                return this.isWidening((ArrayType)from, (ArrayType)to);
            }
        }
        return false;
    }

    @Override
    public boolean isSubtype(ClassType a, ClassType b) {
        boolean result = false;
        if (a instanceof ParameterizedType) {
            a = ((ParameterizedType)a).getGenericType();
        }
        if (b instanceof ParameterizedType) {
            b = ((ParameterizedType)b).getGenericType();
        }
        if (a instanceof TypeParameter && b instanceof TypeParameter) {
            result = true;
        } else if (a != null && b != null) {
            if (a == b || a == this.getNameInfo().getNullType() || b == this.getNameInfo().getJavaLangObject()) {
                result = true;
            } else {
                List<ClassType> superA = a.getSupertypes();
                if (superA != null) {
                    int s = superA.size();
                    for (int i = 0; i < s && !result; ++i) {
                        ClassType sa = superA.get(i);
                        if (sa == a) {
                            this.getErrorHandler().reportError(new CyclicInheritanceException(a));
                        }
                        if (!this.isSubtype(sa, b)) continue;
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isSupertype(ClassType a, ClassType b) {
        return this.isSubtype(b, a);
    }

    private final boolean paramMatches(Type ta, Type tb, boolean allowAutoboxing) {
        if (ta == tb) {
            return true;
        }
        while (ta instanceof ArrayType && tb instanceof ArrayType) {
            ta = ((ArrayType)ta).getBaseType();
            tb = ((ArrayType)tb).getBaseType();
        }
        if (tb instanceof TypeParameter && ta instanceof ArrayType) {
            TypeParameter tp = (TypeParameter)tb;
            if (tp.getBoundCount() == 0) {
                return true;
            }
            if (tp.getBoundCount() > 1) {
                return false;
            }
            return tp.getBoundName(0).equals("java.lang.Object");
        }
        if (tb instanceof TypeParameter && ta instanceof ClassType) {
            TypeParameter tp = (TypeParameter)tb;
            for (int i = 0; i < tp.getBoundCount(); ++i) {
                ClassType t = this.getClassTypeFromTypeParameter(tp, i);
                if (t == null) {
                    System.err.println(tp.getBoundName(i));
                    System.err.println("cannot resolve type reference in paramMatches/raw type check... TODO");
                }
                if (this.isWidening(ta, (Type)t)) continue;
                return false;
            }
            return true;
        }
        if (ta != null && !this.isWidening(ta, tb)) {
            if (allowAutoboxing) {
                if (ta instanceof PrimitiveType && this.isWidening((Type)this.getBoxedType((PrimitiveType)ta), tb)) {
                    return true;
                }
                if (!(ta instanceof ClassType)) {
                    return false;
                }
                PrimitiveType unboxedType = this.getUnboxedType((ClassType)ta);
                return this.isWidening((Type)unboxedType, tb);
            }
            return false;
        }
        return true;
    }

    private ClassType getClassTypeFromTypeParameter(TypeParameter tp, int i) {
        ClassType t;
        if (tp instanceof TypeParameterDeclaration) {
            TypeParameterDeclaration tpd = (TypeParameterDeclaration)tp;
            SourceInfo si = (SourceInfo)((Object)this);
            t = (ClassType)si.getType((TypeReference)tpd.getBounds().get(i));
        } else {
            t = this.getNameInfo().getClassType(tp.getBoundName(i));
        }
        return t;
    }

    private final boolean internalIsCompatibleSignature(List<Type> a, List<Type> b, boolean allowAutoboxing, boolean isVarArgMethod) {
        int s = b.size();
        int n = a.size();
        if (isVarArgMethod) {
            if (s > n + 1) {
                return false;
            }
            if (s == n) {
                Type tb;
                Type ta = a.get(s - 1);
                if (this.paramMatches(ta, tb = ((ArrayType)b.get(s - 1)).getBaseType(), allowAutoboxing)) {
                    --s;
                }
            } else {
                Type tb = ((ArrayType)b.get(s - 1)).getBaseType();
                for (int i = s - 1; i < n; ++i) {
                    Type ta = a.get(i);
                    if (this.paramMatches(ta, tb, allowAutoboxing)) continue;
                    return false;
                }
                --s;
            }
        } else if (s != n) {
            return false;
        }
        for (int i = 0; i < s; ++i) {
            Type tb;
            Type ta = a.get(i);
            if (this.paramMatches(ta, tb = b.get(i), allowAutoboxing)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isCompatibleSignature(List<Type> a, List<Type> b) {
        return this.internalIsCompatibleSignature(a, b, false, false);
    }

    @Override
    public final boolean isCompatibleSignature(List<Type> a, List<Type> b, boolean allowAutoboxing, boolean bIsVariableArityMethod) {
        return this.internalIsCompatibleSignature(a, b, allowAutoboxing, bIsVariableArityMethod);
    }

    @Override
    public ClassType getBoxedType(PrimitiveType unboxedType) {
        NameInfo ni = this.getNameInfo();
        if (unboxedType == ni.getBooleanType()) {
            return ni.getJavaLangBoolean();
        }
        if (unboxedType == ni.getByteType()) {
            return ni.getJavaLangByte();
        }
        if (unboxedType == ni.getCharType()) {
            return ni.getJavaLangCharacter();
        }
        if (unboxedType == ni.getShortType()) {
            return ni.getJavaLangShort();
        }
        if (unboxedType == ni.getIntType()) {
            return ni.getJavaLangInteger();
        }
        if (unboxedType == ni.getLongType()) {
            return ni.getJavaLangLong();
        }
        if (unboxedType == ni.getFloatType()) {
            return ni.getJavaLangFloat();
        }
        if (unboxedType == ni.getDoubleType()) {
            return ni.getJavaLangDouble();
        }
        throw new Error("Unknown primitive type " + unboxedType.getFullName());
    }

    @Override
    public PrimitiveType getUnboxedType(ClassType boxedType) {
        NameInfo ni = this.getNameInfo();
        if (boxedType == ni.getJavaLangBoolean()) {
            return ni.getBooleanType();
        }
        if (boxedType == ni.getJavaLangByte()) {
            return ni.getByteType();
        }
        if (boxedType == ni.getJavaLangCharacter()) {
            return ni.getCharType();
        }
        if (boxedType == ni.getJavaLangShort()) {
            return ni.getShortType();
        }
        if (boxedType == ni.getJavaLangInteger()) {
            return ni.getIntType();
        }
        if (boxedType == ni.getJavaLangLong()) {
            return ni.getLongType();
        }
        if (boxedType == ni.getJavaLangFloat()) {
            return ni.getFloatType();
        }
        if (boxedType == ni.getJavaLangDouble()) {
            return ni.getDoubleType();
        }
        return null;
    }

    protected ClassType getOutermostType(ClassType t) {
        ClassTypeContainer c = t;
        for (ClassTypeContainer cc = t.getContainer(); cc != null && !(cc instanceof Package); cc = cc.getContainer()) {
            c = cc;
        }
        return c;
    }

    @Override
    public boolean isVisibleFor(Member m, ClassType t) {
        if (t instanceof ParameterizedType) {
            t = ((ParameterizedType)t).getGenericType();
        }
        if (m.isPublic()) {
            return true;
        }
        ClassType mt = m.getContainingClassType();
        if (mt == null) {
            return false;
        }
        if (mt == t) {
            return true;
        }
        if (m.isPrivate()) {
            return this.getOutermostType(t) == this.getOutermostType(mt);
        }
        if (mt.getPackage() == t.getPackage()) {
            return true;
        }
        if (m.isProtected()) {
            return this.isSubtype(t, mt);
        }
        return false;
    }

    @Override
    public void filterApplicableMethods(List<Method> list, String name, List<Type> signature, ClassType context) {
        boolean allowJava5 = this.getServiceConfiguration().getProjectSettings().java5Allowed();
        this.internalFilterApplicableMethods(list, name, signature, context, null, allowJava5);
    }

    Type getBaseType(TypeArgument ta) {
        if (ta.getWildcardMode() == TypeArgument.WildcardMode.Any) {
            return this.getNameInfo().getJavaLangObject();
        }
        if (ta.getWildcardMode() == TypeArgument.WildcardMode.Super) {
            return this.getNameInfo().getJavaLangObject();
        }
        if (ta instanceof TypeArgumentInfo) {
            TypeArgumentInfo tai = (TypeArgumentInfo)ta;
            if (tai.isTypeVariable()) {
                if (tai.getContainingMethodInfo() != null && tai.getContainingMethodInfo().getTypeParameters() != null) {
                    for (TypeParameterInfo tpi : tai.getContainingMethodInfo().getTypeParameters()) {
                        if (!tpi.getName().equals(tai.getTypeName())) continue;
                        return tpi;
                    }
                }
                for (TypeParameterInfo tpi : tai.getContainingClassFile().getTypeParameters()) {
                    if (!tpi.getName().equals(tai.getTypeName())) continue;
                    return tpi;
                }
                throw new RuntimeException();
            }
            return this.getNameInfo().getClassType(ta.getTypeName());
        }
        if (ta instanceof TypeArgumentDeclaration) {
            SourceInfo si = this.getServiceConfiguration().getSourceInfo();
            return si.getType(((TypeArgumentDeclaration)ta).getTypeReferenceAt(0));
        }
        return ((ResolvedTypeArgument)ta).type;
    }

    protected List<Type> replaceTypeArgs(List<Type> sig, List<? extends TypeArgument> typeArgs, List<? extends TypeParameter> typeParams) {
        ArrayList<Type> res = new ArrayList<Type>(sig.size());
        for (int i = 0; i < sig.size(); ++i) {
            res.add(this.replaceTypeArg((Type)sig.get((int)i), typeArgs, typeParams).baseType);
        }
        return res;
    }

    ReplaceTypeArgResult replaceTypeArg(Type t, List<? extends TypeArgument> typeArgs, List<? extends TypeParameter> typeParams) {
        ReplaceTypeArgResult res = new ReplaceTypeArgResult(t, null);
        if (t instanceof TypeParameter) {
            for (int j = 0; j < typeParams.size(); ++j) {
                if (!t.equals(typeParams.get(j))) continue;
                res = new ReplaceTypeArgResult(this.getBaseType(typeArgs.get(j)), typeArgs.get(j).getWildcardMode());
                break;
            }
        }
        return res;
    }

    private void internalFilterApplicableMethods(List<Method> list, String name, List<Type> signature, ClassType context, List<? extends TypeArgument> typeArguments, boolean allowJava5) {
        block9: {
            Method m;
            int i;
            Debug.assertNonnull(name, signature, context);
            int s = list.size();
            for (i = 0; i < s && name.equals((m = list.get(i)).getName()) && this.isVisibleFor(m, context); ++i) {
                List<Type> methodSig = m.getSignature();
                if (m.getTypeParameters() != null && typeArguments != null) {
                    if (typeArguments.size() != m.getTypeParameters().size()) break;
                    methodSig = this.replaceTypeArguments(methodSig, typeArguments, m);
                }
                if (context instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)context;
                    methodSig = this.replaceTypeArgs(methodSig, pt.getTypeArgs(), pt.getGenericType().getTypeParameters());
                }
                if (!this.internalIsCompatibleSignature(signature, methodSig, allowJava5, m.isVarArgMethod() & allowJava5)) break;
            }
            if (i >= s) break block9;
            int j = i++;
            while (i < s) {
                block10: {
                    List<Type> methodSig;
                    Method m2;
                    block11: {
                        m2 = list.get(i);
                        if (!name.equals(m2.getName()) || !this.isVisibleFor(m2, context)) break block10;
                        methodSig = m2.getSignature();
                        if (m2.getTypeParameters() == null || typeArguments == null) break block11;
                        if (typeArguments.size() != m2.getTypeParameters().size()) break block10;
                        methodSig = this.replaceTypeArguments(methodSig, typeArguments, m2);
                    }
                    if (context instanceof ParameterizedType) {
                        ParameterizedType pt = (ParameterizedType)context;
                        methodSig = this.replaceTypeArgs(methodSig, pt.getTypeArgs(), pt.getGenericType().getTypeParameters());
                    }
                    if (this.internalIsCompatibleSignature(signature, methodSig, allowJava5, m2.isVarArgMethod() & allowJava5)) {
                        list.set(j, m2);
                        ++j;
                    }
                }
                ++i;
            }
            DefaultProgramModelInfo.removeRange(list, j);
        }
    }

    private List<Type> replaceTypeArguments(List<Type> methodSig, List<? extends TypeArgument> typeArguments, Method m) {
        ArrayList<Type> res = new ArrayList<Type>(methodSig.size());
        for (int k = 0; k < methodSig.size(); ++k) {
            res.add(methodSig.get(k));
        }
        for (int l = 0; l < m.getTypeParameters().size(); ++l) {
            TypeParameter tp = m.getTypeParameters().get(l);
            for (int k = 0; k < methodSig.size(); ++k) {
                Type param = methodSig.get(k);
                if (param instanceof ParameterizedType || !tp.equals(param)) continue;
                Type rep = this.makeParameterizedType(typeArguments.get(l));
                res.set(k, rep);
            }
        }
        return res;
    }

    @Override
    public void filterMostSpecificMethods(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, false, false);
    }

    @Override
    public void filterMostSpecificMethodsPhase2(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, true, false);
    }

    @Override
    public void filterMostSpecificMethodsPhase3(List<Method> list) {
        this.internalFilterMostSpecificMethods(list, true, true);
    }

    private void internalFilterMostSpecificMethods(List<Method> list, boolean allowAutoboxing, boolean allowVarArgs) {
        int size = list.size();
        if (size <= 1) {
            return;
        }
        List[] signatures = new List[size];
        signatures[0] = list.get(0).getSignature();
        for (int i = 1; i < size; ++i) {
            signatures[i] = list.get(i).getSignature();
            List<Type> sig = signatures[i];
            if (sig == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                List sig2 = signatures[j];
                if (sig2 == null) continue;
                if (this.internalIsCompatibleSignature(sig2, sig, allowAutoboxing, allowVarArgs & list.get(i).isVarArgMethod())) {
                    if (allowAutoboxing && this.internalIsCompatibleSignature(sig, sig2, allowAutoboxing, false)) continue;
                    signatures[i] = null;
                    continue;
                }
                if (!this.internalIsCompatibleSignature(sig, sig2, allowAutoboxing, allowVarArgs & list.get(j).isVarArgMethod())) continue;
                signatures[j] = null;
            }
        }
        int k = 0;
        for (int i = size - 1; i >= 0; --i) {
            if (signatures[i] == null) {
                ++k;
                continue;
            }
            if (k <= 0) continue;
            DefaultProgramModelInfo.removeRange(list, i + 1, i + k + 1);
            k = 0;
        }
        if (k > 0) {
            DefaultProgramModelInfo.removeRange(list, 0, k);
        }
    }

    public List<? extends Constructor> getConstructors(ClassType ct, List<Type> signature, List<TypeArgumentDeclaration> typeArgs) {
        Debug.assertNonnull((Object)ct, signature);
        if (ct.isInterface()) {
            if (signature.isEmpty()) {
                return this.getNameInfo().getJavaLangObject().getConstructors();
            }
            return new ArrayList(0);
        }
        String name = ct.getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        List<Method> meths = this.internalGetMostSpecificMethods(ct, name, signature, ct.getConstructors(), typeArgs, ct);
        ArrayList<Constructor> result = new ArrayList<Constructor>();
        int s = meths.size();
        for (int i = 0; i < s; ++i) {
            result.add((Constructor)meths.get(i));
        }
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature, List<? extends TypeArgument> typeArgs, ClassType context) {
        return this.internalGetMostSpecificMethods(ct, name, signature, ct.getAllMethods(), typeArgs, context);
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature, List<? extends TypeArgument> typeArgs) {
        return this.internalGetMostSpecificMethods(ct, name, signature, ct.getAllMethods(), typeArgs, ct);
    }

    private List<Method> internalGetMostSpecificMethods(ClassType ct, String name, List<Type> signature, List<? extends Method> meths, List<? extends TypeArgument> typeArgs, ClassType context) {
        ArrayList<Method> result;
        Debug.assertNonnull(ct, name, signature);
        boolean allowJava5 = Boolean.valueOf(this.getServiceConfiguration().getProjectSettings().getProperty("java5"));
        if (allowJava5) {
            result = this.doThreePhaseFilter(meths, signature, name, context, typeArgs);
        } else {
            result = new ArrayList<Method>();
            result.addAll(meths);
            this.internalFilterApplicableMethods(result, name, signature, context, null, false);
            this.filterMostSpecificMethods(result);
        }
        return result;
    }

    public List<Method> doThreePhaseFilter(List<? extends Method> methods, List<Type> signature, String name, ClassType context, List<? extends TypeArgument> typeArgs) {
        ArrayList<Method> applicableMethods = new ArrayList<Method>(methods.size() + 1);
        applicableMethods.addAll(methods);
        this.internalFilterApplicableMethods(applicableMethods, name, signature, context, typeArgs, true);
        if (applicableMethods.size() < 2) {
            return applicableMethods;
        }
        ArrayList<Method> result = new ArrayList<Method>(applicableMethods.size() + 1);
        result.addAll(applicableMethods);
        this.internalFilterApplicableMethods(result, name, signature, context, typeArgs, false);
        this.filterMostSpecificMethods(result);
        if (result.size() > 0) {
            return result;
        }
        result.addAll(applicableMethods);
        this.filterMostSpecificMethodsPhase2(result);
        if (result.size() > 0) {
            return result;
        }
        result.addAll(applicableMethods);
        this.filterMostSpecificMethodsPhase3(result);
        return result;
    }

    public void reset() {
        this.classTypeCache.clear();
    }

    protected Type makeParameterizedArrayType(Type t, List<? extends TypeArgument> typeArgs) {
        assert (t instanceof ArrayType || t instanceof ClassType);
        Type result = t;
        int dim = 0;
        while (result instanceof ArrayType) {
            result = ((ArrayType)result).getBaseType();
            ++dim;
        }
        result = new ParameterizedType((ClassType)result, typeArgs);
        for (int i = 0; i < dim; ++i) {
            result = this.getNameInfo().createArrayType(result);
        }
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct, String name, List<Type> signature) {
        return this.getMethods(ct, name, signature, null);
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct, List<Type> signature) {
        return this.getConstructors(ct, signature, null);
    }

    class SubTypeTopSort
    extends ClassTypeTopSort {
        SubTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return DefaultProgramModelInfo.this.getSubtypes(c);
        }
    }

    static class ReplaceTypeArgResult {
        Type baseType;
        TypeArgument.WildcardMode wildcardMode;

        ReplaceTypeArgResult(Type t, TypeArgument.WildcardMode wm) {
            this.baseType = t;
            this.wildcardMode = wm;
        }
    }

    static class SuperTypeTopSort
    extends ClassTypeTopSort {
        SuperTypeTopSort() {
        }

        @Override
        protected final List<ClassType> getAdjacent(ClassType c) {
            return c.getSupertypes();
        }
    }

    static class ClassTypeCacheEntry {
        List<ClassType> supertypes;
        Set<ClassType> subtypes;
        List<ClassType> allSupertypes;
        List<ClassType> allMemberTypes;
        List<Field> allFields;
        List<Method> allMethods;

        ClassTypeCacheEntry() {
        }
    }

    static class ResolvedTypeArgument
    implements TypeArgument {
        final TypeArgument.WildcardMode wm;
        final Type type;
        final List<? extends TypeArgument> typeArgs;

        public ResolvedTypeArgument(TypeArgument.WildcardMode wm, Type type, List<? extends TypeArgument> typeArgs) {
            if (!(type instanceof ArrayType) && !(type instanceof ClassType)) {
                throw new IllegalArgumentException();
            }
            this.wm = wm;
            this.type = type;
            this.typeArgs = typeArgs;
        }

        @Override
        public TypeArgument.WildcardMode getWildcardMode() {
            return this.wm;
        }

        @Override
        public String getTypeName() {
            return this.type.getFullName();
        }

        @Override
        public List<? extends TypeArgument> getTypeArguments() {
            return this.typeArgs;
        }
    }
}

