/*
 * Decompiled with CFR 0.152.
 */
package recoder.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import recoder.IllegalTransformationException;
import recoder.ModelException;
import recoder.ProgramFactory;
import recoder.ServiceConfiguration;
import recoder.abstraction.AnnotationProperty;
import recoder.abstraction.ArrayType;
import recoder.abstraction.ClassType;
import recoder.abstraction.ClassTypeContainer;
import recoder.abstraction.Constructor;
import recoder.abstraction.Field;
import recoder.abstraction.ImplicitEnumMethod;
import recoder.abstraction.IntersectionType;
import recoder.abstraction.Member;
import recoder.abstraction.Method;
import recoder.abstraction.Package;
import recoder.abstraction.ParameterizedType;
import recoder.abstraction.PrimitiveType;
import recoder.abstraction.ProgramModelElement;
import recoder.abstraction.Type;
import recoder.abstraction.TypeArgument;
import recoder.abstraction.TypeParameter;
import recoder.abstraction.Variable;
import recoder.convenience.Format;
import recoder.convenience.Formats;
import recoder.convenience.Naming;
import recoder.convenience.TreeWalker;
import recoder.io.SourceFileRepository;
import recoder.java.CompilationUnit;
import recoder.java.Expression;
import recoder.java.Identifier;
import recoder.java.Import;
import recoder.java.JavaNonTerminalProgramElement;
import recoder.java.NonTerminalProgramElement;
import recoder.java.PackageSpecification;
import recoder.java.ProgramElement;
import recoder.java.Reference;
import recoder.java.ScopeDefiningElement;
import recoder.java.Statement;
import recoder.java.StatementBlock;
import recoder.java.TerminalProgramElement;
import recoder.java.TypeScope;
import recoder.java.VariableScope;
import recoder.java.declaration.AnnotationDeclaration;
import recoder.java.declaration.AnnotationUseSpecification;
import recoder.java.declaration.ClassDeclaration;
import recoder.java.declaration.ClassInitializer;
import recoder.java.declaration.ConstructorDeclaration;
import recoder.java.declaration.EnumConstantDeclaration;
import recoder.java.declaration.EnumConstantSpecification;
import recoder.java.declaration.EnumDeclaration;
import recoder.java.declaration.Extends;
import recoder.java.declaration.FieldDeclaration;
import recoder.java.declaration.FieldSpecification;
import recoder.java.declaration.Implements;
import recoder.java.declaration.InheritanceSpecification;
import recoder.java.declaration.InterfaceDeclaration;
import recoder.java.declaration.MemberDeclaration;
import recoder.java.declaration.MethodDeclaration;
import recoder.java.declaration.ParameterDeclaration;
import recoder.java.declaration.Throws;
import recoder.java.declaration.TypeArgumentDeclaration;
import recoder.java.declaration.TypeDeclaration;
import recoder.java.declaration.TypeDeclarationContainer;
import recoder.java.declaration.TypeParameterDeclaration;
import recoder.java.declaration.VariableDeclaration;
import recoder.java.declaration.VariableSpecification;
import recoder.java.expression.ArrayInitializer;
import recoder.java.expression.Assignment;
import recoder.java.expression.ElementValueArrayInitializer;
import recoder.java.expression.Literal;
import recoder.java.expression.Operator;
import recoder.java.expression.ParenthesizedExpression;
import recoder.java.expression.literal.BooleanLiteral;
import recoder.java.expression.literal.CharLiteral;
import recoder.java.expression.literal.DoubleLiteral;
import recoder.java.expression.literal.FloatLiteral;
import recoder.java.expression.literal.IntLiteral;
import recoder.java.expression.literal.LongLiteral;
import recoder.java.expression.literal.NullLiteral;
import recoder.java.expression.literal.StringLiteral;
import recoder.java.expression.operator.BinaryAnd;
import recoder.java.expression.operator.BinaryNot;
import recoder.java.expression.operator.BinaryOr;
import recoder.java.expression.operator.BinaryXOr;
import recoder.java.expression.operator.ComparativeOperator;
import recoder.java.expression.operator.Conditional;
import recoder.java.expression.operator.Divide;
import recoder.java.expression.operator.Instanceof;
import recoder.java.expression.operator.LogicalAnd;
import recoder.java.expression.operator.LogicalNot;
import recoder.java.expression.operator.LogicalOr;
import recoder.java.expression.operator.Minus;
import recoder.java.expression.operator.Modulo;
import recoder.java.expression.operator.Negative;
import recoder.java.expression.operator.New;
import recoder.java.expression.operator.NewArray;
import recoder.java.expression.operator.Plus;
import recoder.java.expression.operator.Positive;
import recoder.java.expression.operator.PostDecrement;
import recoder.java.expression.operator.PostIncrement;
import recoder.java.expression.operator.PreDecrement;
import recoder.java.expression.operator.PreIncrement;
import recoder.java.expression.operator.ShiftLeft;
import recoder.java.expression.operator.ShiftRight;
import recoder.java.expression.operator.Times;
import recoder.java.expression.operator.TypeCast;
import recoder.java.expression.operator.TypeOperator;
import recoder.java.expression.operator.UnsignedShiftRight;
import recoder.java.reference.AnnotationPropertyReference;
import recoder.java.reference.ArrayLengthReference;
import recoder.java.reference.ArrayReference;
import recoder.java.reference.ConstructorReference;
import recoder.java.reference.EnumConstructorReference;
import recoder.java.reference.FieldReference;
import recoder.java.reference.MetaClassReference;
import recoder.java.reference.MethodReference;
import recoder.java.reference.PackageReference;
import recoder.java.reference.ReferencePrefix;
import recoder.java.reference.SuperConstructorReference;
import recoder.java.reference.SuperReference;
import recoder.java.reference.ThisConstructorReference;
import recoder.java.reference.ThisReference;
import recoder.java.reference.TypeReference;
import recoder.java.reference.TypeReferenceInfix;
import recoder.java.reference.UncollatedReferenceQualifier;
import recoder.java.reference.VariableReference;
import recoder.java.statement.Branch;
import recoder.java.statement.Break;
import recoder.java.statement.Case;
import recoder.java.statement.Catch;
import recoder.java.statement.Continue;
import recoder.java.statement.Default;
import recoder.java.statement.ExpressionJumpStatement;
import recoder.java.statement.Finally;
import recoder.java.statement.If;
import recoder.java.statement.LabeledStatement;
import recoder.java.statement.LoopStatement;
import recoder.java.statement.Switch;
import recoder.java.statement.SynchronizedBlock;
import recoder.java.statement.Try;
import recoder.kit.MiscKit;
import recoder.kit.StatementKit;
import recoder.kit.UnitKit;
import recoder.list.generic.ASTList;
import recoder.service.AmbiguousDeclarationException;
import recoder.service.AmbiguousImportException;
import recoder.service.AmbiguousReferenceException;
import recoder.service.AmbiguousStaticFieldImportException;
import recoder.service.AttachChange;
import recoder.service.ChangeHistoryEvent;
import recoder.service.ChangeHistoryListener;
import recoder.service.ConstantEvaluator;
import recoder.service.DefaultNameInfo;
import recoder.service.DefaultProgramModelInfo;
import recoder.service.DetachChange;
import recoder.service.ErrorHandler;
import recoder.service.NameInfo;
import recoder.service.SourceInfo;
import recoder.service.TreeChange;
import recoder.service.TypingException;
import recoder.service.UnresolvedReferenceException;
import recoder.util.Debug;
import recoder.util.ProgressListener;
import recoder.util.ProgressListenerManager;

public class DefaultSourceInfo
extends DefaultProgramModelInfo
implements SourceInfo,
ChangeHistoryListener,
Formats {
    private static final boolean DEBUG = false;
    private static final int CONSTANT_FALSE = 0;
    private static final int CONSTANT_TRUE = 1;
    private static final int NOT_CONSTANT = -1;
    protected final Map<String, Type> name2primitiveType = new HashMap<String, Type>(64);
    Map<Reference, ProgramModelElement> reference2element = new HashMap<Reference, ProgramModelElement>(1024);
    ProgressListenerManager listeners = new ProgressListenerManager(this);

    public DefaultSourceInfo(ServiceConfiguration config) {
        super(config);
    }

    static boolean isPartOf(ProgramElement pe, Class c) {
        while (pe != null && !c.isInstance(pe)) {
            pe = pe.getASTParent();
        }
        return pe != null;
    }

    private static VariableScope findOuterVariableScope(VariableScope ts) {
        NonTerminalProgramElement pe;
        for (pe = ts.getASTParent(); pe != null && !(pe instanceof VariableScope); pe = pe.getASTParent()) {
        }
        return (VariableScope)pe;
    }

    /*
     * Unable to fully structure code
     */
    private static void addSequentialFollower(Statement s, List<Statement> list) {
        Debug.assertNonnull(s);
        parent = s.getStatementContainer();
        block0: while (true) {
            c = parent.getStatementCount();
            p = 0;
            while (parent.getStatementAt(p) != s) {
                ++p;
            }
            if (p < c - 1) {
                list.add(parent.getStatementAt(p + 1));
                break;
            }
            if (parent instanceof MemberDeclaration) {
                list.add(DefaultSourceInfo.METHOD_EXIT);
                break;
            }
            if (parent instanceof Statement) {
                if (parent instanceof LoopStatement) {
                    loop = (LoopStatement)parent;
                    list.add(loop);
                    return;
                }
                s = (Statement)parent;
                parent = ((Statement)parent).getStatementContainer();
                continue;
            }
            while (true) {
                if (parent instanceof Branch) ** break;
                continue block0;
                s = ((Branch)parent).getParent();
                parent = s.getStatementContainer();
            }
            break;
        }
    }

    private static Statement findInnermostBreakBlock(Statement s) {
        for (NonTerminalProgramElement parent = s.getStatementContainer(); parent != null && !(parent instanceof MemberDeclaration); parent = parent.getASTParent()) {
            if (!(parent instanceof LoopStatement) && !(parent instanceof Switch)) continue;
            return (Statement)((Object)parent);
        }
        return null;
    }

    private static LoopStatement findInnermostLoop(Statement s) {
        for (NonTerminalProgramElement parent = s.getStatementContainer(); parent != null && !(parent instanceof MemberDeclaration); parent = parent.getASTParent()) {
            if (!(parent instanceof LoopStatement)) continue;
            return (LoopStatement)parent;
        }
        return null;
    }

    @Override
    public void initialize(ServiceConfiguration cfg) {
        super.initialize(cfg);
        cfg.getChangeHistory().addChangeHistoryListener(this);
        NameInfo ni = this.getNameInfo();
        this.name2primitiveType.put("boolean", ni.getBooleanType());
        this.name2primitiveType.put("char", ni.getCharType());
        this.name2primitiveType.put("int", ni.getIntType());
        this.name2primitiveType.put("float", ni.getFloatType());
        this.name2primitiveType.put("double", ni.getDoubleType());
        this.name2primitiveType.put("byte", ni.getByteType());
        this.name2primitiveType.put("short", ni.getShortType());
        this.name2primitiveType.put("long", ni.getLongType());
        this.name2primitiveType.put("boolean[]", ni.createArrayType(ni.getBooleanType()));
        this.name2primitiveType.put("char[]", ni.createArrayType(ni.getCharType()));
        this.name2primitiveType.put("int[]", ni.createArrayType(ni.getIntType()));
        this.name2primitiveType.put("float[]", ni.createArrayType(ni.getFloatType()));
        this.name2primitiveType.put("double[]", ni.createArrayType(ni.getDoubleType()));
        this.name2primitiveType.put("byte[]", ni.createArrayType(ni.getByteType()));
        this.name2primitiveType.put("short[]", ni.createArrayType(ni.getShortType()));
        this.name2primitiveType.put("long[]", ni.createArrayType(ni.getLongType()));
    }

    @Override
    public void addProgressListener(ProgressListener l) {
        this.listeners.addProgressListener(l);
    }

    @Override
    public void removeProgressListener(ProgressListener l) {
        this.listeners.removeProgressListener(l);
    }

    @Override
    protected NameInfo getNameInfo() {
        return super.getNameInfo();
    }

    @Override
    public void modelChanged(ChangeHistoryEvent changes) {
        TreeChange tc;
        int i;
        List<TreeChange> changed = changes.getChanges();
        int s = changed.size();
        this.listeners.fireProgressEvent(0, s);
        int c = 0;
        for (i = 0; i < s; ++i) {
            tc = changed.get(i);
            if (tc.isMinor() || !(tc instanceof DetachChange)) continue;
            this.processChange(tc);
            this.listeners.fireProgressEvent(++c);
        }
        for (i = 0; i < s; ++i) {
            tc = changed.get(i);
            if (tc.isMinor() || !(tc instanceof AttachChange)) continue;
            this.processChange(tc);
            this.listeners.fireProgressEvent(++c);
        }
    }

    void processChange(TreeChange change) {
        ProgramElement changed = change.getChangeRoot();
        if (DefaultSourceInfo.isPartOf(changed, PackageSpecification.class) || DefaultSourceInfo.isPartOf(changed, Import.class) || this.determinesGlobalEntityName(changed) || this.determinesGlobalEntityType(changed)) {
            super.reset();
            this.reference2element.clear();
        }
        if (changed instanceof PackageSpecification) {
            PackageSpecification pkgSpec = (PackageSpecification)changed;
            boolean isAttach = change instanceof AttachChange;
            this.handleCUPackageChange(pkgSpec.getParent(), Naming.toPathName(pkgSpec.getPackageReference()), isAttach);
        }
        if (changed instanceof PackageReference && DefaultSourceInfo.isPartOf(changed, PackageSpecification.class)) {
            System.err.println("WARNING: name info may now contain invalid mappings name2type... (TO BE FIXED)");
        }
        if (changed instanceof Identifier) {
            NonTerminalProgramElement par = changed.getASTParent();
            if (change instanceof AttachChange) {
                this.register(par);
            } else {
                String oldname = ((Identifier)changed).getText();
                if (par instanceof VariableSpecification) {
                    this.unregister((VariableSpecification)par, oldname);
                } else if (par instanceof TypeDeclaration) {
                    this.unregister((TypeDeclaration)par, oldname);
                }
            }
            this.processIdentifierChanged(change);
        } else if (change instanceof AttachChange) {
            this.register(changed);
        } else {
            this.unregister(changed);
        }
    }

    private void handleCUPackageChange(CompilationUnit cu, String originalPkgName, boolean isAttach) {
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        int l = cu.getTypeDeclarationCount();
        for (int j = 0; j < l; ++j) {
            TypeDeclaration ct = cu.getTypeDeclarationAt(j);
            String fullPath = originalPkgName + ("".equals(originalPkgName) ? "" : ".") + ct.getName();
            String defaultPkgPath = ct.getName();
            if (isAttach) {
                dni.handleTypeRename(ct, defaultPkgPath, fullPath);
                continue;
            }
            dni.handleTypeRename(ct, fullPath, defaultPkgPath);
        }
    }

    private void processIdentifierChanged(TreeChange tc) {
        if (!(this.getNameInfo() instanceof DefaultNameInfo)) {
            return;
        }
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        Identifier id = (Identifier)tc.getChangeRoot();
        NonTerminalProgramElement npe = id.getParent();
        if (npe instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)npe;
            if (tc instanceof AttachChange) {
                Type old = dni.getType(td.getFullName());
                if (old == null || old == dni.getUnknownType()) {
                    dni.register(td);
                }
            } else {
                Type old = dni.getType(td.getFullName());
                if (old == td) {
                    dni.unregisterClassType(td.getFullName(), true);
                }
            }
        } else if (npe instanceof FieldSpecification) {
            FieldSpecification fs = (FieldSpecification)npe;
            if (tc instanceof AttachChange) {
                dni.register(fs);
            } else {
                dni.unregisterField(fs.getFullName());
            }
        } else if (npe instanceof PackageReference && DefaultSourceInfo.isPartOf(npe, PackageSpecification.class)) {
            throw new IllegalTransformationException("Changing an Identifier contained in a PackageSpecification is not valid. Change either the containing PackageReference or PackageSpecification instead.");
        }
    }

    private boolean determinesGlobalEntityName(ProgramElement pe) {
        if (pe instanceof Identifier) {
            NonTerminalProgramElement parent = pe.getASTParent();
            return parent instanceof MemberDeclaration;
        }
        return false;
    }

    private boolean determinesGlobalEntityType(ProgramElement pe) {
        return DefaultSourceInfo.isPartOf(pe, TypeReference.class) && (DefaultSourceInfo.isPartOf(pe, FieldDeclaration.class) || DefaultSourceInfo.isPartOf(pe, InheritanceSpecification.class));
    }

    private ProgramElement getDeclaration(ProgramModelElement pme) {
        return pme instanceof ProgramElement ? (ProgramElement)((Object)pme) : null;
    }

    @Override
    public final TypeDeclaration getTypeDeclaration(ClassType ct) {
        return ct instanceof TypeDeclaration ? (TypeDeclaration)ct : null;
    }

    @Override
    public final MethodDeclaration getMethodDeclaration(Method m) {
        return m instanceof MethodDeclaration ? (MethodDeclaration)m : null;
    }

    @Override
    public final VariableSpecification getVariableSpecification(Variable v) {
        return v instanceof VariableSpecification ? (VariableSpecification)v : null;
    }

    @Override
    public final ConstructorDeclaration getConstructorDeclaration(Constructor c) {
        return c instanceof ConstructorDeclaration ? (ConstructorDeclaration)c : null;
    }

    protected ClassType getFromUnitPackage(String name, CompilationUnit cu) {
        String xname = Naming.getPackageName(cu);
        if (xname.length() > 0) {
            xname = Naming.dot(xname, name);
        }
        return this.getNameInfo().getClassType(xname);
    }

    protected ClassType getFromTypeImports(String name, List<Import> il) {
        Member result = null;
        NameInfo ni = this.getNameInfo();
        for (int i = il.size() - 1; i >= 0; --i) {
            String trname;
            Import imp = il.get(i);
            if (imp.isMultiImport()) continue;
            TypeReference tr = imp.getTypeReference();
            Member newResult = null;
            String string = trname = imp.isStaticImport() ? imp.getStaticIdentifier().getText() : tr.getName();
            if (name.startsWith(trname)) {
                int nlen;
                int tlen = trname.length();
                if (tlen == (nlen = name.length()) || name.charAt(tlen) == '.') {
                    ReferencePrefix rp = imp.isStaticImport() ? tr : tr.getReferencePrefix();
                    trname = rp == null ? name : Naming.toPathName(rp, name);
                    newResult = ni.getClassType(trname);
                }
            } else if (name.endsWith(trname) && name.equals(trname = Naming.toPathName(tr))) {
                newResult = ni.getClassType(trname);
            }
            if (newResult == null || !newResult.isStatic() && imp.isStaticImport()) continue;
            if (result != null && result != newResult) {
                this.getErrorHandler().reportError(new AmbiguousImportException("Ambiguous import " + Format.toString("%c \"%s\" @%p in %f", imp) + " - could be " + Format.toString("%N", result) + " or " + Format.toString("%N", newResult), imp, (ClassType)result, (ClassType)newResult));
            }
            result = newResult;
        }
        return result;
    }

    @Override
    protected ErrorHandler getErrorHandler() {
        return super.getErrorHandler();
    }

    protected ClassType getFromPackageImports(String name, List<Import> il, ClassType searchingFrom) {
        ClassType result = null;
        NameInfo ni = this.getNameInfo();
        for (int i = il.size() - 1; i >= 0; --i) {
            Import imp = il.get(i);
            if (!imp.isMultiImport()) continue;
            TypeReferenceInfix ref = imp.getReference();
            String xname = Naming.toPathName(ref, name);
            ClassType newResult = ni.getClassType(xname);
            if (!imp.isStaticImport() && newResult != null && !newResult.isPublic() || imp.isStaticImport() && newResult != null && !this.isVisibleFor(newResult, searchingFrom)) {
                newResult = null;
            }
            if (newResult == null || !newResult.isStatic() && imp.isStaticImport()) continue;
            if (result != null && result != newResult) {
                this.getErrorHandler().reportError(new AmbiguousImportException("Ambiguous import of type " + name + ": could be " + Format.toString("%N", result) + " or " + Format.toString("%N", newResult), imp, result, newResult));
            }
            result = newResult;
        }
        return result;
    }

    private ClassType getMemberType(String shortName, ClassType ct) {
        List<? extends ClassType> innerTypes = ct.getTypes();
        for (int i = innerTypes.size() - 1; i >= 0; --i) {
            ClassType candid = innerTypes.get(i);
            if (!shortName.equals(candid.getName())) continue;
            return candid;
        }
        List<ClassType> superTypes = ct.getSupertypes();
        for (int i = 0; i < superTypes.size(); ++i) {
            ClassType possibleSuperclass = superTypes.get(i);
            ClassType result = this.getMemberType(shortName, possibleSuperclass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected ClassType getLocalType(String name, TypeScope scope) {
        ClassType result = null;
        int dotPos = name.indexOf(46);
        String shortName = dotPos == -1 ? name : name.substring(0, dotPos);
        result = scope.getTypeInScope(shortName);
        while (result != null && dotPos != -1) {
            int nextDotPos;
            shortName = (nextDotPos = name.indexOf(46, ++dotPos)) == -1 ? name.substring(dotPos) : name.substring(dotPos, nextDotPos);
            dotPos = nextDotPos;
            result = this.getMemberType(shortName, result);
        }
        return result;
    }

    protected ClassType getInheritedType(String name, ClassType ct) {
        int dotPos = name.indexOf(46);
        String shortName = dotPos == -1 ? name : name.substring(0, dotPos);
        List<ClassType> ctl = this.getAllTypes(ct);
        ClassType result = null;
        int nc = ctl.size();
        for (int i = 0; i < nc; ++i) {
            ClassType c = ctl.get(i);
            if (!shortName.equals(c.getName())) continue;
            result = c;
            break;
        }
        while (result != null && dotPos != -1) {
            int nextDotPos;
            shortName = (nextDotPos = name.indexOf(46, ++dotPos)) == -1 ? name.substring(dotPos) : name.substring(dotPos, nextDotPos);
            dotPos = nextDotPos;
            result = this.getMemberType(shortName, result);
        }
        return result;
    }

    @Override
    public Type getType(String name, ProgramElement context) {
        String defaultName;
        ProgramElement pe;
        Debug.assertNonnull((Object)name, context);
        NameInfo ni = this.getNameInfo();
        Type t = this.name2primitiveType.get(name);
        if (t != null) {
            return t;
        }
        if (name.equals("void")) {
            return null;
        }
        if (name.endsWith("]")) {
            int px = name.indexOf(91);
            Type baseType = this.getType(name.substring(0, px), context);
            if (baseType == null) {
                return null;
            }
            String indexExprs = name.substring(px);
            return ni.getType(baseType.getFullName() + indexExprs);
        }
        this.updateModel();
        if (context.getASTParent() instanceof InheritanceSpecification) {
            context = context.getASTParent().getASTParent().getASTParent();
        }
        for (pe = context; pe != null && !(pe instanceof TypeScope); pe = pe.getASTParent()) {
            context = pe;
        }
        TypeScope scope = (TypeScope)pe;
        if (scope == null) {
            Debug.log("Null scope during type query " + name + " in context " + Format.toString("%c \"%s\" @%p in %f", context));
            Debug.log(Debug.makeStackTrace());
        }
        ClassType result = null;
        TypeScope s = scope;
        while (s != null) {
            TypeDeclaration td;
            ClassType newResult;
            result = this.getLocalType(name, s);
            if (result != null) {
                if (s instanceof StatementBlock) {
                    Statement stmt;
                    StatementBlock cont = (StatementBlock)s;
                    int i = 0;
                    while ((stmt = cont.getStatementAt(i)) != result) {
                        if (stmt == context) {
                            result = null;
                            break;
                        }
                        ++i;
                    }
                }
                if (result != null) break;
            }
            if (s instanceof TypeDeclaration && (newResult = this.getInheritedType(name, td = (TypeDeclaration)s)) != null) {
                if (result == null) {
                    result = newResult;
                    break;
                }
                if (result != newResult) {
                    this.getErrorHandler().reportError(new AmbiguousReferenceException("Type " + Format.toString("%N", newResult) + " is an inherited member type that is also defined as outer member type " + Format.toString("%N", result), null, result, newResult));
                    break;
                }
            }
            scope = s;
            for (pe = s.getASTParent(); pe != null && !(pe instanceof TypeScope); pe = pe.getASTParent()) {
                context = pe;
            }
            s = (TypeScope)pe;
        }
        if (result != null) {
            return result;
        }
        CompilationUnit cu = (CompilationUnit)scope;
        ASTList<Import> il = cu.getImports();
        if (il != null) {
            result = this.getFromTypeImports(name, il);
        }
        if (result == null && (result = this.getFromUnitPackage(name, cu)) == null && il != null) {
            result = this.getFromPackageImports(name, il, cu.getTypeDeclarationAt(0));
        }
        if (result == null && (result = ni.getClassType(defaultName = Naming.dot("java.lang", name))) == null) {
            result = ni.getClassType(name);
        }
        if (result != null) {
            scope.addTypeToScope(result, name);
        }
        return result;
    }

    @Override
    public Type getType(TypeReference tr) {
        Type res = (Type)this.reference2element.get(tr);
        if (res != null) {
            return res;
        }
        ReferencePrefix rp = tr.getReferencePrefix();
        if (rp instanceof PackageReference) {
            String name = Naming.toPathName(rp, tr.getName());
            res = this.getNameInfo().getClassType(name);
            if (res != null) {
                for (int d = tr.getDimensions(); d > 0; --d) {
                    res = this.getNameInfo().createArrayType(res);
                }
            }
        } else {
            res = this.getType(Naming.toPathName(tr), tr);
        }
        if (res == null && !"void".equals(tr.getName())) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f(14)", tr), tr));
            res = this.getNameInfo().getUnknownType();
        }
        if (res != null) {
            if (tr.getTypeArguments() != null && tr.getTypeArguments().size() != 0) {
                res = res instanceof ArrayType ? this.makeParameterizedArrayType(res, tr.getTypeArguments()) : new ParameterizedType((ClassType)res, tr.getTypeArguments());
            }
            this.reference2element.put(tr, res);
        }
        return res;
    }

    @Override
    public final ClassType getType(TypeDeclaration td) {
        return td;
    }

    @Override
    public Type getType(VariableSpecification vs) {
        if (vs instanceof EnumConstantSpecification) {
            return this.getType((EnumConstantSpecification)vs);
        }
        this.updateModel();
        TypeReference tr = vs.getParent().getTypeReference();
        Type result = this.getType(tr);
        if (result != null) {
            ParameterDeclaration pd;
            int d = vs.getDimensions();
            if (vs.getASTParent() instanceof ParameterDeclaration && (pd = (ParameterDeclaration)vs.getASTParent()).isVarArg()) {
                ++d;
            }
            while (d > 0) {
                result = this.getNameInfo().createArrayType(result);
                --d;
            }
        }
        return result;
    }

    private Type getType(EnumConstantSpecification ecs) {
        ClassDeclaration cd = ecs.getConstructorReference().getClassDeclaration();
        if (cd != null) {
            return cd;
        }
        return ecs.getParent().getParent();
    }

    @Override
    public Type getType(ProgramElement pe) {
        this.updateModel();
        Type result = null;
        if (pe instanceof Expression) {
            result = this.getType((Expression)pe);
        } else if (pe instanceof UncollatedReferenceQualifier) {
            result = this.getType((UncollatedReferenceQualifier)pe);
        } else if (pe instanceof TypeReference) {
            result = this.getType((TypeReference)pe);
        } else if (pe instanceof VariableSpecification) {
            result = this.getType((VariableSpecification)pe);
        } else if (pe instanceof EnumConstantSpecification) {
            result = this.getType((EnumConstantSpecification)pe);
        } else if (pe instanceof MethodDeclaration) {
            if (!(pe instanceof ConstructorDeclaration)) {
                result = this.getReturnType((MethodDeclaration)pe);
            }
        } else if (pe instanceof TypeDeclaration) {
            result = this.getType((TypeDeclaration)pe);
        }
        return result;
    }

    private Type getType(UncollatedReferenceQualifier urq) {
        Reference r = this.resolveURQ(urq);
        if (r instanceof UncollatedReferenceQualifier) {
            return this.getNameInfo().getUnknownClassType();
        }
        return this.getType(r);
    }

    @Override
    public Type getType(Expression expr) {
        Type result = null;
        if (expr instanceof Operator) {
            Operator op = (Operator)expr;
            ASTList<Expression> args = op.getArguments();
            if (op instanceof Assignment) {
                result = this.getType((Expression)args.get(0));
            } else if (op instanceof TypeCast || op instanceof New) {
                result = this.getType(((TypeOperator)op).getTypeReference());
            } else if (op instanceof NewArray) {
                NewArray n = (NewArray)op;
                TypeReference tr = n.getTypeReference();
                result = this.getType(tr);
                for (int d = n.getDimensions(); d > 0; --d) {
                    Type oldResult = result;
                    result = this.getNameInfo().getArrayType(result);
                    if (result != null) continue;
                    result = this.getNameInfo().createArrayType(oldResult);
                }
            } else if (op instanceof PreIncrement || op instanceof PostIncrement || op instanceof PreDecrement || op instanceof PostDecrement || op instanceof ParenthesizedExpression || op instanceof BinaryNot) {
                result = this.getType((Expression)args.get(0));
            } else if (op instanceof Positive || op instanceof Negative) {
                result = this.getType((Expression)args.get(0));
                if (this.java5Allowed() && result instanceof ClassType) {
                    result = this.getUnboxedType((ClassType)result);
                }
            } else if (op instanceof Plus || op instanceof Minus || op instanceof Times || op instanceof Divide || op instanceof Modulo) {
                Type t1 = this.getType((Expression)args.get(0));
                Type t2 = this.getType((Expression)args.get(1));
                if (this.java5Allowed() && t1 instanceof PrimitiveType ^ t2 instanceof PrimitiveType) {
                    if (t1 instanceof ClassType) {
                        t1 = this.getUnboxedType((ClassType)t1);
                    } else if (t2 instanceof ClassType) {
                        t2 = this.getUnboxedType((ClassType)t2);
                    }
                }
                if (op instanceof Plus && (t1 == this.getNameInfo().getJavaLangString() || t2 == this.getNameInfo().getJavaLangString() || t1 == null || t2 == null)) {
                    result = this.getNameInfo().getJavaLangString();
                } else if (t1 instanceof PrimitiveType && t2 instanceof PrimitiveType) {
                    result = this.getPromotedType((PrimitiveType)t1, (PrimitiveType)t2);
                    if (result == null) {
                        this.getErrorHandler().reportError(new TypingException("Boolean types cannot be promoted in " + op, op));
                        result = this.getNameInfo().getUnknownType();
                    }
                } else if (t1 != null && t2 != null) {
                    this.getErrorHandler().reportError(new TypingException("Illegal operand types for plus " + t1 + " + " + t2 + " in expression " + op, op));
                    result = this.getNameInfo().getUnknownType();
                }
            } else if (op instanceof ShiftRight || op instanceof UnsignedShiftRight || op instanceof ShiftLeft || op instanceof BinaryAnd || op instanceof BinaryOr || op instanceof BinaryXOr) {
                Type t1 = this.getType((Expression)args.get(0));
                if (this.java5Allowed()) {
                    Type t2 = this.getType((Expression)args.get(1));
                    if (t1 instanceof ClassType && t2 instanceof PrimitiveType) {
                        t1 = this.getUnboxedType((ClassType)t1);
                    }
                }
                result = t1;
            } else if (op instanceof ComparativeOperator || op instanceof LogicalAnd || op instanceof LogicalOr || op instanceof LogicalNot || op instanceof Instanceof) {
                result = this.getNameInfo().getBooleanType();
            } else if (op instanceof Conditional) {
                Expression e1 = (Expression)args.get(1);
                Expression e2 = (Expression)args.get(2);
                Type t1 = this.getType(e1);
                Type t2 = this.getType(e2);
                if (this.java5Allowed()) {
                    PrimitiveType tmp;
                    if (t1 instanceof PrimitiveType && t2 instanceof ClassType) {
                        tmp = this.getUnboxedType((ClassType)t2);
                        if (tmp != null) {
                            t2 = tmp;
                        } else {
                            t1 = this.getBoxedType((PrimitiveType)t1);
                        }
                    } else if (t1 instanceof ClassType && t2 instanceof PrimitiveType) {
                        tmp = this.getUnboxedType((ClassType)t1);
                        if (tmp != null) {
                            t1 = tmp;
                        } else {
                            t2 = this.getBoxedType((PrimitiveType)t2);
                        }
                    }
                }
                if (t1 == t2) {
                    result = t1;
                } else if (t1 instanceof PrimitiveType && t2 instanceof PrimitiveType) {
                    NameInfo ni = this.getNameInfo();
                    if (t1 == ni.getShortType() && t2 == ni.getByteType() || t2 == ni.getShortType() && t1 == ni.getByteType()) {
                        result = ni.getShortType();
                    } else {
                        result = this.serviceConfiguration.getConstantEvaluator().getCompileTimeConstantType(op);
                        if (result == null) {
                            if (this.isNarrowingTo(e1, (PrimitiveType)t2)) {
                                return t2;
                            }
                            if (this.isNarrowingTo(e2, (PrimitiveType)t1)) {
                                return t1;
                            }
                            result = this.getPromotedType((PrimitiveType)t1, (PrimitiveType)t2);
                        }
                    }
                } else if (t1 instanceof PrimitiveType || t2 instanceof PrimitiveType) {
                    this.getErrorHandler().reportError(new TypingException("Incompatible types in conditional", op));
                    result = this.getNameInfo().getUnknownType();
                } else if (t1 == this.getNameInfo().getNullType()) {
                    result = t2;
                } else if (t2 == this.getNameInfo().getNullType()) {
                    result = t1;
                } else if (this.isWidening(t1, t2)) {
                    result = t2;
                } else if (this.isWidening(t2, t1)) {
                    result = t1;
                } else if (this.java5Allowed() && t1 instanceof ClassType && t2 instanceof ClassType) {
                    ArrayList<Type> tml = new ArrayList<Type>();
                    tml.addAll(this.getAllSupertypes((ClassType)t1));
                    List<ClassType> comp = this.getAllSupertypes((ClassType)t2);
                    for (int j = tml.size() - 1; j >= 0; --j) {
                        if (comp.indexOf(tml.get(j)) != -1) continue;
                        tml.remove(j);
                    }
                    this.removeSupertypesFromList(tml);
                    if (tml.size() == 0) {
                        throw new Error();
                    }
                    result = tml.size() == 1 ? (Type)tml.get(0) : new IntersectionType(tml, this);
                } else {
                    this.getErrorHandler().reportError(new TypingException("Incompatible types in conditional", op));
                    result = this.getNameInfo().getUnknownType();
                }
            } else {
                Debug.error("Type resolution not implemented for operation " + op.getClass().getName());
            }
        } else if (expr instanceof Literal) {
            if (expr instanceof NullLiteral) {
                result = this.getNameInfo().getNullType();
            } else if (expr instanceof BooleanLiteral) {
                result = this.getNameInfo().getBooleanType();
            } else if (expr instanceof LongLiteral) {
                result = this.getNameInfo().getLongType();
            } else if (expr instanceof IntLiteral) {
                result = this.getNameInfo().getIntType();
            } else if (expr instanceof FloatLiteral) {
                result = this.getNameInfo().getFloatType();
            } else if (expr instanceof DoubleLiteral) {
                result = this.getNameInfo().getDoubleType();
            } else if (expr instanceof CharLiteral) {
                result = this.getNameInfo().getCharType();
            } else if (expr instanceof StringLiteral) {
                result = this.getNameInfo().getJavaLangString();
            }
        } else if (expr instanceof Reference) {
            ReferencePrefix rp;
            ClassType thisType;
            List<ClassType> supers;
            if (expr instanceof UncollatedReferenceQualifier) {
                result = this.getType((UncollatedReferenceQualifier)expr);
            } else if (expr instanceof MetaClassReference) {
                result = this.getNameInfo().getJavaLangClass();
            } else if (expr instanceof VariableReference) {
                Variable v = this.getVariable((VariableReference)expr);
                if (v != null) {
                    result = v.getType();
                    if (expr instanceof FieldReference) {
                        Type t = this.getType(((FieldReference)expr).getReferencePrefix());
                        if (t instanceof ParameterizedType && this.containsTypeParameter(result)) {
                            result = this.replaceTypeParameter((ParameterizedType)((ParameterizedType)t), (Type)result).baseType;
                        }
                        if (t instanceof ClassType && this.containsTypeParameter(result)) {
                            ClassType st;
                            List<ClassType> allSupertypes = ((ClassType)t).getAllSupertypes();
                            for (int i = 1; i < allSupertypes.size() && (!((st = allSupertypes.get(i)) instanceof ParameterizedType) || this.containsTypeParameter(result = this.replaceTypeParameter((ParameterizedType)((ParameterizedType)st), (Type)result).baseType)); ++i) {
                            }
                        }
                    }
                } else {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f", expr) + " (01)", expr));
                    v = this.getNameInfo().getUnknownField();
                }
            } else if (expr instanceof MethodReference) {
                Method m = this.getMethod((MethodReference)expr);
                if (m != null) {
                    MethodReference mr;
                    result = m.getReturnType();
                    if (this.containsTypeParameter(result) && m.getTypeParameters() != null && m.getTypeParameters().size() != 0) {
                        for (int i = 0; i < m.getTypeParameters().size(); ++i) {
                            TypeParameter currentTypeParam = m.getTypeParameters().get(i);
                            MethodReference mr2 = (MethodReference)expr;
                            Type replacement = null;
                            if (mr2.getTypeArguments() != null) {
                                TypeArgumentDeclaration ta = (TypeArgumentDeclaration)mr2.getTypeArguments().get(i);
                                replacement = this.getType(ta.getTypeReferenceAt(0));
                                if (ta.getTypeArguments() != null) {
                                    replacement = new ParameterizedType((ClassType)replacement, this.replaceTypeParameter(ta.getTypeArguments(), currentTypeParam, (ClassType)replacement));
                                }
                            } else {
                                replacement = this.inferType(m, mr2, currentTypeParam.getName());
                            }
                            List<? extends TypeArgument> typeArgs = null;
                            if (result instanceof ParameterizedType) {
                                typeArgs = ((ParameterizedType)result).getTypeArgs();
                                typeArgs = this.replaceTypeParameter(typeArgs, currentTypeParam, (ClassType)replacement);
                                result = ((ParameterizedType)result).getGenericType();
                            }
                            if (result == currentTypeParam) {
                                result = replacement;
                            }
                            if (typeArgs == null) continue;
                            result = new ParameterizedType((ClassType)result, typeArgs);
                        }
                    }
                    if ((mr = (MethodReference)expr).getReferencePrefix() != null) {
                        Type t = this.getType(mr.getReferencePrefix());
                        if (t instanceof ParameterizedType && this.containsTypeParameter(result)) {
                            result = this.replaceTypeParameter((ParameterizedType)((ParameterizedType)t), (Type)result).baseType;
                        }
                        if (t instanceof ClassType && this.containsTypeParameter(result)) {
                            ClassType st;
                            List<ClassType> allSupertypes = ((ClassType)t).getAllSupertypes();
                            for (int i = 1; i < allSupertypes.size() && (!((st = allSupertypes.get(i)) instanceof ParameterizedType) || this.containsTypeParameter(result = this.replaceTypeParameter((ParameterizedType)((ParameterizedType)st), (Type)result).baseType)); ++i) {
                            }
                        }
                    }
                }
            } else if (expr instanceof AnnotationPropertyReference) {
                AnnotationProperty ap = this.getAnnotationProperty((AnnotationPropertyReference)((Object)expr));
                if (ap != null) {
                    result = ap.getReturnType();
                }
            } else if (expr instanceof ArrayLengthReference) {
                result = this.getNameInfo().getIntType();
            } else if (expr instanceof ArrayReference) {
                ArrayReference aref = (ArrayReference)expr;
                Type ht = this.getType(aref.getReferencePrefix());
                if (ht != null && !(ht instanceof DefaultNameInfo.UnknownClassType)) {
                    ASTList<Expression> dimExprs = aref.getDimensionExpressions();
                    int dims = dimExprs.size();
                    for (int i = 0; i < dims; ++i) {
                        ht = ((ArrayType)ht).getBaseType();
                    }
                    if (ht != null) {
                        result = ht;
                    } else {
                        this.getErrorHandler().reportError(new TypingException("Not an array type: " + ht + " in expression " + expr, expr));
                        result = this.getNameInfo().getUnknownType();
                    }
                }
            } else if (expr instanceof ThisReference) {
                ReferencePrefix rp2 = ((ThisReference)expr).getReferencePrefix();
                result = rp2 == null ? this.getContainingClassType(expr) : this.getType(rp2);
            } else if (expr instanceof SuperReference && (supers = (thisType = (rp = ((SuperReference)expr).getReferencePrefix()) == null ? this.getContainingClassType(expr) : (ClassType)this.getType(rp)).getSupertypes()) != null && !supers.isEmpty()) {
                result = supers.get(0);
            }
        } else if (expr instanceof ArrayInitializer) {
            ProgramElement pe;
            for (pe = expr; pe != null && !(pe instanceof VariableSpecification) && !(pe instanceof NewArray); pe = pe.getASTParent()) {
            }
            result = this.getType(pe);
        } else if (expr instanceof ElementValueArrayInitializer) {
            ProgramElement pe;
            for (pe = expr; pe != null && !(pe instanceof VariableSpecification); pe = pe.getASTParent()) {
            }
            result = this.getType(pe);
        } else if (expr instanceof AnnotationUseSpecification) {
            result = this.getType(((AnnotationUseSpecification)expr).getTypeReference());
        } else {
            Debug.error("Type analysis for general expressions is currently not implemented: " + expr + " <" + expr.getClass().getName() + ">");
        }
        return result;
    }

    private Type inferType(Method m, MethodReference mr, String typeParamName) {
        ArrayList<Type> result = new ArrayList<Type>();
        List<Type> sig = m.getSignature();
        for (int j = 0; j < sig.size(); ++j) {
            Type t = sig.get(j);
            Expression e = (Expression)mr.getArguments().get(j);
            Type actualArgType = this.getType(e);
            this.inferType1(typeParamName, result, t, actualArgType);
        }
        this.removeSupertypesFromList(result);
        if (result.size() == 0) {
            return this.getNameInfo().getJavaLangObject();
        }
        if (result.size() == 1) {
            return (Type)result.get(0);
        }
        return new IntersectionType(result, this.getServiceConfiguration().getImplicitElementInfo());
    }

    private void removeSupertypesFromList(List<Type> result) {
        block0: for (int j = result.size() - 1; j >= 0; --j) {
            for (int k = 0; k < result.size() - 1; ++k) {
                Type a = result.get(j);
                Type b = result.get(k);
                if (a instanceof ArrayType) {
                    assert (b instanceof ArrayType);
                    while (a instanceof ArrayType) {
                        a = ((ArrayType)a).getBaseType();
                        b = ((ArrayType)b).getBaseType();
                    }
                }
                if (!this.isSupertype((ClassType)a, (ClassType)b)) continue;
                result.remove(j);
                continue block0;
            }
        }
    }

    private void inferType1(String typeParamName, List<Type> result, Type t, Type actualArgType) {
        this.inferType2(typeParamName, result, t, actualArgType);
        if (t instanceof ParameterizedType && actualArgType instanceof ParameterizedType) {
            ParameterizedType tp = (ParameterizedType)t;
            ParameterizedType ap = (ParameterizedType)actualArgType;
            for (int i = 0; i < tp.getTypeArgs().size(); ++i) {
                this.inferType1(typeParamName, result, this.getBaseType(tp.getTypeArgs().get(i)), this.getBaseType(ap.getTypeArgs().get(i)));
            }
        }
    }

    private void inferType2(String typeParamName, List<Type> result, Type t, Type actualArgType) {
        Type toAdd = actualArgType;
        int reduceDim = 0;
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
            ++reduceDim;
        }
        if (t instanceof TypeParameter && t.getName().equals(typeParamName)) {
            while (reduceDim > 0) {
                toAdd = ((ArrayType)toAdd).getBaseType();
                --reduceDim;
            }
            List<Object> ctl = new ArrayList();
            int dim = 0;
            if (toAdd instanceof ArrayType) {
                while (toAdd instanceof ArrayType) {
                    toAdd = ((ArrayType)toAdd).getBaseType();
                    ++dim;
                }
                ctl = this.getAllSupertypes((ClassType)toAdd);
                ArrayList<ArrayType> tmp = new ArrayList<ArrayType>(ctl.size());
                for (int i = 0; i < ctl.size(); ++i) {
                    tmp.add(this.getNameInfo().createArrayType((Type)ctl.get(i), dim));
                }
                ctl = tmp;
            } else {
                ctl = this.getAllSupertypes((ClassType)toAdd);
            }
            if (result.isEmpty()) {
                result.addAll(ctl);
            } else {
                for (int i = result.size() - 1; i >= 0; --i) {
                    if (ctl.indexOf(result.get(i)) != -1) continue;
                    result.remove(i);
                }
            }
        }
    }

    private List<TypeArgument> replaceTypeParameter(List<? extends TypeArgument> typeArgs, TypeParameter typeParam, ClassType replacement) {
        ArrayList<TypeArgument> res = new ArrayList<TypeArgument>();
        for (int i = 0; i < typeArgs.size(); ++i) {
            TypeArgument ta;
            TypeArgument newTa = ta = typeArgs.get(i);
            List<TypeArgument> newTas = null;
            if (ta.getTypeArguments() != null) {
                newTas = this.replaceTypeParameter(ta.getTypeArguments(), typeParam, replacement);
            }
            if (this.getBaseType(ta) == typeParam) {
                newTa = new DefaultProgramModelInfo.ResolvedTypeArgument(ta.getWildcardMode(), replacement, newTas);
            } else if (newTas != null) {
                newTa = new DefaultProgramModelInfo.ResolvedTypeArgument(ta.getWildcardMode(), this.getBaseType(ta), newTas);
            }
            res.add(newTa);
        }
        return res;
    }

    public boolean containsTypeParameter(Type t) {
        while (t instanceof ArrayType) {
            t = ((ArrayType)t).getBaseType();
        }
        if (!(t instanceof ClassType)) {
            return false;
        }
        if (t instanceof TypeParameter) {
            return true;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getGenericType() instanceof TypeParameter) {
                return true;
            }
            for (TypeArgument typeArgument : pt.getTypeArgs()) {
                if (!this.containsTypeParameter(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsTypeParameter(TypeArgument ta) {
        if (this.getBaseType(ta) instanceof TypeParameter) {
            return true;
        }
        if (ta.getTypeArguments() != null) {
            for (TypeArgument typeArgument : ta.getTypeArguments()) {
                if (!this.containsTypeParameter(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private List<? extends TypeArgument> replaceTypeArgsRec(ParameterizedType context, List<? extends TypeArgument> targs) {
        ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument> result = new ArrayList<DefaultProgramModelInfo.ResolvedTypeArgument>(targs.size());
        for (TypeArgument typeArgument : targs) {
            Type ct = this.getBaseType(typeArgument);
            DefaultProgramModelInfo.ReplaceTypeArgResult repl = this.replaceTypeParameter(context, ct);
            result.add(new DefaultProgramModelInfo.ResolvedTypeArgument(repl.wildcardMode, repl.baseType, repl.baseType instanceof ParameterizedType ? ((ParameterizedType)repl.baseType).getTypeArgs() : null));
        }
        return result;
    }

    private DefaultProgramModelInfo.ReplaceTypeArgResult replaceTypeParameter(ParameterizedType context, Type toReplace) {
        List<? extends TypeArgument> newTypeArgs = null;
        if (toReplace instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)toReplace;
            DefaultProgramModelInfo.ReplaceTypeArgResult innerResult = this.replaceTypeParameter(context, arrayType.getBaseType());
            DefaultProgramModelInfo.ReplaceTypeArgResult result = new DefaultProgramModelInfo.ReplaceTypeArgResult(this.getNameInfo().createArrayType(innerResult.baseType), null);
            return result;
        }
        if (toReplace instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)toReplace;
            newTypeArgs = this.replaceTypeArgsRec(context, pt.getTypeArgs());
            toReplace = pt.getGenericType();
        }
        DefaultProgramModelInfo.ReplaceTypeArgResult result = new DefaultProgramModelInfo.ReplaceTypeArgResult(toReplace, null);
        if (toReplace instanceof TypeParameter) {
            result = super.replaceTypeArg(toReplace, context.getTypeArgs(), context.getGenericType().getTypeParameters());
        }
        if (newTypeArgs != null) {
            result = new DefaultProgramModelInfo.ReplaceTypeArgResult(new ParameterizedType((ClassType)result.baseType, newTypeArgs), result.wildcardMode);
        }
        return result;
    }

    @Override
    public boolean isNarrowingTo(Expression expr, PrimitiveType to) {
        int maxValue;
        int minValue;
        NameInfo ni = this.getNameInfo();
        if (to == ni.getByteType()) {
            minValue = -128;
            maxValue = 127;
        } else if (to == ni.getCharType()) {
            minValue = 0;
            maxValue = 65535;
        } else if (to == ni.getShortType()) {
            minValue = Short.MIN_VALUE;
            maxValue = Short.MAX_VALUE;
        } else {
            return false;
        }
        ConstantEvaluator ce = this.serviceConfiguration.getConstantEvaluator();
        ConstantEvaluator.EvaluationResult res = new ConstantEvaluator.EvaluationResult();
        if (!ce.isCompileTimeConstant(expr, res) || res.getTypeCode() != 4) {
            return false;
        }
        int value = res.getInt();
        return minValue <= value && value <= maxValue;
    }

    @Override
    public Type getType(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        Type result = null;
        if (pme instanceof Type) {
            result = (Type)pme;
        } else if (pme instanceof ProgramElement) {
            result = this.getType((ProgramElement)((Object)pme));
            if (result == null && pme instanceof VariableSpecification) {
                if (pme instanceof EnumConstantSpecification) {
                    throw new IllegalStateException("Enum constant outside an enum, this shouldn't even be possible");
                }
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Unknown type of %c \"%s\" @%p in %f", pme), ((VariableSpecification)pme).getParent().getTypeReference()));
                result = this.getNameInfo().getUnknownType();
            }
            if (result == null && pme instanceof EnumConstantDeclaration) {
                throw new Error("fatal error: EnumConstantDeclaration occured outside enum declaration");
            }
        } else {
            result = pme.getProgramModelInfo().getType(pme);
        }
        return result;
    }

    @Override
    public ClassType getContainingClassType(ProgramElement context) {
        Debug.assertNonnull(context);
        if (context instanceof TypeDeclaration) {
            context = context.getASTParent();
        }
        do {
            if (!(context instanceof ClassType)) continue;
            return (ClassType)((Object)context);
        } while ((context = context.getASTParent()) != null);
        return null;
    }

    @Override
    public ClassType getContainingClassType(Member m) {
        Debug.assertNonnull(m);
        ClassType result = null;
        ProgramElement pe = this.getDeclaration(m);
        result = pe == null ? m.getProgramModelInfo().getContainingClassType(m) : this.getContainingClassType(pe);
        return result;
    }

    protected Field getInheritedField(String name, ClassType ct) {
        List<Field> fl = ct.getAllFields();
        int nf = fl.size();
        for (int i = 0; i < nf; ++i) {
            Field f = fl.get(i);
            if (!name.equals(f.getName())) continue;
            return f;
        }
        return null;
    }

    @Override
    public Variable getVariable(String name, ProgramElement context) {
        TypeDeclaration ct;
        ASTList<Import> imports;
        Variable result;
        ProgramElement pe;
        ProgramElement originalContext = context;
        Debug.assertNonnull((Object)name, context);
        this.updateModel();
        if (this.java5Allowed() && (context instanceof VariableReference || context instanceof UncollatedReferenceQualifier) && context.getASTParent() instanceof Case && this.getType(((Case)context.getASTParent()).getParent().getExpression()) instanceof EnumDeclaration) {
            EnumConstantSpecification ecs = (EnumConstantSpecification)((EnumDeclaration)this.getType(((Case)context.getASTParent()).getParent().getExpression())).getVariableInScope(name);
            return ecs;
        }
        for (pe = context; pe != null && !(pe instanceof VariableScope); pe = pe.getASTParent()) {
            context = pe;
        }
        if (pe == null) {
            return null;
        }
        VariableScope scope = (VariableScope)pe;
        do {
            if ((result = scope.getVariableInScope(name)) != null) {
                if (scope instanceof StatementBlock) {
                    Statement s;
                    StatementBlock cont = (StatementBlock)scope;
                    VariableDeclaration def = result.getParent();
                    int i = 0;
                    while ((s = cont.getStatementAt(i)) != def) {
                        if (s == context) {
                            result = null;
                            break;
                        }
                        ++i;
                    }
                }
                if (result != null) break;
            }
            if (scope instanceof TypeDeclaration && (result = this.getInheritedField(name, (TypeDeclaration)scope)) != null) break;
            for (pe = scope.getASTParent(); pe != null && !(pe instanceof VariableScope); pe = pe.getASTParent()) {
                context = pe;
            }
        } while ((scope = (VariableScope)pe) != null);
        if (result == null && this.java5Allowed() && (result = this.getVariableFromStaticSingleImport(name, imports = UnitKit.getCompilationUnit(context).getImports(), ct = MiscKit.getParentTypeDeclaration(originalContext))) == null) {
            result = this.getVariableFromStaticOnDemandImport(name, imports, ct);
        }
        return result;
    }

    private Variable getVariableFromStaticSingleImport(String name, List<Import> imports, ClassType context) {
        Field result = null;
        Field oldResult = null;
        Import firstImport = null;
        int max = imports.size();
        block0: for (int i = 0; i < max; ++i) {
            Import imp = imports.get(i);
            if (!imp.isStaticImport() || imp.isMultiImport() || !name.equals(imp.getStaticIdentifier().getText())) continue;
            List<? extends Field> fields = this.getFields((ClassType)this.getType(imp.getTypeReference()));
            int maxF = fields.size();
            for (int f = 0; f < maxF; ++f) {
                Field field = fields.get(f);
                if (!field.getName().equals(name) || !this.isVisibleFor(field, context)) continue;
                result = field;
                if (oldResult != null && oldResult != result) {
                    this.getErrorHandler().reportError(new AmbiguousStaticFieldImportException(firstImport, imp, oldResult, result));
                }
                firstImport = imp;
                oldResult = field;
                continue block0;
            }
        }
        return result;
    }

    private Variable getVariableFromStaticOnDemandImport(String name, List<Import> imports, ClassType context) {
        Debug.assertNonnull(name);
        Debug.assertNonnull(imports);
        Debug.assertNonnull(context);
        Field result = null;
        Field oldResult = null;
        Import firstImport = null;
        int max = imports.size();
        block0: for (int i = 0; i < max; ++i) {
            Import imp = imports.get(i);
            if (!imp.isStaticImport() || !imp.isMultiImport()) continue;
            List<? extends Field> fields = this.getFields((ClassType)this.getType(imp.getTypeReference()));
            int maxF = fields.size();
            for (int f = 0; f < maxF; ++f) {
                Field field = fields.get(f);
                if (!field.getName().equals(name) || !this.isVisibleFor(field, context)) continue;
                result = field;
                if (oldResult != null && oldResult != result) {
                    this.getErrorHandler().reportError(new AmbiguousStaticFieldImportException(firstImport, imp, oldResult, result));
                }
                firstImport = imp;
                oldResult = field;
                continue block0;
            }
        }
        return result;
    }

    @Override
    public final Variable getVariable(VariableSpecification vs) {
        return vs;
    }

    @Override
    public Field getField(FieldReference fr) {
        Field res = (Field)this.reference2element.get(fr);
        if (res != null) {
            return res;
        }
        this.updateModel();
        String name = fr.getName();
        ReferencePrefix rp = fr.getReferencePrefix();
        if (rp == null) {
            res = (Field)this.getVariable(name, fr);
            if (res != null) {
                this.reference2element.put(fr, res);
            }
            return res;
        }
        ClassType thisType = this.getContainingClassType(fr);
        if (thisType == null) {
            return null;
        }
        ClassType ct = (ClassType)this.getType(rp);
        if (ct == null || ct instanceof DefaultNameInfo.UnknownClassType) {
            return null;
        }
        List<Field> fl = ct.getAllFields();
        if (fl == null) {
            return null;
        }
        for (int i = fl.size() - 1; i >= 0; --i) {
            res = fl.get(i);
            if (res.getName() != name) continue;
            this.reference2element.put(fr, res);
            return res;
        }
        return null;
    }

    @Override
    public Variable getVariable(VariableReference vr) {
        if (vr instanceof FieldReference) {
            return this.getField((FieldReference)vr);
        }
        Variable res = (Variable)this.reference2element.get(vr);
        if (res != null) {
            return res;
        }
        res = this.getVariable(vr.getName(), vr);
        if (res != null) {
            this.reference2element.put(vr, res);
        }
        return res;
    }

    @Override
    public List<Type> makeSignature(List<Expression> args) {
        if (args == null || args.isEmpty()) {
            return new ArrayList<Type>(0);
        }
        int arity = args.size();
        ArrayList<Type> result = new ArrayList<Type>(arity);
        for (int i = 0; i < arity; ++i) {
            Expression e = args.get(i);
            Type et = this.getType(e);
            if (et == null) {
                this.getErrorHandler().reportError(new TypingException("Unknown type for argument #" + i + " in call " + Format.toString("%c \"%s\" @%p in %f", e.getExpressionContainer()), e));
                et = this.getNameInfo().getUnknownType();
            }
            result.add(et);
        }
        return result;
    }

    @Override
    public final Method getMethod(MethodDeclaration md) {
        return md;
    }

    @Override
    public final Constructor getConstructor(ConstructorDeclaration cd) {
        return cd;
    }

    private final String isAppropriate(Method m, MethodReference mr) {
        if (mr.getReferencePrefix() == null) {
            return m.isStatic() || !this.occursInStaticContext(mr) ? null : "method invocation to non-static method occurs in static context (a)";
        }
        if (mr.getReferencePrefix() instanceof TypeReference && !m.isStatic()) {
            return "Static access to a non-static member";
        }
        if (mr.getTypeReferenceCount() == 1) {
            return null;
        }
        if (mr.getReferencePrefix() instanceof SuperReference) {
            SuperReference sr = (SuperReference)mr.getReferencePrefix();
            if (m.isAbstract()) {
                // empty if block
            }
            if (this.occursInStaticContext(mr)) {
                return "method invocation to non-static method occurs in static context (c)";
            }
            if (sr.getReferencePrefix() == null || sr.getReferencePrefix() instanceof TypeReference) {
                // empty if block
            }
            return null;
        }
        if (mr.getReferenceSuffix() != null && m.getReturnType() == null) {
            return "void method must not have a reference suffix";
        }
        return null;
    }

    private final boolean occursInStaticContext(MethodReference mr) {
        NonTerminalProgramElement pe;
        for (pe = mr; pe != null; pe = pe.getASTParent()) {
            if (pe instanceof ClassInitializer) {
                return ((ClassInitializer)pe).isStatic();
            }
            if (pe instanceof MethodDeclaration) {
                return ((MethodDeclaration)pe).isStatic();
            }
            if (!(pe instanceof FieldDeclaration)) continue;
            return ((FieldDeclaration)pe).isStatic();
        }
        this.getErrorHandler().reportError(new ModelException("cannot determine if MethodReference " + Format.toString(pe) + " occurs in static context; check parent links!"));
        return false;
    }

    @Override
    public AnnotationProperty getAnnotationProperty(AnnotationPropertyReference apr) {
        AnnotationProperty res = (AnnotationProperty)this.reference2element.get(apr);
        if (res != null) {
            return res;
        }
        Type at = this.getType(apr.getParent().getParent().getTypeReference());
        if (at instanceof ClassType && ((ClassType)at).isAnnotationType()) {
            ClassType ct = (ClassType)at;
            List<Method> ml = ct.getMethods();
            for (int i = 0; i < ml.size(); ++i) {
                if (!ml.get(i).getName().equals(apr.getIdentifier().getText())) continue;
                res = (AnnotationProperty)ml.get(i);
                break;
            }
            if (res == null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (12)", apr), apr));
                res = this.getNameInfo().getUnknownAnnotationProperty();
            }
        } else if (at == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (13)", apr), apr));
        } else {
            this.getErrorHandler().reportError(new ModelException(Format.toString("%c \"%s\" @%p in %f does not reference an annotation type!", apr)));
            res = this.getNameInfo().getUnknownAnnotationProperty();
        }
        this.reference2element.put(apr, res);
        return res;
    }

    @Override
    public Method getMethod(MethodReference mr) {
        Method res = (Method)this.reference2element.get(mr);
        if (res != null) {
            return res;
        }
        List<Method> mlist = this.getMethods(mr);
        if (mlist == null || mlist.isEmpty()) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (02)", mr), mr));
            return this.getNameInfo().getUnknownMethod();
        }
        if (mlist.size() > 1) {
            this.getErrorHandler().reportError(new AmbiguousReferenceException(Format.toString("%c \"%s\" @%p in %f is ambiguous - it could be one of ", mr) + Format.toString("%N", mlist), mr, mlist));
        } else {
            String msg = this.isAppropriate(mlist.get(0), mr);
            if (msg != null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Inappropriate method access: " + msg + " at %c \"%s\" @%p in %f", mr), mr));
            }
        }
        res = mlist.get(0);
        this.reference2element.put(mr, res);
        return res;
    }

    @Override
    public List<Method> getMethods(MethodReference mr) {
        Debug.assertNonnull(mr);
        this.updateModel();
        List<Method> result = null;
        List<Type> signature = this.makeSignature(mr.getArguments());
        ReferencePrefix rp = mr.getReferencePrefix();
        if (rp == null) {
            ClassType targetClass = this.getContainingClassType(mr);
            result = this.getMethods(targetClass, mr.getName(), signature, mr.getTypeArguments());
            if (result != null && result.size() > 0) {
                return result;
            }
            for (ClassTypeContainer ctc = targetClass.getContainer(); ctc != null; ctc = ctc.getContainer()) {
                if (!(ctc instanceof ClassType) || (result = this.getMethods((ClassType)ctc, mr.getName(), signature, mr.getTypeArguments())) == null || result.size() <= 0) continue;
                return result;
            }
            if (this.java5Allowed()) {
                ASTList<Import> imports = UnitKit.getCompilationUnit(mr).getImports();
                result = this.getMethodsFromStaticSingleImports(mr, imports);
                if (result != null && result.size() > 0) {
                    return result;
                }
                result = this.getMethodsFromStaticOnDemandImports(mr, imports);
                if (result != null && result.size() > 0) {
                    return result;
                }
            }
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (03)", mr), mr));
            ArrayList<Method> list = new ArrayList<Method>(1);
            list.add(this.getNameInfo().getUnknownMethod());
            result = list;
        } else {
            Type rpt = this.getType(rp);
            if (rpt == null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (04)", rp), rp));
                ArrayList<Method> list = new ArrayList<Method>(1);
                list.add(this.getNameInfo().getUnknownMethod());
                return list;
            }
            if (rpt instanceof ArrayType) {
                rpt = this.getNameInfo().getJavaLangObject();
            }
            result = this.getMethods((ClassType)rpt, mr.getName(), signature, mr.getTypeArguments());
        }
        return result;
    }

    private List<Method> getMethodsFromStaticOnDemandImports(MethodReference mr, List<Import> imports) {
        NameInfo ni = this.getNameInfo();
        ArrayList<Method> result = new ArrayList<Method>();
        int max = imports.size();
        for (int i = 0; i < max; ++i) {
            Import imp = imports.get(i);
            if (!imp.isStaticImport() || !imp.isMultiImport()) continue;
            List<Method> ml = ni.getClassType(Naming.toPathName(imp.getTypeReference())).getMethods();
            for (int j = 0; j < ml.size(); ++j) {
                Method m = ml.get(j);
                if (!m.isStatic() || !m.getName().equals(mr.getName())) continue;
                result.add(m);
            }
        }
        List<Type> sig = this.makeSignature(mr.getArguments());
        return this.doThreePhaseFilter(result, sig, mr.getName(), MiscKit.getParentTypeDeclaration(mr), mr.getTypeArguments());
    }

    private List<Method> getMethodsFromStaticSingleImports(MethodReference mr, List<Import> imports) {
        NameInfo ni = this.getNameInfo();
        ArrayList<Method> result = new ArrayList<Method>();
        int max = imports.size();
        for (int i = 0; i < max; ++i) {
            Import imp = imports.get(i);
            if (!imp.isStaticImport() || imp.isMultiImport() || !imp.getStaticIdentifier().getText().equals(mr.getName())) continue;
            List<Method> ml = ni.getClassType(Naming.toPathName(imp.getTypeReference())).getMethods();
            for (int j = 0; j < ml.size(); ++j) {
                Method m = ml.get(j);
                if (!m.isStatic() || !m.getName().equals(mr.getName())) continue;
                result.add(m);
            }
        }
        List<Type> sig = this.makeSignature(mr.getArguments());
        return this.doThreePhaseFilter(result, sig, mr.getName(), MiscKit.getParentTypeDeclaration(mr), mr.getTypeArguments());
    }

    @Override
    public Constructor getConstructor(ConstructorReference cr) {
        Constructor res = (Constructor)this.reference2element.get(cr);
        if (res != null) {
            return res;
        }
        List<? extends Constructor> clist = this.getConstructors(cr);
        if (clist == null || clist.isEmpty()) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (05)", cr), cr));
            return this.getNameInfo().getUnknownConstructor();
        }
        if (clist.size() > 1) {
            this.getErrorHandler().reportError(new AmbiguousReferenceException(Format.toString("%c \"%s\" @%p in %f is ambiguous - it could be one of ", cr) + Format.toString("%N", clist), cr, clist));
        }
        res = clist.get(0);
        this.reference2element.put(cr, res);
        return res;
    }

    @Override
    public List<? extends Constructor> getConstructors(ConstructorReference cr) {
        this.updateModel();
        ClassType type = null;
        if (cr instanceof New) {
            New n = (New)cr;
            ReferencePrefix rp = n.getReferencePrefix();
            if (rp != null) {
                // empty if block
            }
            type = (ClassType)this.getType(n.getTypeReference());
        } else if (cr instanceof ThisConstructorReference) {
            type = this.getContainingClassType(cr);
        } else if (cr instanceof SuperConstructorReference) {
            type = this.getContainingClassType(cr);
            List<ClassType> superTypes = this.getSupertypes(type);
            for (int i = 0; i < superTypes.size() && (type = superTypes.get(i)).isInterface(); ++i) {
            }
        } else if (cr instanceof EnumConstructorReference) {
            type = this.getContainingClassType(cr);
        } else {
            Debug.error("Unknown Constructor Reference " + cr);
        }
        if (type == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (06)", cr), cr));
            ArrayList<Constructor> list = new ArrayList<Constructor>(1);
            list.add(this.getNameInfo().getUnknownConstructor());
            return list;
        }
        return this.getConstructors(type, this.makeSignature(cr.getArguments()));
    }

    @Override
    public List<TypeDeclaration> getTypes(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null) {
            return new ArrayList<TypeDeclaration>(0);
        }
        int s = members.size();
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>();
        for (int i = 0; i < s; ++i) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (!(m instanceof TypeDeclaration)) continue;
            result.add((TypeDeclaration)m);
        }
        return result;
    }

    @Override
    public List<FieldSpecification> getFields(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null) {
            return new ArrayList<FieldSpecification>(0);
        }
        int s = members.size();
        ArrayList<FieldSpecification> result = new ArrayList<FieldSpecification>();
        for (int i = 0; i < s; ++i) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (m instanceof FieldDeclaration) {
                result.addAll(((FieldDeclaration)m).getFieldSpecifications());
                continue;
            }
            if (!(m instanceof EnumConstantDeclaration)) continue;
            result.add(((EnumConstantDeclaration)m).getEnumConstantSpecification());
        }
        return result;
    }

    @Override
    public List<Method> getMethods(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ASTList<MemberDeclaration> members = td.getMembers();
        if (members == null && !(td instanceof EnumDeclaration)) {
            return new ArrayList<Method>(0);
        }
        int s = members == null ? 0 : members.size();
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i = 0; i < s; ++i) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (!(m instanceof MethodDeclaration) || m instanceof ConstructorDeclaration) continue;
            result.add((MethodDeclaration)m);
        }
        if (td instanceof EnumDeclaration) {
            List<ImplicitEnumMethod> rl = this.serviceConfiguration.getImplicitElementInfo().getImplicitEnumMethods((EnumDeclaration)td);
            result.add(rl.get(0));
            result.add(rl.get(1));
        }
        return result;
    }

    @Override
    public List<Constructor> getConstructors(TypeDeclaration td) {
        Debug.assertNonnull(td);
        this.updateModel();
        ArrayList<Constructor> result = new ArrayList<Constructor>(2);
        ASTList<MemberDeclaration> members = td.getMembers();
        int s = members == null ? 0 : members.size();
        for (int i = 0; i < s; ++i) {
            MemberDeclaration m = (MemberDeclaration)members.get(i);
            if (!(m instanceof ConstructorDeclaration)) continue;
            result.add((ConstructorDeclaration)m);
        }
        if (result.isEmpty() && !td.isInterface() && td.getName() != null) {
            result.add(this.serviceConfiguration.getImplicitElementInfo().getDefaultConstructor(td));
        }
        return result;
    }

    @Override
    public Package getPackage(PackageReference pr) {
        Package res = (Package)this.reference2element.get(pr);
        if (res != null) {
            return res;
        }
        res = this.getNameInfo().createPackage(Naming.toPathName(pr));
        if (res != null) {
            this.reference2element.put(pr, res);
        }
        return res;
    }

    @Override
    public Package getPackage(ProgramModelElement pme) {
        Debug.assertNonnull(pme);
        this.updateModel();
        Package result = null;
        ProgramElement pe = this.getDeclaration(pme);
        result = pe == null ? pme.getProgramModelInfo().getPackage(pme) : this.getNameInfo().createPackage(Naming.getPackageName(UnitKit.getCompilationUnit(pe)));
        return result;
    }

    @Override
    public List<? extends ClassType> getTypes(ClassTypeContainer ctc) {
        ProgramElement decl;
        Debug.assertNonnull(ctc);
        this.updateModel();
        if (decl == null) {
            return ctc.getProgramModelInfo().getTypes(ctc);
        }
        for (decl = this.getDeclaration(ctc); decl != null && !(decl instanceof TypeScope); decl = decl.getASTParent()) {
        }
        Debug.assertNonnull((Object)decl, "Internal error - scope inconsistency");
        return ((TypeScope)decl).getTypesInScope();
    }

    @Override
    public ClassTypeContainer getClassTypeContainer(ClassType ct) {
        Debug.assertNonnull(ct);
        TypeDeclaration td = this.getTypeDeclaration(ct);
        if (td == null) {
            return ct.getProgramModelInfo().getClassTypeContainer(ct);
        }
        NonTerminalProgramElement cur = td;
        NonTerminalProgramElement par = cur.getASTParent();
        while (par != null) {
            cur = par;
            if (cur instanceof ClassTypeContainer) {
                return (ClassTypeContainer)((Object)cur);
            }
            par = cur.getASTParent();
        }
        return this.getNameInfo().createPackage(Naming.getPackageName((CompilationUnit)cur));
    }

    List<ClassType> getTypeList(List<TypeReference> trl) {
        this.updateModel();
        int s = trl != null ? trl.size() : 0;
        ArrayList<ClassType> result = new ArrayList<ClassType>(s);
        for (int i = 0; i < s; ++i) {
            result.add((ClassType)this.getType(trl.get(i)));
        }
        return result;
    }

    void addToTypeList(ArrayList<ClassType> result, List<TypeReference> trl) {
        int s = trl != null ? trl.size() : 0;
        result.ensureCapacity(result.size() + s);
        for (int i = 0; i < s; ++i) {
            TypeReference tr = trl.get(i);
            if (tr == null) continue;
            ClassType ct = (ClassType)this.getType(tr);
            if (ct == null) {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Unable to resolve %c \"%s\" @%p in %f", tr), tr));
                ct = this.getNameInfo().getUnknownClassType();
            }
            result.add(ct);
        }
    }

    @Override
    public List<ClassType> getSupertypes(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        TypeDeclaration td = this.getTypeDeclaration(ct);
        if (td == null) {
            return ct.getProgramModelInfo().getSupertypes(ct);
        }
        DefaultProgramModelInfo.ClassTypeCacheEntry ctce = (DefaultProgramModelInfo.ClassTypeCacheEntry)this.classTypeCache.get(ct);
        if (ctce == null) {
            ctce = new DefaultProgramModelInfo.ClassTypeCacheEntry();
            this.classTypeCache.put(ct, ctce);
        }
        if (ctce.supertypes != null) {
            return ctce.supertypes;
        }
        ArrayList<ClassType> res = new ArrayList<ClassType>();
        if (td instanceof EnumDeclaration) {
            res.add(this.getNameInfo().getJavaLangEnum());
            res.add(this.getNameInfo().getJavaLangObject());
        } else if (td instanceof AnnotationDeclaration) {
            res.add(this.getNameInfo().getJavaLangAnnotationAnnotation());
            res.add(this.getNameInfo().getJavaLangObject());
        } else if (td instanceof InterfaceDeclaration) {
            InterfaceDeclaration id = (InterfaceDeclaration)td;
            Extends ext = id.getExtendedTypes();
            if (ext != null) {
                this.addToTypeList(res, ext.getSupertypes());
            }
            res.add(this.getNameInfo().getJavaLangObject());
        } else if (td instanceof TypeParameterDeclaration) {
            TypeParameterDeclaration tp = (TypeParameterDeclaration)td;
            if (tp.getBounds() == null || tp.getBounds().size() == 0) {
                res.add(this.getNameInfo().getJavaLangObject());
            } else {
                for (TypeReference tr : tp.getBounds()) {
                    String name = tr.getName();
                    if (tr.getReferencePrefix() != null) {
                        name = Naming.toPathName(tr.getReferencePrefix(), name);
                    }
                    res.add((ClassType)this.getType(name, tp.getASTParent()));
                }
            }
        } else {
            ClassType jlo;
            ClassDeclaration cd = (ClassDeclaration)td;
            TypeDeclarationContainer con = cd.getParent();
            if (con instanceof New) {
                TypeReference tr = ((New)con).getTypeReference();
                res.add((ClassType)this.getType(tr));
            } else {
                Implements imp;
                Extends ext = cd.getExtendedTypes();
                if (ext != null) {
                    this.addToTypeList(res, ext.getSupertypes());
                }
                if ((imp = cd.getImplementedTypes()) != null) {
                    this.addToTypeList(res, imp.getSupertypes());
                }
            }
            if (res.isEmpty() && ct != (jlo = this.getNameInfo().getJavaLangObject())) {
                res.add(jlo);
            }
        }
        ctce.supertypes = res;
        return ctce.supertypes;
    }

    @Override
    public List<? extends Field> getFields(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Field> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getFields(ct) : this.getFields(td);
        return result;
    }

    @Override
    public List<Method> getMethods(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Method> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getMethods(ct) : this.getMethods(td);
        return result;
    }

    @Override
    public List<? extends Constructor> getConstructors(ClassType ct) {
        Debug.assertNonnull(ct);
        this.updateModel();
        List<Constructor> result = null;
        TypeDeclaration td = this.getTypeDeclaration(ct);
        result = td == null ? ct.getProgramModelInfo().getConstructors(ct) : this.getConstructors(td);
        return result;
    }

    @Override
    public List<Type> getSignature(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        List<Object> result = new ArrayList(0);
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            result = m.getProgramModelInfo().getSignature(m);
        } else {
            int params;
            ASTList<ParameterDeclaration> pdl = md.getParameters();
            int n = params = pdl == null ? 0 : pdl.size();
            if (params > 0) {
                ArrayList<Type> res = new ArrayList<Type>(params);
                result = res;
                for (int i = 0; i < params; ++i) {
                    Type ptype = this.getType(((ParameterDeclaration)pdl.get(i)).getVariables().get(0));
                    res.add(ptype);
                }
            }
        }
        return result;
    }

    @Override
    public List<ClassType> getExceptions(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        List<Object> result = new ArrayList(0);
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            result = m.getProgramModelInfo().getExceptions(m);
        } else {
            Throws t = md.getThrown();
            if (t != null) {
                result = this.getTypeList(t.getExceptions());
            }
        }
        return result;
    }

    @Override
    public Type getReturnType(Method m) {
        Debug.assertNonnull(m);
        this.updateModel();
        Type result = null;
        MethodDeclaration md = this.getMethodDeclaration(m);
        if (md == null) {
            result = m.getProgramModelInfo().getReturnType(m);
        } else {
            TypeReference tr = md.getTypeReference();
            if (tr != null && !"void".equals(tr.getName())) {
                result = this.getType(tr);
            }
        }
        return result;
    }

    @Override
    public Type getAnnotationType(AnnotationUseSpecification au) {
        Debug.assertNonnull(au);
        this.updateModel();
        Type result = null;
        TypeReference tr = au.getTypeReference();
        if (tr != null) {
            result = this.getType(tr);
        }
        return result;
    }

    @Override
    public Reference resolveURQ(UncollatedReferenceQualifier urq) {
        NonTerminalProgramElement parent = urq.getASTParent();
        return this.resolveURQ(urq, !(parent instanceof TypeReference) && !(parent instanceof PackageReference));
    }

    protected Reference resolveURQ(UncollatedReferenceQualifier urq, boolean allowVariables) {
        String fullname;
        Debug.assertNonnull(urq);
        ReferencePrefix rp = urq.getReferencePrefix();
        if (rp instanceof UncollatedReferenceQualifier) {
            rp = (ReferencePrefix)((Object)this.resolveURQ((UncollatedReferenceQualifier)rp, allowVariables));
        }
        this.updateModel();
        JavaNonTerminalProgramElement result = null;
        NameInfo ni = this.getNameInfo();
        NonTerminalProgramElement parent = urq.getASTParent();
        String urqName = urq.getName();
        if (rp == null) {
            Variable v;
            if (allowVariables && (v = this.getVariable(urqName, urq)) != null) {
                result = v instanceof Field ? urq.toFieldReference() : urq.toVariableReference();
                this.reference2element.put((Reference)((Object)result), v);
            }
            if (result == null) {
                Package pkg = ni.getPackage(urqName);
                if (pkg != null) {
                    result = urq.toPackageReference();
                    this.reference2element.put((Reference)((Object)result), pkg);
                } else {
                    Type t = this.getType(urqName, urq);
                    if (t != null) {
                        result = urq.toTypeReference();
                        this.reference2element.put((Reference)((Object)result), t);
                    } else if (urqName.charAt(0) >= 'A' && urqName.charAt(0) <= 'Z') {
                        result = urq.toTypeReference();
                        this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (07b)", urq), urq));
                    } else {
                        try {
                            result = urq.toPackageReference();
                        }
                        catch (ClassCastException cce) {
                            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (07)", urq), urq));
                            result = urq.toTypeReference();
                        }
                    }
                }
            }
        } else if (rp instanceof ThisReference) {
            TypeScope thisScope;
            ReferencePrefix rpp = ((ThisReference)rp).getReferencePrefix();
            if (rpp == null) {
                thisScope = (TypeScope)((Object)this.getContainingClassType(urq));
            } else {
                TypeReference tr = rpp instanceof TypeReference ? (TypeReference)rpp : (TypeReference)this.resolveURQ((UncollatedReferenceQualifier)rpp, false);
                thisScope = (TypeDeclaration)this.getType(tr);
            }
            Variable v = this.getVariable(urqName, thisScope);
            if (v != null) {
                result = urq.toFieldReference();
                this.reference2element.put((Reference)((Object)result), v);
            } else {
                ClassType refT = thisScope.getTypeInScope(urqName);
                if (refT != null) {
                    result = urq.toTypeReference();
                    this.reference2element.put((Reference)((Object)result), refT);
                }
            }
        } else if (rp instanceof SuperReference) {
            ClassType superType = (ClassType)this.getType(rp);
            Field f = this.getInheritedField(urq.getName(), superType);
            if (f != null) {
                result = urq.toFieldReference();
                this.reference2element.put((Reference)((Object)result), f);
            } else {
                fullname = Naming.getFullName(superType, urq.getName());
                ClassType ct = ni.getClassType(fullname);
                if (ct != null) {
                    result = urq.toTypeReference();
                    this.reference2element.put((Reference)((Object)result), ct);
                }
            }
        } else if (rp instanceof PackageReference) {
            String fullRefName = Naming.toPathName(urq);
            Package pkg = ni.getPackage(fullRefName);
            if (pkg != null) {
                result = urq.toPackageReference();
                this.reference2element.put((Reference)((Object)result), pkg);
            } else {
                ClassType t = ni.getClassType(fullRefName);
                if (t != null) {
                    result = urq.toTypeReference();
                    this.reference2element.put((Reference)((Object)result), t);
                } else {
                    result = urq.getReferenceSuffix() instanceof MethodReference || allowVariables && urq.getReferenceSuffix() instanceof FieldReference ? urq.toTypeReference() : urq.toPackageReference();
                }
            }
        } else if (rp instanceof TypeReference || rp instanceof Expression) {
            Type refT = this.getType(rp);
            if (refT instanceof ClassType) {
                ClassType innerType;
                Field f;
                ClassType ct = (ClassType)refT;
                if (allowVariables && (f = this.getInheritedField(urq.getName(), ct)) != null) {
                    result = urq.toFieldReference();
                    this.reference2element.put((Reference)((Object)result), f);
                }
                if (result == null && (innerType = ni.getClassType(fullname = Naming.getFullName((ClassType)refT, urq.getName()))) != null) {
                    result = urq.toTypeReference();
                    this.reference2element.put((Reference)((Object)result), innerType);
                }
            } else if (refT instanceof ArrayType) {
                if (allowVariables && urq.getName() == "length") {
                    result = urq.toArrayLengthReference();
                } else {
                    this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (08)", urq), urq));
                    result = urq;
                }
            } else {
                this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (09)", rp), rp));
                result = urq;
            }
        } else {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (10)", rp), rp));
            result = urq;
        }
        if (result == null) {
            this.getErrorHandler().reportError(new UnresolvedReferenceException(Format.toString("Could not resolve %c \"%s\" @%p in %f (11)", urq), urq));
            result = urq;
        } else if (result != urq) {
            block49: {
                try {
                    parent.replaceChild(urq, result);
                }
                catch (ClassCastException cce) {
                    boolean throwAgain = true;
                    if (!(result instanceof Expression) && result instanceof PackageReference) {
                        PackageReference pr = (PackageReference)result;
                        ProgramFactory pf = result.getFactory();
                        Package pack = pf.getServiceConfiguration().getNameInfo().getPackage(pr.toSource());
                        if (pack == null) {
                            PackageReference pkgToBeReplacedByType = pr.getPackageReference();
                            PackageReference newPr = null;
                            TypeReference typeRef = null;
                            if (pkgToBeReplacedByType != null) {
                                newPr = pr.getPackageReference().getPackageReference();
                                typeRef = pf.createTypeReference(newPr, pkgToBeReplacedByType.getIdentifier());
                            }
                            result = pf.createFieldReference(typeRef, pr.getIdentifier());
                            result.setStartPosition(pr.getStartPosition());
                            result.setEndPosition(pr.getEndPosition());
                            result.setRelativePosition(pr.getRelativePosition());
                            result.setComments(pr.getComments());
                            throwAgain = false;
                            parent.replaceChild(urq, result);
                        }
                    }
                    if (!throwAgain) break block49;
                    throw cce;
                }
            }
            Debug.assertBoolean(parent == result.getASTParent());
        }
        return result;
    }

    private boolean java5Allowed() {
        return this.serviceConfiguration.getProjectSettings().java5Allowed();
    }

    @Override
    public List<Statement> getSucceedingStatements(Statement s) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (s instanceof LoopStatement) {
            LoopStatement loop = (LoopStatement)s;
            switch (this.getBooleanStatus(loop.getGuard())) {
                case 1: {
                    if (loop.getBody() == null) break;
                    list.add(loop.getBody());
                    break;
                }
                case 0: {
                    if (loop.isCheckedBeforeIteration()) {
                        DefaultSourceInfo.addSequentialFollower(s, list);
                        break;
                    }
                    if (loop.getBody() != null) {
                        list.add(loop.getBody());
                    }
                    DefaultSourceInfo.addSequentialFollower(s, list);
                    break;
                }
                case -1: {
                    if (loop.getBody() != null) {
                        list.add(loop.getBody());
                    }
                    DefaultSourceInfo.addSequentialFollower(s, list);
                }
            }
        } else if (s instanceof LabeledStatement) {
            list.add(((LabeledStatement)s).getBody());
        } else if (s instanceof StatementBlock) {
            ASTList<Statement> slist = ((StatementBlock)s).getBody();
            if (slist == null || slist.isEmpty()) {
                DefaultSourceInfo.addSequentialFollower(s, list);
            } else {
                list.add((Statement)slist.get(0));
            }
        } else if (s instanceof SynchronizedBlock) {
            ASTList<Statement> slist = ((SynchronizedBlock)s).getBody().getBody();
            if (slist == null || slist.isEmpty()) {
                DefaultSourceInfo.addSequentialFollower(s, list);
            } else {
                list.add((Statement)slist.get(0));
            }
        } else if (s instanceof If) {
            If ifstmt = (If)s;
            if (ifstmt.getElse() != null) {
                list.add(ifstmt.getThen().getBody());
                list.add(ifstmt.getElse().getBody());
            } else {
                list.add(ifstmt.getThen().getBody());
                DefaultSourceInfo.addSequentialFollower(s, list);
            }
        } else if (s instanceof Switch) {
            ASTList<Branch> branches = ((Switch)s).getBranchList();
            if (branches == null || branches.isEmpty()) {
                DefaultSourceInfo.addSequentialFollower(s, list);
            } else {
                boolean hasDefault = false;
                int c = branches.size();
                for (int i = 0; i < c; ++i) {
                    Branch b = (Branch)branches.get(i);
                    ASTList<Statement> stats = null;
                    if (b instanceof Default) {
                        stats = ((Default)b).getBody();
                        if (i < c - 1 || stats != null && !stats.isEmpty()) {
                            hasDefault = true;
                        }
                    } else if (b instanceof Case) {
                        stats = ((Case)b).getBody();
                    }
                    if (stats == null || stats.isEmpty()) continue;
                    list.add((Statement)stats.get(0));
                }
                if (!hasDefault) {
                    DefaultSourceInfo.addSequentialFollower(s, list);
                }
            }
        } else if (s instanceof Try) {
            list.add(((Try)s).getBody());
            ASTList<Branch> branches = ((Try)s).getBranchList();
            if (branches == null || branches.isEmpty()) {
                DefaultSourceInfo.addSequentialFollower(s, list);
                return list;
            }
            for (int i = 0; i < branches.size(); ++i) {
                Branch b = (Branch)branches.get(i);
                if (b instanceof Catch) {
                    Catch ca = (Catch)b;
                    boolean newException = true;
                    if (i > 0) {
                        ClassType ex = (ClassType)this.getType(ca.getParameterDeclaration().getTypeReference());
                        for (int j = i - 1; j >= 0; --j) {
                            ClassType dx;
                            if (!(branches.get(j) instanceof Catch) || !this.isSubtype(ex, dx = (ClassType)this.getType(((Catch)branches.get(j)).getParameterDeclaration().getTypeReference()))) continue;
                            newException = false;
                            break;
                        }
                    }
                    if (!newException) continue;
                    list.add(ca.getBody());
                    continue;
                }
                if (!(b instanceof Finally)) continue;
                list.add(((Finally)b).getBody());
            }
            DefaultSourceInfo.addSequentialFollower(s, list);
        } else if (s instanceof ExpressionJumpStatement) {
            list.add(METHOD_EXIT);
        } else if (s instanceof Break) {
            if (((Break)s).getIdentifier() == null) {
                DefaultSourceInfo.addSequentialFollower(DefaultSourceInfo.findInnermostBreakBlock(s), list);
            } else {
                DefaultSourceInfo.addSequentialFollower(StatementKit.getCorrespondingLabel((Break)s), list);
            }
        } else if (s instanceof Continue) {
            if (((Continue)s).getIdentifier() == null) {
                list.add(DefaultSourceInfo.findInnermostLoop(s));
            } else {
                list.add(StatementKit.getCorrespondingLabel((Continue)s).getBody());
            }
        } else {
            DefaultSourceInfo.addSequentialFollower(s, list);
        }
        return list;
    }

    private int getBooleanStatus(Expression expr) {
        if (expr == null) {
            return 1;
        }
        ConstantEvaluator.EvaluationResult evr = new ConstantEvaluator.EvaluationResult();
        if (this.serviceConfiguration.getConstantEvaluator().isCompileTimeConstant(expr, evr)) {
            return evr.getBoolean() ? 1 : 0;
        }
        return -1;
    }

    @Override
    public void register(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof CompilationUnit) {
            if (!((CompilationUnit)pe).isDefinedScope()) {
                this.analyzeProgramElement(pe);
            }
        } else {
            Debug.assertNonnull(pe.getASTParent());
            this.analyzeProgramElement(pe);
        }
    }

    private void analyzeProgramElement(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)pe;
            String packageName = Naming.getPackageName(cu);
            this.getNameInfo().createPackage(packageName);
        }
        this.analyzeProgramElement0(pe);
    }

    private void analyzeProgramElement0(ProgramElement pe) {
        ProgramModelElement dup;
        if (pe instanceof TerminalProgramElement) {
            return;
        }
        if (pe instanceof ScopeDefiningElement) {
            ((ScopeDefiningElement)pe).setDefinedScope(true);
            if (pe instanceof MethodDeclaration) {
                ((MethodDeclaration)pe).setProgramModelInfo(this);
            } else if (pe instanceof TypeDeclaration) {
                TypeDeclaration td = (TypeDeclaration)pe;
                td.setProgramModelInfo(this);
                String typename = td.getName();
                if (typename != null) {
                    NonTerminalProgramElement parent = pe.getASTParent();
                    while (!(parent instanceof TypeScope)) {
                        parent = parent.getASTParent();
                    }
                    TypeScope scope = (TypeScope)parent;
                    dup = scope.getTypeInScope(typename);
                    if (dup != null && dup != td) {
                        this.getErrorHandler().reportError(new AmbiguousDeclarationException("Duplicate declaration of " + Format.toString("%c \"%N\" @%p in %f", td) + " - was " + Format.toString("%c \"%N\" @%p in %f", dup), td, dup));
                    }
                    scope.addTypeToScope(td, typename);
                    this.getNameInfo().register(td);
                }
            }
        } else if (pe instanceof VariableSpecification) {
            VariableSpecification vs = (VariableSpecification)pe;
            vs.setProgramModelInfo(this);
            NonTerminalProgramElement parent = vs.getASTParent().getASTParent();
            while (!(parent instanceof VariableScope)) {
                parent = parent.getASTParent();
            }
            VariableScope scope = (VariableScope)parent;
            String vname = vs.getName();
            dup = scope.getVariableInScope(vname);
            if (dup != null && dup != vs) {
                this.getErrorHandler().reportError(new AmbiguousDeclarationException("Duplicate declaration of " + Format.toString("%c \"%N\" @%p in %f", vs) + " - was " + Format.toString("%c \"%N\" @%p in %f", dup), vs, dup));
            }
            if (!(scope instanceof TypeDeclaration)) {
                VariableScope outer = DefaultSourceInfo.findOuterVariableScope(scope);
                while (!(outer instanceof TypeDeclaration)) {
                    dup = outer.getVariableInScope(vname);
                    if (dup != null) {
                        this.getErrorHandler().reportError(new AmbiguousDeclarationException("Hidden local declaration: " + Format.toString("%c \"%N\" @%p in %f", vs) + " - hides " + Format.toString("%c \"%N\" @%p in %f", dup), vs, dup));
                    }
                    outer = DefaultSourceInfo.findOuterVariableScope(outer);
                }
            }
            scope.addVariableToScope(vs);
            if (vs instanceof FieldSpecification) {
                this.getNameInfo().register((Field)((Object)vs));
            }
        }
        NonTerminalProgramElement cont = (NonTerminalProgramElement)pe;
        int childCount = cont.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.analyzeProgramElement0(cont.getChildAt(i));
        }
    }

    void unregister(TypeDeclaration td) {
        this.unregister(td, td.getName());
    }

    void unregister(TypeDeclaration td, String shortname) {
        List<ClassType> superTypes;
        if (shortname != null) {
            ((TypeScope)td.getASTParent()).removeTypeFromScope(shortname);
        }
        this.getNameInfo().unregisterClassType(td.getFullName());
        DefaultProgramModelInfo.ClassTypeCacheEntry ctce = (DefaultProgramModelInfo.ClassTypeCacheEntry)this.classTypeCache.get(td);
        if (ctce != null && (superTypes = ctce.supertypes) != null) {
            for (int i = superTypes.size() - 1; i >= 0; --i) {
                this.removeSubtype(td, superTypes.get(i));
            }
        }
    }

    void unregister(VariableSpecification vs) {
        this.unregister(vs, vs.getName());
    }

    void unregister(VariableSpecification vs, String shortname) {
        NonTerminalProgramElement pe = vs.getASTParent().getASTParent();
        while (!(pe instanceof VariableScope)) {
            pe = pe.getASTParent();
        }
        ((VariableScope)pe).removeVariableFromScope(shortname);
        if (vs instanceof FieldSpecification) {
            ClassType ct = ((Field)((Object)vs)).getContainingClassType();
            this.getNameInfo().unregisterField(Naming.getFullName(ct, shortname));
        }
    }

    void unregister(ProgramElement pe) {
        Debug.assertNonnull(pe);
        if (pe instanceof TypeDeclaration) {
            this.unregister((TypeDeclaration)pe);
        } else if (pe instanceof VariableSpecification) {
            this.unregister((VariableSpecification)pe);
        } else if (pe instanceof VariableDeclaration) {
            List<? extends VariableSpecification> vspecs = ((VariableDeclaration)pe).getVariables();
            for (int i = vspecs.size() - 1; i >= 0; --i) {
                this.unregister(vspecs.get(i));
            }
        }
        TreeWalker tw = new TreeWalker(pe);
        while (tw.next()) {
            pe = tw.getProgramElement();
            if (!(pe instanceof ScopeDefiningElement)) continue;
            this.flushScopes((ScopeDefiningElement)pe);
        }
    }

    void flushScopes(ScopeDefiningElement sde) {
        int j;
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        if (sde instanceof TypeScope) {
            List<? extends ClassType> ctl = ((TypeScope)sde).getTypesInScope();
            if (sde instanceof CompilationUnit) {
                for (j = ctl.size() - 1; j >= 0; --j) {
                    ClassType ct = ctl.get(j);
                    if (!(ct instanceof TypeDeclaration) || ((TypeDeclaration)ct).getASTParent() != sde) continue;
                    dni.unregisterClassType(ct.getFullName());
                }
            } else {
                for (j = ctl.size() - 1; j >= 0; --j) {
                    dni.unregisterClassType(ctl.get(j).getFullName());
                }
            }
        }
        if (sde instanceof TypeDeclaration) {
            List<FieldSpecification> fl = ((TypeDeclaration)sde).getFieldsInScope();
            for (j = fl.size() - 1; j >= 0; --j) {
                dni.unregisterField(fl.get(j).getFullName());
            }
        }
        sde.setDefinedScope(false);
    }

    @Override
    public void reset() {
        super.reset();
        this.reference2element.clear();
        SourceFileRepository sfr = this.serviceConfiguration.getSourceFileRepository();
        List<CompilationUnit> cul = sfr.getCompilationUnits();
        DefaultNameInfo dni = (DefaultNameInfo)this.getNameInfo();
        dni.unregisterPackages();
        for (int i = cul.size() - 1; i >= 0; --i) {
            CompilationUnit cu = cul.get(i);
            this.unregister(cu);
            this.analyzeProgramElement(cu);
        }
    }
}

