/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import recoder.util.OptionException;
import recoder.util.OptionManager;

public abstract class CommandLineProgram {
    public static final Boolean TRUE = OptionManager.TRUE;
    public static final Boolean FALSE = OptionManager.FALSE;
    public static final Boolean ON = OptionManager.ON;
    public static final Boolean OFF = OptionManager.OFF;
    public static final int ONE = 1;
    public static final int ZERO_OR_ONE = 2;
    public static final int ONE_OR_MORE = 4;
    public static final int ZERO_OR_MORE = 8;
    private final OptionManager om = new OptionManager();
    private final Map<String, Field> vars = new HashMap<String, Field>();
    public boolean showHelp;

    protected abstract String getArgsDescription();

    protected abstract void run(String[] var1) throws Exception;

    protected void registerOptions() {
        this.registerSimpleOpt("showHelp", "h", "help", "display help information");
    }

    protected final void start(String[] args) {
        try {
            this.registerOptions();
            String[] remainingArgs = this.parseArgs(args);
            this.setVariables();
            if (this.showHelp) {
                this.usage(true, 0);
            }
            this.run(remainingArgs);
        }
        catch (OptionException oe) {
            this.handleOptionException(oe);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    protected void handleOptionException(OptionException oe) {
        try {
            this.setVariables();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.showHelp) {
            this.usage(true, 0);
        } else {
            System.err.println(oe);
            this.usage(false, 1);
        }
    }

    protected final void registerSimpleOpt(String varName, String shortOpt, String longOpt, String descr) {
        this.registerSimpleOpt(varName, shortOpt, longOpt, descr, 2);
    }

    protected final void registerSimpleOpt(String varName, String shortOpt, String longOpt, String descr, int multiplicity) {
        this.registerVar(varName, shortOpt, Boolean.FALSE);
        this.om.addOption(0, multiplicity, shortOpt, longOpt, descr);
    }

    protected final void registerSwitchOpt(String varName, String shortOpt, String longOpt, String descr, boolean defaultVal) {
        this.registerSwitchOpt(varName, shortOpt, longOpt, descr, 2, defaultVal);
    }

    protected final void registerSwitchOpt(String varName, String shortOpt, String longOpt, String descr, int multiplicity, boolean defaultVal) {
        this.registerVar(varName, shortOpt, new Boolean(defaultVal));
        this.om.addOption(1, multiplicity, shortOpt, longOpt, descr);
    }

    protected final void registerBooleanOpt(String varName, String shortOpt, String longOpt, String descr, boolean defaultVal) {
        this.registerBooleanOpt(varName, shortOpt, longOpt, descr, 2, defaultVal);
    }

    protected final void registerBooleanOpt(String varName, String shortOpt, String longOpt, String descr, int multiplicity, boolean defaultVal) {
        this.registerVar(varName, shortOpt, new Boolean(defaultVal));
        this.om.addOption(2, multiplicity, shortOpt, longOpt, descr);
    }

    protected final void registerNumberOpt(String varName, String shortOpt, String longOpt, String descr, int defaultVal) {
        this.registerNumberOpt(varName, shortOpt, longOpt, descr, 2, defaultVal);
    }

    protected final void registerNumberOpt(String varName, String shortOpt, String longOpt, String descr, int multiplicity, int defaultVal) {
        this.registerVar(varName, shortOpt, new Integer(defaultVal));
        this.om.addOption(3, multiplicity, shortOpt, longOpt, descr);
    }

    protected final void registerStringOpt(String varName, String shortOpt, String longOpt, String descr, String defaultVal) {
        this.registerStringOpt(varName, shortOpt, longOpt, descr, 2, defaultVal);
    }

    protected final void registerStringOpt(String varName, String shortOpt, String longOpt, String descr, int multiplicity, String defaultVal) {
        this.registerVar(varName, shortOpt, defaultVal);
        this.om.addOption(4, multiplicity, shortOpt, longOpt, descr);
    }

    public void usage(boolean detailed, int exitcode) {
        this.om.showUsage("java " + this.getClass().getName(), this.getArgsDescription(), detailed);
        if (exitcode > -1) {
            System.exit(exitcode);
        }
    }

    private String[] parseArgs(String[] args) throws Exception {
        return this.om.parseArgs(args);
    }

    private void setVariables() throws Exception {
        for (String s : this.vars.keySet()) {
            Field f = this.vars.get(s);
            Object val = this.om.getValue(s);
            if (val == null) continue;
            f.set(this, val);
        }
    }

    private void registerVar(String varName, String optStr, Object defVal) {
        try {
            Field var = this.getClass().getField(varName);
            var.set(this, defVal);
            this.vars.put(optStr, var);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal error: " + e);
        }
    }
}

