/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import recoder.util.Equality;
import recoder.util.HashCode;

public interface Order
extends Equality {
    public static final Order NATURAL = new Natural();
    public static final Order IDENTITY = new Identity();
    public static final Order LEXICAL = new Lexical();

    public boolean isComparable(Object var1, Object var2);

    public boolean less(Object var1, Object var2);

    public boolean greater(Object var1, Object var2);

    public boolean lessOrEquals(Object var1, Object var2);

    public boolean greaterOrEquals(Object var1, Object var2);

    public static class Lexical
    extends CustomLexicalOrder {
        @Override
        protected String toString(Object x) {
            return x.toString();
        }

        @Override
        public final boolean isComparable(Object x, Object y) {
            return x != null && y != null;
        }
    }

    public static abstract class CustomLexicalOrder
    implements Order,
    HashCode {
        protected abstract String toString(Object var1);

        @Override
        public final int hashCode(Object x) {
            return this.toString(x).hashCode();
        }

        @Override
        public boolean isComparable(Object x, Object y) {
            return true;
        }

        private int diff(Object x, Object y) {
            String s1 = this.toString(x);
            String s2 = this.toString(y);
            int len1 = s1.length();
            int len2 = s2.length();
            int m = Math.min(len1, len2);
            for (int i = 0; i < m; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }

        @Override
        public final boolean equals(Object x, Object y) {
            return this.diff(x, y) == 0;
        }

        @Override
        public final boolean less(Object x, Object y) {
            return this.diff(x, y) < 0;
        }

        @Override
        public final boolean greater(Object x, Object y) {
            return this.diff(x, y) > 0;
        }

        @Override
        public final boolean lessOrEquals(Object x, Object y) {
            return this.diff(x, y) <= 0;
        }

        @Override
        public final boolean greaterOrEquals(Object x, Object y) {
            return this.diff(x, y) >= 0;
        }
    }

    public static class Identity
    implements Order,
    HashCode {
        @Override
        public final boolean equals(Object x, Object y) {
            return x == y;
        }

        @Override
        public final int hashCode(Object x) {
            return System.identityHashCode(x);
        }

        @Override
        public final boolean isComparable(Object x, Object y) {
            return true;
        }

        @Override
        public final boolean less(Object x, Object y) {
            return System.identityHashCode(x) < System.identityHashCode(x);
        }

        @Override
        public final boolean greater(Object x, Object y) {
            return System.identityHashCode(x) > System.identityHashCode(x);
        }

        @Override
        public final boolean lessOrEquals(Object x, Object y) {
            return System.identityHashCode(x) <= System.identityHashCode(x);
        }

        @Override
        public final boolean greaterOrEquals(Object x, Object y) {
            return System.identityHashCode(x) >= System.identityHashCode(x);
        }
    }

    public static class Natural
    implements Order,
    HashCode {
        @Override
        public final boolean equals(Object x, Object y) {
            return x.equals(y);
        }

        @Override
        public final int hashCode(Object x) {
            return x.hashCode();
        }

        @Override
        public final boolean isComparable(Object x, Object y) {
            return x != null && y != null;
        }

        @Override
        public final boolean less(Object x, Object y) {
            return x.hashCode() < y.hashCode();
        }

        @Override
        public final boolean greater(Object x, Object y) {
            return x.hashCode() > y.hashCode();
        }

        @Override
        public final boolean lessOrEquals(Object x, Object y) {
            return x.hashCode() <= y.hashCode();
        }

        @Override
        public final boolean greaterOrEquals(Object x, Object y) {
            return x.hashCode() >= y.hashCode();
        }
    }
}

