/*
 * Decompiled with CFR 0.152.
 */
package recoder.util;

import recoder.util.Order;

public class Sorting {
    public static void heapSort(Object[] a) {
        Sorting.heapSort(a, Order.NATURAL);
    }

    public static void heapSort(Object[] a, Order ord) {
        int m;
        block0: for (m = (a.length - 1) / 2; m >= 0; --m) {
            int j;
            int i = m;
            while ((j = 2 * i + 1) < a.length) {
                int k = j + 1;
                if (ord.greater(a[i], a[j])) {
                    j = i;
                }
                if (k < a.length && ord.greater(a[k], a[j])) {
                    j = k;
                }
                if (i == j) continue block0;
                Object swap = a[i];
                a[i] = a[j];
                a[j] = swap;
                i = j;
            }
        }
        block2: for (m = a.length - 1; m >= 1; --m) {
            int j;
            Object swap = a[0];
            a[0] = a[m];
            a[m] = swap;
            int i = 0;
            while ((j = 2 * i + 1) < m) {
                int k = j + 1;
                if (ord.greater(a[i], a[j])) {
                    j = i;
                }
                if (k < m && ord.greater(a[k], a[j])) {
                    j = k;
                }
                if (i == j) continue block2;
                swap = a[i];
                a[i] = a[j];
                a[j] = swap;
                i = j;
            }
        }
    }

    public static void insertionSort(Object[] a) {
        Sorting.insertionSort(a, Order.NATURAL);
    }

    public static void insertionSort(Object[] a, Order ord) {
        for (int i = 1; i < a.length; ++i) {
            Object x = a[i];
            for (int j = i - 1; j >= 0 && ord.greater(a[j], x); --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = x;
        }
    }

    protected static void insertionSort(Object[] a, int le, int ri, Order ord) {
        for (int i = le + 1; i <= ri; ++i) {
            Object x = a[i];
            for (int j = i - 1; j >= le && ord.greater(a[j], x); --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = x;
        }
    }

    protected static final Object median(Object x, Object y, Object z, Order o) {
        return o.less(x, y) ? (o.less(y, z) ? y : (o.less(x, z) ? z : x)) : (o.less(y, z) ? y : (o.less(z, x) ? z : x));
    }

    public static void quickSort(Object[] a) {
        Sorting.quickSort(a, 0, a.length - 1, Order.NATURAL);
    }

    public static void quickSort(Object[] a, Order ord) {
        Sorting.quickSort(a, 0, a.length - 1, ord);
    }

    protected static void quickSort(Object[] a, int le, int ri, Order ord) {
        if (ri > le) {
            int i = le;
            int j = ri;
            Object x = Sorting.median(a[le], a[ri], a[(le + ri) / 2], ord);
            while (true) {
                if (ord.less(a[i], x)) {
                    ++i;
                    continue;
                }
                while (ord.less(x, a[j])) {
                    --j;
                }
                if (i <= j) {
                    Object h = a[i];
                    a[i] = a[j];
                    a[j] = h;
                    ++i;
                    --j;
                }
                if (i > j) break;
            }
            if (j < le + 16) {
                Sorting.insertionSort(a, le, j, ord);
            } else {
                Sorting.quickSort(a, le, j, ord);
            }
            if (ri < i + 16) {
                Sorting.insertionSort(a, i, ri, ord);
            } else {
                Sorting.quickSort(a, i, ri, ord);
            }
        }
    }

    public static boolean isOrdered(Object[] a) {
        return Sorting.isOrdered(a, Order.NATURAL);
    }

    public static boolean isOrdered(Object[] a, Order ord) {
        for (int i = a.length - 1; i > 0; --i) {
            if (!ord.greater(a[i - 1], a[i])) continue;
            return false;
        }
        return true;
    }
}

