/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.rule.label;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.FormulaTermLabel;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.label.TermLabelState;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.label.TermLabelRefactoring;
import de.uka.ilkd.key.symbolic_execution.TruthValueTracingUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;

public class FormulaTermLabelRefactoring
implements TermLabelRefactoring {
    private static final String INNER_MOST_PARENT_REFACTORED_PREFIX = "innerMostParentRefactoredAtGoal_";
    private static final String UPDATE_REFACTORING_REQUIRED = "updateRefactroingRequired";
    private static final String PARENT_REFACTORING_REQUIRED = "parentRefactoringRequired";
    private static final String SEQUENT_FORMULA_REFACTORING_REQUIRED = "sequentFormulaRefactoringRequired";

    public ImmutableList<Name> getSupportedRuleNames() {
        return null;
    }

    public TermLabelRefactoring.RefactoringScope defineRefactoringScope(TermLabelState state, Services services, PosInOccurrence applicationPosInOccurrence, Term applicationTerm, Rule rule, Goal goal, Object hint, Term tacletTerm) {
        if (this.shouldRefactorSpecificationApplication(rule, goal, hint)) {
            return TermLabelRefactoring.RefactoringScope.APPLICATION_CHILDREN_AND_GRANDCHILDREN_SUBTREE;
        }
        if (FormulaTermLabelRefactoring.isParentRefactroingRequired(state)) {
            return TermLabelRefactoring.RefactoringScope.APPLICATION_CHILDREN_AND_GRANDCHILDREN_SUBTREE_AND_PARENTS;
        }
        if (FormulaTermLabelRefactoring.isUpdateRefactroingRequired(state)) {
            return TermLabelRefactoring.RefactoringScope.APPLICATION_BELOW_UPDATES;
        }
        if (FormulaTermLabelRefactoring.containsSequentFormulasToRefactor(state)) {
            return TermLabelRefactoring.RefactoringScope.SEQUENT;
        }
        if ("SUBSTITUTION_WITH_LABELS".equals(hint)) {
            return TermLabelRefactoring.RefactoringScope.APPLICATION_BELOW_UPDATES;
        }
        return TermLabelRefactoring.RefactoringScope.NONE;
    }

    protected boolean shouldRefactorSpecificationApplication(Rule rule, Goal goal, Object hint) {
        return TermLabelRefactoring.shouldRefactorOnBuiltInRule((Rule)rule, (Goal)goal, (Object)hint);
    }

    public void refactorLabels(TermLabelState state, Services services, PosInOccurrence applicationPosInOccurrence, Term applicationTerm, Rule rule, Goal goal, Object hint, Term tacletTerm, Term term, List<TermLabel> labels) {
        if (this.shouldRefactorSpecificationApplication(rule, goal, hint)) {
            this.refactorSpecificationApplication(term, goal, services, labels, hint);
        } else if (FormulaTermLabelRefactoring.isParentRefactroingRequired(state)) {
            this.refactorInCaseOfNewIdRequired(state, goal, term, services, labels);
        } else if (FormulaTermLabelRefactoring.isUpdateRefactroingRequired(state)) {
            this.refactorBewlowUpdates(applicationPosInOccurrence, term, labels);
        } else if (FormulaTermLabelRefactoring.containsSequentFormulasToRefactor(state)) {
            this.refactorSequentFormulas(state, services, term, labels);
        } else if ("SUBSTITUTION_WITH_LABELS".equals(hint)) {
            this.refactorSubstitution(term, tacletTerm, labels);
        }
    }

    protected void refactorSpecificationApplication(Term term, Goal goal, Services services, List<TermLabel> labels, Object hint) {
        TermLabel existingLabel;
        if ((TruthValueTracingUtil.isPredicate(term) || "finalWeakeningTerm".equals(hint) && TruthValueTracingUtil.isLogicOperator(term)) && (existingLabel = term.getLabel(FormulaTermLabel.NAME)) == null) {
            int labelID = services.getCounter("F_LABEL_COUNTER").getCountPlusPlus();
            int labelSubID = FormulaTermLabel.newLabelSubID((Services)services, (int)labelID);
            labels.add((TermLabel)new FormulaTermLabel(labelID, labelSubID));
        }
    }

    protected void refactorInCaseOfNewIdRequired(TermLabelState state, Goal goal, Term term, Services services, List<TermLabel> labels) {
        TermLabel existingLabel;
        if (goal != null && !FormulaTermLabelRefactoring.isInnerMostParentRefactored(state, goal) && (existingLabel = term.getLabel(FormulaTermLabel.NAME)) instanceof FormulaTermLabel) {
            FormulaTermLabel pLabel = (FormulaTermLabel)existingLabel;
            int labelID = pLabel.getMajorId();
            int labelSubID = FormulaTermLabel.newLabelSubID((Services)services, (int)labelID);
            labels.remove(existingLabel);
            labels.add((TermLabel)new FormulaTermLabel(labelID, labelSubID, Collections.singletonList(pLabel.getId())));
            FormulaTermLabelRefactoring.setInnerMostParentRefactored(state, goal, true);
        }
    }

    protected void refactorBewlowUpdates(PosInOccurrence applicationPosInOccurrence, Term term, List<TermLabel> labels) {
        FormulaTermLabel applicationLabel;
        Term applicationTerm = applicationPosInOccurrence != null ? applicationPosInOccurrence.subTerm() : null;
        FormulaTermLabel formulaTermLabel = applicationLabel = applicationTerm != null ? (FormulaTermLabel)applicationTerm.getLabel(FormulaTermLabel.NAME) : null;
        if (applicationLabel != null) {
            FormulaTermLabel termLabel = (FormulaTermLabel)term.getLabel(FormulaTermLabel.NAME);
            if (termLabel == null) {
                labels.add((TermLabel)applicationLabel);
            } else {
                labels.remove(termLabel);
                LinkedHashSet<String> beforeIds = new LinkedHashSet<String>();
                CollectionUtil.addAll(beforeIds, (Object[])termLabel.getBeforeIds());
                beforeIds.add(applicationLabel.getId());
                labels.add((TermLabel)new FormulaTermLabel(termLabel.getMajorId(), termLabel.getMinorId(), beforeIds));
            }
        }
    }

    protected void refactorSequentFormulas(TermLabelState state, Services services, final Term term, List<TermLabel> labels) {
        FormulaTermLabel termLabel;
        Set<SequentFormula> sequentFormulas = FormulaTermLabelRefactoring.getSequentFormulasToRefactor(state);
        if (CollectionUtil.search(sequentFormulas, (IFilter)new IFilter<SequentFormula>(){

            public boolean select(SequentFormula element) {
                return element.formula() == term;
            }
        }) != null && (termLabel = (FormulaTermLabel)term.getLabel(FormulaTermLabel.NAME)) != null) {
            labels.remove(termLabel);
            LinkedHashSet<String> beforeIds = new LinkedHashSet<String>();
            beforeIds.add(termLabel.getId());
            int labelSubID = FormulaTermLabel.newLabelSubID((Services)services, (FormulaTermLabel)termLabel);
            labels.add((TermLabel)new FormulaTermLabel(termLabel.getMajorId(), labelSubID, beforeIds));
        }
    }

    protected void refactorSubstitution(Term term, Term tacletTerm, List<TermLabel> labels) {
        FormulaTermLabel tacletLabel = (FormulaTermLabel)tacletTerm.getLabel(FormulaTermLabel.NAME);
        if (tacletLabel != null) {
            FormulaTermLabel existingLabel = (FormulaTermLabel)term.getLabel(FormulaTermLabel.NAME);
            if (existingLabel == null) {
                labels.add((TermLabel)tacletLabel);
            } else {
                LinkedList<String> beforeIds = new LinkedList<String>();
                CollectionUtil.addAll(beforeIds, (Object[])existingLabel.getBeforeIds());
                boolean changed = true;
                if (!beforeIds.contains(tacletLabel.getId())) {
                    changed = true;
                    beforeIds.add(tacletLabel.getId());
                }
                for (String id : tacletLabel.getBeforeIds()) {
                    if (beforeIds.contains(id)) continue;
                    changed = true;
                    beforeIds.add(id);
                }
                if (changed) {
                    labels.remove(existingLabel);
                    labels.add((TermLabel)new FormulaTermLabel(existingLabel.getMajorId(), existingLabel.getMinorId(), beforeIds));
                }
            }
        }
    }

    public static boolean isInnerMostParentRefactored(TermLabelState state, Goal goal) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        return labelState.containsKey(INNER_MOST_PARENT_REFACTORED_PREFIX + goal.node().serialNr());
    }

    public static void setInnerMostParentRefactored(TermLabelState state, Goal goal, boolean refactored) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        labelState.put(INNER_MOST_PARENT_REFACTORED_PREFIX + goal.node().serialNr(), refactored);
    }

    public static boolean isUpdateRefactroingRequired(TermLabelState state) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        Object value = labelState.get(UPDATE_REFACTORING_REQUIRED);
        return value instanceof Boolean && (Boolean)value != false;
    }

    public static void setUpdateRefactroingRequired(TermLabelState state, boolean required) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        labelState.put(UPDATE_REFACTORING_REQUIRED, required);
    }

    public static boolean isParentRefactroingRequired(TermLabelState state) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        Object value = labelState.get(PARENT_REFACTORING_REQUIRED);
        return value instanceof Boolean && (Boolean)value != false;
    }

    public static void setParentRefactroingRequired(TermLabelState state, boolean required) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        labelState.put(PARENT_REFACTORING_REQUIRED, required);
    }

    public static boolean containsSequentFormulasToRefactor(TermLabelState state) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        Set sfSet = (Set)labelState.get(SEQUENT_FORMULA_REFACTORING_REQUIRED);
        return !CollectionUtil.isEmpty((Collection)sfSet);
    }

    public static Set<SequentFormula> getSequentFormulasToRefactor(TermLabelState state) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        Set sfSet = (Set)labelState.get(SEQUENT_FORMULA_REFACTORING_REQUIRED);
        return sfSet;
    }

    public static void addSequentFormulaToRefactor(TermLabelState state, SequentFormula sf) {
        Map labelState = state.getLabelState(FormulaTermLabel.NAME);
        LinkedHashSet<SequentFormula> sfSet = (LinkedHashSet<SequentFormula>)labelState.get(SEQUENT_FORMULA_REFACTORING_REQUIRED);
        if (sfSet == null) {
            sfSet = new LinkedHashSet<SequentFormula>();
            labelState.put(SEQUENT_FORMULA_REFACTORING_REQUIRED, sfSet);
        }
        sfSet.add(sf);
    }
}

