/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.logic.op.ElementaryUpdate;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.op.UpdateJunctor;
import de.uka.ilkd.key.logic.op.UpdateableOperator;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.ObjectUtil;

public abstract class AbstractUpdateExtractor {
    protected final Node node;
    protected final PosInOccurrence modalityPio;
    private int preVariableIndex = 0;

    public AbstractUpdateExtractor(Node node, PosInOccurrence modalityPio) {
        assert (node != null);
        assert (modalityPio != null);
        this.node = node;
        this.modalityPio = modalityPio;
    }

    protected Term removeImplicitSubTermsFromPathCondition(Term pathCondition) {
        if (Junctor.AND == pathCondition.op()) {
            LinkedList<Term> newTerms = new LinkedList<Term>();
            for (Term sub : pathCondition.subs()) {
                if (this.containsImplicitProgramVariable(sub)) continue;
                newTerms.add(sub);
            }
            return this.getServices().getTermBuilder().and(newTerms);
        }
        if (!this.containsImplicitProgramVariable(pathCondition)) {
            return pathCondition;
        }
        return this.getServices().getTermBuilder().tt();
    }

    protected boolean containsImplicitProgramVariable(Term term) {
        if (term.op() instanceof ProgramVariable && this.isImplicitProgramVariable((ProgramVariable)term.op())) {
            return true;
        }
        for (int i = 0; i < term.arity(); ++i) {
            if (!this.containsImplicitProgramVariable(term.sub(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isImplicitProgramVariable(ProgramVariable var) {
        return var != null && var.isImplicit();
    }

    protected Set<Term> computeInitialObjectsToIgnore(boolean ignoreExceptionVariable, boolean ignoreOldStateVariables) {
        IProgramVariable excVar;
        LinkedHashSet<Term> result = new LinkedHashSet<Term>();
        if (ignoreExceptionVariable && (excVar = SymbolicExecutionUtil.extractExceptionVariable(this.getProof())) instanceof ProgramVariable) {
            result.add(this.getServices().getTermBuilder().var((ProgramVariable)excVar));
        }
        if (ignoreOldStateVariables) {
            Sequent sequent = this.getRoot().sequent();
            for (SequentFormula sf : sequent.succedent()) {
                Term term = sf.formula();
                if (!Junctor.IMP.equals(term.op())) continue;
                this.fillInitialObjectsToIgnoreRecursively(term.sub(1), result);
            }
        }
        return result;
    }

    protected void fillInitialObjectsToIgnoreRecursively(Term term, Set<Term> toFill) {
        ElementaryUpdate eu;
        if (term.op() instanceof UpdateApplication) {
            Term updateTerm = UpdateApplication.getUpdate((Term)term);
            this.fillInitialObjectsToIgnoreRecursively(updateTerm, toFill);
        } else if (term.op() == UpdateJunctor.PARALLEL_UPDATE) {
            for (int i = 0; i < term.arity(); ++i) {
                this.fillInitialObjectsToIgnoreRecursively(term.sub(i), toFill);
            }
        } else if (term.op() instanceof ElementaryUpdate && (eu = (ElementaryUpdate)term.op()).lhs() instanceof ProgramVariable) {
            toFill.add(term.sub(0));
        }
    }

    protected void collectLocationsFromUpdates(Sequent sequent, Set<ExtractLocationParameter> locationsToFill, Set<Term> updateCreatedObjectsToFill, Set<Term> updateValueObjectsToFill, Set<Term> objectsToIgnore) throws ProofInputException {
        PosInOccurrence pio = this.modalityPio;
        while (pio != null) {
            Term updateApplication = pio.subTerm();
            if (updateApplication.op() == UpdateApplication.UPDATE_APPLICATION) {
                Term topUpdate = UpdateApplication.getUpdate((Term)updateApplication);
                this.collectLocationsFromTerm(topUpdate, locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill, objectsToIgnore);
            }
            if (!pio.isTopLevel()) {
                pio = pio.up();
                continue;
            }
            pio = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void collectLocationsFromTerm(Term updateTerm, Set<ExtractLocationParameter> locationsToFill, Set<Term> updateCreatedObjectsToFill, Set<Term> updateValueObjectsToFill, Set<Term> objectsToIgnore) throws ProofInputException {
        if (updateTerm.op() instanceof UpdateJunctor) {
            for (Term sub : updateTerm.subs()) {
                this.collectLocationsFromTerm(sub, locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill, objectsToIgnore);
            }
            return;
        } else {
            if (!(updateTerm.op() instanceof ElementaryUpdate)) throw new ProofInputException("Unsupported update operator \"" + updateTerm.op() + "\".");
            ElementaryUpdate eu = (ElementaryUpdate)updateTerm.op();
            if (SymbolicExecutionUtil.isHeapUpdate(this.getServices(), updateTerm)) {
                this.collectLocationsFromHeapUpdate(updateTerm.sub(0), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
                return;
            } else {
                if (!(eu.lhs() instanceof ProgramVariable)) throw new ProofInputException("Unsupported update operator \"" + eu.lhs() + "\".");
                HeapLDT heapLDT = this.getServices().getTypeConverter().getHeapLDT();
                ProgramVariable var = (ProgramVariable)eu.lhs();
                if (SymbolicExecutionUtil.isHeap((Operator)var, heapLDT)) return;
                if (!(this.isImplicitProgramVariable(var) || objectsToIgnore.contains(this.getServices().getTermBuilder().var(var)) || this.hasFreeVariables(updateTerm))) {
                    locationsToFill.add(new ExtractLocationParameter(var, true));
                }
                if (!SymbolicExecutionUtil.hasReferenceSort(this.getServices(), updateTerm.sub(0))) return;
                Term objectTerm = updateTerm.sub(0);
                objectTerm = SymbolicExecutionUtil.replaceSkolemConstants(this.node.sequent(), objectTerm, this.getServices());
                updateValueObjectsToFill.add(OriginTermLabel.removeOriginLabels((Term)objectTerm, (Services)this.getServices()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void collectLocationsFromHeapUpdate(Term term, Set<ExtractLocationParameter> locationsToFill, Set<Term> updateCreatedObjectsToFill, Set<Term> updateValueObjectsToFill) throws ProofInputException {
        HeapLDT heapLDT;
        block18: {
            Term arrayIndex;
            block21: {
                Term selectArgument;
                block19: {
                    block20: {
                        heapLDT = this.getServices().getTypeConverter().getHeapLDT();
                        if (term.op() != heapLDT.getStore()) break block18;
                        selectArgument = term.sub(1);
                        if (heapLDT.getSortOfSelect(selectArgument.op()) == null) break block19;
                        ProgramVariable var = SymbolicExecutionUtil.getProgramVariable(this.getServices(), heapLDT, selectArgument.sub(2));
                        if (var == null) break block20;
                        if (!this.isImplicitProgramVariable(var) && !this.hasFreeVariables(selectArgument.sub(2))) {
                            locationsToFill.add(new ExtractLocationParameter(var, selectArgument.sub(1)));
                        }
                        break block21;
                    }
                    arrayIndex = SymbolicExecutionUtil.getArrayIndex(this.getServices(), heapLDT, selectArgument.sub(2));
                    if (arrayIndex == null) throw new ProofInputException("Unsupported select statement \"" + term + "\".");
                    if (this.hasFreeVariables(arrayIndex)) break block21;
                    locationsToFill.add(new ExtractLocationParameter(arrayIndex, selectArgument.sub(1)));
                    break block21;
                }
                if (selectArgument.op() instanceof IProgramVariable) {
                    ProgramVariable var = (ProgramVariable)selectArgument.op();
                    if (!this.isImplicitProgramVariable(var) && !this.hasFreeVariables(selectArgument)) {
                        locationsToFill.add(new ExtractLocationParameter(var, false));
                    }
                } else if (heapLDT.getNull() != selectArgument.op()) {
                    for (int i = 0; i < selectArgument.arity(); ++i) {
                        this.collectLocationsFromHeapUpdate(selectArgument.sub(i), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
                    }
                }
            }
            ProgramVariable var = SymbolicExecutionUtil.getProgramVariable(this.getServices(), heapLDT, term.sub(2));
            if (var != null) {
                if (!this.isImplicitProgramVariable(var) && !this.hasFreeVariables(term.sub(2))) {
                    if (var.isStatic()) {
                        locationsToFill.add(new ExtractLocationParameter(var, true));
                    } else {
                        locationsToFill.add(new ExtractLocationParameter(var, term.sub(1)));
                    }
                }
            } else {
                arrayIndex = SymbolicExecutionUtil.getArrayIndex(this.getServices(), heapLDT, term.sub(2));
                if (arrayIndex == null || this.hasFreeVariables(arrayIndex)) throw new ProofInputException("Unsupported select statement \"" + term + "\".");
                locationsToFill.add(new ExtractLocationParameter(arrayIndex, term.sub(1)));
            }
            if (SymbolicExecutionUtil.hasReferenceSort(this.getServices(), term.sub(3)) && term.sub(3).op() instanceof ProgramVariable) {
                Term objectTerm = term.sub(3);
                objectTerm = SymbolicExecutionUtil.replaceSkolemConstants(this.node.sequent(), objectTerm, this.getServices());
                updateValueObjectsToFill.add(OriginTermLabel.removeOriginLabels((Term)objectTerm, (Services)this.getServices()));
            }
            this.collectLocationsFromHeapUpdate(term.sub(0), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
            return;
        }
        if (term.op() == heapLDT.getCreate()) {
            Term newObject = term.sub(1);
            newObject = SymbolicExecutionUtil.replaceSkolemConstants(this.node.sequent(), newObject, this.getServices());
            updateCreatedObjectsToFill.add(OriginTermLabel.removeOriginLabels((Term)newObject, (Services)this.getServices()));
            this.collectLocationsFromHeapUpdate(term.sub(0), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
            return;
        } else {
            if (term.op() == heapLDT.getHeap()) return;
            if (term.op() == heapLDT.getMemset()) {
                Term arrayRange = term.sub(1);
                if (arrayRange.op() == this.getServices().getTypeConverter().getLocSetLDT().getArrayRange()) {
                    Term array = arrayRange.sub(0);
                    Term startIndex = arrayRange.sub(1);
                    Term endIndex = arrayRange.sub(2);
                    locationsToFill.add(new ExtractLocationParameter(startIndex, endIndex, array));
                }
                this.collectLocationsFromHeapUpdate(term.sub(0), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
                return;
            } else {
                for (int i = 0; i < term.arity(); ++i) {
                    this.collectLocationsFromHeapUpdate(term.sub(i), locationsToFill, updateCreatedObjectsToFill, updateValueObjectsToFill);
                }
            }
        }
    }

    protected boolean hasFreeVariables(Term term) {
        return term != null && !term.freeVars().isEmpty();
    }

    protected Set<ExtractLocationParameter> extractLocationsFromSequent(Sequent sequent, Set<Term> objectsToIgnore) throws ProofInputException {
        LinkedHashSet<ExtractLocationParameter> result = new LinkedHashSet<ExtractLocationParameter>();
        for (SequentFormula sf : sequent) {
            result.addAll(this.extractLocationsFromTerm(OriginTermLabel.removeOriginLabels((Term)sf.formula(), (Services)this.getServices()), objectsToIgnore));
        }
        return result;
    }

    protected Set<ExtractLocationParameter> extractLocationsFromTerm(Term term, Set<Term> objectsToIgnore) throws ProofInputException {
        LinkedHashSet<ExtractLocationParameter> result = new LinkedHashSet<ExtractLocationParameter>();
        this.collectLocationsFromTerm(result, term, objectsToIgnore);
        return result;
    }

    protected void collectLocationsFromTerm(Set<ExtractLocationParameter> toFill, Term term, Set<Term> objectsToIgnore) throws ProofInputException {
        term = OriginTermLabel.removeOriginLabels((Term)term, (Services)this.getServices());
        HeapLDT heapLDT = this.getServices().getTypeConverter().getHeapLDT();
        if (term.op() instanceof ProgramVariable) {
            ProgramVariable var = (ProgramVariable)term.op();
            if (!(SymbolicExecutionUtil.isHeap((Operator)var, heapLDT) || this.isImplicitProgramVariable(var) || objectsToIgnore.contains(term) || this.hasFreeVariables(term))) {
                toFill.add(new ExtractLocationParameter(var, true));
            }
        } else {
            Sort sort = heapLDT.getSortOfSelect(term.op());
            if (sort != null) {
                this.collectLocationsFromHeapTerms(term.sub(1), term.sub(2), heapLDT, toFill, objectsToIgnore);
            } else if (heapLDT.getStore() == term.op()) {
                this.collectLocationsFromHeapTerms(term.sub(1), term.sub(2), heapLDT, toFill, objectsToIgnore);
            } else if (heapLDT.getLength() == term.op()) {
                if (!objectsToIgnore.contains(term.sub(0)) && !this.hasFreeVariables(term)) {
                    ProgramVariable var = this.getServices().getJavaInfo().getArrayLength();
                    toFill.add(new ExtractLocationParameter(var, term.sub(0)));
                }
            } else {
                for (Term sub : term.subs()) {
                    this.collectLocationsFromTerm(toFill, sub, objectsToIgnore);
                }
            }
        }
    }

    protected void collectLocationsFromHeapTerms(Term selectTerm, Term variableTerm, HeapLDT heapLDT, Set<ExtractLocationParameter> toFill, Set<Term> objectsToIgnore) throws ProofInputException {
        if (!objectsToIgnore.contains(selectTerm) && !SymbolicExecutionUtil.isSkolemConstant(selectTerm)) {
            ProgramVariable var = SymbolicExecutionUtil.getProgramVariable(this.getServices(), heapLDT, variableTerm);
            if (var != null) {
                if (!this.isImplicitProgramVariable(var) && !this.hasFreeVariables(variableTerm)) {
                    if (var.isStatic()) {
                        toFill.add(new ExtractLocationParameter(var, true));
                    } else {
                        if (selectTerm.op() instanceof ProgramVariable) {
                            toFill.add(new ExtractLocationParameter((ProgramVariable)selectTerm.op(), true));
                        }
                        toFill.add(new ExtractLocationParameter(var, selectTerm));
                    }
                }
            } else {
                Term arrayIndex = SymbolicExecutionUtil.getArrayIndex(this.getServices(), heapLDT, variableTerm);
                if (arrayIndex != null && !this.hasFreeVariables(arrayIndex)) {
                    if (selectTerm.op() instanceof ProgramVariable) {
                        toFill.add(new ExtractLocationParameter((ProgramVariable)selectTerm.op(), true));
                    }
                    toFill.add(new ExtractLocationParameter(arrayIndex, selectTerm));
                }
            }
        }
    }

    protected Term createLocationPredicateAndTerm(Set<ExtractLocationParameter> valueSelectParameter) {
        LinkedList<Term> argumentsList = new LinkedList<Term>();
        int argumentIndex = -1;
        for (ExtractLocationParameter param : valueSelectParameter) {
            argumentsList.add(param.createPreParentTerm());
            param.setParentTermIndexInStatePredicate(++argumentIndex);
            argumentsList.add(param.createPreValueTerm());
            param.setValueTermIndexInStatePredicate(++argumentIndex);
        }
        Term[] arguments = argumentsList.toArray(new Term[argumentsList.size()]);
        Sort[] sorts = new Sort[arguments.length];
        for (int i = 0; i < sorts.length; ++i) {
            sorts[i] = arguments[i].sort();
        }
        Function newPredicate = new Function(new Name(this.getServices().getTermBuilder().newName("LayoutPredicate")), Sort.FORMULA, sorts);
        Term newTerm = this.getServices().getTermBuilder().func(newPredicate, arguments);
        return newTerm;
    }

    protected Proof getProof() {
        return this.node.proof();
    }

    protected Node getRoot() {
        return this.getProof().root();
    }

    protected Services getServices() {
        return this.getProof().getServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ExecutionVariableValuePair> computeVariableValuePairs(Term layoutCondition, Term layoutTerm, Set<ExtractLocationParameter> locations, boolean currentLayout, boolean simplifyConditions) throws ProofInputException {
        ImmutableList<Term> originalUpdates = this.computeOriginalUpdates(this.modalityPio, currentLayout);
        HashMap<LocationVariable, Term> preUpdateMap = new HashMap<LocationVariable, Term>();
        ImmutableSLList additionalUpdates = ImmutableSLList.nil();
        for (ExtractLocationParameter evp : locations) {
            additionalUpdates = additionalUpdates.append((Object)evp.createPreUpdate());
            preUpdateMap.put(evp.getPreVariable(), evp.getPreUpdateTarget());
        }
        TermBuilder tb = this.getServices().getTermBuilder();
        Term updateLayoutTerm = tb.applyParallel(originalUpdates, layoutTerm);
        updateLayoutTerm = tb.applyParallel((ImmutableList)additionalUpdates, updateLayoutTerm);
        for (Term additionalUpdate : this.collectAdditionalUpdates()) {
            updateLayoutTerm = tb.apply(additionalUpdate, updateLayoutTerm);
        }
        ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(this.getProof(), true);
        Sequent sequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(this.node, this.modalityPio, layoutCondition, updateLayoutTerm, null, false);
        ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(this.getProof(), sideProofEnv, sequent, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_NORMAL");
        try {
            if (!info.getProof().closed()) {
                Map[] paramValueMap = new Map[locations.size()];
                for (Goal goal : info.getProof().openGoals()) {
                    Term resultTerm = SymbolicExecutionSideProofUtil.extractOperatorTerm(goal, layoutTerm.op());
                    int i = 0;
                    for (ExtractLocationParameter param : locations) {
                        Term originalTarget;
                        Term object;
                        LinkedHashMap<Term, LinkedHashSet<Goal>> valueMap = paramValueMap[i];
                        if (valueMap == null) {
                            paramValueMap[i] = valueMap = new LinkedHashMap<Term, LinkedHashSet<Goal>>();
                        }
                        Term value = resultTerm.sub(param.getValueTermIndexInStatePredicate());
                        value = SymbolicExecutionUtil.replaceSkolemConstants(goal.sequent(), value, this.getServices());
                        if (value.op() instanceof LocationVariable) {
                            Term originalTarget2 = (Term)preUpdateMap.get(value.op());
                            if (originalTarget2 != null) {
                                value = originalTarget2;
                            }
                        } else if (SymbolicExecutionUtil.isSelect(goal.proof().getServices(), value) && (object = value.sub(1)).op() instanceof LocationVariable && (originalTarget = (Term)preUpdateMap.get(object.op())) != null) {
                            value = goal.proof().getServices().getTermBuilder().select(value.sort(), value.sub(0), originalTarget, value.sub(2));
                        }
                        LinkedHashSet<Goal> valueList = (LinkedHashSet<Goal>)valueMap.get(value);
                        if (valueList == null) {
                            valueList = new LinkedHashSet<Goal>();
                            valueMap.put(value, valueList);
                        }
                        valueList.add(goal);
                        ++i;
                    }
                }
                HashMap<Node, Term> branchConditionCache = new HashMap<Node, Term>();
                LinkedHashSet<ExecutionVariableValuePair> pairs = new LinkedHashSet<ExecutionVariableValuePair>();
                int i = 0;
                for (ExtractLocationParameter param : locations) {
                    for (Map.Entry valueEntry : paramValueMap[i].entrySet()) {
                        ExecutionVariableValuePair pair;
                        Map<Goal, Term> conditionsMap = this.computeValueConditions((Set)valueEntry.getValue(), branchConditionCache, simplifyConditions);
                        if (param.isArrayRange()) {
                            for (Goal goal : (Set)valueEntry.getValue()) {
                                if (valueEntry.getKey() == param.getNotAValue()) continue;
                                pair = new ExecutionVariableValuePair(OriginTermLabel.removeOriginLabels((Term)param.getArrayStartIndex(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)param.getArrayEndIndex(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)param.getArrayRangeConstant(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)param.getParentTerm(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)((Term)valueEntry.getKey()), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)conditionsMap.get(goal), (Services)this.getServices()), param.isStateMember(), goal.node());
                                pairs.add(pair);
                            }
                            continue;
                        }
                        if (param.isArrayIndex()) {
                            for (Goal goal : (Set)valueEntry.getValue()) {
                                pair = new ExecutionVariableValuePair(OriginTermLabel.removeOriginLabels((Term)param.getArrayIndex(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)param.getParentTerm(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)((Term)valueEntry.getKey()), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)conditionsMap.get(goal), (Services)this.getServices()), param.isStateMember(), goal.node());
                                pairs.add(pair);
                            }
                            continue;
                        }
                        for (Goal goal : (Set)valueEntry.getValue()) {
                            pair = new ExecutionVariableValuePair(param.getProgramVariable(), OriginTermLabel.removeOriginLabels((Term)param.getParentTerm(), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)((Term)valueEntry.getKey()), (Services)this.getServices()), OriginTermLabel.removeOriginLabels((Term)conditionsMap.get(goal), (Services)this.getServices()), param.isStateMember(), goal.node());
                            pairs.add(pair);
                        }
                    }
                    ++i;
                }
                LinkedHashSet<ExecutionVariableValuePair> linkedHashSet = pairs;
                return linkedHashSet;
            }
            Set<ExecutionVariableValuePair> set = null;
            return set;
        }
        finally {
            SymbolicExecutionSideProofUtil.disposeOrStore("Layout computation on node " + this.node.serialNr() + " with layout term " + ProofSaver.printAnything((Object)layoutTerm, (Services)this.getServices()) + ".", info);
        }
    }

    protected List<Term> collectAdditionalUpdates() {
        return Collections.emptyList();
    }

    protected ImmutableList<Term> computeOriginalUpdates(PosInOccurrence pio, boolean currentLayout) {
        ImmutableList originalUpdates;
        if (!currentLayout) {
            originalUpdates = ImmutableSLList.nil();
        } else if (this.node.proof().root() == this.node) {
            originalUpdates = SymbolicExecutionUtil.computeRootElementaryUpdates(this.node);
        } else {
            Term originalModifiedFormula = pio.subTerm();
            originalUpdates = (ImmutableList)TermBuilder.goBelowUpdates2((Term)originalModifiedFormula).first;
        }
        return originalUpdates;
    }

    protected Map<Goal, Term> computeValueConditions(Set<Goal> valueGoals, Map<Node, Term> branchConditionCache, boolean simplifyConditions) throws ProofInputException {
        Comparator<NodeGoal> comparator = new Comparator<NodeGoal>(){

            @Override
            public int compare(NodeGoal o1, NodeGoal o2) {
                return o2.getSerialNr() - o1.getSerialNr();
            }
        };
        HashSet<Node> untriedRealGoals = new HashSet<Node>();
        HashMap goalConditions = new HashMap();
        LinkedList<NodeGoal> sortedBranchLeafs = new LinkedList<NodeGoal>();
        for (Goal goal : valueGoals) {
            CollectionUtil.binaryInsert(sortedBranchLeafs, (Object)new NodeGoal(goal), (Comparator)comparator);
            goalConditions.put(goal, new LinkedHashSet());
            untriedRealGoals.add(goal.node());
        }
        LinkedList<NodeGoal> waitingBranchLeafs = new LinkedList<NodeGoal>();
        HashMap<Node, LinkedList<NodeGoal>> splitMap = new HashMap<Node, LinkedList<NodeGoal>>();
        while (!sortedBranchLeafs.isEmpty()) {
            NodeGoal maximumOuterLeaf;
            NodeGoal childGoal = this.iterateBackOnParents(maximumOuterLeaf, !untriedRealGoals.remove((maximumOuterLeaf = (NodeGoal)sortedBranchLeafs.remove(0)).getCurrentNode()));
            if (childGoal == null) continue;
            waitingBranchLeafs.add(childGoal);
            LinkedList<NodeGoal> childGoals = (LinkedList<NodeGoal>)splitMap.get(childGoal.getParent());
            if (childGoals == null) {
                childGoals = new LinkedList<NodeGoal>();
                splitMap.put(childGoal.getParent(), childGoals);
            }
            childGoals.add(childGoal);
            if (!this.isParentReachedOnAllChildGoals(childGoal.getParent(), sortedBranchLeafs)) continue;
            if (childGoals.size() != childGoal.getParent().childrenCount()) {
                for (NodeGoal nodeGoal : childGoals) {
                    Term branchCondition = this.computeBranchCondition(nodeGoal.getCurrentNode(), branchConditionCache, simplifyConditions);
                    for (Goal goal : nodeGoal.getStartingGoals()) {
                        Set conditions = (Set)goalConditions.get(goal);
                        conditions.add(branchCondition);
                    }
                }
            }
            for (NodeGoal nodeGoal : childGoals) {
                waitingBranchLeafs.remove(nodeGoal);
                CollectionUtil.binaryInsert(sortedBranchLeafs, (Object)nodeGoal, (Comparator)comparator);
            }
        }
        LinkedHashMap<Goal, Term> pathConditionsMap = new LinkedHashMap<Goal, Term>();
        for (Map.Entry entry : goalConditions.entrySet()) {
            Term pathCondition = this.getServices().getTermBuilder().and((Iterable)entry.getValue());
            pathConditionsMap.put((Goal)entry.getKey(), pathCondition);
        }
        return pathConditionsMap;
    }

    protected boolean isParentReachedOnAllChildGoals(Node currentNode, List<NodeGoal> branchLeafs) {
        if (!branchLeafs.isEmpty()) {
            return branchLeafs.get(0).getSerialNr() <= currentNode.serialNr();
        }
        return true;
    }

    protected NodeGoal iterateBackOnParents(NodeGoal nodeToStartAt, boolean force) {
        Node child = force ? nodeToStartAt.getParent() : nodeToStartAt.getCurrentNode();
        Node parent = child.parent();
        while (parent != null && this.countOpenChildren(parent) == 1) {
            child = parent;
            parent = child.parent();
        }
        if (parent != null) {
            return new NodeGoal(child, nodeToStartAt.getStartingGoals());
        }
        return null;
    }

    protected int countOpenChildren(Node node) {
        int openChildCount = 0;
        for (int i = 0; i < node.childrenCount(); ++i) {
            Node child = node.child(i);
            if (child.isClosed()) continue;
            ++openChildCount;
        }
        return openChildCount;
    }

    protected Term computeBranchCondition(Node node, Map<Node, Term> branchConditionCache, boolean simplifyConditions) throws ProofInputException {
        Term result = branchConditionCache.get(node);
        if (result == null) {
            result = SymbolicExecutionUtil.computeBranchCondition(node, simplifyConditions, true);
            branchConditionCache.put(node, result);
        }
        return result;
    }

    public static class ExecutionVariableValuePair {
        private final ProgramVariable programVariable;
        private final Term arrayIndex;
        private final Term arrayStartIndex;
        private final Term arrayEndIndex;
        private final Term parent;
        private final Term value;
        private final boolean stateMember;
        private final Term condition;
        private final Node goalNode;

        public ExecutionVariableValuePair(ProgramVariable programVariable, Term parent, Term value, Term condition, boolean stateMember, Node goalNode) {
            assert (programVariable != null);
            assert (value != null);
            this.programVariable = programVariable;
            this.parent = parent;
            this.value = value;
            this.condition = condition;
            this.arrayIndex = null;
            this.stateMember = stateMember;
            this.goalNode = goalNode;
            this.arrayStartIndex = null;
            this.arrayEndIndex = null;
        }

        public ExecutionVariableValuePair(Term arrayIndex, Term parent, Term value, Term condition, boolean stateMember, Node goalNode) {
            assert (parent != null);
            assert (value != null);
            this.programVariable = null;
            this.arrayIndex = arrayIndex;
            this.parent = parent;
            this.value = value;
            this.condition = condition;
            this.stateMember = stateMember;
            this.goalNode = goalNode;
            this.arrayStartIndex = null;
            this.arrayEndIndex = null;
        }

        public ExecutionVariableValuePair(Term arrayStartIndex, Term arrayEndIndex, Term arrayRangeConstant, Term parent, Term value, Term condition, boolean stateMember, Node goalNode) {
            assert (parent != null);
            assert (value != null);
            this.programVariable = null;
            this.arrayIndex = arrayRangeConstant;
            this.parent = parent;
            this.value = value;
            this.condition = condition;
            this.stateMember = stateMember;
            this.goalNode = goalNode;
            this.arrayStartIndex = arrayStartIndex;
            this.arrayEndIndex = arrayEndIndex;
        }

        public ProgramVariable getProgramVariable() {
            return this.programVariable;
        }

        public Term getParent() {
            return this.parent;
        }

        public Term getValue() {
            return this.value;
        }

        public boolean isArrayIndex() {
            return this.arrayIndex != null && (this.arrayStartIndex == null || this.arrayEndIndex == null);
        }

        public boolean isArrayRange() {
            return this.arrayStartIndex != null && this.arrayEndIndex != null;
        }

        public Term getArrayIndex() {
            return this.arrayIndex;
        }

        public Term getArrayStartIndex() {
            return this.arrayStartIndex;
        }

        public Term getArrayEndIndex() {
            return this.arrayEndIndex;
        }

        public boolean isStateMember() {
            return this.stateMember;
        }

        public Term getCondition() {
            return this.condition;
        }

        public Node getGoalNode() {
            return this.goalNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExecutionVariableValuePair) {
                ExecutionVariableValuePair other = (ExecutionVariableValuePair)obj;
                return this.isArrayRange() ? this.getArrayStartIndex().equals(other.getArrayStartIndex()) && this.getArrayEndIndex().equals(other.getArrayEndIndex()) : ((this.isArrayIndex() ? this.getArrayIndex().equals(other.getArrayIndex()) : this.getProgramVariable().equals(other.getProgramVariable())) && this.getParent() != null ? this.getParent().equals(other.getParent()) : (other.getParent() == null && this.getCondition() != null ? this.getCondition().equals(other.getCondition()) : other.getCondition() == null && this.getValue().equals(other.getValue()) && this.getGoalNode().equals(other.getGoalNode())));
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            if (this.isArrayRange()) {
                result = 31 * result + this.getArrayStartIndex().hashCode();
                result = 31 * result + this.getArrayEndIndex().hashCode();
            } else {
                result = this.isArrayIndex() ? 31 * result + this.getArrayIndex().hashCode() : 31 * result + this.getProgramVariable().hashCode();
            }
            result = 31 * result + (this.getParent() != null ? this.getParent().hashCode() : 0);
            result = 31 * result + (this.getCondition() != null ? this.getCondition().hashCode() : 0);
            result = 31 * result + this.getValue().hashCode();
            result = 31 * result + this.getGoalNode().hashCode();
            return result;
        }

        public String toString() {
            if (this.isArrayRange()) {
                return "[" + this.getArrayIndex() + "] between " + this.getArrayStartIndex() + " and " + this.getArrayEndIndex() + (String)(this.getParent() != null ? " of " + this.getParent() : "") + " is " + this.getValue() + (String)(this.getCondition() != null ? " under condition " + this.getCondition() : "") + " at goal " + this.goalNode.serialNr();
            }
            if (this.isArrayIndex()) {
                return "[" + this.getArrayIndex() + "]" + (String)(this.getParent() != null ? " of " + this.getParent() : "") + " is " + this.getValue() + (String)(this.getCondition() != null ? " under condition " + this.getCondition() : "") + " at goal " + this.goalNode.serialNr();
            }
            return this.getProgramVariable() + (String)(this.getParent() != null ? " of " + this.getParent() : "") + " is " + this.getValue() + (String)(this.getCondition() != null ? " under condition " + this.getCondition() : "") + " at goal " + this.goalNode.serialNr();
        }
    }

    protected static class NodeGoal {
        private final Node currentNode;
        private final ImmutableList<Goal> startingGoals;

        public NodeGoal(Goal goal) {
            this(goal.node(), (ImmutableList<Goal>)ImmutableSLList.nil().prepend((Object)goal));
        }

        public NodeGoal(Node currentNode, ImmutableList<Goal> startingGoals) {
            this.currentNode = currentNode;
            this.startingGoals = startingGoals;
        }

        public Node getCurrentNode() {
            return this.currentNode;
        }

        public Node getParent() {
            return this.currentNode.parent();
        }

        public int getSerialNr() {
            return this.currentNode.serialNr();
        }

        public ImmutableList<Goal> getStartingGoals() {
            return this.startingGoals;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.currentNode.serialNr());
            sb.append(" starting from goals ");
            boolean afterFirst = false;
            for (Goal goal : this.startingGoals) {
                if (afterFirst) {
                    sb.append(", ");
                } else {
                    afterFirst = true;
                }
                sb.append(goal.node().serialNr());
            }
            return sb.toString();
        }
    }

    public class ExtractLocationParameter {
        private final ProgramVariable programVariable;
        private final Term arrayIndex;
        private final Term arrayStartIndex;
        private final Term arrayEndIndex;
        private final Term parentTerm;
        private int parentTermIndexInStatePredicate;
        private int valueTermIndexInStatePredicate;
        private final LocationVariable preVariable;
        private final boolean stateMember;
        private final Term arrayRangeConstant;
        private final Term notAValue;

        public ExtractLocationParameter(ExtractLocationParameter original, Term newParent) {
            this.programVariable = original.programVariable;
            this.arrayIndex = original.arrayIndex;
            this.parentTerm = OriginTermLabel.removeOriginLabels((Term)newParent, (Services)AbstractUpdateExtractor.this.getServices());
            this.parentTermIndexInStatePredicate = original.parentTermIndexInStatePredicate;
            this.valueTermIndexInStatePredicate = original.valueTermIndexInStatePredicate;
            this.preVariable = original.preVariable;
            this.stateMember = original.stateMember;
            this.arrayStartIndex = original.arrayStartIndex;
            this.arrayEndIndex = original.arrayEndIndex;
            this.arrayRangeConstant = original.arrayRangeConstant;
            this.notAValue = original.notAValue;
        }

        public ExtractLocationParameter(ProgramVariable programVariable, boolean stateMember) throws ProofInputException {
            this(programVariable, null, stateMember);
        }

        public ExtractLocationParameter(ProgramVariable programVariable, Term parentTerm) throws ProofInputException {
            this(programVariable, parentTerm, false);
        }

        protected ExtractLocationParameter(ProgramVariable programVariable, Term parentTerm, boolean stateMember) throws ProofInputException {
            assert (programVariable != null);
            this.programVariable = programVariable;
            this.parentTerm = OriginTermLabel.removeOriginLabels((Term)parentTerm, (Services)AbstractUpdateExtractor.this.getServices());
            this.preVariable = this.createLocationVariable("Pre" + AbstractUpdateExtractor.this.preVariableIndex++, parentTerm != null ? parentTerm.sort() : programVariable.sort());
            this.arrayIndex = null;
            this.stateMember = stateMember;
            this.arrayStartIndex = null;
            this.arrayEndIndex = null;
            this.arrayRangeConstant = null;
            this.notAValue = null;
        }

        public ExtractLocationParameter(Term arrayIndex, Term parentTerm) throws ProofInputException {
            assert (parentTerm != null);
            this.programVariable = null;
            this.arrayIndex = OriginTermLabel.removeOriginLabels((Term)arrayIndex, (Services)AbstractUpdateExtractor.this.getServices());
            this.parentTerm = OriginTermLabel.removeOriginLabels((Term)parentTerm, (Services)AbstractUpdateExtractor.this.getServices());
            this.preVariable = this.createLocationVariable("Pre" + AbstractUpdateExtractor.this.preVariableIndex++, parentTerm.sort());
            this.stateMember = false;
            this.arrayStartIndex = null;
            this.arrayEndIndex = null;
            this.arrayRangeConstant = null;
            this.notAValue = null;
        }

        public ExtractLocationParameter(Term arrayStartIndex, Term arrayEndIndex, Term parentTerm) throws ProofInputException {
            assert (arrayStartIndex != null);
            assert (arrayEndIndex != null);
            assert (parentTerm != null);
            this.programVariable = null;
            this.arrayIndex = null;
            this.parentTerm = OriginTermLabel.removeOriginLabels((Term)parentTerm, (Services)AbstractUpdateExtractor.this.getServices());
            this.preVariable = this.createLocationVariable("Pre" + AbstractUpdateExtractor.this.preVariableIndex++, parentTerm.sort());
            this.stateMember = false;
            this.arrayStartIndex = OriginTermLabel.removeOriginLabels((Term)arrayStartIndex, (Services)AbstractUpdateExtractor.this.getServices());
            this.arrayEndIndex = OriginTermLabel.removeOriginLabels((Term)arrayEndIndex, (Services)AbstractUpdateExtractor.this.getServices());
            TermBuilder tb = AbstractUpdateExtractor.this.getServices().getTermBuilder();
            Function constantFunction = new Function(new Name(tb.newName("*")), AbstractUpdateExtractor.this.getServices().getTypeConverter().getIntegerLDT().targetSort());
            this.arrayRangeConstant = tb.func(constantFunction);
            Function notAValueFunction = new Function(new Name(tb.newName("<Not a Value>")), Sort.ANY);
            this.notAValue = tb.func(notAValueFunction);
        }

        protected LocationVariable createLocationVariable(String name, Sort sort) throws ProofInputException {
            return new LocationVariable(new ProgramElementName(name), sort);
        }

        public boolean isStateMember() {
            return this.stateMember;
        }

        public boolean isArrayIndex() {
            return this.arrayIndex != null;
        }

        public boolean isArrayRange() {
            return this.arrayStartIndex != null && this.arrayEndIndex != null;
        }

        public Term getArrayIndex() {
            return this.arrayIndex;
        }

        public Term getArrayStartIndex() {
            return this.arrayStartIndex;
        }

        public Term getArrayEndIndex() {
            return this.arrayEndIndex;
        }

        public Term getArrayRangeConstant() {
            return this.arrayRangeConstant;
        }

        public Term getNotAValue() {
            return this.notAValue;
        }

        public LocationVariable getPreVariable() {
            return this.preVariable;
        }

        public Term getPreUpdateTarget() {
            return this.parentTerm != null ? this.parentTerm : AbstractUpdateExtractor.this.getServices().getTermBuilder().var(this.programVariable);
        }

        public Term createPreUpdate() {
            Term originalTerm = this.getPreUpdateTarget();
            return AbstractUpdateExtractor.this.getServices().getTermBuilder().elementary((UpdateableOperator)this.preVariable, originalTerm);
        }

        public Term createPreParentTerm() {
            return AbstractUpdateExtractor.this.getServices().getTermBuilder().var((ProgramVariable)this.preVariable);
        }

        public Term createPreValueTerm() {
            TermBuilder tb = AbstractUpdateExtractor.this.getServices().getTermBuilder();
            if (this.parentTerm != null) {
                if (this.isArrayRange()) {
                    Term arrayRange = tb.and(tb.geq(this.arrayRangeConstant, this.arrayStartIndex), tb.leq(this.arrayRangeConstant, this.arrayEndIndex));
                    return tb.ife(arrayRange, tb.dotArr(this.parentTerm, this.arrayRangeConstant), this.notAValue);
                }
                if (this.isArrayIndex()) {
                    return tb.dotArr(this.parentTerm, this.arrayIndex);
                }
                if (AbstractUpdateExtractor.this.getServices().getJavaInfo().getArrayLength() == this.programVariable) {
                    Function function = AbstractUpdateExtractor.this.getServices().getTypeConverter().getHeapLDT().getLength();
                    return tb.func(function, this.createPreParentTerm());
                }
                Function function = AbstractUpdateExtractor.this.getServices().getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)this.programVariable, AbstractUpdateExtractor.this.getServices());
                return tb.dot(this.programVariable.sort(), this.createPreParentTerm(), function);
            }
            if (this.programVariable.isStatic()) {
                Function function = AbstractUpdateExtractor.this.getServices().getTypeConverter().getHeapLDT().getFieldSymbolForPV((LocationVariable)this.programVariable, AbstractUpdateExtractor.this.getServices());
                return tb.staticDot(this.programVariable.sort(), function);
            }
            return tb.var(this.programVariable);
        }

        public ProgramVariable getProgramVariable() {
            return this.programVariable;
        }

        public Term getParentTerm() {
            return this.parentTerm;
        }

        public int getParentTermIndexInStatePredicate() {
            return this.parentTermIndexInStatePredicate;
        }

        public void setParentTermIndexInStatePredicate(int selectParentTermIndexInStatePredicate) {
            this.parentTermIndexInStatePredicate = selectParentTermIndexInStatePredicate;
        }

        public int getValueTermIndexInStatePredicate() {
            return this.valueTermIndexInStatePredicate;
        }

        public void setValueTermIndexInStatePredicate(int selectValueTermIndexInStatePredicate) {
            this.valueTermIndexInStatePredicate = selectValueTermIndexInStatePredicate;
        }

        public String toString() {
            if (this.isArrayRange()) {
                return "[" + this.arrayStartIndex + " to " + this.arrayEndIndex + "] " + (String)(this.parentTerm != null ? " of " + this.parentTerm : "");
            }
            if (this.isArrayIndex()) {
                return "[" + this.arrayIndex + "] " + (String)(this.parentTerm != null ? " of " + this.parentTerm : "");
            }
            return this.programVariable + (String)(this.parentTerm != null ? " of " + this.parentTerm : "");
        }

        public boolean equals(Object obj) {
            if (obj instanceof ExtractLocationParameter) {
                ExtractLocationParameter other = (ExtractLocationParameter)obj;
                return ObjectUtil.equals((Object)this.arrayIndex, (Object)other.arrayIndex) && this.stateMember == other.stateMember && ObjectUtil.equals((Object)this.parentTerm, (Object)other.parentTerm) && ObjectUtil.equals((Object)this.programVariable, (Object)other.programVariable);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.arrayIndex != null ? this.arrayIndex.hashCode() : 0);
            result = 31 * result + (this.stateMember ? 1 : 0);
            result = 31 * result + (this.parentTerm != null ? this.parentTerm.hashCode() : 0);
            result = 31 * result + (this.programVariable != null ? this.programVariable.hashCode() : 0);
            return result;
        }
    }
}

