/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import java.util.Map;
import org.key_project.util.java.StringUtil;
import org.key_project.util.java.XMLUtil;

public abstract class AbstractWriter {
    public static final String NEW_LINE = StringUtil.NEW_LINE;
    public static final String LEADING_WHITE_SPACE_PER_LEVEL = "   ";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String ATTRIBUTE_ENCODING = "encoding";
    public static final String ATTRIBUTE_XML_ID = "xml:id";

    protected void appendEmptyTag(int level, String tagName, Map<String, String> attributeValues, StringBuffer sb) {
        this.appendWhiteSpace(level, sb);
        sb.append("<");
        sb.append(tagName);
        for (Map.Entry<String, String> entry : attributeValues.entrySet()) {
            this.appendAttribute(entry.getKey(), entry.getValue(), sb);
        }
        sb.append("/>");
        this.appendNewLine(sb);
    }

    protected void appendStartTag(int level, String tagName, Map<String, String> attributeValues, StringBuffer sb) {
        this.appendWhiteSpace(level, sb);
        sb.append("<");
        sb.append(tagName);
        for (Map.Entry<String, String> entry : attributeValues.entrySet()) {
            this.appendAttribute(entry.getKey(), entry.getValue(), sb);
        }
        sb.append(">");
        this.appendNewLine(sb);
    }

    protected void appendEndTag(int level, String tagName, StringBuffer sb) {
        this.appendWhiteSpace(level, sb);
        sb.append("</");
        sb.append(tagName);
        sb.append(">");
        this.appendNewLine(sb);
    }

    protected void appendWhiteSpace(int level, StringBuffer sb) {
        for (int i = 0; i < level; ++i) {
            sb.append(LEADING_WHITE_SPACE_PER_LEVEL);
        }
    }

    protected void appendAttribute(String attributeName, String value, StringBuffer sb) {
        if (attributeName != null && value != null) {
            sb.append(" ");
            sb.append(attributeName);
            sb.append("=\"");
            sb.append(XMLUtil.encodeText((String)value));
            sb.append("\"");
        }
    }

    protected void appendXmlHeader(String encoding, StringBuffer sb) {
        sb.append("<?xml version=\"1.0\"");
        this.appendAttribute(ATTRIBUTE_ENCODING, encoding, sb);
        sb.append("?>");
        this.appendNewLine(sb);
    }

    protected void appendNewLine(StringBuffer sb) {
        sb.append(NEW_LINE);
    }
}

