/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;

public class ExecutionNodePreorderIterator {
    private IExecutionNode<?> start;
    private IExecutionNode<?> next;

    public ExecutionNodePreorderIterator(IExecutionNode<?> start) {
        this.start = start;
        this.next = start;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public IExecutionNode<?> next() {
        IExecutionNode<?> oldNext = this.next;
        this.updateNext();
        return oldNext;
    }

    protected void updateNext() {
        IExecutionNode<?> newNext = null;
        IExecutionNode<?>[] children = this.next.getChildren();
        newNext = children.length >= 1 ? children[0] : this.getNextOnParent(this.next);
        this.next = newNext;
    }

    protected IExecutionNode<?> getNextOnParent(IExecutionNode<?> node) {
        for (IExecutionNode<?> parent = node.getParent(); parent != null; parent = parent.getParent()) {
            boolean IExecutionNodeFound = false;
            IExecutionNode<?>[] children = parent.getChildren();
            IExecutionNode<?> nextChildOnParent = null;
            for (int i = 0; i < children.length; ++i) {
                nextChildOnParent = children[i];
                if (nextChildOnParent == this.start) {
                    return null;
                }
                if (IExecutionNodeFound) {
                    return nextChildOnParent;
                }
                if (nextChildOnParent != node) continue;
                IExecutionNodeFound = true;
            }
            if (nextChildOnParent != this.start) {
                node = parent;
                continue;
            }
            return null;
        }
        return null;
    }
}

