/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.reference.MethodReference;
import de.uka.ilkd.key.java.statement.BranchStatement;
import de.uka.ilkd.key.java.statement.JavaStatement;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.java.statement.Throw;
import de.uka.ilkd.key.java.statement.While;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.speclang.BlockContract;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.LoopSpecification;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionAuxiliaryContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBaseMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionElement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionExceptionalMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionJoin;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLink;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopInvariant;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturnValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionOperationContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStart;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicLayout;
import de.uka.ilkd.key.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExecutionNodeReader {
    public IExecutionNode<?> read(File file) throws ParserConfigurationException, SAXException, IOException {
        return this.read(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExecutionNode<?> read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        if (in != null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser saxParser = factory.newSAXParser();
                SEDSAXHandler handler = new SEDSAXHandler();
                saxParser.parse(in, (DefaultHandler)handler);
                IExecutionNode<?> root = handler.getRoot();
                Set<Map.Entry<AbstractKeYlessExecutionNode<?>, List<String>>> entries = handler.getCallStackPathEntries().entrySet();
                for (Map.Entry<AbstractKeYlessExecutionNode<?>, List<String>> entry : entries) {
                    for (String string : entry.getValue()) {
                        IExecutionNode<?> iExecutionNode = this.findNode(root, string);
                        if (iExecutionNode == null) {
                            throw new SAXException("Can't find call stack entry \"" + string + "\" in parsed symbolic execution tree.");
                        }
                        entry.getKey().addCallStackEntry(iExecutionNode);
                    }
                }
                Set<Map.Entry<KeYlessMethodCall, List<String>>> methodReturnEntries = handler.getMethodReturnPathEntries().entrySet();
                for (Map.Entry<KeYlessMethodCall, List<String>> entry : methodReturnEntries) {
                    for (String string : entry.getValue()) {
                        IExecutionNode<?> iExecutionNode = this.findNode(root, string);
                        if (iExecutionNode == null) {
                            throw new SAXException("Can't find method return entry \"" + string + "\" in parsed symbolic execution tree.");
                        }
                        if (!(iExecutionNode instanceof IExecutionBaseMethodReturn)) {
                            throw new SAXException("Expected basemethod return on \"" + string + "\" but is " + iExecutionNode.getElementType() + ".");
                        }
                        entry.getKey().addMethodReturn((IExecutionBaseMethodReturn)iExecutionNode);
                    }
                }
                Set<Map.Entry<AbstractKeYlessExecutionNode<?>, List<Pair<String, String>>>> set = handler.getCompletedBlockEntries().entrySet();
                for (Map.Entry<AbstractKeYlessExecutionNode<?>, List<Pair<String, String>>> entry : set) {
                    for (Pair<String, String> pair : entry.getValue()) {
                        IExecutionNode<?> returnEntry = this.findNode(root, (String)pair.first);
                        if (returnEntry == null) {
                            throw new SAXException("Can't find completed block entry \"" + (String)pair.first + "\" in parsed symbolic execution tree.");
                        }
                        if (!(returnEntry instanceof IExecutionBlockStartNode)) {
                            throw new SAXException("Found completed block entry is not an instance of IExecutionBlockStartNode.");
                        }
                        entry.getKey().addCompletedBlock((IExecutionBlockStartNode)returnEntry, (String)pair.second);
                    }
                }
                Set<Map.Entry<AbstractKeYlessExecutionBlockStartNode<?>, List<String>>> set2 = handler.getBlockCompletionEntries().entrySet();
                for (Map.Entry<AbstractKeYlessExecutionBlockStartNode<?>, List<String>> entry : set2) {
                    for (Object path : entry.getValue()) {
                        IExecutionNode<?> returnEntry = this.findNode(root, (String)path);
                        if (returnEntry == null) {
                            throw new SAXException("Can't find block completion entry \"" + (String)path + "\" in parsed symbolic execution tree.");
                        }
                        entry.getKey().addBlockCompletion(returnEntry);
                    }
                }
                Set<Map.Entry<AbstractKeYlessExecutionNode<?>, List<String>>> set3 = handler.getOutgoingLinks().entrySet();
                for (Map.Entry<AbstractKeYlessExecutionNode<?>, List<String>> entry : set3) {
                    for (String path : entry.getValue()) {
                        IExecutionNode<?> target = this.findNode(root, path);
                        if (target == null) {
                            throw new SAXException("Can't find link targets \"" + path + "\" in parsed symbolic execution tree.");
                        }
                        KeYLessLink link = new KeYLessLink();
                        link.setSource((IExecutionNode)entry.getKey());
                        link.setTarget(target);
                        entry.getKey().addOutgoingLink(link);
                        ((AbstractKeYlessExecutionNode)target).addIncomingLink(link);
                    }
                }
                Set<Map.Entry<KeYlessStart, List<String>>> set4 = handler.getTerminationPathEntries().entrySet();
                for (Map.Entry<KeYlessStart, List<String>> entry : set4) {
                    for (String path : entry.getValue()) {
                        IExecutionNode<?> terminationEntry = this.findNode(root, path);
                        if (terminationEntry == null) {
                            throw new SAXException("Can't find termination entry \"" + path + "\" in parsed symbolic execution tree.");
                        }
                        if (!(terminationEntry instanceof IExecutionTermination)) {
                            throw new SAXException("Expected termination on \"" + path + "\" but is " + terminationEntry.getElementType() + ".");
                        }
                        entry.getKey().addTermination((IExecutionTermination)terminationEntry);
                    }
                }
                IExecutionNode<?> iExecutionNode = root;
                return iExecutionNode;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    protected IExecutionNode<?> findNode(IExecutionNode<?> root, String path) throws SAXException {
        if (path != null && !path.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                try {
                    int childIndex = Integer.parseInt(next);
                    if (childIndex < 0) {
                        throw new SAXException("Path segment \"" + next + "\" of path \"" + path + "\" is a negative integer.");
                    }
                    IExecutionNode<?>[] children = root.getChildren();
                    if (childIndex >= children.length) {
                        throw new SAXException("Path segment \"" + next + "\" of path \"" + path + "\" is outside of the child array range.");
                    }
                    root = children[childIndex];
                }
                catch (NumberFormatException e) {
                    throw new SAXException("Path segment \"" + next + "\" of path \"" + path + "\" is no valid integer.", e);
                }
            }
        }
        return root;
    }

    protected boolean isConstraint(String uri, String localName, String qName) {
        return "constraint".equals(qName);
    }

    protected boolean isVariable(String uri, String localName, String qName) {
        return "variable".equals(qName);
    }

    protected boolean isCallStateVariable(String uri, String localName, String qName) {
        return "callStateVariable".equals(qName);
    }

    protected boolean isMethodReturnValue(String uri, String localName, String qName) {
        return "methodReturnValue".equals(qName);
    }

    protected boolean isValue(String uri, String localName, String qName) {
        return "value".equals(qName);
    }

    protected boolean isCallStackEntry(String uri, String localName, String qName) {
        return "callStackEntry".equals(qName);
    }

    protected boolean isMethodReturnEntry(String uri, String localName, String qName) {
        return "methodReturnEntry".equals(qName);
    }

    protected boolean isCompletedBlockEntry(String uri, String localName, String qName) {
        return "completedBlockEntry".equals(qName);
    }

    protected boolean isOutgoingLink(String uri, String localName, String qName) {
        return "outgoingLink".equals(qName);
    }

    protected boolean isBlockCompletionEntry(String uri, String localName, String qName) {
        return "blockCompletionEntry".equals(qName);
    }

    protected boolean isTerminationEntry(String uri, String localName, String qName) {
        return "terminationEntry".equals(qName);
    }

    protected KeYlessVariable createVariable(IExecutionValue parentValue, String uri, String localName, String qName, Attributes attributes) {
        return new KeYlessVariable(parentValue, this.isArrayIndex(attributes), this.getArrayIndexString(attributes), this.getName(attributes));
    }

    public KeYlessMethodReturnValue createMethodReturnValue(String uri, String localName, String qName, Attributes attributes) {
        return new KeYlessMethodReturnValue(this.getName(attributes), this.getReturnValueString(attributes), this.getHasCondition(attributes), this.getConditionString(attributes));
    }

    protected KeYlessValue createValue(IExecutionVariable parentVariable, String uri, String localName, String qName, Attributes attributes) {
        return new KeYlessValue(parentVariable, this.getTypeString(attributes), this.getValueString(attributes), this.getName(attributes), this.isValueUnknown(attributes), this.isValueAnObject(attributes), this.getConditionString(attributes));
    }

    protected AbstractKeYlessExecutionNode<?> createExecutionNode(IExecutionNode<?> parent, String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("branchCondition".equals(qName)) {
            return new KeYlessBranchCondition(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.getBranchCondition(attributes), this.isMergedBranchCondition(attributes), this.isBranchConditionComputed(attributes), this.getAdditionalBranchLabel(attributes));
        }
        if ("branchStatement".equals(qName)) {
            return new KeYlessBranchStatement(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isBlockOpened(attributes));
        }
        if ("loopCondition".equals(qName)) {
            return new KeYlessLoopCondition(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isBlockOpened(attributes));
        }
        if ("loopStatement".equals(qName)) {
            return new KeYlessLoopStatement(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isBlockOpened(attributes));
        }
        if ("methodCall".equals(qName)) {
            return new KeYlessMethodCall(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes));
        }
        if ("methodReturn".equals(qName)) {
            return new KeYlessMethodReturn(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.getNameIncludingReturnValue(attributes), this.getSignature(attributes), this.getSignatureIncludingReturnValue(attributes), this.isReturnValueComputed(attributes), this.getMethodReturnCondition(attributes));
        }
        if ("exceptionalMethodReturn".equals(qName)) {
            return new KeYlessExceptionalMethodReturn(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.getSignature(attributes), this.getMethodReturnCondition(attributes));
        }
        if ("start".equals(qName)) {
            return new KeYlessStart(this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes));
        }
        if ("statement".equals(qName)) {
            return new KeYlessStatement(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes));
        }
        if ("termination".equals(qName)) {
            return new KeYlessTermination(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.getTerminationKind(attributes), this.getBranchVerified(attributes));
        }
        if ("operationContract".equals(qName)) {
            return new KeYlessOperationContract(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isPreconditionComplied(attributes), this.isHasNotNullCheck(attributes), this.isNotNullCheckComplied(attributes), this.getResultTerm(attributes), this.getExceptionTerm(attributes), this.getSelfTerm(attributes), this.getContractParameters(attributes));
        }
        if ("loopInvariant".equals(qName)) {
            return new KeYlessLoopInvariant(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isInitiallyValid(attributes));
        }
        if ("blockContract".equals(qName)) {
            return new KeYlessBlockContract(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isPreconditionComplied(attributes));
        }
        if ("join".equals(qName)) {
            return new KeYlessJoin(parent, this.getName(attributes), this.getPathCondition(attributes), this.isPathConditionChanged(attributes), this.isWeakeningVerified(attributes));
        }
        throw new SAXException("Unknown tag \"" + qName + "\".");
    }

    protected String getAdditionalBranchLabel(Attributes attributes) {
        return attributes.getValue("additionalBranchLabel");
    }

    protected String getPathInTree(Attributes attributes) {
        return attributes.getValue("path");
    }

    protected String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    protected String getNameIncludingReturnValue(Attributes attributes) {
        return attributes.getValue("nameIncludingReturnValue");
    }

    protected String getSignature(Attributes attributes) {
        return attributes.getValue("signature");
    }

    protected String getSignatureIncludingReturnValue(Attributes attributes) {
        return attributes.getValue("signatureIncludingReturnValue");
    }

    protected IExecutionTermination.TerminationKind getTerminationKind(Attributes attributes) {
        return IExecutionTermination.TerminationKind.valueOf(attributes.getValue("terminationKind"));
    }

    protected boolean isPreconditionComplied(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("preconditionComplied"));
    }

    protected boolean isHasNotNullCheck(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("hasNotNullCheck"));
    }

    protected boolean isBlockOpened(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("blockOpened"));
    }

    protected boolean isReturnValueComputed(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isReturnValueComputed"));
    }

    protected boolean isBranchConditionComputed(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isBranchConditionComputed"));
    }

    protected boolean isNotNullCheckComplied(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("notNullCheckComplied"));
    }

    protected boolean isInitiallyValid(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("initiallyValid"));
    }

    protected boolean isValueAnObject(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isValueAnObject"));
    }

    protected boolean isWeakeningVerified(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("weakeningVerified"));
    }

    protected boolean isValueUnknown(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isValueUnknown"));
    }

    protected String getValueString(Attributes attributes) {
        return attributes.getValue("valueString");
    }

    protected String getConditionString(Attributes attributes) {
        return attributes.getValue("conditionString");
    }

    protected boolean getHasCondition(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("hasCondition"));
    }

    protected boolean getBranchVerified(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("branchVerified"));
    }

    protected String getReturnValueString(Attributes attributes) {
        return attributes.getValue("returnValueString");
    }

    protected String getTypeString(Attributes attributes) {
        return attributes.getValue("typeString");
    }

    protected String getExceptionTerm(Attributes attributes) {
        return attributes.getValue("exceptionTerm");
    }

    protected String getResultTerm(Attributes attributes) {
        return attributes.getValue("resultTerm");
    }

    protected String getSelfTerm(Attributes attributes) {
        return attributes.getValue("selfTerm");
    }

    protected String getContractParameters(Attributes attributes) {
        return attributes.getValue("contractParameters");
    }

    protected String getArrayIndexString(Attributes attributes) {
        return attributes.getValue("arrayIndex");
    }

    protected boolean isArrayIndex(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isArrayIndex"));
    }

    protected String getBranchCondition(Attributes attributes) {
        return attributes.getValue("branchCondition");
    }

    protected String getPathCondition(Attributes attributes) {
        return attributes.getValue("pathCondition");
    }

    protected String getMethodReturnCondition(Attributes attributes) {
        return attributes.getValue("methodReturnCondition");
    }

    protected boolean isPathConditionChanged(Attributes attributes) {
        return Boolean.valueOf(attributes.getValue("pathConditionChanged"));
    }

    protected boolean isMergedBranchCondition(Attributes attributes) {
        return Boolean.valueOf(attributes.getValue("mergedBranchCondition"));
    }

    public static class KeYlessValue
    extends AbstractKeYlessExecutionElement
    implements IExecutionValue {
        private final IExecutionVariable variable;
        private final String typeString;
        private final String valueString;
        private final boolean valueUnknown;
        private final boolean valueAnObject;
        private final List<IExecutionVariable> childVariables = new LinkedList<IExecutionVariable>();
        private final String conditionString;
        private final List<IExecutionConstraint> constraints = new LinkedList<IExecutionConstraint>();

        public KeYlessValue(IExecutionVariable variable, String typeString, String valueString, String name, boolean valueUnknown, boolean valueAnObject, String conditionString) {
            super(name);
            this.variable = variable;
            this.typeString = typeString;
            this.valueString = valueString;
            this.valueUnknown = valueUnknown;
            this.valueAnObject = valueAnObject;
            this.conditionString = conditionString;
        }

        public void addChildVariable(IExecutionVariable variable) {
            this.childVariables.add(variable);
        }

        @Override
        public String getValueString() throws ProofInputException {
            return this.valueString;
        }

        @Override
        public String getTypeString() {
            return this.typeString;
        }

        @Override
        public String getConditionString() throws ProofInputException {
            return this.conditionString;
        }

        @Override
        public IExecutionVariable getVariable() {
            return this.variable;
        }

        @Override
        public IExecutionVariable[] getChildVariables() throws ProofInputException {
            return this.childVariables.toArray(new IExecutionVariable[this.childVariables.size()]);
        }

        @Override
        public boolean isValueUnknown() throws ProofInputException {
            return this.valueUnknown;
        }

        @Override
        public boolean isValueAnObject() throws ProofInputException {
            return this.valueAnObject;
        }

        @Override
        public Term getValue() throws ProofInputException {
            return null;
        }

        @Override
        public String getElementType() {
            return "Value";
        }

        @Override
        public Term getCondition() throws ProofInputException {
            return null;
        }

        public void addConstraint(IExecutionConstraint constraint) {
            this.constraints.add(constraint);
        }

        @Override
        public IExecutionConstraint[] getConstraints() throws ProofInputException {
            return this.constraints.toArray(new IExecutionConstraint[this.constraints.size()]);
        }

        @Override
        public PosInOccurrence getModalityPIO() {
            return null;
        }
    }

    public static class KeYLessLink
    implements IExecutionLink {
        private IExecutionNode<?> source;
        private IExecutionNode<?> target;

        @Override
        public IExecutionNode<?> getSource() {
            return this.source;
        }

        @Override
        public IExecutionNode<?> getTarget() {
            return this.target;
        }

        public void setSource(IExecutionNode<?> source) {
            this.source = source;
        }

        public void setTarget(IExecutionNode<?> target) {
            this.target = target;
        }
    }

    public static class KeYlessVariable
    extends AbstractKeYlessExecutionElement
    implements IExecutionVariable {
        private final IExecutionValue parentValue;
        private final boolean isArrayIndex;
        private final String arrayIndexString;
        private final List<IExecutionValue> values = new LinkedList<IExecutionValue>();

        public KeYlessVariable(IExecutionValue parentValue, boolean isArrayIndex, String arrayIndexString, String name) {
            super(name);
            this.parentValue = parentValue;
            this.isArrayIndex = isArrayIndex;
            this.arrayIndexString = arrayIndexString;
        }

        public void addValue(IExecutionValue variable) {
            this.values.add(variable);
        }

        @Override
        public IExecutionValue getParentValue() {
            return this.parentValue;
        }

        @Override
        public IExecutionValue[] getValues() {
            return this.values.toArray(new IExecutionValue[this.values.size()]);
        }

        @Override
        public Term getArrayIndex() {
            return null;
        }

        @Override
        public String getArrayIndexString() {
            return this.arrayIndexString;
        }

        @Override
        public boolean isArrayIndex() {
            return this.isArrayIndex;
        }

        @Override
        public IProgramVariable getProgramVariable() {
            return null;
        }

        @Override
        public String getElementType() {
            return "Variable";
        }

        @Override
        public Term getAdditionalCondition() {
            return null;
        }

        @Override
        public PosInOccurrence getModalityPIO() {
            return null;
        }

        @Override
        public Term createSelectTerm() {
            return null;
        }
    }

    public static class KeYlessConstraint
    extends AbstractKeYlessExecutionElement
    implements IExecutionConstraint {
        public KeYlessConstraint(String name) {
            super(name);
        }

        @Override
        public String getElementType() {
            return "Constraint";
        }

        @Override
        public Term getTerm() {
            return null;
        }

        @Override
        public PosInOccurrence getModalityPIO() {
            return null;
        }
    }

    public static class KeYlessBlockContract
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionAuxiliaryContract {
        private final boolean preconditionComplied;

        public KeYlessBlockContract(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean preconditionComplied) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.preconditionComplied = preconditionComplied;
        }

        @Override
        public String getElementType() {
            return "Block Contract";
        }

        public BlockContract getContract() {
            return null;
        }

        @Override
        public StatementBlock getBlock() {
            return null;
        }

        @Override
        public boolean isPreconditionComplied() {
            return this.preconditionComplied;
        }
    }

    public static class KeYlessLoopInvariant
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionLoopInvariant {
        private final boolean initiallyValid;

        public KeYlessLoopInvariant(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean initiallyValid) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.initiallyValid = initiallyValid;
        }

        @Override
        public String getElementType() {
            return "Loop Invariant";
        }

        @Override
        public LoopSpecification getLoopInvariant() {
            return null;
        }

        @Override
        public While getLoopStatement() {
            return null;
        }

        @Override
        public boolean isInitiallyValid() {
            return this.initiallyValid;
        }
    }

    public static class KeYlessOperationContract
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionOperationContract {
        private final boolean preconditionComplied;
        private final boolean hasNotNullCheck;
        private final boolean notNullCheckComplied;
        private final String formatedResultTerm;
        private final String formatedExceptionTerm;
        private final String formatedSelfTerm;
        private final String formatedContractParams;

        public KeYlessOperationContract(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean preconditionComplied, boolean hasNotNullCheck, boolean notNullCheckComplied, String formatedResultTerm, String formatedExceptionTerm, String formatedSelfTerm, String formatedContractParams) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.preconditionComplied = preconditionComplied;
            this.hasNotNullCheck = hasNotNullCheck;
            this.notNullCheckComplied = notNullCheckComplied;
            this.formatedResultTerm = formatedResultTerm;
            this.formatedExceptionTerm = formatedExceptionTerm;
            this.formatedSelfTerm = formatedSelfTerm;
            this.formatedContractParams = formatedContractParams;
        }

        @Override
        public String getElementType() {
            return "Operation Contract";
        }

        @Override
        public Contract getContract() {
            return null;
        }

        @Override
        public IProgramMethod getContractProgramMethod() {
            return null;
        }

        @Override
        public boolean isPreconditionComplied() {
            return this.preconditionComplied;
        }

        @Override
        public boolean hasNotNullCheck() {
            return this.hasNotNullCheck;
        }

        @Override
        public boolean isNotNullCheckComplied() {
            return this.notNullCheckComplied;
        }

        @Override
        public Term getResultTerm() throws ProofInputException {
            return null;
        }

        @Override
        public Term getExceptionTerm() throws ProofInputException {
            return null;
        }

        @Override
        public String getFormatedResultTerm() throws ProofInputException {
            return this.formatedResultTerm;
        }

        @Override
        public String getFormatedExceptionTerm() throws ProofInputException {
            return this.formatedExceptionTerm;
        }

        @Override
        public Term getSelfTerm() throws ProofInputException {
            return null;
        }

        @Override
        public ImmutableList<Term> getContractParams() throws ProofInputException {
            return null;
        }

        @Override
        public String getFormatedSelfTerm() throws ProofInputException {
            return this.formatedSelfTerm;
        }

        @Override
        public String getFormatedContractParams() throws ProofInputException {
            return this.formatedContractParams;
        }
    }

    public static class KeYlessJoin
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionJoin {
        private final boolean weakeningVerified;

        public KeYlessJoin(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean weakeningVerified) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.weakeningVerified = weakeningVerified;
        }

        @Override
        public String getElementType() {
            return "Join";
        }

        @Override
        public boolean isWeakeningVerified() {
            return this.weakeningVerified;
        }

        @Override
        public boolean isWeakeningVerificationSupported() {
            return true;
        }
    }

    public static class KeYlessStatement
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionStatement {
        public KeYlessStatement(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
        }

        @Override
        public String getElementType() {
            return "Statement";
        }
    }

    public static class KeYlessMethodReturnValue
    extends AbstractKeYlessExecutionElement
    implements IExecutionMethodReturnValue {
        private final String returnValueString;
        private final boolean hasCondition;
        private final String conditionString;

        public KeYlessMethodReturnValue(String name, String returnValueString, boolean hasCondition, String conditionString) {
            super(name);
            this.returnValueString = returnValueString;
            this.hasCondition = hasCondition;
            this.conditionString = conditionString;
        }

        @Override
        public String getElementType() {
            return "Return Value";
        }

        @Override
        public Term getReturnValue() throws ProofInputException {
            return null;
        }

        @Override
        public String getReturnValueString() throws ProofInputException {
            return this.returnValueString;
        }

        @Override
        public boolean hasCondition() throws ProofInputException {
            return this.hasCondition;
        }

        @Override
        public Term getCondition() throws ProofInputException {
            return null;
        }

        @Override
        public String getConditionString() throws ProofInputException {
            return this.conditionString;
        }

        @Override
        public PosInOccurrence getModalityPIO() {
            return null;
        }
    }

    public static class KeYlessMethodReturn
    extends AbstractKeYlessBaseExecutionNode<SourceElement>
    implements IExecutionMethodReturn {
        private final String nameIncludingReturnValue;
        private final String signatureIncludingReturnValue;
        private final boolean returnValueComputed;
        private final List<IExecutionMethodReturnValue> returnValues = new LinkedList<IExecutionMethodReturnValue>();

        public KeYlessMethodReturn(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, String nameIncludingReturnValue, String signature, String signatureIncludingReturnValue, boolean returnValueComputed, String formatedMethodReturn) {
            super(parent, name, formatedPathCondition, pathConditionChanged, signature, formatedMethodReturn);
            this.nameIncludingReturnValue = nameIncludingReturnValue;
            this.signatureIncludingReturnValue = signatureIncludingReturnValue;
            this.returnValueComputed = returnValueComputed;
        }

        @Override
        public String getNameIncludingReturnValue() throws ProofInputException {
            return this.nameIncludingReturnValue;
        }

        @Override
        public String getSignatureIncludingReturnValue() throws ProofInputException {
            return this.signatureIncludingReturnValue;
        }

        @Override
        public String getElementType() {
            return "Method Return";
        }

        @Override
        public boolean isReturnValuesComputed() {
            return this.returnValueComputed;
        }

        @Override
        public IExecutionMethodReturnValue[] getReturnValues() throws ProofInputException {
            return this.returnValues.toArray(new IExecutionMethodReturnValue[this.returnValues.size()]);
        }

        public void addReturnValue(IExecutionMethodReturnValue returnValue) {
            this.returnValues.add(returnValue);
        }
    }

    public static class KeYlessExceptionalMethodReturn
    extends AbstractKeYlessBaseExecutionNode<Throw>
    implements IExecutionExceptionalMethodReturn {
        public KeYlessExceptionalMethodReturn(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, String signature, String formatedMethodReturn) {
            super(parent, name, formatedPathCondition, pathConditionChanged, signature, formatedMethodReturn);
        }

        @Override
        public String getElementType() {
            return "Exceptional Method Return";
        }
    }

    public static abstract class AbstractKeYlessBaseExecutionNode<S extends SourceElement>
    extends AbstractKeYlessExecutionNode<S>
    implements IExecutionBaseMethodReturn<S> {
        private final List<IExecutionVariable> callStateVariables = new LinkedList<IExecutionVariable>();
        private final String signature;
        private final String formatedMethodReturn;

        public AbstractKeYlessBaseExecutionNode(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, String signature, String formatedMethodReturn) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.signature = signature;
            this.formatedMethodReturn = formatedMethodReturn;
        }

        @Override
        public IExecutionVariable[] getCallStateVariables() {
            return this.callStateVariables.toArray(new IExecutionVariable[this.callStateVariables.size()]);
        }

        public void addCallStateVariable(IExecutionVariable variable) {
            this.callStateVariables.add(variable);
        }

        @Override
        public IExecutionMethodCall getMethodCall() {
            return null;
        }

        @Override
        public String getSignature() throws ProofInputException {
            return this.signature;
        }

        @Override
        public Term getMethodReturnCondition() throws ProofInputException {
            return null;
        }

        @Override
        public String getFormatedMethodReturnCondition() throws ProofInputException {
            return this.formatedMethodReturn;
        }
    }

    public static class KeYlessMethodCall
    extends AbstractKeYlessExecutionNode<MethodBodyStatement>
    implements IExecutionMethodCall {
        private ImmutableList<IExecutionBaseMethodReturn<?>> methodReturns = ImmutableSLList.nil();

        public KeYlessMethodCall(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
        }

        @Override
        public MethodReference getMethodReference() {
            return null;
        }

        @Override
        public IProgramMethod getProgramMethod() {
            return null;
        }

        @Override
        public String getElementType() {
            return "Method Call";
        }

        @Override
        public boolean isImplicitConstructor() {
            return false;
        }

        @Override
        public MethodReference getExplicitConstructorMethodReference() {
            return null;
        }

        @Override
        public IProgramMethod getExplicitConstructorProgramMethod() {
            return null;
        }

        @Override
        public ImmutableList<IExecutionBaseMethodReturn<?>> getMethodReturns() {
            return this.methodReturns;
        }

        public void addMethodReturn(IExecutionBaseMethodReturn<?> methodReturn) {
            if (methodReturn != null) {
                this.methodReturns = this.methodReturns.prepend(methodReturn);
            }
        }
    }

    public static class KeYlessLoopStatement
    extends AbstractKeYlessExecutionBlockStartNode<LoopStatement>
    implements IExecutionLoopStatement {
        public KeYlessLoopStatement(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean blockOpened) {
            super(parent, name, formatedPathCondition, pathConditionChanged, blockOpened);
        }

        @Override
        public String getElementType() {
            return "Loop Statement";
        }
    }

    public static class KeYlessLoopCondition
    extends AbstractKeYlessExecutionBlockStartNode<JavaStatement>
    implements IExecutionLoopCondition {
        public KeYlessLoopCondition(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean blockOpened) {
            super(parent, name, formatedPathCondition, pathConditionChanged, blockOpened);
        }

        @Override
        public Expression getGuardExpression() {
            return null;
        }

        @Override
        public PositionInfo getGuardExpressionPositionInfo() {
            return null;
        }

        @Override
        public String getElementType() {
            return "Loop Condition";
        }
    }

    public static class KeYlessBranchStatement
    extends AbstractKeYlessExecutionBlockStartNode<BranchStatement>
    implements IExecutionBranchStatement {
        public KeYlessBranchStatement(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean blockOpened) {
            super(parent, name, formatedPathCondition, pathConditionChanged, blockOpened);
        }

        @Override
        public String getElementType() {
            return "Branch Statement";
        }
    }

    public static class KeYlessTermination
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionTermination {
        private final IExecutionTermination.TerminationKind terminationKind;
        private final boolean branchVerified;

        public KeYlessTermination(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, IExecutionTermination.TerminationKind terminationKind, boolean branchVerified) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.terminationKind = terminationKind;
            this.branchVerified = branchVerified;
        }

        @Override
        public IProgramVariable getExceptionVariable() {
            return null;
        }

        @Override
        public Sort getExceptionSort() {
            return null;
        }

        @Override
        public String getElementType() {
            switch (this.getTerminationKind()) {
                case EXCEPTIONAL: {
                    return "Exceptional Termination";
                }
                case LOOP_BODY: {
                    return "Loop Body Termination";
                }
                case BLOCK_CONTRACT_EXCEPTIONAL: {
                    return "Block Contract Exceptional Termination";
                }
                case BLOCK_CONTRACT_NORMAL: {
                    return "Block Contract Termination";
                }
            }
            return "Termination";
        }

        @Override
        public IExecutionTermination.TerminationKind getTerminationKind() {
            return this.terminationKind;
        }

        @Override
        public boolean isBranchVerified() {
            return this.branchVerified;
        }
    }

    public static class KeYlessStart
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionStart {
        private ImmutableList<IExecutionTermination> terminations = ImmutableSLList.nil();

        public KeYlessStart(String name, String formatedPathCondition, boolean pathConditionChanged) {
            super(null, name, formatedPathCondition, pathConditionChanged);
        }

        @Override
        public String getElementType() {
            return "Start";
        }

        public void addTermination(IExecutionTermination termination) {
            if (termination != null) {
                this.terminations = this.terminations.prepend((Object)termination);
            }
        }

        @Override
        public ImmutableList<IExecutionTermination> getTerminations() {
            return this.terminations;
        }
    }

    public static class KeYlessBranchCondition
    extends AbstractKeYlessExecutionNode<SourceElement>
    implements IExecutionBranchCondition {
        private final String formatedBranchCondition;
        private final boolean mergedBranchCondition;
        private final boolean branchConditionComputed;
        private final String additionalBranchLabel;

        public KeYlessBranchCondition(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, String formatedBranchCondition, boolean mergedBranchCondition, boolean branchConditionComputed, String additionalBranchLabel) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.formatedBranchCondition = formatedBranchCondition;
            this.mergedBranchCondition = mergedBranchCondition;
            this.branchConditionComputed = branchConditionComputed;
            this.additionalBranchLabel = additionalBranchLabel;
        }

        @Override
        public String getElementType() {
            return "Branch Condition";
        }

        @Override
        public Term getBranchCondition() {
            return null;
        }

        @Override
        public String getFormatedBranchCondition() {
            return this.formatedBranchCondition;
        }

        @Override
        public boolean isMergedBranchCondition() {
            return this.mergedBranchCondition;
        }

        @Override
        public Node[] getMergedProofNodes() {
            return null;
        }

        @Override
        public Term[] getMergedBranchCondtions() throws ProofInputException {
            return null;
        }

        @Override
        public boolean isBranchConditionComputed() {
            return this.branchConditionComputed;
        }

        @Override
        public String getAdditionalBranchLabel() {
            return this.additionalBranchLabel;
        }
    }

    public static abstract class AbstractKeYlessExecutionBlockStartNode<S extends SourceElement>
    extends AbstractKeYlessExecutionNode<S>
    implements IExecutionBlockStartNode<S> {
        private ImmutableList<IExecutionNode<?>> blockCompletions = ImmutableSLList.nil();
        private final boolean blockOpened;

        public AbstractKeYlessExecutionBlockStartNode(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged, boolean blockOpened) {
            super(parent, name, formatedPathCondition, pathConditionChanged);
            this.blockOpened = blockOpened;
        }

        @Override
        public ImmutableList<IExecutionNode<?>> getBlockCompletions() {
            return this.blockCompletions;
        }

        public void addBlockCompletion(IExecutionNode<?> blockCompletion) {
            if (blockCompletion != null) {
                this.blockCompletions = this.blockCompletions.append(blockCompletion);
            }
        }

        @Override
        public boolean isBlockOpened() {
            return this.blockOpened;
        }
    }

    public static abstract class AbstractKeYlessExecutionNode<S extends SourceElement>
    extends AbstractKeYlessExecutionElement
    implements IExecutionNode<S> {
        private final IExecutionNode<?> parent;
        private final List<IExecutionNode<?>> children = new LinkedList();
        private final String formatedPathCondition;
        private final boolean pathConditionChanged;
        private final List<IExecutionNode<?>> callStack = new LinkedList();
        private final List<IExecutionConstraint> constraints = new LinkedList<IExecutionConstraint>();
        private final List<IExecutionVariable> variables = new LinkedList<IExecutionVariable>();
        private ImmutableList<IExecutionBlockStartNode<?>> completedBlocks = ImmutableSLList.nil();
        private final Map<IExecutionBlockStartNode<?>, String> formatedCompletedBlockConditions = new LinkedHashMap();
        private ImmutableList<IExecutionLink> outgoingLinks = ImmutableSLList.nil();
        private ImmutableList<IExecutionLink> incomingLinks = ImmutableSLList.nil();

        public AbstractKeYlessExecutionNode(IExecutionNode<?> parent, String name, String formatedPathCondition, boolean pathConditionChanged) {
            super(name);
            this.parent = parent;
            this.formatedPathCondition = formatedPathCondition;
            this.pathConditionChanged = pathConditionChanged;
        }

        @Override
        public IExecutionNode<?> getParent() {
            return this.parent;
        }

        public void addChild(IExecutionNode<?> child) {
            this.children.add(child);
        }

        @Override
        public IExecutionNode<?>[] getChildren() {
            return this.children.toArray(new IExecutionNode[this.children.size()]);
        }

        @Override
        public Term getPathCondition() throws ProofInputException {
            return null;
        }

        @Override
        public String getFormatedPathCondition() throws ProofInputException {
            return this.formatedPathCondition;
        }

        @Override
        public boolean isPathConditionChanged() {
            return this.pathConditionChanged;
        }

        public void addCallStackEntry(IExecutionNode<?> entry) {
            this.callStack.add(entry);
        }

        @Override
        public IExecutionNode<?>[] getCallStack() {
            return this.callStack.isEmpty() ? null : this.callStack.toArray(new IExecutionNode[this.callStack.size()]);
        }

        public void addConstraint(IExecutionConstraint constraint) {
            this.constraints.add(constraint);
        }

        @Override
        public IExecutionConstraint[] getConstraints() {
            return this.constraints.toArray(new IExecutionConstraint[this.constraints.size()]);
        }

        public void addVariable(IExecutionVariable variable) {
            this.variables.add(variable);
        }

        @Override
        public S getActiveStatement() {
            return null;
        }

        @Override
        public PositionInfo getActivePositionInfo() {
            return null;
        }

        @Override
        public IExecutionVariable[] getVariables() {
            return this.variables.toArray(new IExecutionVariable[this.variables.size()]);
        }

        @Override
        public IExecutionVariable[] getVariables(Term condition) {
            return null;
        }

        @Override
        public int getLayoutsCount() throws ProofInputException {
            return 0;
        }

        @Override
        public ISymbolicLayout getInitialLayout(int configurationIndex) throws ProofInputException {
            return null;
        }

        @Override
        public ISymbolicLayout getCurrentLayout(int configurationIndex) throws ProofInputException {
            return null;
        }

        @Override
        public ImmutableList<ISymbolicEquivalenceClass> getLayoutsEquivalenceClasses(int configurationIndex) throws ProofInputException {
            return null;
        }

        @Override
        public PosInOccurrence getModalityPIO() {
            return null;
        }

        @Override
        public ImmutableList<IExecutionBlockStartNode<?>> getCompletedBlocks() {
            return this.completedBlocks;
        }

        @Override
        public Term getBlockCompletionCondition(IExecutionBlockStartNode<?> completedNode) throws ProofInputException {
            return null;
        }

        @Override
        public String getFormatedBlockCompletionCondition(IExecutionBlockStartNode<?> completedNode) throws ProofInputException {
            return this.formatedCompletedBlockConditions.get(completedNode);
        }

        public void addCompletedBlock(IExecutionBlockStartNode<?> completedBlock, String formatedCondition) {
            if (completedBlock != null) {
                this.completedBlocks = this.completedBlocks.append(completedBlock);
                this.formatedCompletedBlockConditions.put(completedBlock, formatedCondition);
            }
        }

        @Override
        public IExecutionLink getOutgoingLink(final IExecutionNode<?> target) {
            return (IExecutionLink)CollectionUtil.search(this.outgoingLinks, (IFilter)new IFilter<IExecutionLink>(){

                public boolean select(IExecutionLink element) {
                    return element.getTarget() == target;
                }
            });
        }

        public void addOutgoingLink(IExecutionLink link) {
            this.outgoingLinks = this.outgoingLinks.append((Object)link);
        }

        @Override
        public ImmutableList<IExecutionLink> getOutgoingLinks() {
            return this.outgoingLinks;
        }

        public void addIncomingLink(IExecutionLink link) {
            this.incomingLinks = this.incomingLinks.append((Object)link);
        }

        @Override
        public IExecutionLink getIncomingLink(final IExecutionNode<?> source) {
            return (IExecutionLink)CollectionUtil.search(this.incomingLinks, (IFilter)new IFilter<IExecutionLink>(){

                public boolean select(IExecutionLink element) {
                    return element.getSource() == source;
                }
            });
        }

        @Override
        public ImmutableList<IExecutionLink> getIncomingLinks() {
            return this.incomingLinks;
        }
    }

    public static abstract class AbstractKeYlessExecutionElement
    implements IExecutionElement {
        private final String name;

        public AbstractKeYlessExecutionElement(String name) {
            this.name = name;
        }

        @Override
        public Services getServices() {
            return null;
        }

        @Override
        public InitConfig getInitConfig() {
            return null;
        }

        @Override
        public Proof getProof() {
            return null;
        }

        @Override
        public RuleApp getAppliedRuleApp() {
            return null;
        }

        @Override
        public Node getProofNode() {
            return null;
        }

        @Override
        public NodeInfo getProofNodeInfo() {
            return null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getElementType() + " " + this.getName();
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public ITreeSettings getSettings() {
            return null;
        }
    }

    private class SEDSAXHandler
    extends DefaultHandler {
        private IExecutionNode<?> root;
        private final Deque<AbstractKeYlessExecutionNode<?>> parentNodeStack = new LinkedList();
        private final Deque<Object> parentVariableValueStack = new LinkedList<Object>();
        private final Map<AbstractKeYlessExecutionNode<?>, List<String>> callStackPathEntries = new LinkedHashMap();
        private final Map<KeYlessMethodCall, List<String>> methodReturnPathEntries = new LinkedHashMap<KeYlessMethodCall, List<String>>();
        private final Map<AbstractKeYlessExecutionNode<?>, List<Pair<String, String>>> completedBlockEntries = new LinkedHashMap();
        private final Map<AbstractKeYlessExecutionBlockStartNode<?>, List<String>> blockCompletionEntries = new LinkedHashMap();
        private final Map<AbstractKeYlessExecutionNode<?>, List<String>> outgoingLinks = new LinkedHashMap();
        private final Map<KeYlessStart, List<String>> terminationPathEntries = new LinkedHashMap<KeYlessStart, List<String>>();

        private SEDSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            AbstractKeYlessExecutionNode<?> parent = this.parentNodeStack.peekFirst();
            if (ExecutionNodeReader.this.isConstraint(uri, localName, qName)) {
                Object parentValue = this.parentVariableValueStack.peekFirst();
                if (parentValue != null) {
                    if (!(parentValue instanceof KeYlessValue)) {
                        throw new SAXException("Can't add constraint to variable.");
                    }
                    KeYlessConstraint constraint = new KeYlessConstraint(ExecutionNodeReader.this.getName(attributes));
                    ((KeYlessValue)parentValue).addConstraint(constraint);
                } else {
                    if (!(parent instanceof AbstractKeYlessExecutionNode)) {
                        throw new SAXException("Can't add constraint to non execution node.");
                    }
                    KeYlessConstraint constraint = new KeYlessConstraint(ExecutionNodeReader.this.getName(attributes));
                    parent.addConstraint(constraint);
                }
            } else if (ExecutionNodeReader.this.isCallStateVariable(uri, localName, qName)) {
                Object parentValue = this.parentVariableValueStack.peekFirst();
                KeYlessVariable variable = ExecutionNodeReader.this.createVariable(parentValue instanceof KeYlessValue ? (KeYlessValue)parentValue : null, uri, localName, qName, attributes);
                if (parentValue != null) {
                    throw new SAXException("Can't add initial state variable to parent variable or value.");
                }
                if (!(parent instanceof AbstractKeYlessBaseExecutionNode)) {
                    throw new SAXException("Can't add call state variable to parent execution node.");
                }
                ((AbstractKeYlessBaseExecutionNode)parent).addCallStateVariable(variable);
                this.parentVariableValueStack.addFirst(variable);
            } else if (ExecutionNodeReader.this.isVariable(uri, localName, qName)) {
                Object parentValue = this.parentVariableValueStack.peekFirst();
                KeYlessVariable variable = ExecutionNodeReader.this.createVariable(parentValue instanceof KeYlessValue ? (KeYlessValue)parentValue : null, uri, localName, qName, attributes);
                if (parentValue != null) {
                    ((KeYlessValue)parentValue).addChildVariable(variable);
                } else if (parent != null) {
                    parent.addVariable(variable);
                } else {
                    throw new SAXException("Can't add variable to parent execution node.");
                }
                this.parentVariableValueStack.addFirst(variable);
            } else if (ExecutionNodeReader.this.isValue(uri, localName, qName)) {
                Object parentValue = this.parentVariableValueStack.peekFirst();
                if (!(parentValue instanceof KeYlessVariable)) {
                    throw new SAXException("Can't add value to parent variable.");
                }
                KeYlessValue value = ExecutionNodeReader.this.createValue((KeYlessVariable)parentValue, uri, localName, qName, attributes);
                ((KeYlessVariable)parentValue).addValue(value);
                this.parentVariableValueStack.addFirst(value);
            } else if (ExecutionNodeReader.this.isCallStackEntry(uri, localName, qName)) {
                List<String> callStackEntries = this.callStackPathEntries.get(parent);
                if (callStackEntries == null) {
                    callStackEntries = new LinkedList<String>();
                    this.callStackPathEntries.put(parent, callStackEntries);
                }
                callStackEntries.add(ExecutionNodeReader.this.getPathInTree(attributes));
            } else if (ExecutionNodeReader.this.isMethodReturnEntry(uri, localName, qName)) {
                List<String> methodReturnEntries = this.methodReturnPathEntries.get(parent);
                if (methodReturnEntries == null) {
                    methodReturnEntries = new LinkedList<String>();
                    this.methodReturnPathEntries.put((KeYlessMethodCall)parent, methodReturnEntries);
                }
                methodReturnEntries.add(0, ExecutionNodeReader.this.getPathInTree(attributes));
            } else if (ExecutionNodeReader.this.isCompletedBlockEntry(uri, localName, qName)) {
                List<Pair<String, String>> completedBlocks = this.completedBlockEntries.get(parent);
                if (completedBlocks == null) {
                    completedBlocks = new LinkedList<Pair<String, String>>();
                    this.completedBlockEntries.put(parent, completedBlocks);
                }
                completedBlocks.add((Pair<String, String>)new Pair((Object)ExecutionNodeReader.this.getPathInTree(attributes), (Object)ExecutionNodeReader.this.getConditionString(attributes)));
            } else if (ExecutionNodeReader.this.isBlockCompletionEntry(uri, localName, qName)) {
                List<String> blockCompletionPathEntries = this.blockCompletionEntries.get(parent);
                if (blockCompletionPathEntries == null) {
                    blockCompletionPathEntries = new LinkedList<String>();
                    this.blockCompletionEntries.put((AbstractKeYlessExecutionBlockStartNode)parent, blockCompletionPathEntries);
                }
                blockCompletionPathEntries.add(ExecutionNodeReader.this.getPathInTree(attributes));
            } else if (ExecutionNodeReader.this.isOutgoingLink(uri, localName, qName)) {
                List<String> linkPaths = this.outgoingLinks.get(parent);
                if (linkPaths == null) {
                    linkPaths = new LinkedList<String>();
                    this.outgoingLinks.put(parent, linkPaths);
                }
                linkPaths.add(ExecutionNodeReader.this.getPathInTree(attributes));
            } else if (ExecutionNodeReader.this.isTerminationEntry(uri, localName, qName)) {
                List<String> terminationEntries = this.terminationPathEntries.get(parent);
                if (terminationEntries == null) {
                    terminationEntries = new LinkedList<String>();
                    this.terminationPathEntries.put((KeYlessStart)parent, terminationEntries);
                }
                terminationEntries.add(0, ExecutionNodeReader.this.getPathInTree(attributes));
            } else if (ExecutionNodeReader.this.isMethodReturnValue(uri, localName, qName)) {
                AbstractKeYlessExecutionNode<?> parentValue = this.parentNodeStack.peekFirst();
                if (!(parentValue instanceof KeYlessMethodReturn)) {
                    throw new SAXException("Can't add method return value to parent.");
                }
                KeYlessMethodReturnValue returnValue = ExecutionNodeReader.this.createMethodReturnValue(uri, localName, qName, attributes);
                ((KeYlessMethodReturn)parentValue).addReturnValue(returnValue);
            } else {
                AbstractKeYlessExecutionNode<?> child = ExecutionNodeReader.this.createExecutionNode(parent, uri, localName, qName, attributes);
                if (this.root == null) {
                    this.root = child;
                }
                if (parent != null) {
                    parent.addChild(child);
                }
                this.parentNodeStack.addFirst(child);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!ExecutionNodeReader.this.isConstraint(uri, localName, qName)) {
                if (ExecutionNodeReader.this.isCallStateVariable(uri, localName, qName)) {
                    this.parentVariableValueStack.removeFirst();
                } else if (ExecutionNodeReader.this.isVariable(uri, localName, qName)) {
                    this.parentVariableValueStack.removeFirst();
                } else if (ExecutionNodeReader.this.isValue(uri, localName, qName)) {
                    this.parentVariableValueStack.removeFirst();
                } else if (!(ExecutionNodeReader.this.isCallStackEntry(uri, localName, qName) || ExecutionNodeReader.this.isMethodReturnEntry(uri, localName, qName) || ExecutionNodeReader.this.isCompletedBlockEntry(uri, localName, qName) || ExecutionNodeReader.this.isBlockCompletionEntry(uri, localName, qName) || ExecutionNodeReader.this.isOutgoingLink(uri, localName, qName) || ExecutionNodeReader.this.isTerminationEntry(uri, localName, qName) || ExecutionNodeReader.this.isMethodReturnValue(uri, localName, qName))) {
                    this.parentNodeStack.removeFirst();
                }
            }
        }

        public IExecutionNode<?> getRoot() {
            return this.root;
        }

        public Map<AbstractKeYlessExecutionNode<?>, List<String>> getCallStackPathEntries() {
            return this.callStackPathEntries;
        }

        public Map<KeYlessMethodCall, List<String>> getMethodReturnPathEntries() {
            return this.methodReturnPathEntries;
        }

        public Map<AbstractKeYlessExecutionNode<?>, List<Pair<String, String>>> getCompletedBlockEntries() {
            return this.completedBlockEntries;
        }

        public Map<AbstractKeYlessExecutionBlockStartNode<?>, List<String>> getBlockCompletionEntries() {
            return this.blockCompletionEntries;
        }

        public Map<KeYlessStart, List<String>> getTerminationPathEntries() {
            return this.terminationPathEntries;
        }

        public Map<AbstractKeYlessExecutionNode<?>, List<String>> getOutgoingLinks() {
            return this.outgoingLinks;
        }
    }
}

