/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.SymbolicLayoutExtractor;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class ExecutionNodeSymbolicLayoutExtractor
extends SymbolicLayoutExtractor {
    private final IExecutionNode<?> executionNode;

    public ExecutionNodeSymbolicLayoutExtractor(IExecutionNode<?> executionNode) {
        super(executionNode.getProofNode(), executionNode.getModalityPIO(), executionNode.getSettings().isUseUnicode(), executionNode.getSettings().isUsePrettyPrinting(), executionNode.getSettings().isSimplifyConditions());
        this.executionNode = executionNode;
    }

    @Override
    protected String computeInitialStateName() {
        try {
            return SymbolicExecutionUtil.getRoot(this.executionNode).getName() + " resulting in " + this.computeCurrentStateName();
        }
        catch (ProofInputException e) {
            return e.getMessage();
        }
    }

    @Override
    protected String computeCurrentStateName() {
        try {
            return this.executionNode.getName();
        }
        catch (ProofInputException e) {
            return e.getMessage();
        }
    }
}

