/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.AbstractWriter;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionAuxiliaryContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBaseMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionExceptionalMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionJoin;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLink;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopInvariant;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturnValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionOperationContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStart;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.util.LinkedHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.java.ArrayUtil;

public class ExecutionNodeWriter
extends AbstractWriter {
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_NAME_INCLUDING_RETURN_VALUE = "nameIncludingReturnValue";
    public static final String ATTRIBUTE_SIGNATURE_INCLUDING_RETURN_VALUE = "signatureIncludingReturnValue";
    public static final String ATTRIBUTE_SIGNATURE = "signature";
    public static final String ATTRIBUTE_TERMINATION_KIND = "terminationKind";
    public static final String ATTRIBUTE_TYPE_STRING = "typeString";
    public static final String ATTRIBUTE_VALUE_STRING = "valueString";
    public static final String ATTRIBUTE_CONDITION_STRING = "conditionString";
    public static final String ATTRIBUTE_RETURN_VALUE_STRING = "returnValueString";
    public static final String ATTRIBUTE_HAS_CONDITION = "hasCondition";
    public static final String ATTRIBUTE_BRANCH_VERIFIED = "branchVerified";
    public static final String ATTRIBUTE_ARRAY_INDEX = "arrayIndex";
    public static final String ATTRIBUTE_IS_ARRAY_INDEX = "isArrayIndex";
    public static final String ATTRIBUTE_BRANCH_CONDITION = "branchCondition";
    public static final String ATTRIBUTE_PATH_CONDITION = "pathCondition";
    public static final String ATTRIBUTE_PATH_CONDITION_CHANGED = "pathConditionChanged";
    public static final String ATTRIBUTE_PATH_IN_TREE = "path";
    public static final String ATTRIBUTE_MERGED_BRANCH_CONDITION = "mergedBranchCondition";
    public static final String ATTRIBUTE_IS_VALUE_AN_OBJECT = "isValueAnObject";
    public static final String ATTRIBUTE_IS_VALUE_UNKNOWN = "isValueUnknown";
    public static final String ATTRIBUTE_PRECONDITION_COMPLIED = "preconditionComplied";
    public static final String ATTRIBUTE_HAS_NOT_NULL_CHECK = "hasNotNullCheck";
    public static final String ATTRIBUTE_RETURN_VALUE_COMPUTED = "isReturnValueComputed";
    public static final String ATTRIBUTE_BRANCH_CONDITION_COMPUTED = "isBranchConditionComputed";
    public static final String ATTRIBUTE_NOT_NULL_CHECK_COMPLIED = "notNullCheckComplied";
    public static final String ATTRIBUTE_INITIALLY_VALID = "initiallyValid";
    public static final String ATTRIBUTE_ADDITIONAL_BRANCH_LABEL = "additionalBranchLabel";
    public static final String ATTRIBUTE_METHOD_RETURN_CONDITION = "methodReturnCondition";
    public static final String ATTRIBUTE_RESULT_TERM = "resultTerm";
    public static final String ATTRIBUTE_EXCEPTION_TERM = "exceptionTerm";
    public static final String ATTRIBUTE_SELF_TERM = "selfTerm";
    public static final String ATTRIBUTE_CONTRACT_PARAMETERS = "contractParameters";
    public static final String ATTRIBUTE_BLOCK_OPENED = "blockOpened";
    public static final String ATTRIBUTE_WEAKENING_VERIFIED = "weakeningVerified";
    public static final String TAG_BRANCH_CONDITION = "branchCondition";
    public static final String TAG_START = "start";
    public static final String TAG_BRANCH_STATEMENT = "branchStatement";
    public static final String TAG_LOOP_CONDITION = "loopCondition";
    public static final String TAG_LOOP_STATEMENT = "loopStatement";
    public static final String TAG_METHOD_CALL = "methodCall";
    public static final String TAG_METHOD_RETURN = "methodReturn";
    public static final String TAG_EXCEPTIONAL_METHOD_RETURN = "exceptionalMethodReturn";
    public static final String TAG_METHOD_RETURN_VALUE = "methodReturnValue";
    public static final String TAG_STATEMENT = "statement";
    public static final String TAG_TERMINATION = "termination";
    public static final String TAG_JOIN = "join";
    public static final String TAG_OPERATION_CONTRACT = "operationContract";
    public static final String TAG_BLOCK_CONTRACT = "blockContract";
    public static final String TAG_LOOP_INVARIANT = "loopInvariant";
    public static final String TAG_CONSTRAINT = "constraint";
    public static final String TAG_VARIABLE = "variable";
    public static final String TAG_CALL_STATE_VARIABLE = "callStateVariable";
    public static final String TAG_VALUE = "value";
    public static final String TAG_CALL_STACK_ENTRY = "callStackEntry";
    public static final String TAG_METHOD_RETURN_ENTRY = "methodReturnEntry";
    public static final String TAG_COMPLETED_BLOCK_ENTRY = "completedBlockEntry";
    public static final String TAG_BLOCK_COMPLETION_ENTRY = "blockCompletionEntry";
    public static final String TAG_TERMINATION_ENTRY = "terminationEntry";
    public static final String TAG_OUTGOING_LINK = "outgoingLink";
    public static final char PATH_SEPARATOR = '/';

    public void write(IExecutionNode<?> node, String encoding, File file, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints) throws IOException, ProofInputException {
        this.write(node, encoding, new FileOutputStream(file), saveVariables, saveCallStack, saveReturnValues, saveConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(IExecutionNode<?> node, String encoding, OutputStream out, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints) throws IOException, ProofInputException {
        if (out != null) {
            try {
                Charset charset = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
                String xml = this.toXML(node, charset.displayName(), saveVariables, saveCallStack, saveReturnValues, saveConstraints);
                out.write(xml.getBytes(charset));
            }
            finally {
                out.close();
            }
        }
    }

    public String toXML(IExecutionNode<?> node, String encoding, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints) throws ProofInputException {
        StringBuffer sb = new StringBuffer();
        this.appendXmlHeader(encoding, sb);
        this.appendExecutionNode(0, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        return sb.toString();
    }

    protected void appendExecutionNode(int level, IExecutionNode<?> node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        if (node instanceof IExecutionBranchCondition) {
            this.appendExecutionBranchCondition(level, (IExecutionBranchCondition)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionStart) {
            this.appendExecutionStart(level, (IExecutionStart)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionBranchStatement) {
            this.appendExecutionBranchStatement(level, (IExecutionBranchStatement)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionLoopCondition) {
            this.appendExecutionLoopCondition(level, (IExecutionLoopCondition)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionLoopStatement) {
            this.appendExecutionLoopStatement(level, (IExecutionLoopStatement)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionMethodCall) {
            this.appendExecutionMethodCall(level, (IExecutionMethodCall)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionMethodReturn) {
            this.appendExecutionMethodReturn(level, (IExecutionMethodReturn)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionExceptionalMethodReturn) {
            this.appendExecutionExceptionalMethodReturn(level, (IExecutionExceptionalMethodReturn)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionStatement) {
            this.appendExecutionStatement(level, (IExecutionStatement)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionTermination) {
            this.appendExecutionTermination(level, (IExecutionTermination)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionOperationContract) {
            this.appendExecutionOperationContract(level, (IExecutionOperationContract)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionLoopInvariant) {
            this.appendExecutionLoopInvariant(level, (IExecutionLoopInvariant)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionAuxiliaryContract) {
            this.appendExecutionBlockContract(level, (IExecutionAuxiliaryContract)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else if (node instanceof IExecutionJoin) {
            this.appendExecutionJoin(level, (IExecutionJoin)node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        } else {
            throw new IllegalArgumentException("Not supported node \"" + node + "\".");
        }
    }

    protected void appendExecutionBranchCondition(int level, IExecutionBranchCondition node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put("branchCondition", node.getFormatedBranchCondition());
        attributeValues.put(ATTRIBUTE_MERGED_BRANCH_CONDITION, "" + node.isMergedBranchCondition());
        attributeValues.put(ATTRIBUTE_BRANCH_CONDITION_COMPUTED, "" + node.isBranchConditionComputed());
        attributeValues.put(ATTRIBUTE_ADDITIONAL_BRANCH_LABEL, node.getAdditionalBranchLabel());
        this.appendStartTag(level, "branchCondition", (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, "branchCondition", sb);
    }

    protected void appendExecutionStart(int level, IExecutionStart node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        this.appendStartTag(level, TAG_START, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendTerminations(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_START, sb);
    }

    protected void appendTerminations(int level, IExecutionStart node, StringBuffer sb) {
        ImmutableList<IExecutionTermination> terminations = node.getTerminations();
        if (terminations != null) {
            for (IExecutionTermination termination : terminations) {
                LinkedHashMap attributeValues = new LinkedHashMap();
                attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(termination));
                this.appendEmptyTag(level, TAG_TERMINATION_ENTRY, (Map<String, String>)attributeValues, sb);
            }
        }
    }

    protected void appendExecutionBranchStatement(int level, IExecutionBranchStatement node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_BLOCK_OPENED, "" + node.isBlockOpened());
        this.appendStartTag(level, TAG_BRANCH_STATEMENT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendBlockCompletions(level + 1, node, sb);
        this.appendEndTag(level, TAG_BRANCH_STATEMENT, sb);
    }

    protected void appendExecutionLoopCondition(int level, IExecutionLoopCondition node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_BLOCK_OPENED, "" + node.isBlockOpened());
        this.appendStartTag(level, TAG_LOOP_CONDITION, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendBlockCompletions(level + 1, node, sb);
        this.appendEndTag(level, TAG_LOOP_CONDITION, sb);
    }

    protected void appendExecutionLoopStatement(int level, IExecutionLoopStatement node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_BLOCK_OPENED, "" + node.isBlockOpened());
        this.appendStartTag(level, TAG_LOOP_STATEMENT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendBlockCompletions(level + 1, node, sb);
        this.appendEndTag(level, TAG_LOOP_STATEMENT, sb);
    }

    protected void appendExecutionMethodCall(int level, IExecutionMethodCall node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        this.appendStartTag(level, TAG_METHOD_CALL, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendMethodReturns(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_METHOD_CALL, sb);
    }

    protected void appendExecutionMethodReturn(int level, IExecutionMethodReturn node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_SIGNATURE, node.getSignature());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        if (saveReturnValues) {
            attributeValues.put(ATTRIBUTE_NAME_INCLUDING_RETURN_VALUE, node.getNameIncludingReturnValue());
            attributeValues.put(ATTRIBUTE_SIGNATURE_INCLUDING_RETURN_VALUE, node.getSignatureIncludingReturnValue());
        }
        attributeValues.put(ATTRIBUTE_RETURN_VALUE_COMPUTED, "" + node.isReturnValuesComputed());
        attributeValues.put(ATTRIBUTE_METHOD_RETURN_CONDITION, node.getFormatedMethodReturnCondition());
        this.appendStartTag(level, TAG_METHOD_RETURN, (Map<String, String>)attributeValues, sb);
        if (saveReturnValues) {
            IExecutionMethodReturnValue[] returnValues;
            for (IExecutionMethodReturnValue returnValue : returnValues = node.getReturnValues()) {
                this.appendExecutionMethodReturnValue(level + 1, returnValue, sb);
            }
        }
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendCallStateVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendEndTag(level, TAG_METHOD_RETURN, sb);
    }

    protected void appendExecutionExceptionalMethodReturn(int level, IExecutionExceptionalMethodReturn node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_SIGNATURE, node.getSignature());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_METHOD_RETURN_CONDITION, node.getFormatedMethodReturnCondition());
        this.appendStartTag(level, TAG_EXCEPTIONAL_METHOD_RETURN, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendCallStateVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendEndTag(level, TAG_EXCEPTIONAL_METHOD_RETURN, sb);
    }

    protected void appendExecutionMethodReturnValue(int level, IExecutionMethodReturnValue returnValue, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, returnValue.getName());
        attributeValues.put(ATTRIBUTE_RETURN_VALUE_STRING, returnValue.getReturnValueString());
        attributeValues.put(ATTRIBUTE_HAS_CONDITION, "" + returnValue.hasCondition());
        attributeValues.put(ATTRIBUTE_CONDITION_STRING, returnValue.getConditionString());
        this.appendStartTag(level, TAG_METHOD_RETURN_VALUE, (Map<String, String>)attributeValues, sb);
        this.appendEndTag(level, TAG_METHOD_RETURN_VALUE, sb);
    }

    protected void appendExecutionStatement(int level, IExecutionStatement node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        this.appendStartTag(level, TAG_STATEMENT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_STATEMENT, sb);
    }

    protected void appendExecutionJoin(int level, IExecutionJoin node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_WEAKENING_VERIFIED, "" + node.isWeakeningVerified());
        this.appendStartTag(level, TAG_JOIN, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_JOIN, sb);
    }

    protected void appendExecutionOperationContract(int level, IExecutionOperationContract node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_RESULT_TERM, node.getFormatedResultTerm());
        attributeValues.put(ATTRIBUTE_EXCEPTION_TERM, node.getFormatedExceptionTerm());
        attributeValues.put(ATTRIBUTE_SELF_TERM, node.getFormatedSelfTerm());
        attributeValues.put(ATTRIBUTE_CONTRACT_PARAMETERS, node.getFormatedContractParams());
        attributeValues.put(ATTRIBUTE_PRECONDITION_COMPLIED, "" + node.isPreconditionComplied());
        attributeValues.put(ATTRIBUTE_HAS_NOT_NULL_CHECK, "" + node.hasNotNullCheck());
        attributeValues.put(ATTRIBUTE_NOT_NULL_CHECK_COMPLIED, "" + node.isNotNullCheckComplied());
        this.appendStartTag(level, TAG_OPERATION_CONTRACT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_OPERATION_CONTRACT, sb);
    }

    protected void appendExecutionLoopInvariant(int level, IExecutionLoopInvariant node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_INITIALLY_VALID, "" + node.isInitiallyValid());
        this.appendStartTag(level, TAG_LOOP_INVARIANT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_LOOP_INVARIANT, sb);
    }

    protected void appendExecutionBlockContract(int level, IExecutionAuxiliaryContract node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_PRECONDITION_COMPLIED, "" + node.isPreconditionComplied());
        this.appendStartTag(level, TAG_BLOCK_CONTRACT, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_BLOCK_CONTRACT, sb);
    }

    protected void appendExecutionTermination(int level, IExecutionTermination node, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, node.getName());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION, node.getFormatedPathCondition());
        attributeValues.put(ATTRIBUTE_PATH_CONDITION_CHANGED, "" + node.isPathConditionChanged());
        attributeValues.put(ATTRIBUTE_TERMINATION_KIND, node.getTerminationKind().toString());
        attributeValues.put(ATTRIBUTE_BRANCH_VERIFIED, "" + node.isBranchVerified());
        this.appendStartTag(level, TAG_TERMINATION, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, node, saveConstraints, sb);
        this.appendVariables(level + 1, node, saveVariables, saveConstraints, sb);
        this.appendCallStack(level + 1, node, saveCallStack, sb);
        this.appendChildren(level + 1, node, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        this.appendOutgoingLinks(level + 1, node, sb);
        this.appendCompletedBlocks(level + 1, node, sb);
        this.appendEndTag(level, TAG_TERMINATION, sb);
    }

    protected void appendConstraints(int level, IExecutionValue value, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        if (saveConstraints) {
            IExecutionConstraint[] constraints;
            for (IExecutionConstraint constraint : constraints = value.getConstraints()) {
                this.appendConstraint(level, constraint, sb);
            }
        }
    }

    protected void appendConstraints(int level, IExecutionNode<?> node, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        if (saveConstraints) {
            IExecutionConstraint[] constraints;
            for (IExecutionConstraint constraint : constraints = node.getConstraints()) {
                this.appendConstraint(level, constraint, sb);
            }
        }
    }

    protected void appendConstraint(int level, IExecutionConstraint constraint, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, constraint.getName());
        this.appendEmptyTag(level, TAG_CONSTRAINT, (Map<String, String>)attributeValues, sb);
    }

    protected void appendVariables(int level, IExecutionNode<?> node, boolean saveVariables, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        if (saveVariables) {
            IExecutionVariable[] variables;
            for (IExecutionVariable variable : variables = node.getVariables()) {
                this.appendVariable(level, variable, saveConstraints, TAG_VARIABLE, sb);
            }
        }
    }

    protected void appendCallStateVariables(int level, IExecutionBaseMethodReturn<?> node, boolean saveVariables, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        if (saveVariables) {
            IExecutionVariable[] variables;
            for (IExecutionVariable variable : variables = node.getCallStateVariables()) {
                this.appendVariable(level, variable, saveConstraints, TAG_CALL_STATE_VARIABLE, sb);
            }
        }
    }

    protected void appendVariable(int level, IExecutionVariable variable, boolean saveConstraints, String tagName, StringBuffer sb) throws ProofInputException {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, variable.getName());
        attributeValues.put(ATTRIBUTE_ARRAY_INDEX, variable.getArrayIndexString());
        attributeValues.put(ATTRIBUTE_IS_ARRAY_INDEX, "" + variable.isArrayIndex());
        this.appendStartTag(level, tagName, (Map<String, String>)attributeValues, sb);
        this.appendValues(level + 1, variable, saveConstraints, sb);
        this.appendEndTag(level, tagName, sb);
    }

    protected void appendValues(int level, IExecutionVariable variable, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        IExecutionValue[] values;
        for (IExecutionValue value : values = variable.getValues()) {
            this.appendValue(level, value, saveConstraints, sb);
        }
    }

    protected void appendValue(int level, IExecutionValue value, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        IExecutionVariable[] childVariables;
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, value.getName());
        attributeValues.put(ATTRIBUTE_TYPE_STRING, value.getTypeString());
        attributeValues.put(ATTRIBUTE_VALUE_STRING, value.getValueString());
        attributeValues.put(ATTRIBUTE_IS_VALUE_AN_OBJECT, "" + value.isValueAnObject());
        attributeValues.put(ATTRIBUTE_IS_VALUE_UNKNOWN, "" + value.isValueUnknown());
        attributeValues.put(ATTRIBUTE_CONDITION_STRING, value.getConditionString());
        this.appendStartTag(level, TAG_VALUE, (Map<String, String>)attributeValues, sb);
        this.appendConstraints(level + 1, value, saveConstraints, sb);
        for (IExecutionVariable childVariable : childVariables = value.getChildVariables()) {
            this.appendVariable(level + 1, childVariable, saveConstraints, TAG_VARIABLE, sb);
        }
        this.appendEndTag(level, TAG_VALUE, sb);
    }

    protected void appendChildren(int childLevel, IExecutionNode<?> parent, boolean saveVariables, boolean saveCallStack, boolean saveReturnValues, boolean saveConstraints, StringBuffer sb) throws ProofInputException {
        IExecutionNode<?>[] children;
        for (IExecutionNode<?> child : children = parent.getChildren()) {
            this.appendExecutionNode(childLevel, child, saveVariables, saveCallStack, saveReturnValues, saveConstraints, sb);
        }
    }

    protected void appendOutgoingLinks(int level, IExecutionNode<?> node, StringBuffer sb) {
        if (!node.getOutgoingLinks().isEmpty()) {
            for (IExecutionLink link : node.getOutgoingLinks()) {
                this.appendOutgoingLink(level, link, sb);
            }
        }
    }

    protected void appendOutgoingLink(int level, IExecutionLink link, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(link.getTarget()));
        this.appendEmptyTag(level, TAG_OUTGOING_LINK, (Map<String, String>)attributeValues, sb);
    }

    protected void appendCallStack(int level, IExecutionNode<?> node, boolean saveCallStack, StringBuffer sb) {
        IExecutionNode<?>[] callStack;
        if (saveCallStack && (callStack = node.getCallStack()) != null) {
            for (IExecutionNode<?> stackNode : callStack) {
                LinkedHashMap attributeValues = new LinkedHashMap();
                attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(stackNode));
                this.appendEmptyTag(level, TAG_CALL_STACK_ENTRY, (Map<String, String>)attributeValues, sb);
            }
        }
    }

    protected void appendMethodReturns(int level, IExecutionMethodCall node, StringBuffer sb) {
        ImmutableList<IExecutionBaseMethodReturn<?>> methodReturns = node.getMethodReturns();
        if (methodReturns != null) {
            for (IExecutionBaseMethodReturn methodReturn : methodReturns) {
                LinkedHashMap attributeValues = new LinkedHashMap();
                attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(methodReturn));
                this.appendEmptyTag(level, TAG_METHOD_RETURN_ENTRY, (Map<String, String>)attributeValues, sb);
            }
        }
    }

    protected void appendCompletedBlocks(int level, IExecutionNode<?> node, StringBuffer sb) throws ProofInputException {
        ImmutableList<IExecutionBlockStartNode<?>> completedBlocks = node.getCompletedBlocks();
        if (completedBlocks != null) {
            for (IExecutionBlockStartNode completedBlock : completedBlocks) {
                LinkedHashMap attributeValues = new LinkedHashMap();
                attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(completedBlock));
                attributeValues.put(ATTRIBUTE_CONDITION_STRING, node.getFormatedBlockCompletionCondition(completedBlock));
                this.appendEmptyTag(level, TAG_COMPLETED_BLOCK_ENTRY, (Map<String, String>)attributeValues, sb);
            }
        }
    }

    protected void appendBlockCompletions(int level, IExecutionBlockStartNode<?> node, StringBuffer sb) throws ProofInputException {
        ImmutableList<IExecutionNode<?>> blockCompletions = node.getBlockCompletions();
        if (blockCompletions != null) {
            for (IExecutionNode blockCompletion : blockCompletions) {
                LinkedHashMap attributeValues = new LinkedHashMap();
                attributeValues.put(ATTRIBUTE_PATH_IN_TREE, this.computePath(blockCompletion));
                this.appendEmptyTag(level, TAG_BLOCK_COMPLETION_ENTRY, (Map<String, String>)attributeValues, sb);
            }
        }
    }

    protected String computePath(IExecutionNode<?> node) {
        StringBuffer sb = new StringBuffer();
        boolean afterFirst = false;
        while (node != null) {
            IExecutionNode<?> parent = node.getParent();
            if (parent != null) {
                if (afterFirst) {
                    sb.insert(0, '/');
                } else {
                    afterFirst = true;
                }
                int index = ArrayUtil.indexOf((Object[])parent.getChildren(), node);
                assert (index >= 0) : "Node \"" + node + "\" is not contained in parents children \"" + Arrays.toString(parent.getChildren()) + "\".";
                sb.insert(0, index);
            } else {
                sb.insert(0, '/');
            }
            node = parent;
        }
        return sb.toString();
    }
}

