/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.AbstractUpdateExtractor;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.ObjectUtil;

public class ExecutionVariableExtractor
extends AbstractUpdateExtractor {
    private final IExecutionNode<?> executionNode;
    private final Term additionalCondition;
    private final Term layoutTerm;
    private final Set<AbstractUpdateExtractor.ExtractLocationParameter> currentLocations;
    private final Set<Term> objectsToIgnore;
    private final Map<LocationDefinition, StateExecutionVariable> allStateVariables;
    private final boolean simplifyConditions;

    public ExecutionVariableExtractor(Node node, PosInOccurrence modalityPio, IExecutionNode<?> executionNode, Term condition, boolean simplifyConditions) throws ProofInputException {
        super(node, modalityPio);
        this.executionNode = executionNode;
        this.additionalCondition = condition;
        this.simplifyConditions = simplifyConditions;
        Term pathCondition = SymbolicExecutionUtil.computePathCondition(executionNode.getProofNode(), true, false);
        pathCondition = this.removeImplicitSubTermsFromPathCondition(pathCondition);
        LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter> temporaryCurrentLocations = new LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter>();
        this.objectsToIgnore = this.computeInitialObjectsToIgnore(false, false);
        LinkedHashSet<Term> updateCreatedObjects = new LinkedHashSet<Term>();
        LinkedHashSet<Term> updateValueObjects = new LinkedHashSet<Term>();
        this.collectLocationsFromUpdates(node.sequent(), temporaryCurrentLocations, updateCreatedObjects, updateValueObjects, this.objectsToIgnore);
        this.objectsToIgnore.addAll(updateCreatedObjects);
        Set<AbstractUpdateExtractor.ExtractLocationParameter> initialLocations = this.extractLocationsFromTerm(pathCondition, this.objectsToIgnore);
        initialLocations.addAll(this.extractLocationsFromSequent(node.sequent(), this.objectsToIgnore));
        this.currentLocations = new LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter>(initialLocations);
        this.currentLocations.addAll(temporaryCurrentLocations);
        this.layoutTerm = this.createLocationPredicateAndTerm(this.currentLocations);
        this.allStateVariables = new LinkedHashMap<LocationDefinition, StateExecutionVariable>();
        for (AbstractUpdateExtractor.ExtractLocationParameter location : this.currentLocations) {
            LocationDefinition locDef;
            if (!location.isStateMember() || this.allStateVariables.containsKey(locDef = new LocationDefinition(location.getProgramVariable(), location.getArrayIndex()))) continue;
            StateExecutionVariable variable = new StateExecutionVariable(executionNode, node, modalityPio, (IProgramVariable)location.getProgramVariable(), location.getArrayIndex(), this.additionalCondition);
            this.allStateVariables.put(locDef, variable);
        }
    }

    public IExecutionVariable[] analyse() throws ProofInputException {
        Collection<StateExecutionVariable> variables = this.allStateVariables.values();
        return variables.toArray(new StateExecutionVariable[variables.size()]);
    }

    protected void analyzeTreeStructure(Set<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> topVariables, Map<ParentDefinition, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>> contentMap) {
        for (AbstractUpdateExtractor.ExecutionVariableValuePair pair : pairs) {
            LocationDefinition locDef;
            List<AbstractUpdateExtractor.ExecutionVariableValuePair> locationContent;
            if (pair.isStateMember()) {
                LocationDefinition locDef2 = new LocationDefinition(pair.getProgramVariable(), pair.getArrayIndex());
                List<AbstractUpdateExtractor.ExecutionVariableValuePair> currentTopPairs = topVariables.get(locDef2);
                if (currentTopPairs == null) {
                    currentTopPairs = new LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>();
                    topVariables.put(locDef2, currentTopPairs);
                }
                currentTopPairs.add(pair);
                continue;
            }
            ParentDefinition parentDef = new ParentDefinition(pair.getParent(), pair.getGoalNode());
            Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> content = contentMap.get(parentDef);
            if (content == null) {
                content = new LinkedHashMap<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>();
                contentMap.put(parentDef, content);
            }
            if ((locationContent = content.get(locDef = new LocationDefinition(pair.getProgramVariable(), pair.getArrayIndex()))) == null) {
                locationContent = new LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>();
                content.put(locDef, locationContent);
            }
            locationContent.add(pair);
        }
    }

    protected IExecutionVariable createVariablesValueStructure(List<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs, Map<ParentDefinition, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>> contentMap, ExtractedExecutionValue parentValue, ImmutableList<Term> alreadyVisitedObjects) throws ProofInputException {
        assert (!pairs.isEmpty());
        AbstractUpdateExtractor.ExecutionVariableValuePair firstPair = pairs.get(0);
        ExtractedExecutionVariable variable = new ExtractedExecutionVariable(this.executionNode, this.node, this.modalityPio, (IProgramVariable)firstPair.getProgramVariable(), firstPair.getArrayIndex(), firstPair.getArrayStartIndex(), firstPair.getArrayEndIndex(), this.additionalCondition, parentValue);
        if (parentValue != null) {
            parentValue.addChildVariable(variable);
        }
        LinkedList<IExecutionValue> values = new LinkedList<IExecutionValue>();
        this.createValues(variable, pairs, firstPair, contentMap, values, alreadyVisitedObjects);
        variable.setValues(values);
        return variable;
    }

    protected void createValues(IExecutionVariable variable, List<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs, AbstractUpdateExtractor.ExecutionVariableValuePair firstPair, Map<ParentDefinition, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>> contentMap, List<IExecutionValue> valueListToFill, ImmutableList<Term> alreadyVisitedObjects) throws ProofInputException {
        LinkedHashMap<Term, LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>> groupedPairs = new LinkedHashMap<Term, LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>>();
        for (AbstractUpdateExtractor.ExecutionVariableValuePair pair : pairs) {
            assert (firstPair.getProgramVariable() == pair.getProgramVariable());
            assert (firstPair.getArrayIndex() == pair.getArrayIndex());
            assert (firstPair.isArrayIndex() == pair.isArrayIndex());
            assert (firstPair.getArrayStartIndex() == pair.getArrayStartIndex());
            assert (firstPair.getArrayEndIndex() == pair.getArrayEndIndex());
            assert (firstPair.isArrayRange() == pair.isArrayRange());
            LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair> values = (LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>)groupedPairs.get(pair.getValue());
            if (values == null) {
                values = new LinkedList<AbstractUpdateExtractor.ExecutionVariableValuePair>();
                groupedPairs.put(pair.getValue(), values);
            }
            values.add(pair);
        }
        for (List group : groupedPairs.values()) {
            if (group.size() == 1) {
                ParentDefinition parentDef;
                Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> content;
                AbstractUpdateExtractor.ExecutionVariableValuePair pair = (AbstractUpdateExtractor.ExecutionVariableValuePair)group.get(0);
                ExtractedExecutionValue value = new ExtractedExecutionValue(this.executionNode, this.node, variable, pair.getCondition(), pair.getValue());
                valueListToFill.add(value);
                Iterator cycleCheckResult = this.updateAlreadyVisitedObjects(alreadyVisitedObjects, pair.getValue());
                if (((Boolean)((Pair)cycleCheckResult).first).booleanValue() || (content = contentMap.get(parentDef = new ParentDefinition(pair.getValue(), pair.getGoalNode()))) == null) continue;
                for (List<AbstractUpdateExtractor.ExecutionVariableValuePair> child : content.values()) {
                    this.createVariablesValueStructure(child, contentMap, value, (ImmutableList<Term>)((ImmutableList)((Pair)cycleCheckResult).second));
                }
                continue;
            }
            LinkedList<Term> conditions = new LinkedList<Term>();
            LinkedHashMap childContentMap = new LinkedHashMap();
            for (AbstractUpdateExtractor.ExecutionVariableValuePair pair : group) {
                conditions.add(pair.getCondition());
                ParentDefinition parentDef = new ParentDefinition(pair.getValue(), pair.getGoalNode());
                Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> content = contentMap.get(parentDef);
                if (content == null) continue;
                for (Map.Entry<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> entry : content.entrySet()) {
                    LinkedList childList = (LinkedList)childContentMap.get(entry.getKey());
                    if (childList == null) {
                        childList = new LinkedList();
                        childContentMap.put(entry.getKey(), childList);
                    }
                    childList.addAll(entry.getValue());
                }
            }
            Services services = this.getServices();
            Term comboundPathCondition = services.getTermBuilder().or(conditions);
            if (this.simplifyConditions) {
                comboundPathCondition = SymbolicExecutionUtil.simplify(this.getProof().getInitConfig(), this.getProof(), comboundPathCondition);
            }
            comboundPathCondition = SymbolicExecutionUtil.improveReadability(comboundPathCondition, services);
            ExtractedExecutionValue value = new ExtractedExecutionValue(this.executionNode, this.node, variable, comboundPathCondition, ((AbstractUpdateExtractor.ExecutionVariableValuePair)group.get(0)).getValue());
            valueListToFill.add(value);
            Pair<Boolean, ImmutableList<Term>> cycleCheckResult = this.updateAlreadyVisitedObjects(alreadyVisitedObjects, ((AbstractUpdateExtractor.ExecutionVariableValuePair)group.get(0)).getValue());
            if (((Boolean)cycleCheckResult.first).booleanValue() || childContentMap.isEmpty()) continue;
            for (List child : childContentMap.values()) {
                this.createVariablesValueStructure(child, contentMap, value, (ImmutableList<Term>)((ImmutableList)cycleCheckResult.second));
            }
        }
    }

    protected Pair<Boolean, ImmutableList<Term>> updateAlreadyVisitedObjects(ImmutableList<Term> alreadyVisitedObjects, Term value) {
        ImmutableList alreadyVisitedObjectsForChildren = alreadyVisitedObjects;
        boolean cycleDetected = false;
        if (value != null && SymbolicExecutionUtil.hasReferenceSort(this.getServices(), value) && !SymbolicExecutionUtil.isNullSort(value.sort(), this.getServices())) {
            if (!alreadyVisitedObjects.contains((Object)value)) {
                alreadyVisitedObjectsForChildren = alreadyVisitedObjectsForChildren.prepend((Object)value);
            } else {
                cycleDetected = true;
            }
        }
        return new Pair((Object)cycleDetected, alreadyVisitedObjectsForChildren);
    }

    public static class ExtractedExecutionValue
    extends AbstractExecutionValue {
        private final List<ExtractedExecutionVariable> childVariables = new LinkedList<ExtractedExecutionVariable>();
        private final IExecutionNode<?> parentNode;

        public ExtractedExecutionValue(IExecutionNode<?> parentNode, Node proofNode, IExecutionVariable variable, Term condition, Term value) {
            super(parentNode.getSettings(), proofNode, variable, condition, value);
            this.parentNode = parentNode;
        }

        @Override
        public String getConditionString() throws ProofInputException {
            return this.getCondition() != null ? this.formatTerm(this.getCondition(), this.getServices()) : null;
        }

        @Override
        public boolean isValueUnknown() throws ProofInputException {
            return false;
        }

        @Override
        public String getValueString() throws ProofInputException {
            return this.getValue() != null ? this.formatTerm(this.getValue(), this.getServices()) : null;
        }

        @Override
        public String getTypeString() throws ProofInputException {
            return this.getValue() != null && this.getValue().sort() != null ? this.getValue().sort().toString() : null;
        }

        protected void addChildVariable(ExtractedExecutionVariable variable) {
            if (variable != null) {
                this.childVariables.add(variable);
            }
        }

        public ExtractedExecutionVariable[] getChildVariables() throws ProofInputException {
            return this.childVariables.toArray(new ExtractedExecutionVariable[this.childVariables.size()]);
        }

        @Override
        protected IExecutionConstraint[] getNodeConstraints() {
            return this.parentNode.getConstraints();
        }
    }

    public static class ExtractedExecutionVariable
    extends AbstractExecutionVariable {
        private List<IExecutionValue> values;
        private final Term arrayStartIndex;
        private final Term arrayEndIndex;

        public ExtractedExecutionVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, IProgramVariable programVariable, Term arrayIndex, Term arrayStartIndex, Term arrayEndIndex, Term additionalCondition, ExtractedExecutionValue parentValue) {
            super(parentNode.getSettings(), proofNode, programVariable, parentValue, arrayIndex, additionalCondition, modalityPIO);
            this.arrayStartIndex = arrayStartIndex;
            this.arrayEndIndex = arrayEndIndex;
        }

        private void setValues(List<IExecutionValue> values) {
            this.values = values;
        }

        @Override
        public IExecutionValue[] getValues() throws ProofInputException {
            return this.values.toArray(new IExecutionValue[this.values.size()]);
        }

        @Override
        public Term createSelectTerm() {
            return SymbolicExecutionUtil.createSelectTerm(this);
        }

        public Term getArrayStartIndex() {
            return this.arrayStartIndex;
        }

        public String getArrayStartIndexString() {
            return this.arrayStartIndex != null ? this.formatTerm(this.arrayStartIndex, this.getServices()) : null;
        }

        public Term getArrayEndIndex() {
            return this.arrayEndIndex;
        }

        public String getArrayEndIndexString() {
            return this.arrayEndIndex != null ? this.formatTerm(this.arrayEndIndex, this.getServices()) : null;
        }

        @Override
        protected String lazyComputeName() throws ProofInputException {
            if (this.getArrayStartIndex() != null || this.getArrayEndIndex() != null) {
                Object name = "[";
                if (this.getArrayStartIndex() != null) {
                    name = (String)name + this.getArrayIndexString() + " >= " + this.getArrayStartIndexString();
                }
                if (this.getArrayStartIndex() != null && this.getArrayEndIndex() != null) {
                    name = (String)name + " and ";
                }
                if (this.getArrayEndIndex() != null) {
                    name = (String)name + this.getArrayIndexString() + " <= " + this.getArrayEndIndexString();
                }
                name = (String)name + "]";
                return name;
            }
            return super.lazyComputeName();
        }
    }

    private class StateExecutionVariable
    extends AbstractExecutionVariable {
        private IExecutionValue[] values;

        public StateExecutionVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, IProgramVariable programVariable, Term arrayIndex, Term additionalCondition) {
            super(parentNode.getSettings(), proofNode, programVariable, null, arrayIndex, additionalCondition, modalityPIO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExecutionValue[] getValues() throws ProofInputException {
            if (this.values == null) {
                Map<LocationDefinition, StateExecutionVariable> map = ExecutionVariableExtractor.this.allStateVariables;
                synchronized (map) {
                    if (this.values == null) {
                        Set<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs = ExecutionVariableExtractor.this.computeVariableValuePairs(this.getAdditionalCondition(), ExecutionVariableExtractor.this.layoutTerm, ExecutionVariableExtractor.this.currentLocations, true, ExecutionVariableExtractor.this.simplifyConditions);
                        if (pairs != null) {
                            LinkedHashMap<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>> topVariables = new LinkedHashMap<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>();
                            LinkedHashMap<ParentDefinition, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>> contentMap = new LinkedHashMap<ParentDefinition, Map<LocationDefinition, List<AbstractUpdateExtractor.ExecutionVariableValuePair>>>();
                            ExecutionVariableExtractor.this.analyzeTreeStructure(pairs, topVariables, contentMap);
                            for (List pairsList : topVariables.values()) {
                                AbstractUpdateExtractor.ExecutionVariableValuePair firstPair = (AbstractUpdateExtractor.ExecutionVariableValuePair)pairsList.get(0);
                                LinkedList<IExecutionValue> values = new LinkedList<IExecutionValue>();
                                StateExecutionVariable variable = ExecutionVariableExtractor.this.allStateVariables.get(new LocationDefinition(firstPair.getProgramVariable(), firstPair.getArrayIndex()));
                                assert (variable != null);
                                ExecutionVariableExtractor.this.createValues(variable, pairsList, firstPair, contentMap, values, (ImmutableList<Term>)ImmutableSLList.nil());
                                variable.values = values.toArray(new IExecutionValue[values.size()]);
                            }
                        } else {
                            this.values = new IExecutionValue[0];
                        }
                    }
                }
            }
            return this.values;
        }

        @Override
        public Term createSelectTerm() {
            return SymbolicExecutionUtil.createSelectTerm(this);
        }
    }

    private static final class LocationDefinition {
        private final ProgramVariable programVariable;
        private final Term arrayIndex;

        public LocationDefinition(ProgramVariable programVariable, Term arrayIndex) {
            this.programVariable = programVariable;
            this.arrayIndex = arrayIndex;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocationDefinition) {
                LocationDefinition other = (LocationDefinition)obj;
                return this.programVariable == other.programVariable && ObjectUtil.equals((Object)this.arrayIndex, (Object)other.arrayIndex);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.programVariable != null ? this.programVariable.hashCode() : 0);
            result = 31 * result + (this.arrayIndex != null ? this.arrayIndex.hashCode() : 0);
            return result;
        }
    }

    private static final class ParentDefinition {
        private final Term parent;
        private final Node goalNode;

        public ParentDefinition(Term parent, Node goalNode) {
            this.parent = parent;
            this.goalNode = goalNode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParentDefinition) {
                ParentDefinition other = (ParentDefinition)obj;
                return ObjectUtil.equals((Object)this.parent, (Object)other.parent) && ObjectUtil.equals((Object)this.goalNode, (Object)other.goalNode);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.goalNode != null ? this.goalNode.hashCode() : 0);
            return result;
        }
    }
}

