/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.JavaProgramElement;
import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.statement.If;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.java.visitor.JavaASTVisitor;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.label.BlockContractValidityTermLabel;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabel;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofVisitor;
import de.uka.ilkd.key.proof.init.AbstractOperationPO;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.merge.MergePartner;
import de.uka.ilkd.key.rule.merge.MergeRuleBuiltInRuleApp;
import de.uka.ilkd.key.symbolic_execution.ExecutionNodePreorderIterator;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBaseMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLink;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStart;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionAuxiliaryContract;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionBranchStatement;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionExceptionalMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionJoin;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionLink;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionLoopCondition;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionLoopInvariant;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionLoopStatement;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionOperationContract;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionStart;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionStatement;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.impl.TreeSettings;
import de.uka.ilkd.key.symbolic_execution.util.DefaultEntry;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.NodePreorderIterator;
import de.uka.ilkd.key.util.Pair;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.ArrayUtil;

public class SymbolicExecutionTreeBuilder {
    private Proof proof;
    private ExecutionStart startNode;
    private Map<Node, AbstractExecutionNode<?>> keyNodeMapping = new LinkedHashMap();
    private Map<Node, List<AbstractExecutionNode<?>>> multipleExecutionNodes = new LinkedHashMap();
    private Map<Node, ExecutionLoopCondition> keyNodeLoopConditionMapping = new LinkedHashMap<Node, ExecutionLoopCondition>();
    private Map<Node, ExecutionBranchCondition> keyNodeBranchConditionMapping = new LinkedHashMap<Node, ExecutionBranchCondition>();
    private Map<Integer, Map<Node, ImmutableList<Node>>> methodCallStackMap = new LinkedHashMap<Integer, Map<Node, ImmutableList<Node>>>();
    private Map<Integer, Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>>> afterBlockMap = new LinkedHashMap();
    private Map<Integer, Set<Node>> methodReturnsToIgnoreMap = new LinkedHashMap<Integer, Set<Node>>();
    private IProgramVariable exceptionVariable;
    private final TreeSettings settings;
    private final boolean isUninterpretedPredicateUsed;
    private final Deque<Map.Entry<AbstractExecutionNode<?>, List<ExecutionBranchCondition>>> branchConditionsStack = new LinkedList();

    public SymbolicExecutionTreeBuilder(Proof proof, boolean mergeBranchConditions, boolean useUnicode, boolean usePrettyPrinting, boolean variablesAreOnlyComputedFromUpdates, boolean simplifyConditions) {
        assert (proof != null);
        this.proof = proof;
        this.isUninterpretedPredicateUsed = AbstractOperationPO.getUninterpretedPredicate((Proof)this.getProof()) != null;
        this.settings = new TreeSettings(mergeBranchConditions, useUnicode, usePrettyPrinting, variablesAreOnlyComputedFromUpdates, simplifyConditions);
        this.exceptionVariable = SymbolicExecutionUtil.extractExceptionVariable(proof);
        this.startNode = new ExecutionStart(this.settings, proof.root());
        this.keyNodeMapping.put(proof.root(), this.startNode);
        this.initMethodCallStack(proof.root(), proof.getServices());
    }

    protected void initMethodCallStack(final Node root, Services services) {
        final LinkedList modalityTerms = new LinkedList();
        for (SequentFormula sequentFormula : root.sequent().succedent()) {
            sequentFormula.formula().execPreOrder((Visitor)new DefaultVisitor(){

                public void visit(Term visited) {
                    if (visited.op() instanceof Modality && SymbolicExecutionUtil.hasSymbolicExecutionLabel(visited)) {
                        modalityTerms.add(visited);
                    }
                }
            });
        }
        if (modalityTerms.isEmpty()) {
            throw new IllegalStateException("Sequent contains no modalities with symbolic execution label.");
        }
        if (modalityTerms.size() >= 2) {
            throw new IllegalStateException("Sequent contains multiple modalities with symbolic execution label.");
        }
        Term modalityTerm = (Term)modalityTerms.get(0);
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(modalityTerm);
        if (label == null) {
            throw new IllegalStateException("Modality \"" + modalityTerm + "\" has no symbolic execution term label.");
        }
        if (!modalityTerms.isEmpty()) {
            JavaBlock javaBlock = modalityTerm.javaBlock();
            JavaProgramElement program = javaBlock.program();
            final LinkedList initialStack = new LinkedList();
            new JavaASTVisitor((ProgramElement)program, services, (ProgramElement)program){
                final /* synthetic */ ProgramElement val$program;
                {
                    this.val$program = programElement;
                    super(arg0, arg1);
                }

                protected void doDefaultAction(SourceElement node) {
                }

                public void performActionOnMethodFrame(MethodFrame x) {
                    initialStack.add(root);
                }

                public void run() {
                    this.walk(this.val$program);
                }
            }.run();
            Map<Node, ImmutableList<Node>> methodCallStack = this.getMethodCallStack(label);
            methodCallStack.put(root, (ImmutableList<Node>)ImmutableSLList.nil().append(initialStack));
        }
    }

    protected Set<Node> getMethodReturnsToIgnore(RuleApp ruleApp) {
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(ruleApp);
        return this.getMethodReturnsToIgnore(label);
    }

    protected Set<Node> getMethodReturnsToIgnore(SymbolicExecutionTermLabel label) {
        assert (label != null) : "No symbolic execuion term label provided";
        return this.getMethodReturnsToIgnore(label.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Node> getMethodReturnsToIgnore(int id) {
        Map<Integer, Set<Node>> map = this.methodReturnsToIgnoreMap;
        synchronized (map) {
            Integer key = id;
            Set<Node> result = this.methodReturnsToIgnoreMap.get(key);
            if (result == null) {
                result = new LinkedHashSet<Node>();
                this.methodReturnsToIgnoreMap.put(key, result);
            }
            return result;
        }
    }

    protected Map<Node, ImmutableList<Node>> getMethodCallStack(RuleApp ruleApp) {
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(ruleApp);
        return this.getMethodCallStack(label);
    }

    protected Map<Node, ImmutableList<Node>> getMethodCallStack(SymbolicExecutionTermLabel label) {
        assert (label != null) : "No symbolic execuion term label provided";
        return this.getMethodCallStack(label.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Node, ImmutableList<Node>> getMethodCallStack(int id) {
        Map<Integer, Map<Node, ImmutableList<Node>>> map = this.methodCallStackMap;
        synchronized (map) {
            Integer key = id;
            Map<Node, ImmutableList<Node>> result = this.methodCallStackMap.get(key);
            if (result == null) {
                result = new HashMap<Node, ImmutableList<Node>>();
                this.methodCallStackMap.put(key, result);
            }
            return result;
        }
    }

    public void dispose() {
        if (this.keyNodeMapping != null) {
            this.keyNodeMapping.clear();
            this.keyNodeMapping = null;
        }
        if (this.keyNodeLoopConditionMapping != null) {
            this.keyNodeLoopConditionMapping.clear();
            this.keyNodeLoopConditionMapping = null;
        }
        if (this.keyNodeBranchConditionMapping != null) {
            this.keyNodeBranchConditionMapping.clear();
            this.keyNodeBranchConditionMapping = null;
        }
        if (this.methodCallStackMap != null) {
            this.methodCallStackMap.clear();
            this.methodCallStackMap = null;
        }
        if (this.afterBlockMap != null) {
            this.afterBlockMap.clear();
            this.afterBlockMap = null;
        }
        if (this.methodReturnsToIgnoreMap != null) {
            this.methodReturnsToIgnoreMap.clear();
            this.methodReturnsToIgnoreMap = null;
        }
        this.exceptionVariable = null;
        this.proof = null;
        this.startNode = null;
    }

    public Proof getProof() {
        return this.proof;
    }

    public IExecutionStart getStartNode() {
        return this.startNode;
    }

    public SymbolicExecutionCompletions analyse() {
        SymbolicExecutionCompletions completions = new SymbolicExecutionCompletions();
        AnalyzerProofVisitor visitor = new AnalyzerProofVisitor(completions);
        NodePreorderIterator iter = new NodePreorderIterator(this.proof.root());
        while (iter.hasNext()) {
            Node node = iter.next();
            visitor.visit(this.proof, node);
        }
        visitor.completeTree();
        visitor.injectLinks();
        return completions;
    }

    public Set<AbstractExecutionNode<?>> prune(Node node) {
        boolean pruneOnExNode = false;
        IExecutionNode<?> firstFather = this.getExecutionNode(node);
        if (firstFather != null && firstFather != this.startNode) {
            pruneOnExNode = true;
        } else {
            while (firstFather == null) {
                node = node.parent();
                firstFather = this.getExecutionNode(node);
            }
        }
        ExecutionNodePreorderIterator subtreeToBePruned = new ExecutionNodePreorderIterator(firstFather);
        if (!pruneOnExNode) {
            subtreeToBePruned.next();
        }
        HashSet exNodesToDelete = new HashSet();
        while (subtreeToBePruned.hasNext()) {
            AbstractExecutionNode exNode = (AbstractExecutionNode)subtreeToBePruned.next();
            exNodesToDelete.add(exNode);
            Node node2 = exNode.getProofNode();
            this.keyNodeMapping.remove(node2);
            this.keyNodeLoopConditionMapping.remove(node2);
            this.keyNodeBranchConditionMapping.remove(node2);
            SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(node2.getAppliedRuleApp());
            if (label == null) continue;
            this.methodCallStackMap.remove(label);
            this.afterBlockMap.remove(label);
            this.methodReturnsToIgnoreMap.remove(label);
        }
        for (AbstractExecutionNode abstractExecutionNode : exNodesToDelete) {
            IExecutionNode exParent = abstractExecutionNode.getParent();
            if (exParent != null) {
                ((AbstractExecutionNode)exParent).removeChild(abstractExecutionNode);
                abstractExecutionNode.setParent(null);
            }
            if (!abstractExecutionNode.getOutgoingLinks().isEmpty()) {
                for (IExecutionLink link : abstractExecutionNode.getOutgoingLinks()) {
                    ((AbstractExecutionNode)link.getSource()).removeOutgoingLink(link);
                    ((AbstractExecutionNode)link.getTarget()).removeIncomingLink(link);
                }
            }
            if (abstractExecutionNode.getIncomingLinks().isEmpty()) continue;
            for (IExecutionLink link : abstractExecutionNode.getIncomingLinks()) {
                ((AbstractExecutionNode)link.getSource()).removeOutgoingLink(link);
                ((AbstractExecutionNode)link.getTarget()).removeIncomingLink(link);
            }
        }
        ExecutionNodePreorderIterator executionNodePreorderIterator = new ExecutionNodePreorderIterator(this.startNode);
        while (executionNodePreorderIterator.hasNext()) {
            LinkedList<Object> removed;
            Iterator iter;
            Object block2;
            AbstractExecutionNode exNode = (AbstractExecutionNode)executionNodePreorderIterator.next();
            LinkedList<Object> deletedBlocks = new LinkedList<Object>();
            for (Object block2 : exNode.getCompletedBlocks()) {
                if (!exNodesToDelete.contains(block2)) continue;
                deletedBlocks.add(block2);
            }
            block2 = deletedBlocks.iterator();
            while (block2.hasNext()) {
                IExecutionBlockStartNode block3 = (IExecutionBlockStartNode)block2.next();
                exNode.removeCompletedBlock(block3);
            }
            if (exNode instanceof ExecutionMethodCall) {
                iter = ((ExecutionMethodCall)exNode).getMethodReturns().iterator();
                removed = new LinkedList<Object>();
                while (iter.hasNext()) {
                    IExecutionBaseMethodReturn methodReturn = (IExecutionBaseMethodReturn)iter.next();
                    if (!exNodesToDelete.contains(methodReturn)) continue;
                    removed.add(methodReturn);
                }
                for (IExecutionNode deleted : removed) {
                    ((ExecutionMethodCall)exNode).removeMethodReturn((IExecutionBaseMethodReturn<?>)deleted);
                }
            }
            if (exNode instanceof AbstractExecutionBlockStartNode) {
                iter = ((AbstractExecutionBlockStartNode)exNode).getBlockCompletions().iterator();
                removed = new LinkedList();
                while (iter.hasNext()) {
                    IExecutionNode completion = (IExecutionNode)iter.next();
                    if (!exNodesToDelete.contains(completion)) continue;
                    removed.add(completion);
                }
                for (IExecutionNode deleted : removed) {
                    ((AbstractExecutionBlockStartNode)exNode).removeBlockCompletion(deleted);
                }
            }
            if (!(exNode instanceof ExecutionStart)) continue;
            iter = ((ExecutionStart)exNode).getTerminations().iterator();
            removed = new LinkedList();
            while (iter.hasNext()) {
                IExecutionTermination termination = (IExecutionTermination)iter.next();
                if (!exNodesToDelete.contains(termination)) continue;
                removed.add(termination);
            }
            for (IExecutionNode deleted : removed) {
                ((ExecutionStart)exNode).removeTermination((IExecutionTermination)deleted);
            }
        }
        return exNodesToDelete;
    }

    protected AbstractExecutionNode<?> analyzeNode(Node node, AbstractExecutionNode<?> parentToAddTo, SymbolicExecutionCompletions completions) {
        if (!this.shouldPrune(node)) {
            AbstractExecutionNode<?> executionNode;
            Map<JavaPair, ImmutableList<IExecutionNode<?>>> completedBlocks;
            Goal goal;
            NodeInfo info = node.getNodeInfo();
            SourceElement statement = info.getActiveStatement();
            this.updateCallStack(node, statement);
            RuleApp currentOrFutureRuleApplication = node.getAppliedRuleApp();
            if (currentOrFutureRuleApplication == null && node != this.proof.root() && (goal = this.proof.getGoal(node)) != null) {
                currentOrFutureRuleApplication = goal.getRuleAppManager().peekNext();
            }
            if (SymbolicExecutionUtil.isSymbolicExecutionTreeNode(node, currentOrFutureRuleApplication) && (completedBlocks = this.updateAfterBlockMap(node, currentOrFutureRuleApplication)) != null) {
                for (Map.Entry<JavaPair, ImmutableList<IExecutionNode<?>>> entry : completedBlocks.entrySet()) {
                    for (IExecutionNode entryNode : entry.getValue()) {
                        if (entryNode == parentToAddTo || !(entryNode instanceof AbstractExecutionBlockStartNode)) continue;
                        parentToAddTo.addCompletedBlock((AbstractExecutionBlockStartNode)entryNode);
                        if (parentToAddTo instanceof IExecutionBranchCondition) continue;
                        ((AbstractExecutionBlockStartNode)entryNode).addBlockCompletion(parentToAddTo);
                        completions.addBlockCompletion(parentToAddTo);
                    }
                }
            }
            if ((executionNode = this.keyNodeMapping.get(node)) == null) {
                executionNode = this.createExecutionTreeModelRepresentation(parentToAddTo, node, statement);
                parentToAddTo = this.addNodeToTreeAndUpdateParent(node, parentToAddTo, executionNode);
                executionNode = this.createMehtodReturn(parentToAddTo, node, statement, completions);
                parentToAddTo = this.addNodeToTreeAndUpdateParent(node, parentToAddTo, executionNode);
            } else {
                parentToAddTo = executionNode;
            }
            boolean isLoopCondition = false;
            if (SymbolicExecutionUtil.hasLoopCondition(node, node.getAppliedRuleApp(), statement) && ((LoopStatement)statement).getGuardExpression().getPositionInfo() != PositionInfo.UNDEFINED && !SymbolicExecutionUtil.isDoWhileLoopCondition(node, statement) && !SymbolicExecutionUtil.isForLoopCondition(node, statement)) {
                isLoopCondition = true;
            }
            if (statement instanceof If && ((If)statement).getExpression().getPositionInfo() != PositionInfo.UNDEFINED && SymbolicExecutionUtil.getSymbolicExecutionLabel(node.getAppliedRuleApp()) != null && this.searchDirectParentBodyPreservesInvariantBranchCondition(parentToAddTo) != null) {
                isLoopCondition = true;
            }
            if (isLoopCondition) {
                ExecutionLoopCondition condition = this.keyNodeLoopConditionMapping.get(node);
                if (condition == null) {
                    condition = new ExecutionLoopCondition(this.settings, node);
                    this.addChild(parentToAddTo, condition);
                    this.keyNodeLoopConditionMapping.put(node, condition);
                    condition.setCallStack(this.createCallStack(node));
                    Pair<Integer, SourceElement> secondPair = SymbolicExecutionUtil.computeSecondStatement(node.getAppliedRuleApp());
                    this.addToBlockMap(node, condition, (Integer)secondPair.first, (SourceElement)secondPair.second, statement);
                }
                parentToAddTo = condition;
            }
        }
        return parentToAddTo;
    }

    protected IExecutionBranchCondition searchDirectParentBodyPreservesInvariantBranchCondition(IExecutionNode<?> current) {
        Iterator<Map.Entry<AbstractExecutionNode<?>, List<ExecutionBranchCondition>>> iter = this.branchConditionsStack.iterator();
        while (current instanceof IExecutionBranchCondition) {
            if ("Body Preserves Invariant".equals(current.getProofNode().getNodeInfo().getBranchLabel())) {
                return (IExecutionBranchCondition)current;
            }
            boolean parentFound = false;
            while (!parentFound && iter.hasNext()) {
                Map.Entry<AbstractExecutionNode<?>, List<ExecutionBranchCondition>> entry = iter.next();
                if (!entry.getValue().contains(current)) continue;
                current = entry.getKey();
                parentFound = true;
            }
            if (parentFound) continue;
            current = null;
        }
        return null;
    }

    protected boolean shouldPrune(Node node) {
        if (this.isUninterpretedPredicateUsed) {
            return node.isClosed();
        }
        return false;
    }

    protected AbstractExecutionNode<?> addNodeToTreeAndUpdateParent(Node node, AbstractExecutionNode<?> parentToAddTo, AbstractExecutionNode<?> executionNode) {
        if (executionNode != null) {
            this.addChild(parentToAddTo, executionNode);
            if (this.keyNodeMapping.get(node) != null) {
                if (this.multipleExecutionNodes.containsKey(node)) {
                    this.multipleExecutionNodes.get(node).add(executionNode);
                } else {
                    LinkedList list = new LinkedList();
                    list.add(this.keyNodeMapping.get(node));
                    list.add(executionNode);
                    this.multipleExecutionNodes.put(node, list);
                }
            }
            this.keyNodeMapping.put(node, executionNode);
            parentToAddTo = executionNode;
            executionNode.setCallStack(this.createCallStack(node));
        }
        return parentToAddTo;
    }

    protected void updateCallStack(Node node, SourceElement statement) {
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(node.getAppliedRuleApp());
        if (label != null && SymbolicExecutionUtil.isMethodCallNode(node, node.getAppliedRuleApp(), statement, true)) {
            int currentLevel = SymbolicExecutionUtil.computeStackSize(node.getAppliedRuleApp());
            Map<Node, ImmutableList<Node>> methodCallStack = this.getMethodCallStack(label);
            ImmutableSLList stack = this.findMethodCallStack(methodCallStack, node);
            if (stack != null) {
                while (stack.size() > currentLevel) {
                    stack = stack.take(1);
                }
            } else {
                stack = ImmutableSLList.nil();
            }
            stack = stack.prepend((Object)node);
            methodCallStack.put(node, (ImmutableList<Node>)stack);
        }
    }

    protected ImmutableList<Node> findMethodCallStack(Map<Node, ImmutableList<Node>> methodCallStack, Node node) {
        ImmutableList<Node> result = null;
        while (result == null && node != null) {
            result = methodCallStack.get(node);
            node = node.parent();
        }
        return result;
    }

    protected AbstractExecutionNode<?> createExecutionTreeModelRepresentation(AbstractExecutionNode<?> parent, Node node, SourceElement statement) {
        AbstractExecutionNode result = null;
        if (SymbolicExecutionUtil.hasSymbolicExecutionLabel(node.getAppliedRuleApp())) {
            if (statement != null && !SymbolicExecutionUtil.isRuleAppToIgnore(node.getAppliedRuleApp())) {
                PositionInfo posInfo = statement.getPositionInfo();
                if (SymbolicExecutionUtil.isMethodCallNode(node, node.getAppliedRuleApp(), statement)) {
                    result = new ExecutionMethodCall(this.settings, node);
                } else if (SymbolicExecutionUtil.isTerminationNode(node, node.getAppliedRuleApp())) {
                    if (!SymbolicExecutionUtil.hasLoopBodyLabel(node.getAppliedRuleApp())) {
                        Term modalityTerm = TermBuilder.goBelowUpdates((Term)node.getAppliedRuleApp().posInOccurrence().subTerm());
                        BlockContractValidityTermLabel bcLabel = (BlockContractValidityTermLabel)modalityTerm.getLabel(BlockContractValidityTermLabel.NAME);
                        result = new ExecutionTermination(this.settings, node, (IProgramVariable)(bcLabel != null ? MiscTools.findActualVariable((ProgramVariable)bcLabel.getExceptionVariable(), (Node)node) : this.exceptionVariable), null);
                        this.startNode.addTermination((IExecutionTermination)((Object)result));
                    }
                } else if (SymbolicExecutionUtil.isBranchStatement(node, node.getAppliedRuleApp(), statement, posInfo)) {
                    if (this.isNotInImplicitMethod(node)) {
                        result = new ExecutionBranchStatement(this.settings, node);
                        this.addToBlockMap(node, (ExecutionBranchStatement)result);
                    }
                } else if (SymbolicExecutionUtil.isLoopStatement(node, node.getAppliedRuleApp(), statement, posInfo)) {
                    if (this.isNotInImplicitMethod(node)) {
                        result = new ExecutionLoopStatement(this.settings, node);
                        this.addToBlockMap(node, (ExecutionLoopStatement)result);
                    }
                } else if (SymbolicExecutionUtil.isStatementNode(node, node.getAppliedRuleApp(), statement, posInfo) && this.isNotInImplicitMethod(node)) {
                    result = new ExecutionStatement(this.settings, node);
                }
            } else if (SymbolicExecutionUtil.isOperationContract(node, node.getAppliedRuleApp())) {
                if (this.isNotInImplicitMethod(node)) {
                    result = new ExecutionOperationContract(this.settings, node);
                }
            } else if (SymbolicExecutionUtil.isLoopInvariant(node, node.getAppliedRuleApp())) {
                if (this.isNotInImplicitMethod(node)) {
                    result = new ExecutionLoopInvariant(this.settings, node);
                    this.initNewLoopBodyMethodCallStack(node);
                }
            } else if (SymbolicExecutionUtil.isBlockSpecificationElement(node, node.getAppliedRuleApp())) {
                if (this.isNotInImplicitMethod(node)) {
                    result = new ExecutionAuxiliaryContract(this.settings, node);
                    this.initNewValidiityMethodCallStack(node);
                }
            } else if (SymbolicExecutionUtil.isCloseAfterJoin(node.getAppliedRuleApp())) {
                result = new ExecutionJoin(this.settings, node);
            }
        } else if (SymbolicExecutionUtil.isLoopBodyTermination(node, node.getAppliedRuleApp())) {
            result = new ExecutionTermination(this.settings, node, this.exceptionVariable, IExecutionTermination.TerminationKind.LOOP_BODY);
            this.startNode.addTermination((IExecutionTermination)((Object)result));
        }
        return result;
    }

    protected void addToBlockMap(Node node, AbstractExecutionBlockStartNode<?> blockStartNode) {
        Pair<Integer, SourceElement> secondPair = SymbolicExecutionUtil.computeSecondStatement(node.getAppliedRuleApp());
        this.addToBlockMap(node, blockStartNode, (Integer)secondPair.first, (SourceElement)secondPair.second);
    }

    protected void addToBlockMap(Node node, AbstractExecutionBlockStartNode<?> blockStartNode, int stackSize, SourceElement ... sourceElements) {
        boolean blockPossible = this.checkBlockPossibility(node, stackSize, sourceElements);
        if (blockPossible && sourceElements != null && sourceElements.length >= 1) {
            SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(node.getAppliedRuleApp());
            Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> afterBlockMaps = this.getAfterBlockMaps(label);
            Map<JavaPair, ImmutableList<IExecutionNode<?>>> afterBlockMap = this.findAfterBlockMap(afterBlockMaps, node);
            afterBlockMap = afterBlockMap == null ? new LinkedHashMap() : new LinkedHashMap(afterBlockMap);
            afterBlockMaps.put(node, afterBlockMap);
            JavaPair secondPair = new JavaPair(stackSize, (ImmutableList<SourceElement>)ImmutableSLList.nil().append((Object[])sourceElements));
            ImmutableSLList blockStartList = afterBlockMap.get((Object)secondPair);
            if (blockStartList == null) {
                blockStartList = ImmutableSLList.nil();
            }
            blockStartList = blockStartList.append(blockStartNode);
            afterBlockMap.put(secondPair, (ImmutableList<IExecutionNode<?>>)blockStartList);
        }
        blockStartNode.setBlockOpened(blockPossible);
    }

    private boolean checkBlockPossibility(Node node, int expectedStackSize, SourceElement ... expectedSourceElements) {
        if (node != null && expectedSourceElements != null && expectedSourceElements.length >= 1) {
            RuleApp ruleApp = null;
            boolean seNodeFound = false;
            while (!seNodeFound && node != null) {
                if (node.childrenCount() > 1) {
                    int openChildCount = 0;
                    Node nextNode = null;
                    for (int i = 0; i < node.childrenCount(); ++i) {
                        Node child = node.child(i);
                        if (child.isClosed()) continue;
                        ++openChildCount;
                        nextNode = child;
                    }
                    node = openChildCount == 1 ? nextNode : null;
                } else {
                    node = node.childrenCount() == 1 ? node.child(0) : null;
                }
                if (node == null) continue;
                if (node.childrenCount() == 0) {
                    Goal goal = this.proof.getGoal(node);
                    ruleApp = goal.getRuleAppManager().peekNext();
                } else {
                    ruleApp = node.getAppliedRuleApp();
                }
                seNodeFound = SymbolicExecutionUtil.isSymbolicExecutionTreeNode(node, ruleApp);
            }
            if (seNodeFound) {
                int currentStackSize = SymbolicExecutionUtil.computeStackSize(ruleApp);
                SourceElement currentActiveStatement = NodeInfo.computeActiveStatement(ruleApp);
                JavaBlock currentJavaBlock = ruleApp.posInOccurrence().subTerm().javaBlock();
                MethodFrame currentInnerMostMethodFrame = JavaTools.getInnermostMethodFrame((JavaBlock)currentJavaBlock, (Services)this.proof.getServices());
                return !this.isAfterBlockReached(currentStackSize, currentInnerMostMethodFrame, currentActiveStatement, expectedStackSize, ImmutableSLList.nil().append((Object[])expectedSourceElements).iterator());
            }
            return true;
        }
        return true;
    }

    protected Map<JavaPair, ImmutableList<IExecutionNode<?>>> findAfterBlockMap(Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> afterBlockMaps, Node node) {
        if (afterBlockMaps != null) {
            Map<JavaPair, ImmutableList<IExecutionNode<?>>> result = null;
            while (result == null && node != null) {
                result = afterBlockMaps.get(node);
                node = node.parent();
            }
            return result;
        }
        return null;
    }

    protected Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> getAfterBlockMaps(SymbolicExecutionTermLabel label) {
        assert (label != null) : "No symbolic execuion term label provided";
        return this.getAfterBlockMaps(label.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> getAfterBlockMaps(int id) {
        Map<Integer, Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>>> map = this.afterBlockMap;
        synchronized (map) {
            Integer key = id;
            Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> result = this.afterBlockMap.get(key);
            if (result == null) {
                result = new LinkedHashMap();
                this.afterBlockMap.put(key, result);
            }
            return result;
        }
    }

    protected Map<JavaPair, ImmutableList<IExecutionNode<?>>> updateAfterBlockMap(Node node, RuleApp ruleApp) {
        Map<Node, Map<JavaPair, ImmutableList<IExecutionNode<?>>>> afterBlockMaps;
        Map<JavaPair, ImmutableList<IExecutionNode<?>>> oldBlockMap;
        LinkedHashMap completedBlocks = new LinkedHashMap();
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(ruleApp);
        if (label != null && (oldBlockMap = this.findAfterBlockMap(afterBlockMaps = this.getAfterBlockMaps(label), node)) != null) {
            int stackSize = SymbolicExecutionUtil.computeStackSize(ruleApp);
            SourceElement activeStatement = NodeInfo.computeActiveStatement((RuleApp)ruleApp);
            JavaBlock javaBlock = ruleApp.posInOccurrence().subTerm().javaBlock();
            MethodFrame innerMostMethodFrame = JavaTools.getInnermostMethodFrame((JavaBlock)javaBlock, (Services)this.proof.getServices());
            LinkedHashMap newBlockMap = new LinkedHashMap();
            if (oldBlockMap != null) {
                for (Map.Entry<JavaPair, ImmutableList<IExecutionNode<?>>> entry : oldBlockMap.entrySet()) {
                    if (this.isContained(entry.getValue(), node)) continue;
                    boolean done = this.isAfterBlockReached(stackSize, innerMostMethodFrame, activeStatement, entry.getKey());
                    if (done) {
                        completedBlocks.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    newBlockMap.put(entry.getKey(), entry.getValue());
                }
            }
            afterBlockMaps.put(node, newBlockMap);
        }
        return completedBlocks;
    }

    protected boolean isContained(ImmutableList<IExecutionNode<?>> list, Node node) {
        boolean contained = false;
        Iterator iter = list.iterator();
        while (!contained && iter.hasNext()) {
            IExecutionNode next = (IExecutionNode)iter.next();
            if (next.getProofNode() != node) continue;
            contained = true;
        }
        return contained;
    }

    protected boolean isAfterBlockReached(int currentStackSize, MethodFrame currentInnerMostMethodFrame, SourceElement currentActiveStatement, JavaPair expectedPair) {
        return this.isAfterBlockReached(currentStackSize, currentInnerMostMethodFrame, currentActiveStatement, (Integer)expectedPair.first, ((ImmutableList)expectedPair.second).iterator());
    }

    protected boolean isAfterBlockReached(int currentStackSize, MethodFrame currentInnerMostMethodFrame, SourceElement currentActiveStatement, int expectedStackSize, Iterator<SourceElement> expectedStatementsIterator) {
        boolean done = false;
        if (expectedStackSize > currentStackSize) {
            done = true;
        } else {
            while (!done && expectedStatementsIterator.hasNext()) {
                SourceElement next = expectedStatementsIterator.next();
                if (SymbolicExecutionUtil.equalsWithPosition(next, currentActiveStatement)) {
                    done = true;
                    continue;
                }
                if (expectedStackSize != currentStackSize || (currentInnerMostMethodFrame == null || !currentInnerMostMethodFrame.getBody().isEmpty()) && (next == null || SymbolicExecutionUtil.containsStatement((ProgramElement)currentInnerMostMethodFrame, next, this.proof.getServices()))) continue;
                done = true;
            }
        }
        return done;
    }

    protected AbstractExecutionMethodReturn<?> createMehtodReturn(AbstractExecutionNode<?> parent, Node node, SourceElement statement, SymbolicExecutionCompletions completions) {
        AbstractExecutionMethodReturn result = null;
        if (SymbolicExecutionUtil.hasSymbolicExecutionLabel(node.getAppliedRuleApp()) && statement != null && !SymbolicExecutionUtil.isRuleAppToIgnore(node.getAppliedRuleApp())) {
            IExecutionNode callSEDNode;
            Set<Node> methodReturnsToIgnore;
            Node callNode;
            boolean exceptionalMethodReturn;
            boolean methodReturn = SymbolicExecutionUtil.isMethodReturnNode(node, node.getAppliedRuleApp());
            boolean bl = exceptionalMethodReturn = !methodReturn && SymbolicExecutionUtil.isExceptionalMethodReturnNode(node, node.getAppliedRuleApp());
            if ((methodReturn || exceptionalMethodReturn) && (callNode = this.findMethodCallNode(node, node.getAppliedRuleApp())) != null && !(methodReturnsToIgnore = this.getMethodReturnsToIgnore(node.getAppliedRuleApp())).contains(callNode) && (callSEDNode = (IExecutionNode)this.keyNodeMapping.get(callNode)) instanceof ExecutionMethodCall) {
                if (methodReturn) {
                    result = new ExecutionMethodReturn(this.settings, node, (ExecutionMethodCall)callSEDNode);
                    completions.addMethodReturn(result);
                } else {
                    result = new ExecutionExceptionalMethodReturn(this.settings, node, (ExecutionMethodCall)callSEDNode);
                    completions.addMethodReturn(result);
                }
            }
        }
        return result;
    }

    protected boolean isNotInImplicitMethod(Node node) {
        Term term = node.getAppliedRuleApp().posInOccurrence().subTerm();
        term = TermBuilder.goBelowUpdates((Term)term);
        Services services = this.proof.getServices();
        ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)term.javaBlock(), (Services)services);
        IProgramMethod pm = ec.getMethodContext();
        return SymbolicExecutionUtil.isNotImplicit(services, pm);
    }

    protected void initNewLoopBodyMethodCallStack(Node node) {
        PosInOccurrence childPIO = SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(node.child(1).sequent());
        this.initNewMethodCallStack(node, childPIO);
    }

    protected void initNewValidiityMethodCallStack(Node node) {
        PosInOccurrence childPIO = SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(node.child(0).sequent());
        this.initNewMethodCallStack(node, childPIO);
    }

    protected void initNewMethodCallStack(Node currentNode, PosInOccurrence childPIO) {
        Term newModality;
        Term term = newModality = childPIO != null ? TermBuilder.goBelowUpdates((Term)childPIO.subTerm()) : null;
        assert (newModality != null);
        SymbolicExecutionTermLabel label = SymbolicExecutionUtil.getSymbolicExecutionLabel(newModality);
        assert (label != null);
        JavaBlock jb = newModality.javaBlock();
        MethodFrameCounterJavaASTVisitor newCounter = new MethodFrameCounterJavaASTVisitor((ProgramElement)jb.program(), this.proof.getServices());
        int newCount = newCounter.run();
        Term oldModality = currentNode.getAppliedRuleApp().posInOccurrence().subTerm();
        oldModality = TermBuilder.goBelowUpdates((Term)oldModality);
        Map<Node, ImmutableList<Node>> currentMethodCallStackMap = this.getMethodCallStack(currentNode.getAppliedRuleApp());
        Map<Node, ImmutableList<Node>> newMethodCallStackMap = this.getMethodCallStack(label.getId());
        ImmutableList<Node> currentMethodCallStack = this.findMethodCallStack(currentMethodCallStackMap, currentNode);
        ImmutableSLList newMethodCallStack = ImmutableSLList.nil();
        Set<Node> currentIgnoreSet = this.getMethodReturnsToIgnore(label.getId());
        assert (newMethodCallStack.isEmpty()) : "Method call stack is not empty.";
        Iterator currentIter = currentMethodCallStack.iterator();
        for (int i = 0; currentIter.hasNext() && i < newCount; ++i) {
            Node next = (Node)currentIter.next();
            newMethodCallStack = newMethodCallStack.prepend((Object)next);
            currentIgnoreSet.add(next);
        }
        newMethodCallStackMap.put(currentNode, (ImmutableList<Node>)newMethodCallStack);
    }

    public boolean isUninterpretedPredicateUsed() {
        return this.isUninterpretedPredicateUsed;
    }

    protected IExecutionNode<?>[] createCallStack(Node node) {
        int size = SymbolicExecutionUtil.computeStackSize(node.getAppliedRuleApp());
        if (size >= 1) {
            LinkedList callStack = new LinkedList();
            Map<Node, ImmutableList<Node>> methodCallStack = this.getMethodCallStack(node.getAppliedRuleApp());
            ImmutableList stack = this.findMethodCallStack(methodCallStack, node);
            stack = stack.take(stack.size() - size);
            Iterator stackIter = stack.iterator();
            for (int i = 0; i < size; ++i) {
                IExecutionNode<?> executionNode;
                Node stackEntry = (Node)stackIter.next();
                if (stackEntry == this.proof.root() || (executionNode = this.getExecutionNode(stackEntry)) == null) continue;
                callStack.add(executionNode);
            }
            return callStack.toArray(new IExecutionNode[callStack.size()]);
        }
        return new IExecutionNode[0];
    }

    protected Node findMethodCallNode(Node currentNode, RuleApp ruleApp) {
        int returnStackSize = SymbolicExecutionUtil.computeStackSize(ruleApp);
        if (returnStackSize >= 0) {
            Map<Node, ImmutableList<Node>> methodCallStack = this.getMethodCallStack(ruleApp);
            ImmutableList<Node> stack = this.findMethodCallStack(methodCallStack, currentNode);
            return (Node)stack.take(stack.size() - returnStackSize).head();
        }
        return null;
    }

    protected boolean isInImplicitMethod(Node node) {
        return SymbolicExecutionUtil.isInImplicitMethod(node, node.getAppliedRuleApp());
    }

    protected boolean hasBranchCondition(Node node) {
        if (node.childrenCount() >= 2) {
            int openChildrenCount = 0;
            Iterator childIter = node.childrenIterator();
            while (childIter.hasNext()) {
                Node previousSymbolicExecutionNode;
                Node child = (Node)childIter.next();
                if (this.shouldPrune(child) || this.isInImplicitMethod(previousSymbolicExecutionNode = this.searchPreviousSymbolicExecutionNode(child))) continue;
                ++openChildrenCount;
            }
            return openChildrenCount >= 2;
        }
        return false;
    }

    protected Node searchPreviousSymbolicExecutionNode(Node node) {
        while (node != null && node.getNodeInfo().getActiveStatement() == null) {
            node = node.parent();
        }
        return node;
    }

    protected void addChild(AbstractExecutionNode<?> parent, AbstractExecutionNode<?> child) {
        child.setParent(parent);
        parent.addChild(child);
    }

    public IExecutionNode<?> getBestExecutionNode(Node proofNode) {
        IExecutionNode<?> node = this.getExecutionNode(proofNode);
        while (node == null && proofNode != null) {
            proofNode = proofNode.parent();
            node = this.getExecutionNode(proofNode);
        }
        return node;
    }

    public IExecutionNode<?> getExecutionNode(Node proofNode) {
        IExecutionNode result = this.keyNodeMapping.get(proofNode);
        if (result == null) {
            result = this.keyNodeBranchConditionMapping.get(proofNode);
        }
        if (result == null) {
            result = this.keyNodeLoopConditionMapping.get(proofNode);
        }
        return result;
    }

    public static Properties createPoPropertiesToForce() {
        Properties poPropertiesToForce = new Properties();
        poPropertiesToForce.setProperty("addSymbolicExecutionLabel", "true");
        return poPropertiesToForce;
    }

    protected static class JavaPair
    extends Pair<Integer, ImmutableList<SourceElement>> {
        public JavaPair(Integer stackSize, ImmutableList<SourceElement> elementsOfInterest) {
            super((Object)stackSize, elementsOfInterest);
        }

        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (o instanceof JavaPair) {
                    JavaPair other = (JavaPair)((Object)o);
                    if (((ImmutableList)this.second).size() == ((ImmutableList)other.second).size()) {
                        Iterator iter = ((ImmutableList)this.second).iterator();
                        Iterator otherIter = ((ImmutableList)other.second).iterator();
                        boolean equals = true;
                        while (equals && iter.hasNext()) {
                            SourceElement otherNext;
                            SourceElement next = (SourceElement)iter.next();
                            if (SymbolicExecutionUtil.equalsWithPosition(next, otherNext = (SourceElement)otherIter.next())) continue;
                            equals = false;
                        }
                        assert (!otherIter.hasNext());
                        return equals;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
    }

    private static final class MethodFrameCounterJavaASTVisitor
    extends JavaASTVisitor {
        private int count = 0;

        public MethodFrameCounterJavaASTVisitor(ProgramElement root, Services services) {
            super(root, services);
        }

        protected void doDefaultAction(SourceElement node) {
        }

        public void performActionOnMethodFrame(MethodFrame x) {
            ++this.count;
        }

        public int run() {
            this.walk(this.root());
            return this.count;
        }
    }

    private class AnalyzerProofVisitor
    implements ProofVisitor {
        private final SymbolicExecutionCompletions completions;
        private Map<Node, AbstractExecutionNode<?>> addToMapping = new LinkedHashMap();
        private Map<AbstractExecutionNode<?>, List<ExecutionBranchCondition>> parentToBranchConditionMapping = new LinkedHashMap();
        private ImmutableList<Node> joinNodes = ImmutableSLList.nil();

        public AnalyzerProofVisitor(SymbolicExecutionCompletions completions) {
            this.completions = completions;
        }

        public void visit(Proof proof, Node visitedNode) {
            AbstractExecutionNode parentToAddTo = (ExecutionStart)((Object)SymbolicExecutionTreeBuilder.this.keyNodeBranchConditionMapping.get(visitedNode));
            if (parentToAddTo == null) {
                Node parent = visitedNode.parent();
                parentToAddTo = parent != null ? this.addToMapping.get(parent) : SymbolicExecutionTreeBuilder.this.startNode;
            }
            parentToAddTo = SymbolicExecutionTreeBuilder.this.analyzeNode(visitedNode, parentToAddTo, this.completions);
            this.addToMapping.put(visitedNode, parentToAddTo);
            if (!(parentToAddTo instanceof IExecutionStart) && SymbolicExecutionTreeBuilder.this.hasBranchCondition(visitedNode)) {
                Iterator iter = visitedNode.childrenIterator();
                while (iter.hasNext()) {
                    Node childNode = (Node)iter.next();
                    if (SymbolicExecutionTreeBuilder.this.keyNodeBranchConditionMapping.containsKey(childNode) || SymbolicExecutionTreeBuilder.this.shouldPrune(visitedNode)) continue;
                    String additionalBranchLabel = null;
                    if (visitedNode.getAppliedRuleApp().rule() instanceof BuiltInRule) {
                        additionalBranchLabel = childNode.getNodeInfo().getBranchLabel();
                    }
                    ExecutionBranchCondition condition = new ExecutionBranchCondition(SymbolicExecutionTreeBuilder.this.settings, childNode, additionalBranchLabel);
                    List<ExecutionBranchCondition> list = this.parentToBranchConditionMapping.get(parentToAddTo);
                    if (list == null) {
                        list = new LinkedList<ExecutionBranchCondition>();
                        SymbolicExecutionTreeBuilder.this.branchConditionsStack.addFirst(new DefaultEntry<ExecutionStart, List<ExecutionBranchCondition>>((ExecutionStart)parentToAddTo, list));
                        this.parentToBranchConditionMapping.put(parentToAddTo, list);
                    }
                    list.add(condition);
                    SymbolicExecutionTreeBuilder.this.keyNodeBranchConditionMapping.put(childNode, condition);
                    if (!SymbolicExecutionUtil.hasSymbolicExecutionLabel(visitedNode.getAppliedRuleApp())) continue;
                    condition.setCallStack(SymbolicExecutionTreeBuilder.this.createCallStack(visitedNode));
                }
            }
            if (SymbolicExecutionUtil.isJoin(visitedNode.getAppliedRuleApp())) {
                this.joinNodes = this.joinNodes.prepend((Object)visitedNode);
            }
        }

        public void injectLinks() {
            for (Node node : this.joinNodes) {
                MergeRuleBuiltInRuleApp ruleApp = (MergeRuleBuiltInRuleApp)node.getAppliedRuleApp();
                IExecutionNode<?> source = SymbolicExecutionTreeBuilder.this.getBestExecutionNode(node);
                if (source == null) continue;
                for (MergePartner partner : ruleApp.getMergePartners()) {
                    IExecutionLink link;
                    IExecutionNode<?> target = SymbolicExecutionTreeBuilder.this.getBestExecutionNode(partner.getGoal().node());
                    while (target instanceof IExecutionBranchCondition) {
                        target = SymbolicExecutionTreeBuilder.this.getBestExecutionNode(target.getProofNode().parent());
                    }
                    if (target == null || (link = source.getOutgoingLink(target)) != null) continue;
                    link = new ExecutionLink(target, source);
                    ((AbstractExecutionNode)link.getTarget()).addIncomingLink(link);
                    ((AbstractExecutionNode)link.getSource()).addOutgoingLink(link);
                }
            }
        }

        public void completeTree() {
            Iterator<Map.Entry<AbstractExecutionNode<?>, List<ExecutionBranchCondition>>> stackIter = SymbolicExecutionTreeBuilder.this.branchConditionsStack.iterator();
            while (stackIter.hasNext()) {
                Map.Entry<AbstractExecutionNode<?>, List<ExecutionBranchCondition>> entry = stackIter.next();
                Iterator<ExecutionBranchCondition> bcIter = entry.getValue().iterator();
                while (bcIter.hasNext()) {
                    ExecutionBranchCondition condition = bcIter.next();
                    Object[] conditionsChildren = condition.getChildren();
                    if (ArrayUtil.isEmpty((Object[])conditionsChildren)) continue;
                    if (SymbolicExecutionTreeBuilder.this.settings.isMergeBranchConditions()) {
                        boolean addingToParentRequired = false;
                        for (Object child : conditionsChildren) {
                            if (child instanceof ExecutionBranchCondition) {
                                ExecutionBranchCondition bcChild = (ExecutionBranchCondition)child;
                                bcChild.addMergedProofNode(condition.getProofNode());
                                SymbolicExecutionTreeBuilder.this.addChild(entry.getKey(), (AbstractExecutionNode<?>)child);
                                this.finishBlockCompletion(condition);
                                continue;
                            }
                            addingToParentRequired = true;
                        }
                        if (addingToParentRequired) {
                            SymbolicExecutionTreeBuilder.this.addChild(entry.getKey(), condition);
                            this.finishBlockCompletion(condition);
                        }
                    } else {
                        SymbolicExecutionTreeBuilder.this.addChild(entry.getKey(), condition);
                        this.finishBlockCompletion(condition);
                    }
                    bcIter.remove();
                }
                if (!entry.getValue().isEmpty()) continue;
                stackIter.remove();
            }
        }

        protected void finishBlockCompletion(IExecutionBranchCondition node) {
            for (IExecutionBlockStartNode start : node.getCompletedBlocks()) {
                ((AbstractExecutionBlockStartNode)start).addBlockCompletion(node);
                this.completions.addBlockCompletion(node);
            }
        }
    }

    public static class SymbolicExecutionCompletions {
        private final List<IExecutionNode<?>> blockCompletions = new LinkedList();
        private final List<IExecutionBaseMethodReturn<?>> methodReturns = new LinkedList();

        public IExecutionNode<?>[] getBlockCompletions() {
            return this.blockCompletions.toArray(new IExecutionNode[this.blockCompletions.size()]);
        }

        private void addBlockCompletion(IExecutionNode<?> blockCompletion) {
            if (blockCompletion != null) {
                this.blockCompletions.add(blockCompletion);
            }
        }

        public IExecutionBaseMethodReturn<?>[] getMethodReturns() {
            return this.methodReturns.toArray(new IExecutionBaseMethodReturn[this.methodReturns.size()]);
        }

        private void addMethodReturn(IExecutionBaseMethodReturn<?> methodReturn) {
            if (methodReturn != null) {
                this.methodReturns.add(methodReturn);
            }
        }
    }
}

