/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.NoPosTacletApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.inst.InstantiationEntry;
import de.uka.ilkd.key.symbolic_execution.AbstractUpdateExtractor;
import de.uka.ilkd.key.symbolic_execution.object_model.IModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicAssociation;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicLayout;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicObject;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicValue;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.AbstractSymbolicAssociationValueContainer;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.ModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicAssociation;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicLayout;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicObject;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicState;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.SymbolicValue;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.ProofStarter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;
import org.key_project.util.java.ObjectUtil;

public class SymbolicLayoutExtractor
extends AbstractUpdateExtractor {
    private final IModelSettings settings;
    private List<ImmutableSet<Term>> appliedCutsPerLayout;
    private Map<Integer, ISymbolicLayout> currentLayouts;
    private Set<AbstractUpdateExtractor.ExtractLocationParameter> currentLocations;
    private Map<Integer, ISymbolicLayout> initialLayouts;
    private Set<AbstractUpdateExtractor.ExtractLocationParameter> initialLocations;
    private Map<Integer, ImmutableList<ISymbolicEquivalenceClass>> layoutsEquivalentClasses;
    private Set<Term> objectsToIgnore;
    private ImmutableList<Term> updates;

    public SymbolicLayoutExtractor(Node node, PosInOccurrence modalityPio, boolean useUnicode, boolean usePrettyPrinting, boolean simplifyConditions) {
        super(node, modalityPio);
        this.settings = new ModelSettings(useUnicode, usePrettyPrinting, simplifyConditions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse() throws ProofInputException {
        SymbolicLayoutExtractor symbolicLayoutExtractor = this;
        synchronized (symbolicLayoutExtractor) {
            if (!this.isAnalysed()) {
                Term pathCondition = SymbolicExecutionUtil.computePathCondition(this.node, true, false);
                pathCondition = this.removeImplicitSubTermsFromPathCondition(pathCondition);
                LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter> temporaryCurrentLocations = new LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter>();
                this.objectsToIgnore = this.computeInitialObjectsToIgnore(false, false);
                LinkedHashSet<Term> updateCreatedObjects = new LinkedHashSet<Term>();
                LinkedHashSet<Term> updateValueObjects = new LinkedHashSet<Term>();
                this.collectLocationsFromUpdates(this.node.sequent(), temporaryCurrentLocations, updateCreatedObjects, updateValueObjects, this.objectsToIgnore);
                this.objectsToIgnore.addAll(updateCreatedObjects);
                this.initialLocations = this.extractLocationsFromTerm(pathCondition, this.objectsToIgnore);
                this.initialLocations.addAll(this.extractLocationsFromSequent(this.node.sequent(), this.objectsToIgnore));
                this.currentLocations = new LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter>(this.initialLocations);
                this.currentLocations.addAll(temporaryCurrentLocations);
                Set<Term> symbolicObjectsResultingInCurrentState = new LinkedHashSet<Term>();
                symbolicObjectsResultingInCurrentState.addAll(this.filterOutObjectsToIgnore(updateValueObjects, this.objectsToIgnore));
                symbolicObjectsResultingInCurrentState.addAll(this.collectObjectsFromSequent(this.node.sequent(), this.objectsToIgnore));
                symbolicObjectsResultingInCurrentState = this.sortTerms(symbolicObjectsResultingInCurrentState);
                symbolicObjectsResultingInCurrentState.add(this.getServices().getTermBuilder().NULL());
                this.updates = this.extractInitialUpdates();
                ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(this.getProof(), true);
                Sequent initialConditionsSequent = this.createSequentForEquivalenceClassComputation();
                ApplyStrategyInfo info = null;
                try {
                    ProofStarter equivalentClassesProofStarter = SymbolicExecutionSideProofUtil.createSideProof(sideProofEnv, initialConditionsSequent, null);
                    this.applyCutRules(equivalentClassesProofStarter, symbolicObjectsResultingInCurrentState, this.updates);
                    info = SymbolicExecutionSideProofUtil.startSideProof(this.getProof(), equivalentClassesProofStarter, "METHOD_CONTRACT", "LOOP_INVARIANT", "QUERY_ON", "SPLITTING_NORMAL");
                    this.appliedCutsPerLayout = this.extractAppliedCutsFromGoals(equivalentClassesProofStarter.getProof());
                    this.initialLayouts = new LinkedHashMap<Integer, ISymbolicLayout>(this.appliedCutsPerLayout.size());
                    this.currentLayouts = new LinkedHashMap<Integer, ISymbolicLayout>(this.appliedCutsPerLayout.size());
                    this.layoutsEquivalentClasses = new LinkedHashMap<Integer, ImmutableList<ISymbolicEquivalenceClass>>();
                }
                catch (Throwable throwable) {
                    SymbolicExecutionSideProofUtil.disposeOrStore("Equivalence class computation on node " + this.node.serialNr() + ".", info);
                    throw throwable;
                }
                SymbolicExecutionSideProofUtil.disposeOrStore("Equivalence class computation on node " + this.node.serialNr() + ".", info);
            }
        }
    }

    protected ImmutableList<Term> extractInitialUpdates() {
        Sequent sequent = this.getRoot().sequent();
        assert (sequent.antecedent().isEmpty());
        assert (sequent.succedent().size() == 1);
        Term sf = sequent.succedent().get(0).formula();
        assert (sf.op() == Junctor.IMP);
        Term modality = sf.sub(1);
        return (ImmutableList)TermBuilder.goBelowUpdates2((Term)modality).first;
    }

    protected Set<Term> sortTerms(Set<Term> terms) {
        LinkedList<Term> list = new LinkedList<Term>(terms);
        Collections.sort(list, new Comparator<Term>(){

            @Override
            public int compare(Term o1, Term o2) {
                String o1s = o1.toString();
                String o2s = o2.toString();
                return o1s.length() - o2s.length();
            }
        });
        return new LinkedHashSet<Term>(list);
    }

    protected Set<Term> filterOutObjectsToIgnore(Set<Term> objectsToFilter, Set<Term> objectsToIgnore) throws ProofInputException {
        LinkedHashSet<Term> result = new LinkedHashSet<Term>();
        for (Term symbolicObject : objectsToFilter) {
            if (objectsToIgnore.contains(symbolicObject)) continue;
            result.add(symbolicObject);
        }
        return result;
    }

    protected Sequent createSequentForEquivalenceClassComputation() {
        return SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(this.node, this.modalityPio, null, null, this.updates, false);
    }

    protected void applyCutRules(ProofStarter starter, Set<Term> symbolicObjects, ImmutableList<Term> updates) {
        TermBuilder tb = this.getServices().getTermBuilder();
        ArrayList<Term> objectsCopy = new ArrayList<Term>(symbolicObjects);
        int maxProofSteps = 8000;
        for (int i = 0; i < objectsCopy.size(); ++i) {
            for (int j = i + 1; j < objectsCopy.size(); ++j) {
                Term equalTerm = tb.equals((Term)objectsCopy.get(i), (Term)objectsCopy.get(j));
                Term updateTerm = tb.applyParallel(updates, equalTerm);
                this.applyCut(starter, updateTerm, maxProofSteps);
            }
        }
        starter.setMaxRuleApplications(maxProofSteps);
        starter.start();
    }

    protected void applyCut(ProofStarter starter, Term term, int maxProofSteps) {
        ImmutableList goals = starter.getProof().openEnabledGoals();
        if (!goals.isEmpty()) {
            int proofSteps = maxProofSteps / goals.size();
            if (proofSteps < 300) {
                proofSteps = 300;
            }
            starter.setMaxRuleApplications(maxProofSteps);
            for (Goal g : goals) {
                NoPosTacletApp c = g.indexOfTaclets().lookup("cut");
                assert (c != null);
                ImmutableSet set2 = c.uninstantiatedVars();
                SchemaVariable cutF = (SchemaVariable)set2.iterator().next();
                TacletApp t2 = c.addInstantiation(cutF, term, false, this.getServices());
                ImmutableList branches = g.apply((RuleApp)t2);
                starter.start(branches);
            }
        }
    }

    protected List<ImmutableSet<Term>> extractAppliedCutsFromGoals(Proof proof) throws ProofInputException {
        LinkedHashSet<ImmutableSet<Term>> resultSet = new LinkedHashSet<ImmutableSet<Term>>();
        Node root = proof.root();
        for (Goal goal : proof.openGoals()) {
            resultSet.add(this.extractAppliedCutsSet(goal.node(), root));
        }
        return new ArrayList<ImmutableSet<Term>>(resultSet);
    }

    protected ImmutableSet<Term> extractAppliedCutsSet(Node goalnode, Node root) throws ProofInputException {
        DefaultImmutableSet result = DefaultImmutableSet.nil();
        if (!root.find(goalnode)) {
            throw new ProofInputException("Node \"" + goalnode + "\" ist not a childs of root node \"" + root + "\".");
        }
        while (goalnode.serialNr() != root.serialNr()) {
            NoPosTacletApp npta;
            Node oldNode = goalnode;
            if (!((goalnode = goalnode.parent()).getAppliedRuleApp() instanceof NoPosTacletApp) || !"CUT".equals((npta = (NoPosTacletApp)goalnode.getAppliedRuleApp()).taclet().name().toString().toUpperCase())) continue;
            Term inst = (Term)((InstantiationEntry)npta.instantiations().lookupEntryForSV(new Name("cutFormula")).value()).getInstantiation();
            inst = TermBuilder.goBelowUpdates((Term)inst);
            if (goalnode.child(1) == oldNode) {
                inst = this.getServices().getTermBuilder().not(inst);
            }
            result = result.add((Object)inst);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAnalysed() {
        SymbolicLayoutExtractor symbolicLayoutExtractor = this;
        synchronized (symbolicLayoutExtractor) {
            return this.initialLayouts != null && this.currentLayouts != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayoutsCount() {
        SymbolicLayoutExtractor symbolicLayoutExtractor = this;
        synchronized (symbolicLayoutExtractor) {
            assert (this.isAnalysed());
            return this.appliedCutsPerLayout.size();
        }
    }

    public ISymbolicLayout getInitialLayout(int layoutIndex) throws ProofInputException {
        return this.getLayout(this.initialLayouts, layoutIndex, this.initialLocations, this.computeInitialStateName(), false);
    }

    protected String computeInitialStateName() {
        return this.getRoot().name() + " resulting in " + this.computeCurrentStateName();
    }

    public ISymbolicLayout getCurrentLayout(int layoutIndex) throws ProofInputException {
        return this.getLayout(this.currentLayouts, layoutIndex, this.currentLocations, this.computeCurrentStateName(), true);
    }

    protected String computeCurrentStateName() {
        return this.node.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISymbolicLayout getLayout(Map<Integer, ISymbolicLayout> confiurationsMap, int layoutIndex, Set<AbstractUpdateExtractor.ExtractLocationParameter> locations, String stateName, boolean currentLayout) throws ProofInputException {
        SymbolicLayoutExtractor symbolicLayoutExtractor = this;
        synchronized (symbolicLayoutExtractor) {
            assert (layoutIndex >= 0);
            assert (layoutIndex < this.appliedCutsPerLayout.size());
            assert (this.isAnalysed());
            ISymbolicLayout result = confiurationsMap.get(layoutIndex);
            if (result == null) {
                ImmutableSet<Term> layout = this.appliedCutsPerLayout.get(layoutIndex);
                ImmutableList<ISymbolicEquivalenceClass> equivalentClasses = this.getEquivalenceClasses(layoutIndex);
                result = this.lazyComputeLayout(layout, locations, equivalentClasses, stateName, currentLayout);
                confiurationsMap.put(layoutIndex, result);
            }
            return result;
        }
    }

    protected ISymbolicLayout lazyComputeLayout(ImmutableSet<Term> layout, Set<AbstractUpdateExtractor.ExtractLocationParameter> locations, ImmutableList<ISymbolicEquivalenceClass> equivalentClasses, String stateName, boolean currentLayout) throws ProofInputException {
        if (!locations.isEmpty()) {
            TermBuilder tb = this.getServices().getTermBuilder();
            ArrayList<Term> updateConditions = new ArrayList<Term>(layout.size());
            for (Term term : layout) {
                updateConditions.add(tb.applyParallel(this.updates, term));
            }
            Term layoutCondition = tb.and(updateConditions);
            Set<AbstractUpdateExtractor.ExtractLocationParameter> locationsAccordingToEquivalentClass = this.updateLocationsAccordingtoEquivalentClass(locations, equivalentClasses);
            Term layoutTerm = this.createLocationPredicateAndTerm(locationsAccordingToEquivalentClass);
            Set<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs = this.computeVariableValuePairs(layoutCondition, layoutTerm, locationsAccordingToEquivalentClass, currentLayout, this.settings.isSimplifyConditions());
            return this.createLayoutFromExecutionVariableValuePairs(equivalentClasses, pairs, stateName);
        }
        return this.createLayoutFromExecutionVariableValuePairs(equivalentClasses, new LinkedHashSet<AbstractUpdateExtractor.ExecutionVariableValuePair>(), stateName);
    }

    protected Set<AbstractUpdateExtractor.ExtractLocationParameter> updateLocationsAccordingtoEquivalentClass(Set<AbstractUpdateExtractor.ExtractLocationParameter> locations, ImmutableList<ISymbolicEquivalenceClass> equivalentClasses) {
        LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter> newLocations = new LinkedHashSet<AbstractUpdateExtractor.ExtractLocationParameter>(locations.size());
        for (AbstractUpdateExtractor.ExtractLocationParameter location : locations) {
            Term parent = location.getParentTerm();
            ISymbolicEquivalenceClass eq = this.findEquivalentClass(equivalentClasses, parent);
            if (eq != null) {
                newLocations.add(new AbstractUpdateExtractor.ExtractLocationParameter((AbstractUpdateExtractor)this, location, eq.getRepresentative()));
                continue;
            }
            newLocations.add(location);
        }
        return newLocations;
    }

    protected Set<Term> collectObjectsFromSequent(Sequent sequent, Set<Term> objectsToIgnore) throws ProofInputException {
        LinkedHashSet<Term> result = new LinkedHashSet<Term>();
        for (SequentFormula sf : sequent) {
            if (SymbolicExecutionUtil.checkSkolemEquality(sf) != 0) continue;
            result.addAll(this.collectSymbolicObjectsFromTerm(sf.formula(), objectsToIgnore));
        }
        return result;
    }

    protected Set<Term> collectSymbolicObjectsFromTerm(Term term, final Set<Term> objectsToIgnore) throws ProofInputException {
        final LinkedHashSet<Term> result = new LinkedHashSet<Term>();
        term.execPreOrder((Visitor)new DefaultVisitor(){

            public void visit(Term visited) {
                visited = OriginTermLabel.removeOriginLabels((Term)visited, (Services)SymbolicLayoutExtractor.this.getServices());
                if (SymbolicExecutionUtil.hasReferenceSort(SymbolicLayoutExtractor.this.getServices(), visited) && visited.freeVars().isEmpty() && !objectsToIgnore.contains(visited) && !SymbolicExecutionUtil.isSkolemConstant(visited)) {
                    result.add(visited);
                }
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<ISymbolicEquivalenceClass> getEquivalenceClasses(int layoutIndex) {
        SymbolicLayoutExtractor symbolicLayoutExtractor = this;
        synchronized (symbolicLayoutExtractor) {
            ImmutableList<ISymbolicEquivalenceClass> equivalentClasses = this.layoutsEquivalentClasses.get(layoutIndex);
            if (equivalentClasses == null) {
                ImmutableSet<Term> appliedCuts = this.appliedCutsPerLayout.get(layoutIndex);
                equivalentClasses = this.lazyComputeEquivalenceClasses(appliedCuts);
                this.layoutsEquivalentClasses.put(layoutIndex, equivalentClasses);
            }
            return equivalentClasses;
        }
    }

    protected ImmutableList<ISymbolicEquivalenceClass> lazyComputeEquivalenceClasses(ImmutableSet<Term> appliedCuts) {
        ImmutableSLList result = ImmutableSLList.nil();
        for (Term term : appliedCuts) {
            if (Junctor.NOT == term.op()) continue;
            assert (term.op() == Equality.EQUALS);
            Iterator iter = term.subs().iterator();
            ISymbolicEquivalenceClass ec = null;
            while (ec == null && iter.hasNext()) {
                ec = this.findEquivalentClass((ImmutableList<ISymbolicEquivalenceClass>)result, (Term)iter.next());
            }
            if (ec == null) {
                ec = new SymbolicEquivalenceClass(this.getServices(), this.settings);
                result = result.append((Object)ec);
            }
            for (Term sub : term.subs()) {
                if (ec.containsTerm(sub)) continue;
                ((SymbolicEquivalenceClass)ec).addTerm(sub);
            }
        }
        return result;
    }

    protected ISymbolicEquivalenceClass findEquivalentClass(ImmutableList<ISymbolicEquivalenceClass> equivalentClasses, final Term term) {
        return (ISymbolicEquivalenceClass)CollectionUtil.search(equivalentClasses, (IFilter)new IFilter<ISymbolicEquivalenceClass>(){

            public boolean select(ISymbolicEquivalenceClass element) {
                return element.containsTerm(term);
            }
        });
    }

    protected ISymbolicLayout createLayoutFromExecutionVariableValuePairs(ImmutableList<ISymbolicEquivalenceClass> equivalentClasses, Set<AbstractUpdateExtractor.ExecutionVariableValuePair> pairs, String stateName) throws ProofInputException {
        SymbolicLayout result = new SymbolicLayout(this.settings, equivalentClasses);
        SymbolicState state = new SymbolicState(stateName, this.settings);
        result.setState(state);
        LinkedHashMap<Term, SymbolicObject> objects = new LinkedHashMap<Term, SymbolicObject>();
        for (AbstractUpdateExtractor.ExecutionVariableValuePair pair : pairs) {
            this.createObjectForTerm(objects, equivalentClasses, result, pair.getParent());
            this.createObjectForTerm(objects, equivalentClasses, result, pair.getValue());
        }
        for (AbstractUpdateExtractor.ExecutionVariableValuePair pair : pairs) {
            SymbolicObject target;
            ISymbolicEquivalenceClass equivalentClass;
            Term parent = pair.getParent();
            Term valueTerm = pair.getValue();
            AbstractSymbolicAssociationValueContainer container = parent != null ? (AbstractSymbolicAssociationValueContainer)objects.get((equivalentClass = this.findEquivalentClass(equivalentClasses, parent)) != null ? equivalentClass.getRepresentative() : parent) : (pair.isStateMember() || !this.objectsToIgnore.contains(valueTerm) ? state : null);
            if (container == null) continue;
            ISymbolicEquivalenceClass eq = this.findEquivalentClass(equivalentClasses, valueTerm);
            if (eq != null) {
                valueTerm = eq.getRepresentative();
            }
            if ((target = (SymbolicObject)objects.get(valueTerm)) != null) {
                SymbolicAssociation association = pair.isArrayRange() ? new SymbolicAssociation(this.getServices(), pair.getArrayIndex(), pair.getArrayStartIndex(), pair.getArrayEndIndex(), target, pair.getCondition(), this.settings) : (pair.isArrayIndex() ? new SymbolicAssociation(this.getServices(), pair.getArrayIndex(), (ISymbolicObject)target, pair.getCondition(), this.settings) : new SymbolicAssociation(this.getServices(), (IProgramVariable)pair.getProgramVariable(), (ISymbolicObject)target, pair.getCondition(), this.settings));
                ISymbolicAssociation existingAssociation = container.getAssociation(association.getProgramVariable(), association.isArrayIndex(), association.getArrayIndex(), association.getCondition());
                if (existingAssociation == null) {
                    container.addAssociation(association);
                    continue;
                }
                if (ObjectUtil.equals((Object)association.getTarget(), (Object)existingAssociation.getTarget())) continue;
                throw new ProofInputException("Multiple association targets found: " + association + " and " + existingAssociation + ".");
            }
            SymbolicValue value = pair.isArrayRange() ? new SymbolicValue(this.getServices(), pair.getArrayIndex(), pair.getArrayStartIndex(), pair.getArrayEndIndex(), valueTerm, pair.getCondition(), this.settings) : (pair.isArrayIndex() ? new SymbolicValue(this.getServices(), pair.getArrayIndex(), valueTerm, pair.getCondition(), this.settings) : new SymbolicValue(this.getServices(), (IProgramVariable)pair.getProgramVariable(), valueTerm, pair.getCondition(), this.settings));
            ISymbolicValue existingValue = container.getValue(value.getProgramVariable(), value.isArrayIndex(), value.getArrayIndex(), value.getCondition());
            if (existingValue == null) {
                container.addValue(value);
                continue;
            }
            if (ObjectUtil.equals((Object)value.getValue(), (Object)existingValue.getValue())) continue;
            throw new ProofInputException("Multiple values found: " + value + " and " + existingValue + ".");
        }
        return result;
    }

    protected void createObjectForTerm(Map<Term, SymbolicObject> objects, ImmutableList<ISymbolicEquivalenceClass> equivalentClasses, SymbolicLayout result, Term objectTerm) {
        if (objectTerm != null && SymbolicExecutionUtil.hasReferenceSort(this.getServices(), objectTerm)) {
            SymbolicObject object;
            ISymbolicEquivalenceClass equivalentClass = this.findEquivalentClass(equivalentClasses, objectTerm);
            if (equivalentClass != null) {
                objectTerm = equivalentClass.getRepresentative();
            }
            if ((object = objects.get(objectTerm)) == null) {
                object = new SymbolicObject(this.getServices(), objectTerm, this.settings);
                objects.put(objectTerm, object);
                result.addObject(object);
            }
        }
    }
}

