/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.symbolic_execution.object_model.IModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicAssociation;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicAssociationValueContainer;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicElement;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicLayout;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicObject;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicState;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SymbolicLayoutReader {
    public ISymbolicLayout read(File file) throws ParserConfigurationException, SAXException, IOException {
        return this.read(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISymbolicLayout read(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        if (in != null) {
            try {
                ISymbolicLayout root;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser saxParser = factory.newSAXParser();
                SEDSAXHandler handler = new SEDSAXHandler();
                saxParser.parse(in, (DefaultHandler)handler);
                ISymbolicLayout iSymbolicLayout = root = handler.getRoot();
                return iSymbolicLayout;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    protected boolean isModel(String uri, String localName, String qName) {
        return "model".equals(qName);
    }

    protected boolean isAssociation(String uri, String localName, String qName) {
        return "association".equals(qName);
    }

    protected boolean isValue(String uri, String localName, String qName) {
        return "value".equals(qName);
    }

    protected boolean isObject(String uri, String localName, String qName) {
        return "object".equals(qName);
    }

    protected boolean isState(String uri, String localName, String qName) {
        return "state".equals(qName);
    }

    protected boolean isEquivalenceClass(String uri, String localName, String qName) {
        return "equivalenceClass".equals(qName);
    }

    protected boolean isTerm(String uri, String localName, String qName) {
        return "term".equals(qName);
    }

    protected String getValueString(Attributes attributes) {
        return attributes.getValue("value");
    }

    protected String getConditionString(Attributes attributes) {
        return attributes.getValue("condition");
    }

    protected String getTypeString(Attributes attributes) {
        return attributes.getValue("type");
    }

    protected String getProgramVariableString(Attributes attributes) {
        return attributes.getValue("programVariable");
    }

    protected String getName(Attributes attributes) {
        return attributes.getValue("name");
    }

    protected String getArrayIndexString(Attributes attributes) {
        return attributes.getValue("arrayIndex");
    }

    protected boolean isArrayIndex(Attributes attributes) {
        return Boolean.parseBoolean(attributes.getValue("isArrayIndex"));
    }

    protected String getId(Attributes attributes) {
        return attributes.getValue("xml:id");
    }

    protected String getTarget(Attributes attributes) {
        return attributes.getValue("target");
    }

    protected String getRepresentativeTerm(Attributes attributes) {
        return attributes.getValue("representativeTerm");
    }

    protected String getTerm(Attributes attributes) {
        return attributes.getValue("term");
    }

    public static class KeYlessEquivalenceClass
    extends AbstractKeYlessElement
    implements ISymbolicEquivalenceClass {
        private ImmutableList<String> termStrings;
        private String representativeString;

        public KeYlessEquivalenceClass(String representativeString) {
            this((ImmutableList<String>)ImmutableSLList.nil(), representativeString);
        }

        public KeYlessEquivalenceClass(ImmutableList<String> termStrings, String representativeString) {
            this.termStrings = termStrings;
            this.representativeString = representativeString;
        }

        @Override
        public ImmutableList<Term> getTerms() {
            return null;
        }

        @Override
        public ImmutableList<String> getTermStrings() {
            return this.termStrings;
        }

        public void addTermString(String termString) {
            this.termStrings = this.termStrings.append((Object)termString);
        }

        @Override
        public Term getRepresentative() {
            return null;
        }

        @Override
        public String getRepresentativeString() {
            return this.representativeString;
        }

        @Override
        public boolean containsTerm(Term term) {
            return false;
        }
    }

    public static class KeYlessAssociation
    extends AbstractKeYlessElement
    implements ISymbolicAssociation {
        private String programVariableString;
        private ISymbolicObject target;
        private String name;
        private boolean isArrayIndex;
        private String arrayIndexString;
        private String conditionString;

        public KeYlessAssociation(String name, String programVariableString, boolean isArrayIndex, String arrayIndexString, String conditionString) {
            this(name, programVariableString, isArrayIndex, arrayIndexString, null, conditionString);
        }

        public KeYlessAssociation(String name, String programVariableString, boolean isArrayIndex, String arrayIndexString, ISymbolicObject target, String conditionString) {
            this.name = name;
            this.programVariableString = programVariableString;
            this.isArrayIndex = isArrayIndex;
            this.arrayIndexString = arrayIndexString;
            this.target = target;
            this.conditionString = conditionString;
        }

        public String toString() {
            return "Association " + this.getName() + " to " + this.getTarget();
        }

        @Override
        public IProgramVariable getProgramVariable() {
            return null;
        }

        @Override
        public String getProgramVariableString() {
            return this.programVariableString;
        }

        public void setTarget(ISymbolicObject target) {
            this.target = target;
        }

        @Override
        public ISymbolicObject getTarget() {
            return this.target;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isArrayIndex() {
            return this.isArrayIndex;
        }

        @Override
        public Term getArrayIndex() {
            return null;
        }

        @Override
        public String getArrayIndexString() {
            return this.arrayIndexString;
        }

        @Override
        public Term getCondition() {
            return null;
        }

        @Override
        public String getConditionString() {
            return this.conditionString;
        }
    }

    public static class KeYlessValue
    extends AbstractKeYlessElement
    implements ISymbolicValue {
        private String programVariableString;
        private String valueString;
        private String typeString;
        private String name;
        private boolean isArrayIndex;
        private String arrayIndexString;
        private String conditionString;

        public KeYlessValue(String name, String programVariableString, boolean isArrayIndex, String arrayIndexString, String valueString, String typeString, String conditionString) {
            this.name = name;
            this.programVariableString = programVariableString;
            this.isArrayIndex = isArrayIndex;
            this.arrayIndexString = arrayIndexString;
            this.valueString = valueString;
            this.typeString = typeString;
            this.conditionString = conditionString;
        }

        public String toString() {
            return "Value of " + this.getName() + " is " + this.getValueString();
        }

        @Override
        public IProgramVariable getProgramVariable() {
            return null;
        }

        @Override
        public String getProgramVariableString() {
            return this.programVariableString;
        }

        @Override
        public Term getValue() {
            return null;
        }

        @Override
        public String getValueString() {
            return this.valueString;
        }

        @Override
        public Sort getType() {
            return null;
        }

        @Override
        public String getTypeString() {
            return this.typeString;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isArrayIndex() {
            return this.isArrayIndex;
        }

        @Override
        public Term getArrayIndex() {
            return null;
        }

        @Override
        public String getArrayIndexString() {
            return this.arrayIndexString;
        }

        @Override
        public Term getCondition() {
            return null;
        }

        @Override
        public String getConditionString() {
            return this.conditionString;
        }
    }

    public static class KeYlessObject
    extends AbstractKeYlessAssociationValueContainer
    implements ISymbolicObject {
        private String nameString;
        private String typeString;

        public KeYlessObject(String nameString, String typeString) {
            this.nameString = nameString;
            this.typeString = typeString;
        }

        public String toString() {
            return "Object " + this.getNameString();
        }

        @Override
        public Term getName() {
            return null;
        }

        @Override
        public String getNameString() {
            return this.nameString;
        }

        @Override
        public Sort getType() {
            return null;
        }

        @Override
        public String getTypeString() {
            return this.typeString;
        }

        @Override
        public ISymbolicAssociation getAssociation(IProgramVariable programVariable, boolean isArrayIndex, Term arrayIndex, Term condition) {
            return null;
        }

        @Override
        public ISymbolicValue getValue(IProgramVariable programVariable, boolean isArrayIndex, Term arrayIndex, Term condition) {
            return null;
        }
    }

    public static class KeYlessState
    extends AbstractKeYlessAssociationValueContainer
    implements ISymbolicState {
        private String name;

        public KeYlessState(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ISymbolicAssociation getAssociation(IProgramVariable programVariable, boolean isArrayIndex, Term arrayIndex, Term condition) {
            return null;
        }

        @Override
        public ISymbolicValue getValue(IProgramVariable programVariable, boolean isArrayIndex, Term arrayIndex, Term condition) {
            return null;
        }
    }

    public static abstract class AbstractKeYlessAssociationValueContainer
    extends AbstractKeYlessElement
    implements ISymbolicAssociationValueContainer {
        private ImmutableList<ISymbolicAssociation> associations = ImmutableSLList.nil();
        private ImmutableList<ISymbolicValue> values = ImmutableSLList.nil();

        @Override
        public ImmutableList<ISymbolicAssociation> getAssociations() {
            return this.associations;
        }

        public void addAssociation(ISymbolicAssociation association) {
            this.associations = this.associations.append((Object)association);
        }

        @Override
        public ImmutableList<ISymbolicValue> getValues() {
            return this.values;
        }

        public void addValue(ISymbolicValue value) {
            this.values = this.values.append((Object)value);
        }
    }

    public static class KeYlessLayout
    extends AbstractKeYlessElement
    implements ISymbolicLayout {
        private ISymbolicState state;
        private ImmutableList<ISymbolicObject> objects = ImmutableSLList.nil();
        private ImmutableList<ISymbolicEquivalenceClass> equivalenceClasses = ImmutableSLList.nil();

        @Override
        public ISymbolicState getState() {
            return this.state;
        }

        public void setState(ISymbolicState state) {
            this.state = state;
        }

        @Override
        public ImmutableList<ISymbolicObject> getObjects() {
            return this.objects;
        }

        public void addObject(ISymbolicObject object) {
            this.objects = this.objects.append((Object)object);
        }

        @Override
        public ImmutableList<ISymbolicEquivalenceClass> getEquivalenceClasses() {
            return this.equivalenceClasses;
        }

        public void addEquivalenceClass(ISymbolicEquivalenceClass ec) {
            this.equivalenceClasses = this.equivalenceClasses.append((Object)ec);
        }
    }

    public static abstract class AbstractKeYlessElement
    implements ISymbolicElement {
        @Override
        public IModelSettings getSettings() {
            return null;
        }
    }

    private class SEDSAXHandler
    extends DefaultHandler {
        private ISymbolicLayout root;
        private Deque<Object> parentStack = new LinkedList<Object>();
        private Map<String, ISymbolicObject> objectIdMapping = new LinkedHashMap<String, ISymbolicObject>();
        private Map<KeYlessAssociation, String> associationTargetMapping = new LinkedHashMap<KeYlessAssociation, String>();

        private SEDSAXHandler() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object parent = this.parentStack.peekFirst();
            if (SymbolicLayoutReader.this.isModel(uri, localName, qName)) {
                if (this.root != null) throw new SAXException("Model found a second time.");
                this.root = new KeYlessLayout();
                this.parentStack.addFirst(this.root);
                return;
            } else if (SymbolicLayoutReader.this.isState(uri, localName, qName)) {
                if (!(parent instanceof KeYlessLayout)) {
                    throw new SAXException("Found state in wrong hierarchy.");
                }
                KeYlessState state = new KeYlessState(SymbolicLayoutReader.this.getName(attributes));
                if (((KeYlessLayout)parent).getState() != null) {
                    throw new SAXException("State found a second time.");
                }
                ((KeYlessLayout)parent).setState(state);
                this.parentStack.addFirst(state);
                return;
            } else if (SymbolicLayoutReader.this.isObject(uri, localName, qName)) {
                if (!(parent instanceof KeYlessLayout)) {
                    throw new SAXException("Found object in wrong hierarchy.");
                }
                KeYlessObject object = new KeYlessObject(SymbolicLayoutReader.this.getName(attributes), SymbolicLayoutReader.this.getTypeString(attributes));
                ((KeYlessLayout)parent).addObject(object);
                this.parentStack.addFirst(object);
                this.objectIdMapping.put(SymbolicLayoutReader.this.getId(attributes), object);
                return;
            } else if (SymbolicLayoutReader.this.isValue(uri, localName, qName)) {
                if (!(parent instanceof AbstractKeYlessAssociationValueContainer)) {
                    throw new SAXException("Found value in wrong hierarchy.");
                }
                KeYlessValue value = new KeYlessValue(SymbolicLayoutReader.this.getName(attributes), SymbolicLayoutReader.this.getProgramVariableString(attributes), SymbolicLayoutReader.this.isArrayIndex(attributes), SymbolicLayoutReader.this.getArrayIndexString(attributes), SymbolicLayoutReader.this.getValueString(attributes), SymbolicLayoutReader.this.getTypeString(attributes), SymbolicLayoutReader.this.getConditionString(attributes));
                ((AbstractKeYlessAssociationValueContainer)parent).addValue(value);
                this.parentStack.addFirst(value);
                return;
            } else if (SymbolicLayoutReader.this.isAssociation(uri, localName, qName)) {
                if (!(parent instanceof AbstractKeYlessAssociationValueContainer)) {
                    throw new SAXException("Found association in wrong hierarchy.");
                }
                KeYlessAssociation association = new KeYlessAssociation(SymbolicLayoutReader.this.getName(attributes), SymbolicLayoutReader.this.getProgramVariableString(attributes), SymbolicLayoutReader.this.isArrayIndex(attributes), SymbolicLayoutReader.this.getArrayIndexString(attributes), SymbolicLayoutReader.this.getConditionString(attributes));
                ((AbstractKeYlessAssociationValueContainer)parent).addAssociation(association);
                this.parentStack.addFirst(association);
                this.associationTargetMapping.put(association, SymbolicLayoutReader.this.getTarget(attributes));
                return;
            } else if (SymbolicLayoutReader.this.isEquivalenceClass(uri, localName, qName)) {
                if (!(parent instanceof KeYlessLayout)) {
                    throw new SAXException("Found equivalence class in wrong hierarchy.");
                }
                KeYlessEquivalenceClass ec = new KeYlessEquivalenceClass(SymbolicLayoutReader.this.getRepresentativeTerm(attributes));
                ((KeYlessLayout)parent).addEquivalenceClass(ec);
                this.parentStack.addFirst(ec);
                return;
            } else {
                if (!SymbolicLayoutReader.this.isTerm(uri, localName, qName)) throw new SAXException("Unsupported tag \"" + localName + "\".");
                if (!(parent instanceof ISymbolicEquivalenceClass)) {
                    throw new SAXException("Found term in wrong hierarchy.");
                }
                ((KeYlessEquivalenceClass)parent).addTermString(SymbolicLayoutReader.this.getTerm(attributes));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!SymbolicLayoutReader.this.isTerm(uri, localName, qName)) {
                this.parentStack.removeFirst();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            for (Map.Entry<KeYlessAssociation, String> entry : this.associationTargetMapping.entrySet()) {
                ISymbolicObject target = this.objectIdMapping.get(entry.getValue());
                if (target == null) {
                    throw new SAXException("Association target object with id \"" + entry.getValue() + "\" is not available.");
                }
                entry.getKey().setTarget(target);
            }
        }

        public ISymbolicLayout getRoot() {
            return this.root;
        }
    }
}

