/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.symbolic_execution.AbstractWriter;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicAssociation;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicLayout;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicObject;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicState;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicValue;
import de.uka.ilkd.key.util.LinkedHashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;

public class SymbolicLayoutWriter
extends AbstractWriter {
    public static final String TAG_MODEL = "model";
    public static final String TAG_STATE = "state";
    public static final String TAG_OBJECT = "object";
    public static final String TAG_VALUE = "value";
    public static final String TAG_ASSOCIATION = "association";
    public static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    public static final String TAG_TERM = "term";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_PROGRAM_VARIABLE = "programVariable";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_CONDITION = "condition";
    public static final String ATTRIBUTE_TARGET = "target";
    public static final String ATTRIBUTE_TERM = "term";
    public static final String ATTRIBUTE_REPRESENTATIVE = "representativeTerm";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_IS_ARRAY_INDEX = "isArrayIndex";
    public static final String ATTRIBUTE_ARRAY_INDEX = "arrayIndex";

    public void write(ISymbolicLayout model, String encoding, File file) throws IOException {
        this.write(model, encoding, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ISymbolicLayout model, String encoding, OutputStream out) throws IOException {
        if (out != null) {
            try {
                Charset charset = encoding != null ? Charset.forName(encoding) : Charset.defaultCharset();
                String xml = this.toXML(model, charset.displayName());
                out.write(xml.getBytes(charset));
            }
            finally {
                out.close();
            }
        }
    }

    public String toXML(ISymbolicLayout model, String encoding) {
        StringBuffer sb = new StringBuffer();
        this.appendXmlHeader(encoding, sb);
        this.appendModel(0, model, sb);
        return sb.toString();
    }

    protected void appendModel(int level, ISymbolicLayout model, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        this.appendStartTag(level, TAG_MODEL, (Map<String, String>)attributeValues, sb);
        for (ISymbolicEquivalenceClass ec : model.getEquivalenceClasses()) {
            this.appendEquivalenceClass(level + 1, ec, sb);
        }
        this.appendState(level + 1, model, model.getState(), sb);
        for (ISymbolicObject object : model.getObjects()) {
            this.appendObject(level + 1, model, object, sb);
        }
        this.appendEndTag(level, TAG_MODEL, sb);
    }

    protected void appendEquivalenceClass(int level, ISymbolicEquivalenceClass ec, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_REPRESENTATIVE, ec.getRepresentativeString());
        this.appendStartTag(level, TAG_EQUIVALENCE_CLASS, (Map<String, String>)attributeValues, sb);
        for (String term : ec.getTermStrings()) {
            LinkedHashMap termAttributeValues = new LinkedHashMap();
            termAttributeValues.put("term", term);
            this.appendEmptyTag(level + 1, "term", (Map<String, String>)termAttributeValues, sb);
        }
        this.appendEndTag(level, TAG_EQUIVALENCE_CLASS, sb);
    }

    protected void appendState(int level, ISymbolicLayout model, ISymbolicState state, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, state.getName());
        this.appendStartTag(level, TAG_STATE, (Map<String, String>)attributeValues, sb);
        for (ISymbolicValue value : state.getValues()) {
            this.appendValue(level + 1, value, sb);
        }
        for (ISymbolicAssociation association : state.getAssociations()) {
            this.appendAssociation(level + 1, model, association, sb);
        }
        this.appendEndTag(level, TAG_STATE, sb);
    }

    protected void appendObject(int level, ISymbolicLayout model, ISymbolicObject object, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put("xml:id", this.computeObjectId(model, object));
        attributeValues.put(ATTRIBUTE_NAME, object.getNameString());
        attributeValues.put(ATTRIBUTE_TYPE, object.getTypeString());
        this.appendStartTag(level, TAG_OBJECT, (Map<String, String>)attributeValues, sb);
        for (ISymbolicValue value : object.getValues()) {
            this.appendValue(level + 1, value, sb);
        }
        for (ISymbolicAssociation association : object.getAssociations()) {
            this.appendAssociation(level + 1, model, association, sb);
        }
        this.appendEndTag(level, TAG_OBJECT, sb);
    }

    protected void appendValue(int level, ISymbolicValue value, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, value.getName());
        attributeValues.put(ATTRIBUTE_PROGRAM_VARIABLE, value.getProgramVariableString());
        attributeValues.put(ATTRIBUTE_IS_ARRAY_INDEX, "" + value.isArrayIndex());
        attributeValues.put(ATTRIBUTE_ARRAY_INDEX, value.getArrayIndexString());
        attributeValues.put("value", value.getValueString());
        attributeValues.put(ATTRIBUTE_TYPE, value.getTypeString());
        if (value.getConditionString() != null) {
            attributeValues.put(ATTRIBUTE_CONDITION, value.getConditionString());
        }
        this.appendEmptyTag(level, "value", (Map<String, String>)attributeValues, sb);
    }

    protected void appendAssociation(int level, ISymbolicLayout model, ISymbolicAssociation association, StringBuffer sb) {
        LinkedHashMap attributeValues = new LinkedHashMap();
        attributeValues.put(ATTRIBUTE_NAME, association.getName());
        attributeValues.put(ATTRIBUTE_PROGRAM_VARIABLE, association.getProgramVariableString());
        attributeValues.put(ATTRIBUTE_IS_ARRAY_INDEX, "" + association.isArrayIndex());
        attributeValues.put(ATTRIBUTE_ARRAY_INDEX, association.getArrayIndexString());
        attributeValues.put(ATTRIBUTE_TARGET, this.computeObjectId(model, association.getTarget()));
        if (association.getConditionString() != null) {
            attributeValues.put(ATTRIBUTE_CONDITION, association.getConditionString());
        }
        this.appendEmptyTag(level, TAG_ASSOCIATION, (Map<String, String>)attributeValues, sb);
    }

    protected String computeObjectId(ISymbolicLayout model, ISymbolicObject object) {
        int i = 0;
        int index = -1;
        Iterator iter = model.getObjects().iterator();
        while (index < 0 && iter.hasNext()) {
            ISymbolicObject next = (ISymbolicObject)iter.next();
            if (next == object) {
                index = i;
            }
            ++i;
        }
        return "o" + (index + 1);
    }
}

