/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.label.FormulaTermLabel;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.op.AbstractTermTransformer;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.IfThenElse;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.SortedOperator;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.rule.IfFormulaInstSeq;
import de.uka.ilkd.key.rule.IfFormulaInstantiation;
import de.uka.ilkd.key.rule.OneStepSimplifierRuleApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.tacletbuilder.TacletGoalTemplate;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.NodePreorderIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.java.ArrayUtil;

public final class TruthValueTracingUtil {
    private TruthValueTracingUtil() {
    }

    public static boolean isPredicate(SequentFormula sequentFormula) {
        return sequentFormula != null ? TruthValueTracingUtil.isPredicate(sequentFormula.formula()) : false;
    }

    public static boolean isPredicate(Term term) {
        return term != null ? TruthValueTracingUtil.isPredicate(term.op()) : false;
    }

    public static boolean isPredicate(Operator operator) {
        if (operator == Equality.EQV) {
            return false;
        }
        if (operator instanceof Junctor) {
            return operator == Junctor.TRUE || operator == Junctor.FALSE;
        }
        if (operator == AbstractTermTransformer.META_EQ || operator == AbstractTermTransformer.META_GEQ || operator == AbstractTermTransformer.META_GREATER || operator == AbstractTermTransformer.META_LEQ || operator == AbstractTermTransformer.META_LESS) {
            return true;
        }
        if (operator instanceof SortedOperator) {
            return ((SortedOperator)operator).sort() == Sort.FORMULA;
        }
        return false;
    }

    public static boolean isLogicOperator(Term term) {
        if (term != null) {
            return TruthValueTracingUtil.isLogicOperator(term.op(), (ImmutableArray<Term>)term.subs());
        }
        return false;
    }

    public static boolean isLogicOperator(Operator operator, ImmutableArray<Term> subs) {
        if (operator instanceof Junctor) {
            return operator != Junctor.TRUE && operator != Junctor.FALSE;
        }
        if (operator == Equality.EQV) {
            return true;
        }
        return TruthValueTracingUtil.isIfThenElseFormula(operator, subs);
    }

    public static boolean isIfThenElseFormula(Term term) {
        if (term != null) {
            return TruthValueTracingUtil.isIfThenElseFormula(term.op(), (ImmutableArray<Term>)term.subs());
        }
        return false;
    }

    public static boolean isIfThenElseFormula(Operator operator, ImmutableArray<Term> subs) {
        if (operator == IfThenElse.IF_THEN_ELSE) {
            Sort sort = operator.sort(subs);
            return sort == Sort.FORMULA;
        }
        return false;
    }

    public static TruthValueTracingResult evaluate(Node node, Name termLabelName, boolean useUnicode, boolean usePrettyPrinting) throws ProofInputException {
        TruthValueTracingResult result = new TruthValueTracingResult();
        LinkedList evaluationStack = new LinkedList();
        evaluationStack.addFirst(new HashMap());
        Services services = node.proof().getServices();
        NodePreorderIterator iterator = new NodePreorderIterator(node);
        while (iterator.hasNext()) {
            int childIndexOnParnt = iterator.getChildIndexOnParent();
            Node next = iterator.next();
            Map topResults = (Map)evaluationStack.getFirst();
            HashMap<String, MultiEvaluationResult> nodeResults = new HashMap<String, MultiEvaluationResult>(topResults);
            evaluationStack.addFirst(nodeResults);
            TruthValueTracingUtil.evaluateNode(node, useUnicode, usePrettyPrinting, next, childIndexOnParnt, termLabelName, nodeResults, result, services);
            for (int i = 0; i < iterator.getReturnedParents(); ++i) {
                evaluationStack.removeFirst();
            }
        }
        return result;
    }

    protected static void evaluateNode(Node evaluationNode, boolean useUnicode, boolean usePrettyPrinting, Node child, int childIndexOnParent, Name termLabelName, Map<String, MultiEvaluationResult> nodeResult, TruthValueTracingResult result, Services services) throws ProofInputException {
        int childCount;
        boolean checkPerformed = false;
        if (childIndexOnParent >= 0) {
            Node parent = child.parent();
            if (parent.getAppliedRuleApp() instanceof TacletApp) {
                TacletApp tacletApp = (TacletApp)parent.getAppliedRuleApp();
                List<LabelOccurrence> labels = TruthValueTracingUtil.findInvolvedLabels(parent.sequent(), tacletApp, termLabelName);
                if (!labels.isEmpty()) {
                    Taclet taclet = tacletApp.taclet();
                    if (!TruthValueTracingUtil.isClosingRule(taclet)) {
                        checkPerformed = true;
                        TacletGoalTemplate tacletGoal = (TacletGoalTemplate)taclet.goalTemplates().reverse().take(childIndexOnParent).head();
                        TruthValueTracingUtil.updatePredicateResultBasedOnNewMinorIds(child, termLabelName, services.getTermBuilder(), nodeResult);
                        TruthValueTracingUtil.analyzeTacletGoal(parent, tacletApp, tacletGoal, labels, services, nodeResult);
                    } else if (tacletApp.posInOccurrence() != null) {
                        for (LabelOccurrence occurrence : labels) {
                            TruthValueTracingUtil.updatePredicateResult(occurrence.getLabel(), !occurrence.isInAntecedent(), nodeResult);
                        }
                    }
                }
            } else if (parent.getAppliedRuleApp() instanceof OneStepSimplifierRuleApp) {
                OneStepSimplifierRuleApp app = (OneStepSimplifierRuleApp)parent.getAppliedRuleApp();
                PosInOccurrence parentPio = null;
                for (RuleApp protocolApp : app.getProtocol()) {
                    if (parentPio != null) {
                        TruthValueTracingUtil.updatePredicateResultBasedOnNewMinorIdsOSS(protocolApp.posInOccurrence(), parentPio, termLabelName, services.getTermBuilder(), nodeResult);
                    }
                    assert (protocolApp instanceof TacletApp);
                    TacletApp tacletApp = (TacletApp)protocolApp;
                    Taclet taclet = tacletApp.taclet();
                    assert (taclet.goalTemplates().size() == 1);
                    List<LabelOccurrence> labels = TruthValueTracingUtil.findInvolvedLabels(parent.sequent(), tacletApp, termLabelName);
                    if (!labels.isEmpty()) {
                        TruthValueTracingUtil.analyzeTacletGoal(parent, tacletApp, (TacletGoalTemplate)taclet.goalTemplates().head(), labels, services, nodeResult);
                    }
                    parentPio = protocolApp.posInOccurrence();
                }
                if (parentPio != null) {
                    assert (1 == parent.childrenCount()) : "Implementaton of the OneStepSimplifierRule has changed.";
                    PosInOccurrence childPio = SymbolicExecutionUtil.posInOccurrenceToOtherSequent(parent, parent.getAppliedRuleApp().posInOccurrence(), parent.child(0));
                    TruthValueTracingUtil.updatePredicateResultBasedOnNewMinorIdsOSS(childPio, parentPio, termLabelName, services.getTermBuilder(), nodeResult);
                }
            }
        }
        if ((childCount = child.childrenCount()) == 0) {
            Term condition = SymbolicExecutionUtil.computePathCondition(evaluationNode, child, false, true);
            String conditionString = SymbolicExecutionUtil.formatTerm(condition, services, useUnicode, usePrettyPrinting);
            result.addBranchResult(new BranchResult(child, nodeResult, condition, conditionString, termLabelName));
        } else if (!checkPerformed) {
            TruthValueTracingUtil.updatePredicateResultBasedOnNewMinorIds(child, termLabelName, services.getTermBuilder(), nodeResult);
        }
    }

    protected static boolean isClosingRule(Taclet taclet) {
        return taclet.goalTemplates().isEmpty();
    }

    protected static List<LabelOccurrence> findInvolvedLabels(Sequent sequent, TacletApp tacletApp, Name termLabelName) {
        TermLabel label;
        Term term;
        LinkedList<LabelOccurrence> result = new LinkedList<LabelOccurrence>();
        PosInOccurrence pio = tacletApp.posInOccurrence();
        if (pio != null && (term = pio.subTerm()) != null && (label = term.getLabel(termLabelName)) instanceof FormulaTermLabel) {
            result.add(new LabelOccurrence((FormulaTermLabel)label, pio.isInAntec()));
        }
        if (TruthValueTracingUtil.isClosingRule(tacletApp.taclet()) && tacletApp.ifInstsComplete() && tacletApp.ifFormulaInstantiations() != null) {
            for (IfFormulaInstantiation ifInst : tacletApp.ifFormulaInstantiations()) {
                assert (ifInst instanceof IfFormulaInstSeq);
                Term term2 = ifInst.getConstrainedFormula().formula();
                TermLabel label2 = term2.getLabel(termLabelName);
                if (!(label2 instanceof FormulaTermLabel)) continue;
                result.add(new LabelOccurrence((FormulaTermLabel)label2, ((IfFormulaInstSeq)ifInst).inAntec()));
            }
        }
        return result;
    }

    protected static void analyzeTacletGoal(Node parent, TacletApp tacletApp, TacletGoalTemplate tacletGoal, List<LabelOccurrence> labels, Services services, Map<String, MultiEvaluationResult> results) {
        block2: {
            Term replaceTerm;
            block3: {
                Object replaceObject = tacletGoal.replaceWithExpressionAsObject();
                if (!(replaceObject instanceof Term)) break block2;
                replaceTerm = SymbolicExecutionUtil.instantiateTerm(parent, (Term)replaceObject, tacletApp, services);
                if (replaceTerm.op() != Junctor.TRUE) break block3;
                for (LabelOccurrence occurrence : labels) {
                    TruthValueTracingUtil.updatePredicateResult(occurrence.getLabel(), true, results);
                }
                break block2;
            }
            if (replaceTerm.op() != Junctor.FALSE) break block2;
            for (LabelOccurrence occurrence : labels) {
                TruthValueTracingUtil.updatePredicateResult(occurrence.getLabel(), false, results);
            }
        }
    }

    protected static void updatePredicateResultBasedOnNewMinorIdsOSS(final PosInOccurrence childPio, final PosInOccurrence parentPio, final Name termLabelName, final TermBuilder tb, final Map<String, MultiEvaluationResult> results) {
        if (parentPio != null) {
            parentPio.subTerm().execPreOrder((Visitor)new DefaultVisitor(){

                public void visit(Term visited) {
                    TruthValueTracingUtil.checkForNewMinorIdsOSS(childPio.sequentFormula(), visited, termLabelName, parentPio, tb, results);
                }
            });
            PosInOccurrence currentPio = parentPio;
            while (!currentPio.isTopLevel()) {
                currentPio = currentPio.up();
                TruthValueTracingUtil.checkForNewMinorIdsOSS(childPio.sequentFormula(), currentPio.subTerm(), termLabelName, parentPio, tb, results);
            }
        }
    }

    protected static void checkForNewMinorIdsOSS(SequentFormula onlyChangedChildSF, Term term, Name termLabelName, PosInOccurrence parentPio, TermBuilder tb, Map<String, MultiEvaluationResult> results) {
        Term replacement;
        TermLabel label = term.getLabel(termLabelName);
        if (label instanceof FormulaTermLabel && (replacement = TruthValueTracingUtil.checkForNewMinorIdsOSS(onlyChangedChildSF, (FormulaTermLabel)label, parentPio.isInAntec(), tb)) != null) {
            TruthValueTracingUtil.updatePredicateResult((FormulaTermLabel)label, replacement, results);
        }
    }

    protected static Term checkForNewMinorIdsOSS(SequentFormula onlyChangedChildSF, FormulaTermLabel label, boolean antecedentRuleApplication, TermBuilder tb) {
        LinkedList<Term> antecedentReplacements = new LinkedList<Term>();
        LinkedList<Term> succedentReplacements = new LinkedList<Term>();
        if (antecedentRuleApplication) {
            TruthValueTracingUtil.listLabelReplacements(onlyChangedChildSF, label.name(), label.getId(), antecedentReplacements);
        } else {
            TruthValueTracingUtil.listLabelReplacements(onlyChangedChildSF, label.name(), label.getId(), succedentReplacements);
        }
        return TruthValueTracingUtil.computeInstructionTerm(antecedentReplacements, succedentReplacements, antecedentRuleApplication, tb);
    }

    protected static void updatePredicateResultBasedOnNewMinorIds(final Node childNode, final Name termLabelName, final TermBuilder tb, final Map<String, MultiEvaluationResult> results) {
        RuleApp parentRuleApp;
        PosInOccurrence parentPio;
        Node parentNode = childNode.parent();
        if (parentNode != null && (parentPio = (parentRuleApp = parentNode.getAppliedRuleApp()).posInOccurrence()) != null) {
            TacletApp ta;
            parentPio.subTerm().execPreOrder((Visitor)new DefaultVisitor(){

                public void visit(Term visited) {
                    TruthValueTracingUtil.checkForNewMinorIds(childNode, visited, termLabelName, parentPio, tb, results);
                }
            });
            PosInOccurrence currentPio = parentPio;
            while (!currentPio.isTopLevel()) {
                currentPio = currentPio.up();
                TruthValueTracingUtil.checkForNewMinorIds(childNode, currentPio.subTerm(), termLabelName, parentPio, tb, results);
            }
            if (parentRuleApp instanceof TacletApp && (ta = (TacletApp)parentRuleApp).ifInstsComplete() && ta.ifFormulaInstantiations() != null) {
                for (IfFormulaInstantiation ifInst : ta.ifFormulaInstantiations()) {
                    TruthValueTracingUtil.checkForNewMinorIds(childNode, ifInst.getConstrainedFormula().formula(), termLabelName, parentPio, tb, results);
                }
            }
        }
    }

    protected static void checkForNewMinorIds(Node childNode, Term term, Name termLabelName, PosInOccurrence parentPio, TermBuilder tb, Map<String, MultiEvaluationResult> results) {
        Term replacement;
        TermLabel label = term.getLabel(termLabelName);
        if (label instanceof FormulaTermLabel && (replacement = TruthValueTracingUtil.checkForNewMinorIds(childNode, (FormulaTermLabel)label, parentPio.isInAntec(), tb)) != null) {
            TruthValueTracingUtil.updatePredicateResult((FormulaTermLabel)label, replacement, results);
        }
    }

    protected static Term checkForNewMinorIds(Node childNode, FormulaTermLabel label, boolean antecedentRuleApplication, TermBuilder tb) {
        LinkedList<Term> antecedentReplacements = new LinkedList<Term>();
        LinkedList<Term> succedentReplacements = new LinkedList<Term>();
        for (SequentFormula sf : childNode.sequent().antecedent()) {
            TruthValueTracingUtil.listLabelReplacements(sf, label.name(), label.getId(), antecedentReplacements);
        }
        for (SequentFormula sf : childNode.sequent().succedent()) {
            TruthValueTracingUtil.listLabelReplacements(sf, label.name(), label.getId(), succedentReplacements);
        }
        return TruthValueTracingUtil.computeInstructionTerm(antecedentReplacements, succedentReplacements, antecedentRuleApplication, tb);
    }

    protected static void listLabelReplacements(SequentFormula sf, final Name labelName, final String labelId, final List<Term> resultToFill) {
        sf.formula().execPreOrder((Visitor)new DefaultVisitor(){

            public boolean visitSubtree(Term visited) {
                return !this.hasLabelOfInterest(visited);
            }

            public void visit(Term visited) {
                if (this.hasLabelOfInterest(visited)) {
                    resultToFill.add(visited);
                }
            }

            protected boolean hasLabelOfInterest(Term visited) {
                TermLabel visitedLabel = visited.getLabel(labelName);
                if (visitedLabel instanceof FormulaTermLabel) {
                    FormulaTermLabel pLabel = (FormulaTermLabel)visitedLabel;
                    Object[] beforeIds = pLabel.getBeforeIds();
                    return ArrayUtil.contains((Object[])beforeIds, (Object)labelId);
                }
                return false;
            }
        });
    }

    protected static Term computeInstructionTerm(List<Term> antecedentReplacements, List<Term> succedentReplacements, boolean antecedentRuleApplication, TermBuilder tb) {
        if (!antecedentReplacements.isEmpty() || !succedentReplacements.isEmpty()) {
            Term left = tb.andPreserveLabels(antecedentReplacements);
            Term right = tb.orPreserveLabels(succedentReplacements);
            if (antecedentRuleApplication) {
                return tb.andPreserveLabels(left, tb.notPreserveLabels(right));
            }
            return tb.impPreserveLabels(left, right);
        }
        return null;
    }

    protected static void updatePredicateResult(FormulaTermLabel label, Term instructionTerm, Map<String, MultiEvaluationResult> results) {
        MultiEvaluationResult result = results.get(label.getId());
        result = result == null ? new MultiEvaluationResult(instructionTerm) : result.newInstructionTerm(instructionTerm);
        results.put(label.getId(), result);
    }

    protected static void updatePredicateResult(FormulaTermLabel label, boolean evaluationResult, Map<String, MultiEvaluationResult> results) {
        MultiEvaluationResult result = results.get(label.getId());
        result = result == null ? new MultiEvaluationResult(evaluationResult) : result.newEvaluationResult(evaluationResult);
        results.put(label.getId(), result);
    }

    public static enum TruthValue {
        TRUE,
        FALSE,
        UNKNOWN;


        public String toString() {
            if (this == TRUE) {
                return "true";
            }
            if (this == FALSE) {
                return "false";
            }
            return "unknown";
        }

        public static TruthValue and(TruthValue left, TruthValue right) {
            if (left == null || UNKNOWN.equals((Object)left)) {
                if (FALSE.equals((Object)right)) {
                    return FALSE;
                }
                return UNKNOWN;
            }
            if (right == null || UNKNOWN.equals((Object)right)) {
                if (FALSE.equals((Object)left)) {
                    return FALSE;
                }
                return UNKNOWN;
            }
            if (TRUE.equals((Object)left) && TRUE.equals((Object)right)) {
                return TRUE;
            }
            return FALSE;
        }

        public static TruthValue imp(TruthValue left, TruthValue right) {
            return TruthValue.or(TruthValue.not(left), right);
        }

        public static TruthValue or(TruthValue left, TruthValue right) {
            if (left == null || UNKNOWN.equals((Object)left)) {
                if (TRUE.equals((Object)right)) {
                    return TRUE;
                }
                return UNKNOWN;
            }
            if (right == null || UNKNOWN.equals((Object)right)) {
                if (TRUE.equals((Object)left)) {
                    return TRUE;
                }
                return UNKNOWN;
            }
            if (TRUE.equals((Object)left) || TRUE.equals((Object)right)) {
                return TRUE;
            }
            return FALSE;
        }

        public static TruthValue not(TruthValue value) {
            if (TRUE.equals((Object)value)) {
                return FALSE;
            }
            if (FALSE.equals((Object)value)) {
                return TRUE;
            }
            return UNKNOWN;
        }

        public static TruthValue eqv(TruthValue left, TruthValue right) {
            return TruthValue.or(TruthValue.and(left, right), TruthValue.and(TruthValue.not(left), TruthValue.not(right)));
        }

        public static TruthValue ifThenElse(TruthValue conditionValue, TruthValue thenValue, TruthValue elseValue) {
            if (TRUE.equals((Object)conditionValue)) {
                return thenValue;
            }
            if (FALSE.equals((Object)conditionValue)) {
                return elseValue;
            }
            return UNKNOWN;
        }
    }

    public static class BranchResult {
        private final Map<String, MultiEvaluationResult> results;
        private final Node leafNode;
        private final Term condition;
        private final String conditionString;
        private final Name termLabelName;

        public BranchResult(Node leafNode, Map<String, MultiEvaluationResult> results, Term condition, String conditionString, Name termLabelName) {
            assert (leafNode != null);
            assert (results != null);
            assert (termLabelName != null);
            this.leafNode = leafNode;
            this.results = results;
            this.condition = condition;
            this.conditionString = conditionString;
            this.termLabelName = termLabelName;
        }

        public Map<String, MultiEvaluationResult> getResults() {
            return Collections.unmodifiableMap(this.results);
        }

        public MultiEvaluationResult getResult(FormulaTermLabel termLabel) {
            return termLabel != null ? this.results.get(termLabel.getId()) : null;
        }

        public void updateResult(FormulaTermLabel termLabel, MultiEvaluationResult result) {
            if (termLabel != null) {
                this.results.put(termLabel.getId(), result);
            }
        }

        public Term getCondition() {
            return this.condition;
        }

        public String getConditionString() {
            return this.conditionString;
        }

        public Name getTermLabelName() {
            return this.termLabelName;
        }

        public boolean hasPredicateLabel(Term term) {
            return this.getPredicateLabel(term) != null;
        }

        public FormulaTermLabel getPredicateLabel(Term term) {
            TermLabel label = term.getLabel(this.termLabelName);
            return label instanceof FormulaTermLabel ? (FormulaTermLabel)label : null;
        }

        public Node getLeafNode() {
            return this.leafNode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Goal ");
            sb.append(this.leafNode.serialNr());
            sb.append("\n");
            boolean afterFirst = false;
            for (Map.Entry<String, MultiEvaluationResult> entry : this.results.entrySet()) {
                if (afterFirst) {
                    sb.append("\n");
                } else {
                    afterFirst = true;
                }
                sb.append(entry.getKey());
                sb.append(" = ");
                sb.append((Object)entry.getValue().evaluate(this.termLabelName, this.results));
                sb.append(" :: ");
                sb.append(entry.getValue());
            }
            return sb.toString();
        }

        public String toPrettyString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Goal ");
            sb.append(this.leafNode.serialNr());
            sb.append("\n");
            boolean afterFirst = false;
            for (Map.Entry<String, MultiEvaluationResult> entry : this.results.entrySet()) {
                if (afterFirst) {
                    sb.append("\n");
                } else {
                    afterFirst = true;
                }
                sb.append(entry.getKey());
                sb.append(" = ");
                sb.append((Object)entry.getValue().evaluate(this.termLabelName, this.results));
                sb.append(" :: ");
                sb.append(entry.getValue().toPrettyString(this.leafNode.proof().getServices()));
            }
            return sb.toString();
        }

        public TruthValue evaluate(FormulaTermLabel termLabel) {
            if (termLabel != null) {
                MultiEvaluationResult instruction = this.getResult(termLabel);
                return instruction != null ? instruction.evaluate(this.termLabelName, this.results) : null;
            }
            return null;
        }
    }

    public static class TruthValueTracingResult {
        private final List<BranchResult> branchResults = new LinkedList<BranchResult>();

        public void addBranchResult(BranchResult result) {
            if (result != null) {
                this.branchResults.add(result);
            }
        }

        public BranchResult[] getBranchResults() {
            return this.branchResults.toArray(new BranchResult[this.branchResults.size()]);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            boolean afterFirst = false;
            for (BranchResult result : this.branchResults) {
                if (afterFirst) {
                    sb.append("\n\n");
                } else {
                    afterFirst = true;
                }
                sb.append(result);
            }
            return sb.toString();
        }
    }

    public static class MultiEvaluationResult {
        private final boolean evaluatesToTrue;
        private final boolean evaluatesToFalse;
        private final Term instructionTerm;

        public MultiEvaluationResult(boolean evaluationResult) {
            this(evaluationResult, !evaluationResult, null);
        }

        public MultiEvaluationResult(Term instructionTerm) {
            this(false, false, instructionTerm);
        }

        public MultiEvaluationResult(boolean evaluatesToTrue, boolean evaluatesToFalse, Term instructionTerm) {
            this.evaluatesToTrue = evaluatesToTrue;
            this.evaluatesToFalse = evaluatesToFalse;
            this.instructionTerm = instructionTerm;
        }

        public boolean isEvaluatesToTrue() {
            return this.evaluatesToTrue;
        }

        public boolean isEvaluatesToFalse() {
            return this.evaluatesToFalse;
        }

        public Term getInstructionTerm() {
            return this.instructionTerm;
        }

        public MultiEvaluationResult newEvaluationResult(boolean evaluationResult) {
            if (evaluationResult) {
                return this.newEvaluatesToTrue(true);
            }
            return this.newEvaluatesToFalse(true);
        }

        public MultiEvaluationResult newEvaluatesToTrue(boolean newEvaluatesToTrue) {
            return new MultiEvaluationResult(newEvaluatesToTrue, this.evaluatesToFalse, this.instructionTerm);
        }

        public MultiEvaluationResult newEvaluatesToFalse(boolean newEvaluatesToFalse) {
            return new MultiEvaluationResult(this.evaluatesToTrue, newEvaluatesToFalse, this.instructionTerm);
        }

        public MultiEvaluationResult newInstructionTerm(Term newInstructionTerm) {
            return new MultiEvaluationResult(this.evaluatesToTrue, this.evaluatesToFalse, newInstructionTerm);
        }

        public String toString() {
            return "true=" + this.evaluatesToTrue + ", false=" + this.evaluatesToFalse + ", instruction=" + this.instructionTerm;
        }

        public String toPrettyString(Services services) {
            return "true=" + this.evaluatesToTrue + ", false=" + this.evaluatesToFalse + (String)(this.instructionTerm != null ? ", instruction:\n" + ProofSaver.printTerm((Term)this.instructionTerm, (Services)services) : "");
        }

        public TruthValue evaluate(Name termLabelName, Map<String, MultiEvaluationResult> results) {
            if (this.evaluatesToTrue && this.evaluatesToFalse) {
                return TruthValue.UNKNOWN;
            }
            if (this.evaluatesToTrue) {
                return TruthValue.TRUE;
            }
            if (this.evaluatesToFalse) {
                return TruthValue.FALSE;
            }
            if (this.instructionTerm != null) {
                return MultiEvaluationResult.evaluateTerm(this.instructionTerm, termLabelName, results);
            }
            return TruthValue.UNKNOWN;
        }

        private static TruthValue evaluateTerm(Term term, Name termLabelName, Map<String, MultiEvaluationResult> results) {
            MultiEvaluationResult instruction;
            TermLabel label = term.getLabel(termLabelName);
            if (label instanceof FormulaTermLabel && (instruction = results.get(((FormulaTermLabel)label).getId())) != null) {
                return instruction.evaluate(termLabelName, results);
            }
            if (term.op() == Junctor.AND || term.op() == Junctor.IMP || term.op() == Junctor.OR || term.op() == Equality.EQV) {
                TruthValue resultValue;
                TruthValue rightValue;
                Term leftTerm = TermBuilder.goBelowUpdates((Term)term.sub(0));
                Term rightTerm = TermBuilder.goBelowUpdates((Term)term.sub(1));
                TermLabel leftLabel = leftTerm.getLabel(termLabelName);
                TermLabel rightLabel = rightTerm.getLabel(termLabelName);
                MultiEvaluationResult leftInstruction = leftLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)leftLabel).getId()) : null;
                MultiEvaluationResult rightInstruction = rightLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)rightLabel).getId()) : null;
                TruthValue leftValue = leftInstruction != null ? leftInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(leftTerm, termLabelName, results);
                TruthValue truthValue = rightValue = rightInstruction != null ? rightInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(rightTerm, termLabelName, results);
                if (term.op() == Junctor.AND) {
                    resultValue = TruthValue.and(leftValue, rightValue);
                } else if (term.op() == Junctor.IMP) {
                    resultValue = TruthValue.imp(leftValue, rightValue);
                } else if (term.op() == Junctor.OR) {
                    resultValue = TruthValue.or(leftValue, rightValue);
                } else if (term.op() == Equality.EQV) {
                    resultValue = TruthValue.eqv(leftValue, rightValue);
                } else {
                    throw new IllegalStateException("Operator '" + term.op() + "' is not supported.");
                }
                return resultValue;
            }
            if (term.op() == Junctor.NOT) {
                Term argumentTerm = TermBuilder.goBelowUpdates((Term)term.sub(0));
                TermLabel argumentLabel = argumentTerm.getLabel(termLabelName);
                MultiEvaluationResult argumentInstruction = argumentLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)argumentLabel).getId()) : null;
                TruthValue argumentValue = argumentInstruction != null ? argumentInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(argumentTerm, termLabelName, results);
                TruthValue resultValue = TruthValue.not(argumentValue);
                return resultValue;
            }
            if (term.op() == Junctor.TRUE) {
                return TruthValue.TRUE;
            }
            if (term.op() == Junctor.FALSE) {
                return TruthValue.FALSE;
            }
            if (TruthValueTracingUtil.isIfThenElseFormula(term)) {
                Term conditionTerm = TermBuilder.goBelowUpdates((Term)term.sub(0));
                Term thenTerm = TermBuilder.goBelowUpdates((Term)term.sub(1));
                Term elseTerm = TermBuilder.goBelowUpdates((Term)term.sub(2));
                TermLabel conditionLabel = conditionTerm.getLabel(termLabelName);
                TermLabel thenLabel = thenTerm.getLabel(termLabelName);
                TermLabel elseLabel = elseTerm.getLabel(termLabelName);
                MultiEvaluationResult conditionInstruction = conditionLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)conditionLabel).getId()) : null;
                MultiEvaluationResult thenInstruction = thenLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)thenLabel).getId()) : null;
                MultiEvaluationResult elseInstruction = elseLabel instanceof FormulaTermLabel ? results.get(((FormulaTermLabel)elseLabel).getId()) : null;
                TruthValue conditionValue = conditionInstruction != null ? conditionInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(conditionTerm, termLabelName, results);
                TruthValue thenValue = thenInstruction != null ? thenInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(thenTerm, termLabelName, results);
                TruthValue elseValue = elseInstruction != null ? elseInstruction.evaluate(termLabelName, results) : MultiEvaluationResult.evaluateTerm(elseTerm, termLabelName, results);
                TruthValue resultValue = TruthValue.ifThenElse(conditionValue, thenValue, elseValue);
                return resultValue;
            }
            return null;
        }
    }

    private static class LabelOccurrence {
        private final FormulaTermLabel label;
        private final boolean inAntecedent;

        public LabelOccurrence(FormulaTermLabel label, boolean inAntecedent) {
            this.label = label;
            this.inAntecedent = inAntecedent;
        }

        public FormulaTermLabel getLabel() {
            return this.label;
        }

        public boolean isInAntecedent() {
            return this.inAntecedent;
        }

        public String toString() {
            return this.label + (this.inAntecedent ? " in antecedent" : " in succedent");
        }
    }
}

