/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionElement;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public abstract class AbstractExecutionElement
implements IExecutionElement {
    private final ITreeSettings settings;
    private final Node proofNode;
    private String name;

    public AbstractExecutionElement(ITreeSettings settings, Node proofNode) {
        assert (settings != null);
        assert (proofNode != null);
        this.settings = settings;
        this.proofNode = proofNode;
    }

    @Override
    public Services getServices() {
        Proof proof = this.getProof();
        return proof != null && !proof.isDisposed() ? proof.getServices() : null;
    }

    @Override
    public RuleApp getAppliedRuleApp() {
        return this.proofNode.getAppliedRuleApp();
    }

    @Override
    public InitConfig getInitConfig() {
        Proof proof = this.getProof();
        return proof != null && !proof.isDisposed() ? proof.getInitConfig() : null;
    }

    @Override
    public Proof getProof() {
        return this.getProofNode().proof();
    }

    @Override
    public Node getProofNode() {
        return this.proofNode;
    }

    @Override
    public NodeInfo getProofNodeInfo() {
        return this.getProofNode().getNodeInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() throws ProofInputException {
        AbstractExecutionElement abstractExecutionElement = this;
        synchronized (abstractExecutionElement) {
            if (this.name == null) {
                this.name = this.lazyComputeName();
            }
            return this.name;
        }
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected boolean isNameComputed() {
        return this.name != null;
    }

    protected abstract String lazyComputeName() throws ProofInputException;

    protected String formatTerm(Term term, Services services) {
        return SymbolicExecutionUtil.formatTerm(term, services, this.settings.isUseUnicode(), this.settings.isUsePrettyPrinting());
    }

    public String toString() {
        try {
            return this.getElementType() + " " + this.getName();
        }
        catch (ProofInputException e) {
            return this.getElementType() + " " + e.getMessage();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.getProof().isDisposed();
    }

    @Override
    public ITreeSettings getSettings() {
        return this.settings;
    }
}

