/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBaseMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.LinkedList;

public abstract class AbstractExecutionMethodReturn<S extends SourceElement>
extends AbstractExecutionNode<S>
implements IExecutionBaseMethodReturn<S> {
    private final ExecutionMethodCall methodCall;
    private String signature;
    private Term methodReturnCondition;
    private String formatedMethodReturnCondition;
    private IExecutionVariable[] callStateVariables;

    public AbstractExecutionMethodReturn(ITreeSettings settings, Node proofNode, ExecutionMethodCall methodCall) {
        super(settings, proofNode);
        assert (methodCall != null);
        this.methodCall = methodCall;
        this.methodCall.addMethodReturn(this);
    }

    @Override
    public IExecutionMethodCall getMethodCall() {
        return this.methodCall;
    }

    @Override
    public String getSignature() throws ProofInputException {
        if (this.signature == null) {
            this.signature = this.lazyComputeSignature();
        }
        return this.signature;
    }

    protected abstract String lazyComputeSignature() throws ProofInputException;

    @Override
    public Term getMethodReturnCondition() throws ProofInputException {
        if (this.methodReturnCondition == null) {
            this.lazyComputeMethodReturnCondition();
        }
        return this.methodReturnCondition;
    }

    @Override
    public String getFormatedMethodReturnCondition() throws ProofInputException {
        if (this.methodReturnCondition == null) {
            this.lazyComputeMethodReturnCondition();
        }
        return this.formatedMethodReturnCondition;
    }

    protected void lazyComputeMethodReturnCondition() throws ProofInputException {
        InitConfig initConfig = this.getProof().getInitConfig();
        if (initConfig != null) {
            Services services = initConfig.getServices();
            LinkedList<Term> bcs = new LinkedList<Term>();
            for (IExecutionNode parent = this.getParent(); parent != null && parent != this.methodCall; parent = ((AbstractExecutionNode)parent).getParent()) {
                if (!(parent instanceof IExecutionBranchCondition)) continue;
                bcs.add(((IExecutionBranchCondition)parent).getBranchCondition());
            }
            this.methodReturnCondition = services.getTermBuilder().and(bcs);
            if (this.getSettings().isSimplifyConditions()) {
                this.methodReturnCondition = SymbolicExecutionUtil.simplify(initConfig, this.getProof(), this.methodReturnCondition);
            }
            this.methodReturnCondition = SymbolicExecutionUtil.improveReadability(this.methodReturnCondition, services);
            this.formatedMethodReturnCondition = this.formatTerm(this.methodReturnCondition, services);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionVariable[] getCallStateVariables() throws ProofInputException {
        AbstractExecutionMethodReturn abstractExecutionMethodReturn = this;
        synchronized (abstractExecutionMethodReturn) {
            if (this.callStateVariables == null) {
                this.callStateVariables = this.lazyComputeCallStateVariables();
            }
            return this.callStateVariables;
        }
    }

    protected IExecutionVariable[] lazyComputeCallStateVariables() throws ProofInputException {
        Node proofNode = this.methodCall.getProofNode();
        assert (proofNode.childrenCount() == 1);
        PosInOccurrence originalPIO = this.methodCall.getModalityPIO();
        int index = originalPIO.isInAntec() ? proofNode.sequent().antecedent().indexOf(originalPIO.sequentFormula()) : proofNode.sequent().succedent().indexOf(originalPIO.sequentFormula());
        Node childNode = proofNode.child(0);
        SequentFormula nodeSF = originalPIO.isInAntec() ? childNode.sequent().antecedent().get(index) : childNode.sequent().succedent().get(index);
        PosInOccurrence modalityPIO = new PosInOccurrence(nodeSF, originalPIO.posInTerm(), originalPIO.isInAntec());
        Term modalityTerm = modalityPIO.subTerm();
        while (modalityTerm.op() instanceof UpdateApplication) {
            modalityPIO = modalityPIO.down(1);
            modalityTerm = modalityPIO.subTerm();
        }
        return SymbolicExecutionUtil.createExecutionVariables(this, childNode, modalityPIO, this.getMethodReturnCondition());
    }
}

