/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.ExecutionNodeSymbolicLayoutExtractor;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLink;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionElement;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicLayout;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;

public abstract class AbstractExecutionNode<S extends SourceElement>
extends AbstractExecutionElement
implements IExecutionNode<S> {
    private AbstractExecutionNode<?> parent;
    private final List<IExecutionNode<?>> children = new LinkedList();
    private IExecutionNode<?>[] callStack;
    private IExecutionConstraint[] constraints;
    private IExecutionVariable[] variables;
    private final Map<Term, IExecutionVariable[]> conditionalVariables = new HashMap<Term, IExecutionVariable[]>();
    private ExecutionNodeSymbolicLayoutExtractor layoutExtractor;
    private PosInOccurrence modalityPIO;
    private ImmutableList<IExecutionBlockStartNode<?>> completedBlocks = ImmutableSLList.nil();
    private final Map<IExecutionBlockStartNode<?>, Term> blockCompletionConditions = new HashMap();
    private final Map<IExecutionBlockStartNode<?>, String> formatedBlockCompletionConditions = new HashMap();
    private ImmutableList<IExecutionLink> outgoingLinks = ImmutableSLList.nil();
    private ImmutableList<IExecutionLink> incomingLinks = ImmutableSLList.nil();

    public AbstractExecutionNode(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    public AbstractExecutionNode<?> getParent() {
        return this.parent;
    }

    public void setParent(AbstractExecutionNode<?> parent) {
        this.parent = parent;
    }

    public AbstractExecutionNode<?>[] getChildren() {
        return this.children.toArray(new AbstractExecutionNode[this.children.size()]);
    }

    public void addChild(AbstractExecutionNode<?> child) {
        if (child != null) {
            this.children.add(child);
        }
    }

    @Override
    public boolean isPathConditionChanged() {
        return false;
    }

    @Override
    public Term getPathCondition() throws ProofInputException {
        Term result = null;
        IExecutionNode parent = this.getParent();
        while (result == null && parent != null) {
            if (((AbstractExecutionNode)parent).isPathConditionChanged()) {
                result = ((AbstractExecutionNode)parent).getPathCondition();
                continue;
            }
            parent = ((AbstractExecutionNode)parent).getParent();
        }
        return result != null ? result : this.getServices().getTermBuilder().tt();
    }

    @Override
    public String getFormatedPathCondition() throws ProofInputException {
        String result = null;
        IExecutionNode parent = this.getParent();
        while (result == null && parent != null) {
            if (((AbstractExecutionNode)parent).isPathConditionChanged()) {
                result = ((AbstractExecutionNode)parent).getFormatedPathCondition();
                continue;
            }
            parent = ((AbstractExecutionNode)parent).getParent();
        }
        if (!this.isDisposed()) {
            return result != null ? result : this.getServices().getTermBuilder().tt().toString();
        }
        return result;
    }

    @Override
    public IExecutionNode<?>[] getCallStack() {
        return this.callStack;
    }

    public void setCallStack(IExecutionNode<?>[] callStack) {
        this.callStack = callStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionConstraint[] getConstraints() {
        AbstractExecutionNode abstractExecutionNode = this;
        synchronized (abstractExecutionNode) {
            if (this.constraints == null) {
                this.constraints = this.lazyComputeConstraints();
            }
            return this.constraints;
        }
    }

    protected abstract IExecutionConstraint[] lazyComputeConstraints();

    @Override
    public S getActiveStatement() {
        return (S)this.getProofNodeInfo().getActiveStatement();
    }

    @Override
    public PositionInfo getActivePositionInfo() {
        return this.getActiveStatement().getPositionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionVariable[] getVariables() throws ProofInputException {
        AbstractExecutionNode abstractExecutionNode = this;
        synchronized (abstractExecutionNode) {
            if (this.variables == null) {
                this.variables = this.lazyComputeVariables();
            }
            return this.variables;
        }
    }

    protected IExecutionVariable[] lazyComputeVariables() throws ProofInputException {
        return SymbolicExecutionUtil.createExecutionVariables(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionVariable[] getVariables(Term condition) throws ProofInputException {
        AbstractExecutionNode abstractExecutionNode = this;
        synchronized (abstractExecutionNode) {
            IExecutionVariable[] result = this.conditionalVariables.get(condition);
            if (result == null) {
                result = this.lazyComputeVariables(condition);
                this.conditionalVariables.put(condition, result);
            }
            return result;
        }
    }

    protected IExecutionVariable[] lazyComputeVariables(Term condition) throws ProofInputException {
        return SymbolicExecutionUtil.createExecutionVariables(this, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionNodeSymbolicLayoutExtractor getLayoutExtractor() throws ProofInputException {
        AbstractExecutionNode abstractExecutionNode = this;
        synchronized (abstractExecutionNode) {
            if (this.layoutExtractor == null) {
                this.layoutExtractor = this.lazyComputeLayoutExtractor();
            }
            return this.layoutExtractor;
        }
    }

    protected ExecutionNodeSymbolicLayoutExtractor lazyComputeLayoutExtractor() throws ProofInputException {
        ExecutionNodeSymbolicLayoutExtractor result = new ExecutionNodeSymbolicLayoutExtractor(this);
        result.analyse();
        return result;
    }

    @Override
    public int getLayoutsCount() throws ProofInputException {
        return this.getLayoutExtractor().getLayoutsCount();
    }

    @Override
    public ISymbolicLayout getInitialLayout(int layoutIndex) throws ProofInputException {
        return this.getLayoutExtractor().getInitialLayout(layoutIndex);
    }

    @Override
    public ISymbolicLayout getCurrentLayout(int layoutIndex) throws ProofInputException {
        return this.getLayoutExtractor().getCurrentLayout(layoutIndex);
    }

    @Override
    public ImmutableList<ISymbolicEquivalenceClass> getLayoutsEquivalenceClasses(int layoutIndex) throws ProofInputException {
        return this.getLayoutExtractor().getEquivalenceClasses(layoutIndex);
    }

    @Override
    public PosInOccurrence getModalityPIO() {
        if (this.modalityPIO == null) {
            this.modalityPIO = this.lazyComputeModalityPIO();
        }
        return this.modalityPIO;
    }

    protected PosInOccurrence lazyComputeModalityPIO() {
        PosInOccurrence originalPio;
        PosInOccurrence pio = originalPio = this.getProofNode().getAppliedRuleApp().posInOccurrence();
        Term term = pio.subTerm();
        if (!pio.isTopLevel() && term.op() != UpdateApplication.UPDATE_APPLICATION) {
            pio = pio.up();
            term = pio.subTerm();
        }
        return term.op() == UpdateApplication.UPDATE_APPLICATION ? pio : originalPio;
    }

    @Override
    public ImmutableList<IExecutionBlockStartNode<?>> getCompletedBlocks() {
        return this.completedBlocks;
    }

    public void addCompletedBlock(IExecutionBlockStartNode<?> completedBlock) {
        if (completedBlock != null && !this.completedBlocks.contains(completedBlock)) {
            this.completedBlocks = this.completedBlocks.append(completedBlock);
        }
    }

    public void removeCompletedBlock(IExecutionBlockStartNode<?> completedBlock) {
        if (completedBlock != null && this.completedBlocks.contains(completedBlock)) {
            this.completedBlocks = this.completedBlocks.removeAll(completedBlock);
            this.blockCompletionConditions.remove(completedBlock);
            this.formatedBlockCompletionConditions.remove(completedBlock);
        }
    }

    @Override
    public Term getBlockCompletionCondition(IExecutionBlockStartNode<?> completedNode) throws ProofInputException {
        Term result = this.blockCompletionConditions.get(completedNode);
        if (result == null) {
            result = (Term)this.lazyComputeBlockCompletionCondition(completedNode, false);
        }
        return result;
    }

    @Override
    public String getFormatedBlockCompletionCondition(IExecutionBlockStartNode<?> completedNode) throws ProofInputException {
        String result = this.formatedBlockCompletionConditions.get(completedNode);
        if (result == null) {
            result = (String)this.lazyComputeBlockCompletionCondition(completedNode, true);
        }
        return result;
    }

    protected Object lazyComputeBlockCompletionCondition(IExecutionBlockStartNode<?> completedNode, boolean returnFormatedCondition) throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null && this.completedBlocks.contains(completedNode)) {
            Services services = initConfig.getServices();
            LinkedList<Term> bcs = new LinkedList<Term>();
            for (IExecutionNode parent = this.getParent(); parent != null && parent != completedNode; parent = ((AbstractExecutionNode)parent).getParent()) {
                if (!(parent instanceof IExecutionBranchCondition)) continue;
                Term bc = ((IExecutionBranchCondition)parent).getBranchCondition();
                if (bc == null) {
                    return null;
                }
                bcs.add(bc);
            }
            Term condition = services.getTermBuilder().and(bcs);
            if (this.getSettings().isSimplifyConditions()) {
                condition = SymbolicExecutionUtil.simplify(initConfig, this.getProof(), condition);
            }
            condition = SymbolicExecutionUtil.improveReadability(condition, services);
            String formatedCondition = this.formatTerm(condition, services);
            this.blockCompletionConditions.put(completedNode, condition);
            this.formatedBlockCompletionConditions.put(completedNode, formatedCondition);
            return returnFormatedCondition ? formatedCondition : condition;
        }
        return null;
    }

    public void removeChild(IExecutionNode<?> child) {
        this.children.remove(child);
    }

    public void addOutgoingLink(IExecutionLink link) {
        this.outgoingLinks = this.outgoingLinks.prepend((Object)link);
    }

    public void removeOutgoingLink(IExecutionLink link) {
        this.outgoingLinks = this.outgoingLinks.removeAll((Object)link);
    }

    @Override
    public IExecutionLink getOutgoingLink(final IExecutionNode<?> target) {
        return (IExecutionLink)CollectionUtil.search(this.outgoingLinks, (IFilter)new IFilter<IExecutionLink>(){

            public boolean select(IExecutionLink element) {
                return element.getTarget() == target;
            }
        });
    }

    @Override
    public ImmutableList<IExecutionLink> getOutgoingLinks() {
        return this.outgoingLinks;
    }

    @Override
    public IExecutionLink getIncomingLink(final IExecutionNode<?> source) {
        return (IExecutionLink)CollectionUtil.search(this.incomingLinks, (IFilter)new IFilter<IExecutionLink>(){

            public boolean select(IExecutionLink element) {
                return element.getSource() == source;
            }
        });
    }

    public void addIncomingLink(IExecutionLink link) {
        this.incomingLinks = this.incomingLinks.prepend((Object)link);
    }

    public void removeIncomingLink(IExecutionLink link) {
        this.incomingLinks = this.incomingLinks.removeAll((Object)link);
    }

    @Override
    public ImmutableList<IExecutionLink> getIncomingLinks() {
        return this.incomingLinks;
    }
}

