/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionElement;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public abstract class AbstractExecutionValue
extends AbstractExecutionElement
implements IExecutionValue {
    private final IExecutionVariable variable;
    private final Term condition;
    private IExecutionConstraint[] constraints;
    private final Term value;

    public AbstractExecutionValue(ITreeSettings settings, Node proofNode, IExecutionVariable variable, Term condition, Term value) {
        super(settings, proofNode);
        this.variable = variable;
        this.condition = condition;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionConstraint[] getConstraints() throws ProofInputException {
        AbstractExecutionValue abstractExecutionValue = this;
        synchronized (abstractExecutionValue) {
            if (this.constraints == null) {
                this.constraints = this.lazyComputeConstraints();
            }
            return this.constraints;
        }
    }

    protected IExecutionConstraint[] lazyComputeConstraints() throws ProofInputException {
        if (!this.isDisposed() && !this.isValueUnknown()) {
            LinkedList<IExecutionConstraint> constraints = new LinkedList<IExecutionConstraint>();
            IExecutionConstraint[] allConstraints = this.getNodeConstraints();
            Set<Term> relevantTerms = this.collectRelevantTerms(this.getServices(), this.getValue());
            for (IExecutionConstraint constraint : allConstraints) {
                if (!this.containsTerm(constraint.getTerm(), relevantTerms)) continue;
                constraints.add(constraint);
            }
            return constraints.toArray(new IExecutionConstraint[constraints.size()]);
        }
        return new IExecutionConstraint[0];
    }

    protected abstract IExecutionConstraint[] getNodeConstraints();

    protected Set<Term> collectRelevantTerms(Services services, Term term) {
        HashSet<Term> terms = new HashSet<Term>();
        this.fillRelevantTerms(services, term, terms);
        return terms;
    }

    protected void fillRelevantTerms(Services services, Term term, Set<Term> toFill) {
        if (term != null) {
            if (term.op() instanceof ProgramVariable || SymbolicExecutionUtil.isSelect(services, term)) {
                toFill.add(OriginTermLabel.removeOriginLabels((Term)term, (Services)services));
            } else {
                for (int i = 0; i < term.arity(); ++i) {
                    this.fillRelevantTerms(services, term.sub(i), toFill);
                }
            }
        }
    }

    protected boolean containsTerm(Term term, Set<Term> toSearch) {
        if (toSearch.contains(OriginTermLabel.removeOriginLabels((Term)term, (Services)this.getServices()))) {
            return true;
        }
        boolean contained = false;
        for (int i = 0; !contained && i < term.arity(); ++i) {
            contained = this.containsTerm(term.sub(i), toSearch);
        }
        return contained;
    }

    @Override
    public IExecutionVariable getVariable() {
        return this.variable;
    }

    @Override
    public PosInOccurrence getModalityPIO() {
        return this.getVariable().getModalityPIO();
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        String conditionString = this.getConditionString();
        if (conditionString != null) {
            return this.getVariable().getName() + " {" + this.getConditionString() + "}";
        }
        return this.getVariable().getName();
    }

    @Override
    public String getElementType() {
        return "Value";
    }

    @Override
    public Term getCondition() throws ProofInputException {
        return this.condition;
    }

    @Override
    public Term getValue() throws ProofInputException {
        return this.value;
    }

    @Override
    public boolean isValueAnObject() throws ProofInputException {
        if (this.isValueUnknown()) {
            return false;
        }
        Term value = this.getValue();
        return SymbolicExecutionUtil.hasReferenceSort(this.getServices(), value);
    }
}

