/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionElement;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public abstract class AbstractExecutionVariable
extends AbstractExecutionElement
implements IExecutionVariable {
    private final IProgramVariable programVariable;
    private final IExecutionValue parentValue;
    private final Term arrayIndex;
    private final Term additionalCondition;
    private final PosInOccurrence modalityPIO;

    public AbstractExecutionVariable(ITreeSettings settings, Node proofNode, IProgramVariable programVariable, IExecutionValue parentValue, Term arrayIndex, Term additionalCondition, PosInOccurrence modalityPIO) {
        super(settings, proofNode);
        this.programVariable = programVariable;
        this.parentValue = parentValue;
        this.arrayIndex = arrayIndex;
        this.additionalCondition = additionalCondition;
        this.modalityPIO = modalityPIO;
    }

    @Override
    public Term getAdditionalCondition() {
        return this.additionalCondition;
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        IProgramVariable pv = this.getProgramVariable();
        if (pv != null) {
            return SymbolicExecutionUtil.getDisplayString(pv);
        }
        return "[" + this.getArrayIndexString() + "]";
    }

    @Override
    public IProgramVariable getProgramVariable() {
        return this.programVariable;
    }

    @Override
    public Term getArrayIndex() {
        return this.arrayIndex;
    }

    @Override
    public String getArrayIndexString() {
        return this.arrayIndex != null ? this.formatTerm(this.arrayIndex, this.getServices()) : null;
    }

    @Override
    public boolean isArrayIndex() {
        return this.getArrayIndex() != null;
    }

    @Override
    public String getElementType() {
        return "Variable";
    }

    @Override
    public IExecutionValue getParentValue() {
        return this.parentValue;
    }

    @Override
    public PosInOccurrence getModalityPIO() {
        return this.modalityPIO;
    }
}

