/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.Function;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class ExecutionAllArrayIndicesVariable
extends ExecutionVariable {
    public static final String ARRAY_INDEX_CONSTANT_NAME = "*";
    public static final String NOT_A_VALUE_NAME = "<Not a Value>";
    private Term constant;
    private final Term notAValue;

    public ExecutionAllArrayIndicesVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, ExecutionValue parentValue, IProgramVariable arrayProgramVariable, Term additionalCondition) {
        super(parentNode, proofNode, modalityPIO, parentValue, arrayProgramVariable, additionalCondition);
        assert (parentValue != null);
        TermBuilder tb = this.getServices().getTermBuilder();
        Function notAValueFunction = new Function(new Name(tb.newName(NOT_A_VALUE_NAME)), Sort.ANY);
        this.notAValue = tb.func(notAValueFunction);
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        if (this.constant == null) {
            this.getValues();
        }
        String arrayName = super.lazyComputeName();
        return arrayName + "[" + this.constant + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ExecutionValue[] lazyComputeValues() throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null) {
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(initConfig, true);
            Services sideServices = sideProofEnv.getServicesForEnvironment();
            TermBuilder tb = sideServices.getTermBuilder();
            Term siteProofCondition = this.getAdditionalCondition() != null ? tb.and(this.getAdditionalCondition(), this.getParentValue().getCondition()) : this.getParentValue().getCondition();
            Term arrayTerm = this.createArrayTerm();
            Function constantFunction = new Function(new Name(tb.newName(ARRAY_INDEX_CONSTANT_NAME)), sideServices.getTypeConverter().getIntegerLDT().targetSort());
            this.constant = tb.func(constantFunction);
            this.setName(this.lazyComputeName());
            Term arrayIndex = tb.dotArr(arrayTerm, this.constant);
            Function arrayLengthFunction = sideServices.getTypeConverter().getHeapLDT().getLength();
            Term arrayRange = tb.and(tb.geq(this.constant, tb.zero()), tb.lt(this.constant, tb.func(arrayLengthFunction, arrayTerm)));
            Term resultIf = tb.ife(arrayRange, arrayIndex, this.notAValue);
            Function resultPredicate = new Function(new Name(tb.newName("ResultPredicate")), Sort.FORMULA, new Sort[]{resultIf.sort()});
            Term resultTerm = tb.func(resultPredicate, resultIf);
            Sequent sequent = SymbolicExecutionUtil.createSequentToProveWithNewSuccedent(this.getProofNode(), this.getModalityPIO(), siteProofCondition, resultTerm, false);
            ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(this.getProof(), sideProofEnv, sequent, "METHOD_NONE", "LOOP_NONE", "QUERY_OFF", "SPLITTING_DELAYED");
            try {
                ExecutionValue[] executionValueArray = this.instantiateValuesFromSideProof(initConfig, sideServices, tb, info, (Operator)resultPredicate, arrayTerm, siteProofCondition);
                return executionValueArray;
            }
            finally {
                SymbolicExecutionSideProofUtil.disposeOrStore("All array indices value computation on node " + this.getProofNode().serialNr(), info);
            }
        }
        return null;
    }

    @Override
    protected boolean isValidValue(Term value) {
        return this.notAValue != value;
    }

    public Term createArrayTerm() {
        return this.getParentValue().getVariable().createSelectTerm();
    }

    @Override
    public Term createSelectTerm() {
        assert (this.constant != null) : "Call getValues() before calling createSelectTerm().";
        return this.getServices().getTermBuilder().dotArr(this.createArrayTerm(), this.constant);
    }

    public Term getConstant() {
        return this.constant;
    }

    public Term getNotAValue() {
        return this.notAValue;
    }
}

