/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.Statement;
import de.uka.ilkd.key.java.StatementBlock;
import de.uka.ilkd.key.java.declaration.LocalVariableDeclaration;
import de.uka.ilkd.key.java.declaration.VariableSpecification;
import de.uka.ilkd.key.java.reference.ExecutionContext;
import de.uka.ilkd.key.java.reference.ReferencePrefix;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.ElementaryUpdate;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ParsableVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.UpdateApplication;
import de.uka.ilkd.key.logic.op.UpdateJunctor;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.rule.AbstractAuxiliaryContractBuiltInRuleApp;
import de.uka.ilkd.key.speclang.AuxiliaryContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionAuxiliaryContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExecutionAuxiliaryContract
extends AbstractExecutionNode<SourceElement>
implements IExecutionAuxiliaryContract {
    public ExecutionAuxiliaryContract(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    public String getElementType() {
        return "Block Contract";
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        ReferencePrefix prefix;
        Term self = null;
        Term applicationTerm = this.getModalityPIO().subTerm();
        Term modalityTerm = TermBuilder.goBelowUpdates((Term)applicationTerm);
        ExecutionContext ec = JavaTools.getInnermostExecutionContext((JavaBlock)modalityTerm.javaBlock(), (Services)this.getServices());
        if (ec != null && (prefix = ec.getRuntimeInstance()) instanceof ProgramVariable) {
            self = this.getServices().getTermBuilder().var((ProgramVariable)prefix);
        }
        Node usageNode = this.getProofNode().child(2);
        assert ("Usage".equals(usageNode.getNodeInfo().getBranchLabel())) : "Block Contract Rule has changed.";
        Term usagePrecondition = usageNode.sequent().antecedent().get(usageNode.sequent().antecedent().size() - 1).formula();
        while (applicationTerm.op() == UpdateApplication.UPDATE_APPLICATION) {
            assert (applicationTerm.sub(0) == usagePrecondition.sub(0)) : "Block Contract Rule has changed.";
            applicationTerm = applicationTerm.sub(1);
            usagePrecondition = usagePrecondition.sub(1);
        }
        assert (usagePrecondition.op() == UpdateApplication.UPDATE_APPLICATION) : "Block Contract Rule has changed.";
        LinkedHashMap<LocationVariable, Term> remembranceHeaps = new LinkedHashMap<LocationVariable, Term>();
        LinkedHashMap<LocationVariable, Term> remembranceLocalVariables = new LinkedHashMap<LocationVariable, Term>();
        this.collectRemembranceVariables(usagePrecondition.sub(0), remembranceHeaps, remembranceLocalVariables);
        Node validitiyNode = this.getProofNode().child(0);
        assert ("Validity".equals(validitiyNode.getNodeInfo().getBranchLabel())) : "Block Contract Rule has changed.";
        Term validitiyModalityTerm = TermBuilder.goBelowUpdates((Term)SymbolicExecutionUtil.posInOccurrenceInOtherNode(this.getProofNode(), this.getModalityPIO(), validitiyNode));
        MethodFrame mf = JavaTools.getInnermostMethodFrame((JavaBlock)validitiyModalityTerm.javaBlock(), (Services)this.getServices());
        StatementBlock sb = mf != null ? mf.getBody() : (StatementBlock)validitiyModalityTerm.javaBlock().program();
        AuxiliaryContract.Variables variables = this.getContract().getVariables();
        int statementIndex = variables.breakFlags.size() + variables.continueFlags.size();
        Term returnFlag = null;
        Term result = null;
        if (variables.returnFlag != null) {
            returnFlag = this.declaredVariableAsTerm(sb, statementIndex);
            ++statementIndex;
            if (variables.result != null) {
                result = this.declaredVariableAsTerm(sb, statementIndex);
                ++statementIndex;
            }
        }
        Term exception = null;
        if (variables.exception != null) {
            exception = this.declaredVariableAsTerm(sb, statementIndex);
        }
        AuxiliaryContract.Terms terms = new AuxiliaryContract.Terms(self, null, null, returnFlag, result, exception, remembranceHeaps, remembranceLocalVariables, null, null);
        return this.getContract().getPlainText(this.getServices(), terms);
    }

    protected Term declaredVariableAsTerm(StatementBlock sb, int statementIndex) {
        Statement resultInitStatement = sb.getStatementAt(statementIndex);
        assert (resultInitStatement instanceof LocalVariableDeclaration) : "Block Contract Rule has changed.";
        IProgramVariable var = ((VariableSpecification)((LocalVariableDeclaration)resultInitStatement).getVariables().get(0)).getProgramVariable();
        assert (var != null) : "Block Contract Rule has changed.";
        return this.getServices().getTermBuilder().var((ProgramVariable)var);
    }

    protected void collectRemembranceVariables(Term term, Map<LocationVariable, Term> remembranceHeaps, Map<LocationVariable, Term> remembranceLocalVariables) {
        if (term.op() == UpdateJunctor.PARALLEL_UPDATE) {
            for (Term sub : term.subs()) {
                this.collectRemembranceVariables(sub, remembranceHeaps, remembranceLocalVariables);
            }
        } else if (term.op() instanceof ElementaryUpdate) {
            ElementaryUpdate eu = (ElementaryUpdate)term.op();
            if (SymbolicExecutionUtil.isHeap((Operator)eu.lhs(), this.getServices().getTypeConverter().getHeapLDT())) {
                remembranceHeaps.put((LocationVariable)term.sub(0).op(), this.getServices().getTermBuilder().var((ParsableVariable)eu.lhs()));
            } else {
                remembranceLocalVariables.put((LocationVariable)term.sub(0).op(), this.getServices().getTermBuilder().var((ParsableVariable)eu.lhs()));
            }
        } else assert (false) : "Unsupported update term with operator '" + term.op() + "'.";
    }

    @Override
    public boolean isPreconditionComplied() {
        boolean complied = this.getProofNode().child(1).isClosed();
        return complied;
    }

    @Override
    public AuxiliaryContract getContract() {
        return ((AbstractAuxiliaryContractBuiltInRuleApp)this.getProofNode().getAppliedRuleApp()).getContract();
    }

    @Override
    public StatementBlock getBlock() {
        return (StatementBlock)((AbstractAuxiliaryContractBuiltInRuleApp)this.getProofNode().getAppliedRuleApp()).getStatement();
    }
}

