/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchCondition;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ExecutionBranchCondition
extends AbstractExecutionNode<SourceElement>
implements IExecutionBranchCondition {
    private final String additionalBranchLabel;
    private Term branchCondition;
    private String formatedBranchCondition;
    private Term pathCondition;
    private String formatedPathCondition;
    private List<Node> mergedProofNodes;
    private Term[] mergedBranchCondtions;

    public ExecutionBranchCondition(ITreeSettings settings, Node proofNode, String additionalBranchLabel) {
        super(settings, proofNode);
        this.additionalBranchLabel = additionalBranchLabel;
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        return this.getFormatedBranchCondition();
    }

    @Override
    public String getElementType() {
        return "Branch Condition";
    }

    @Override
    public String getFormatedBranchCondition() throws ProofInputException {
        if (this.branchCondition == null) {
            this.lazyComputeBranchCondition();
        }
        return this.formatedBranchCondition;
    }

    @Override
    public boolean isBranchConditionComputed() {
        return this.branchCondition != null;
    }

    @Override
    public Term getBranchCondition() throws ProofInputException {
        if (this.branchCondition == null) {
            this.lazyComputeBranchCondition();
        }
        return this.branchCondition;
    }

    protected void lazyComputeBranchCondition() throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null) {
            Services services = initConfig.getServices();
            if (this.isMergedBranchCondition()) {
                Term[] mergedConditions = this.getMergedBranchCondtions();
                this.branchCondition = services.getTermBuilder().and(this.mergedBranchCondtions);
                if (mergedConditions.length >= 2) {
                    if (this.getSettings().isSimplifyConditions()) {
                        this.branchCondition = SymbolicExecutionUtil.simplify(initConfig, this.getProof(), this.branchCondition);
                    }
                    this.branchCondition = SymbolicExecutionUtil.improveReadability(this.branchCondition, services);
                }
            } else {
                this.branchCondition = SymbolicExecutionUtil.computeBranchCondition(this.getProofNode(), this.getSettings().isSimplifyConditions(), true);
            }
            this.formatedBranchCondition = this.formatTerm(this.branchCondition, services);
        }
    }

    @Override
    public boolean isPathConditionChanged() {
        return true;
    }

    @Override
    public Term getPathCondition() throws ProofInputException {
        if (this.pathCondition == null) {
            this.lazyComputePathCondition();
        }
        return this.pathCondition;
    }

    @Override
    public String getFormatedPathCondition() throws ProofInputException {
        if (this.formatedPathCondition == null) {
            this.lazyComputePathCondition();
        }
        return this.formatedPathCondition;
    }

    protected void lazyComputePathCondition() throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null) {
            Services services = initConfig.getServices();
            Term parentPath = this.getParent() != null ? ((AbstractExecutionNode)this.getParent()).getPathCondition() : services.getTermBuilder().tt();
            Term branchCondition = this.getBranchCondition();
            if (branchCondition == null) {
                return;
            }
            this.pathCondition = services.getTermBuilder().and(parentPath, branchCondition);
            if (this.getSettings().isSimplifyConditions()) {
                this.pathCondition = SymbolicExecutionUtil.simplify(initConfig, this.getProof(), this.pathCondition);
            }
            this.pathCondition = SymbolicExecutionUtil.improveReadability(this.pathCondition, services);
            this.formatedPathCondition = this.formatTerm(this.pathCondition, services);
        }
    }

    public void addMergedProofNode(Node node) {
        if (this.mergedProofNodes == null) {
            this.mergedProofNodes = new LinkedList<Node>();
            this.mergedProofNodes.add(this.getProofNode());
        }
        this.mergedProofNodes.add(node);
    }

    @Override
    public Node[] getMergedProofNodes() {
        return this.mergedProofNodes != null ? this.mergedProofNodes.toArray(new Node[this.mergedProofNodes.size()]) : new Node[]{};
    }

    @Override
    public Term[] getMergedBranchCondtions() throws ProofInputException {
        if (this.mergedBranchCondtions == null) {
            this.mergedBranchCondtions = this.lazyComputeMergedBranchCondtions();
        }
        return this.mergedBranchCondtions;
    }

    protected Term[] lazyComputeMergedBranchCondtions() throws ProofInputException {
        if (this.isMergedBranchCondition()) {
            Term[] result = new Term[this.mergedProofNodes.size()];
            Iterator<Node> iter = this.mergedProofNodes.iterator();
            for (int i = 0; i < result.length; ++i) {
                result[i] = SymbolicExecutionUtil.computeBranchCondition(iter.next(), this.getSettings().isSimplifyConditions(), true);
            }
            return result;
        }
        return new Term[0];
    }

    @Override
    public boolean isMergedBranchCondition() {
        return this.mergedProofNodes != null && !this.mergedProofNodes.isEmpty();
    }

    @Override
    public String getAdditionalBranchLabel() {
        return this.additionalBranchLabel;
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    protected PosInOccurrence lazyComputeModalityPIO() {
        return SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(this.getProofNode().sequent());
    }

    @Override
    public SourceElement getActiveStatement() {
        Term modalityTerm = this.getModalityPIO().subTerm();
        SourceElement firstStatement = modalityTerm.javaBlock().program().getFirstElement();
        return NodeInfo.computeActiveStatement((SourceElement)firstStatement);
    }
}

