/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.PrettyPrinter;
import de.uka.ilkd.key.java.statement.BranchStatement;
import de.uka.ilkd.key.java.statement.If;
import de.uka.ilkd.key.java.statement.Switch;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBranchStatement;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class ExecutionBranchStatement
extends AbstractExecutionBlockStartNode<BranchStatement>
implements IExecutionBranchStatement {
    public ExecutionBranchStatement(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() {
        BranchStatement bs = (BranchStatement)this.getActiveStatement();
        try {
            if (bs instanceof If) {
                StringWriter sw = new StringWriter();
                PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                sb.printIf((If)bs, false);
                return sw.toString();
            }
            if (bs instanceof Switch) {
                StringWriter sw = new StringWriter();
                PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                sb.printSwitch((Switch)bs, false);
                return sw.toString();
            }
            return bs.toString();
        }
        catch (IOException e) {
            return bs.toString();
        }
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        return "Branch Statement";
    }
}

