/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionElement;

public class ExecutionConstraint
extends AbstractExecutionElement
implements IExecutionConstraint {
    private final Term term;
    private final PosInOccurrence modalityPIO;

    public ExecutionConstraint(ITreeSettings settings, Node proofNode, PosInOccurrence modalityPIO, Term term) {
        super(settings, proofNode);
        assert (term != null);
        assert (modalityPIO != null);
        this.term = term;
        this.modalityPIO = modalityPIO;
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        return this.formatTerm(this.term, this.getServices());
    }

    @Override
    public String getElementType() {
        return "Constraint";
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public PosInOccurrence getModalityPIO() {
        return this.modalityPIO;
    }
}

