/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.statement.Throw;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionExceptionalMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import org.key_project.util.java.StringUtil;

public class ExecutionExceptionalMethodReturn
extends AbstractExecutionMethodReturn<Throw>
implements IExecutionExceptionalMethodReturn {
    public ExecutionExceptionalMethodReturn(ITreeSettings settings, Node proofNode, ExecutionMethodCall methodCall) {
        super(settings, proofNode, methodCall);
    }

    @Override
    protected String lazyComputeName() {
        String exceptionType;
        Expression expression = ((Throw)this.getActiveStatement()).getExpression();
        if (expression instanceof ProgramVariable) {
            KeYJavaType type = ((ProgramVariable)expression).getKeYJavaType();
            exceptionType = type.getFullName();
        } else {
            exceptionType = expression.toString();
        }
        return "<throw " + exceptionType + ">";
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    protected String lazyComputeSignature() throws ProofInputException {
        String methodName = this.getMethodCall().getName();
        return "<exceptional return" + (String)(!StringUtil.isTrimmedEmpty((String)methodName) ? " of " + methodName : "") + ">";
    }

    @Override
    public String getElementType() {
        return "Exceptional Method Return";
    }
}

