/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Expression;
import de.uka.ilkd.key.java.PositionInfo;
import de.uka.ilkd.key.java.statement.If;
import de.uka.ilkd.key.java.statement.JavaStatement;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopCondition;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class ExecutionLoopCondition
extends AbstractExecutionBlockStartNode<JavaStatement>
implements IExecutionLoopCondition {
    public ExecutionLoopCondition(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() {
        return this.getGuardExpression().toString();
    }

    @Override
    public Expression getGuardExpression() {
        if (this.getActiveStatement() instanceof LoopStatement) {
            return ((LoopStatement)this.getActiveStatement()).getGuardExpression();
        }
        if (this.getActiveStatement() instanceof If) {
            return ((If)this.getActiveStatement()).getExpression();
        }
        return null;
    }

    @Override
    public PositionInfo getGuardExpressionPositionInfo() {
        return this.getGuardExpression().getPositionInfo();
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        return "Loop Condition";
    }
}

