/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.PrettyPrinter;
import de.uka.ilkd.key.java.statement.Do;
import de.uka.ilkd.key.java.statement.EnhancedFor;
import de.uka.ilkd.key.java.statement.For;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.java.statement.While;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionLoopStatement;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionBlockStartNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class ExecutionLoopStatement
extends AbstractExecutionBlockStartNode<LoopStatement>
implements IExecutionLoopStatement {
    public ExecutionLoopStatement(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() {
        LoopStatement ls = (LoopStatement)this.getActiveStatement();
        try {
            if (ls.getGuardExpression() != null) {
                if (ls instanceof While) {
                    StringWriter sw = new StringWriter();
                    PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                    sb.printWhile((While)ls, false);
                    return sw.toString();
                }
                if (ls instanceof For) {
                    StringWriter sw = new StringWriter();
                    PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                    sb.printFor((For)ls, false);
                    return sw.toString();
                }
                if (ls instanceof EnhancedFor) {
                    StringWriter sw = new StringWriter();
                    PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                    sb.printEnhancedFor((EnhancedFor)ls, false);
                    return sw.toString();
                }
                if (ls instanceof Do) {
                    StringWriter sw = new StringWriter();
                    PrettyPrinter sb = new PrettyPrinter((Writer)sw, true);
                    sb.printDo((Do)ls, false);
                    return sw.toString();
                }
                return ls.toString();
            }
            return ls.toString();
        }
        catch (IOException e) {
            return ls.toString();
        }
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        return "Loop Statement";
    }
}

