/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.reference.MethodName;
import de.uka.ilkd.key.java.reference.MethodReference;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionBaseMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.KeYTypeUtil;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class ExecutionMethodCall
extends AbstractExecutionNode<MethodBodyStatement>
implements IExecutionMethodCall {
    private ImmutableList<IExecutionBaseMethodReturn<?>> methodReturns = ImmutableSLList.nil();

    public ExecutionMethodCall(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() {
        return "<call " + this.getMethodCallText() + ">";
    }

    protected String getMethodCallText() {
        String call;
        MethodReference explicitConstructorMR = this.getExplicitConstructorMethodReference();
        String string = call = explicitConstructorMR != null ? explicitConstructorMR.toString() : this.getMethodReference().toString();
        if (call.endsWith(";")) {
            call = call.substring(0, call.length() - 1);
        }
        return call;
    }

    public void removeMethodReturn(IExecutionBaseMethodReturn<?> methodReturn) {
        this.methodReturns = this.methodReturns.removeAll(methodReturn);
    }

    @Override
    public boolean isImplicitConstructor() {
        return KeYTypeUtil.isImplicitConstructor((IProgramMethod)this.getProgramMethod());
    }

    @Override
    public MethodReference getExplicitConstructorMethodReference() {
        IProgramMethod explicitConstructor = this.getExplicitConstructorProgramMethod();
        if (explicitConstructor != null) {
            MethodReference mr = this.getMethodReference();
            return new MethodReference(mr.getArguments(), (MethodName)explicitConstructor.getProgramElementName(), null);
        }
        return null;
    }

    @Override
    public IProgramMethod getExplicitConstructorProgramMethod() {
        IProgramMethod pm = this.getProgramMethod();
        if (KeYTypeUtil.isImplicitConstructor((IProgramMethod)pm)) {
            return KeYTypeUtil.findExplicitConstructor((Services)this.getServices(), (IProgramMethod)pm);
        }
        return null;
    }

    @Override
    public MethodReference getMethodReference() {
        return ((MethodBodyStatement)this.getActiveStatement()).getMethodReference();
    }

    @Override
    public IProgramMethod getProgramMethod() {
        return ((MethodBodyStatement)this.getActiveStatement()).getProgramMethod(this.getServices());
    }

    @Override
    public String getElementType() {
        return "Method Call";
    }

    @Override
    public ImmutableList<IExecutionBaseMethodReturn<?>> getMethodReturns() {
        return this.methodReturns;
    }

    public void addMethodReturn(IExecutionBaseMethodReturn<?> methodReturn) {
        if (methodReturn != null) {
            assert (methodReturn.getMethodCall() == this);
            this.methodReturns = this.methodReturns.append(methodReturn);
        }
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }
}

