/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.reference.MethodReference;
import de.uka.ilkd.key.java.statement.MethodBodyStatement;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.SymbolicExecutionTermLabel;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturnValue;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionMethodReturn;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodCall;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionMethodReturnValue;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import de.uka.ilkd.key.util.MiscTools;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.key_project.util.java.StringUtil;

public class ExecutionMethodReturn
extends AbstractExecutionMethodReturn<SourceElement>
implements IExecutionMethodReturn {
    private String signatureIncludingReturnValue;
    private String nameIncludingReturnValue;
    private IExecutionMethodReturnValue[] returnValues;

    public ExecutionMethodReturn(ITreeSettings settings, Node proofNode, ExecutionMethodCall methodCall) {
        super(settings, proofNode, methodCall);
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        return ExecutionMethodReturn.createMethodReturnName(null, this.computeCalledMethodName());
    }

    protected String computeCalledMethodName() {
        MethodReference explicitConstructorMR = this.getMethodCall().getExplicitConstructorMethodReference();
        return explicitConstructorMR != null ? explicitConstructorMR.getMethodName().toString() : this.getMethodCall().getProgramMethod().getName();
    }

    @Override
    protected String lazyComputeSignature() throws ProofInputException {
        return ExecutionMethodReturn.createMethodReturnName(null, this.computeCalledMethodSignature());
    }

    protected String computeCalledMethodSignature() throws ProofInputException {
        String call;
        MethodReference explicitConstructorMR = this.getMethodCall().getExplicitConstructorMethodReference();
        String string = call = explicitConstructorMR != null ? explicitConstructorMR.toString() : this.getMethodCall().getMethodReference().toString();
        if (call.endsWith(";")) {
            call = call.substring(0, call.length() - 1);
        }
        return call;
    }

    @Override
    public String getNameIncludingReturnValue() throws ProofInputException {
        if (this.nameIncludingReturnValue == null) {
            this.nameIncludingReturnValue = this.lazyComputeNameIncludingReturnValue();
        }
        return this.nameIncludingReturnValue;
    }

    protected String lazyComputeNameIncludingReturnValue() throws ProofInputException {
        IExecutionMethodReturnValue[] returnValues = this.getReturnValues();
        if (returnValues.length == 0) {
            return ExecutionMethodReturn.createMethodReturnName(null, this.computeCalledMethodName());
        }
        if (returnValues.length == 1) {
            return ExecutionMethodReturn.createMethodReturnName(returnValues[0].getName() + " ", this.computeCalledMethodName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        boolean afterFirst = false;
        for (IExecutionMethodReturnValue value : returnValues) {
            if (afterFirst) {
                sb.append(", \n");
            } else {
                afterFirst = true;
            }
            sb.append('\t');
            sb.append(value.getName());
        }
        sb.append('\n');
        return ExecutionMethodReturn.createMethodReturnName(sb.toString(), this.computeCalledMethodName());
    }

    @Override
    public String getSignatureIncludingReturnValue() throws ProofInputException {
        if (this.signatureIncludingReturnValue == null) {
            this.signatureIncludingReturnValue = this.lazyComputeSigntureIncludingReturnValue();
        }
        return this.signatureIncludingReturnValue;
    }

    protected String lazyComputeSigntureIncludingReturnValue() throws ProofInputException {
        IExecutionMethodReturnValue[] returnValues = this.getReturnValues();
        if (returnValues.length == 0) {
            return ExecutionMethodReturn.createMethodReturnName(null, this.computeCalledMethodSignature());
        }
        if (returnValues.length == 1) {
            return ExecutionMethodReturn.createMethodReturnName(returnValues[0].getName() + " ", this.computeCalledMethodSignature());
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        boolean afterFirst = false;
        for (IExecutionMethodReturnValue value : returnValues) {
            if (afterFirst) {
                sb.append(", \n");
            } else {
                afterFirst = true;
            }
            sb.append('\t');
            sb.append(value.getName());
        }
        sb.append('\n');
        return ExecutionMethodReturn.createMethodReturnName(sb.toString(), this.computeCalledMethodSignature());
    }

    @Override
    public IExecutionMethodReturnValue[] getReturnValues() throws ProofInputException {
        if (this.returnValues == null) {
            this.returnValues = this.lazyComputeReturnValues();
        }
        return this.returnValues;
    }

    @Override
    public boolean isReturnValuesComputed() {
        return this.returnValues != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IExecutionMethodReturnValue[] lazyComputeReturnValues() throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null) {
            IProgramMethod pm;
            Services services = initConfig.getServices();
            MethodBodyStatement mbs = (MethodBodyStatement)this.getMethodCall().getActiveStatement();
            IProgramVariable resultVar = mbs.getResultVariable();
            if (resultVar == null && !(pm = mbs.getProgramMethod(services)).isVoid()) {
                resultVar = new LocationVariable(new ProgramElementName(services.getTermBuilder().newName("TmpResultVar")), pm.getReturnType());
            }
            if (resultVar != null) {
                Node methodReturnNode = this.findMethodReturnNode(this.getProofNode());
                if (methodReturnNode != null) {
                    ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(this.getProof(), true);
                    SymbolicExecutionUtil.SiteProofVariableValueInput input = SymbolicExecutionUtil.createExtractReturnVariableValueSequent(services, mbs.getBodySourceAsTypeReference(), mbs.getProgramMethod(services), mbs.getDesignatedContext(), methodReturnNode, this.getProofNode(), resultVar);
                    ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(this.getProof(), sideProofEnv, input.getSequentToProve(), "METHOD_NONE", "LOOP_NONE", "QUERY_OFF", "SPLITTING_NORMAL");
                    try {
                        if (info.getProof().openGoals().size() == 1) {
                            Goal goal = (Goal)info.getProof().openGoals().head();
                            Term returnValue = SymbolicExecutionSideProofUtil.extractOperatorValue(goal, input.getOperator());
                            assert (returnValue != null);
                            returnValue = SymbolicExecutionUtil.replaceSkolemConstants(goal.sequent(), returnValue, services);
                            IExecutionMethodReturnValue[] iExecutionMethodReturnValueArray = new IExecutionMethodReturnValue[]{new ExecutionMethodReturnValue(this.getSettings(), this.getProofNode(), this.getModalityPIO(), returnValue, null)};
                            return iExecutionMethodReturnValueArray;
                        }
                        LinkedHashMap<Term, LinkedList<Node>> valueNodeMap = new LinkedHashMap<Term, LinkedList<Node>>();
                        for (IExecutionMethodReturnValue[] goal : info.getProof().openGoals()) {
                            Term returnValue = SymbolicExecutionSideProofUtil.extractOperatorValue((Goal)goal, input.getOperator());
                            assert (returnValue != null);
                            returnValue = SymbolicExecutionUtil.replaceSkolemConstants(goal.node().sequent(), returnValue, services);
                            LinkedList<Node> nodeList = (LinkedList<Node>)valueNodeMap.get(returnValue);
                            if (nodeList == null) {
                                nodeList = new LinkedList<Node>();
                                valueNodeMap.put(returnValue, nodeList);
                            }
                            nodeList.add(goal.node());
                        }
                        if (valueNodeMap.size() == 1) {
                            IExecutionMethodReturnValue[] goal;
                            Iterator returnValue = (Term)valueNodeMap.keySet().iterator().next();
                            goal = new IExecutionMethodReturnValue[]{new ExecutionMethodReturnValue(this.getSettings(), this.getProofNode(), this.getModalityPIO(), (Term)returnValue, null)};
                            return goal;
                        }
                        IExecutionMethodReturnValue[] result = new IExecutionMethodReturnValue[valueNodeMap.size()];
                        int i = 0;
                        for (Map.Entry entry : valueNodeMap.entrySet()) {
                            LinkedList<Term> conditions = new LinkedList<Term>();
                            for (Node node : (List)entry.getValue()) {
                                Term condition = SymbolicExecutionUtil.computePathCondition(node, this.getSettings().isSimplifyConditions(), false);
                                conditions.add(condition);
                            }
                            Term condition = services.getTermBuilder().or(conditions);
                            if (conditions.size() >= 2 && this.getSettings().isSimplifyConditions()) {
                                condition = SymbolicExecutionUtil.simplify(initConfig, info.getProof(), condition);
                            }
                            condition = SymbolicExecutionUtil.improveReadability(condition, info.getProof().getServices());
                            result[i] = new ExecutionMethodReturnValue(this.getSettings(), this.getProofNode(), this.getModalityPIO(), (Term)entry.getKey(), condition);
                            ++i;
                        }
                        IExecutionMethodReturnValue[] iExecutionMethodReturnValueArray = result;
                        return iExecutionMethodReturnValueArray;
                    }
                    finally {
                        SymbolicExecutionSideProofUtil.disposeOrStore("Return value computation on method return node " + methodReturnNode.serialNr() + ".", info);
                    }
                }
                return new IExecutionMethodReturnValue[0];
            }
            return new IExecutionMethodReturnValue[0];
        }
        return new IExecutionMethodReturnValue[0];
    }

    protected Node findMethodReturnNode(Node node) {
        Node resultNode = null;
        SymbolicExecutionTermLabel origianlLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(node.getAppliedRuleApp());
        if (origianlLabel != null) {
            while (node != null && resultNode == null) {
                SymbolicExecutionTermLabel currentLabel;
                if ("methodCallReturn".equals(MiscTools.getRuleDisplayName((Node)node)) && (currentLabel = SymbolicExecutionUtil.getSymbolicExecutionLabel(node.getAppliedRuleApp())) != null && origianlLabel.equals((Object)currentLabel)) {
                    resultNode = node;
                }
                node = node.parent();
            }
        }
        return resultNode;
    }

    public static String createMethodReturnName(Object returnValue, String methodName) {
        return "<return" + (String)(returnValue != null ? " " + returnValue + "as result" : "") + (String)(!StringUtil.isTrimmedEmpty((String)methodName) ? " of " + methodName : "") + ">";
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        return "Method Return";
    }
}

