/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionMethodReturnValue;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionElement;

public class ExecutionMethodReturnValue
extends AbstractExecutionElement
implements IExecutionMethodReturnValue {
    private final Term returnValue;
    private final PosInOccurrence modalityPIO;
    private String returnValueString;
    private final Term condition;
    private String conditionString;

    public ExecutionMethodReturnValue(ITreeSettings settings, Node proofNode, PosInOccurrence modalityPIO, Term returnValue, Term condition) {
        super(settings, proofNode);
        assert (returnValue != null);
        assert (modalityPIO != null);
        this.returnValue = returnValue;
        this.condition = condition;
        this.modalityPIO = modalityPIO;
    }

    @Override
    public String getElementType() {
        return "Return Value";
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        if (this.hasCondition()) {
            return this.getReturnValueString() + " {" + this.getConditionString() + "}";
        }
        return this.getReturnValueString();
    }

    @Override
    public Term getReturnValue() throws ProofInputException {
        return this.returnValue;
    }

    @Override
    public String getReturnValueString() throws ProofInputException {
        if (this.returnValueString == null) {
            this.returnValueString = this.lazyComputeReturnValueString();
        }
        return this.returnValueString;
    }

    protected String lazyComputeReturnValueString() throws ProofInputException {
        return !this.isDisposed() ? this.formatTerm(this.returnValue, this.getServices()) : null;
    }

    @Override
    public boolean hasCondition() throws ProofInputException {
        return this.condition != null;
    }

    @Override
    public Term getCondition() throws ProofInputException {
        return this.condition;
    }

    @Override
    public String getConditionString() throws ProofInputException {
        if (this.conditionString == null) {
            this.conditionString = this.lazyComputeConditionString();
        }
        return this.conditionString;
    }

    protected String lazyComputeConditionString() throws ProofInputException {
        if (this.hasCondition()) {
            return !this.isDisposed() ? this.formatTerm(this.condition, this.getServices()) : null;
        }
        return null;
    }

    @Override
    public PosInOccurrence getModalityPIO() {
        return this.modalityPIO;
    }
}

