/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.expression.operator.CopyAssignment;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermFactory;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.logic.op.Equality;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.rule.AbstractContractRuleApp;
import de.uka.ilkd.key.rule.UseOperationContractRule;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.speclang.FunctionalOperationContract;
import de.uka.ilkd.key.speclang.FunctionalOperationContractImpl;
import de.uka.ilkd.key.speclang.HeapContext;
import de.uka.ilkd.key.speclang.OperationContract;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionOperationContract;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.List;
import java.util.Map;
import org.key_project.util.collection.ImmutableList;

public class ExecutionOperationContract
extends AbstractExecutionNode<SourceElement>
implements IExecutionOperationContract {
    private Term exceptionTerm;
    private Term resultTerm;
    private Term selfTerm;
    private ImmutableList<Term> contractParams;

    public ExecutionOperationContract(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() throws ProofInputException {
        if (!this.isDisposed()) {
            Services services = this.getServices();
            if (!(this.getContract() instanceof FunctionalOperationContract)) {
                throw new ProofInputException("Unsupported contract: " + this.getContract());
            }
            FunctionalOperationContract contract = (FunctionalOperationContract)this.getContract();
            UseOperationContractRule.Instantiation inst = UseOperationContractRule.computeInstantiation((Term)this.getProofNode().getAppliedRuleApp().posInOccurrence().subTerm(), (Services)services);
            this.resultTerm = this.searchResultTerm(contract, inst, services);
            SymbolicExecutionUtil.ContractPostOrExcPostExceptionVariableResult search = SymbolicExecutionUtil.searchContractPostOrExcPostExceptionVariable(this.getProofNode().child(0), services);
            this.exceptionTerm = search.getExceptionEquality().sub(0);
            List heapContext = HeapContext.getModHeaps((Services)services, (boolean)inst.transaction);
            Map atPreVars = UseOperationContractRule.computeAtPreVars((List)heapContext, (TermServices)services, (UseOperationContractRule.Instantiation)inst);
            Map atPres = HeapContext.getAtPres((Map)atPreVars, (Services)services);
            LocationVariable baseHeap = services.getTypeConverter().getHeapLDT().getHeap();
            Term baseHeapTerm = services.getTermBuilder().getBaseHeap();
            if (contract.hasSelfVar()) {
                if (inst.pm.isConstructor()) {
                    this.selfTerm = this.searchConstructorSelfDefinition(search.getWorkingTerm(), inst.staticType, services);
                    if (this.selfTerm == null) {
                        throw new ProofInputException("Can't find self term, implementation of UseOperationContractRule might has changed!");
                    }
                    KeYJavaType selfType = services.getJavaInfo().getKeYJavaType(this.selfTerm.sort());
                    if (inst.staticType != selfType) {
                        throw new ProofInputException("Type \"" + inst.staticType + "\" expected but found \"" + selfType + "\", implementation of UseOperationContractRule might has changed!");
                    }
                } else {
                    this.selfTerm = UseOperationContractRule.computeSelf((Term)baseHeapTerm, (Map)atPres, (LocationVariable)baseHeap, (UseOperationContractRule.Instantiation)inst, (Term)this.resultTerm, (TermFactory)services.getTermFactory());
                }
            }
            this.contractParams = UseOperationContractRule.computeParams((Term)baseHeapTerm, (Map)atPres, (LocationVariable)baseHeap, (UseOperationContractRule.Instantiation)inst, (TermFactory)services.getTermFactory());
            return FunctionalOperationContractImpl.getText((FunctionalOperationContract)contract, this.contractParams, (Term)this.resultTerm, (Term)this.selfTerm, (Term)this.exceptionTerm, (LocationVariable)baseHeap, (Term)baseHeapTerm, (List)heapContext, (Map)atPres, (boolean)false, (Services)services, (boolean)this.getSettings().isUsePrettyPrinting(), (boolean)this.getSettings().isUseUnicode()).trim();
        }
        return null;
    }

    protected Term searchConstructorSelfDefinition(Term term, KeYJavaType staticType, Services services) {
        if (term.op() == Junctor.NOT && term.sub(0).op() == Equality.EQUALS && term.sub(0).sub(0).op() instanceof LocationVariable && SymbolicExecutionUtil.isNullSort(term.sub(0).sub(1).sort(), services) && services.getJavaInfo().getKeYJavaType(term.sub(0).sub(0).sort()) == staticType) {
            return term.sub(0).sub(0);
        }
        Term result = null;
        for (int i = term.arity() - 1; result == null && i >= 0; --i) {
            result = this.searchConstructorSelfDefinition(term.sub(i), staticType, services);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term getResultTerm() throws ProofInputException {
        ExecutionOperationContract executionOperationContract = this;
        synchronized (executionOperationContract) {
            if (!this.isNameComputed()) {
                this.getName();
            }
            return this.resultTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term getExceptionTerm() throws ProofInputException {
        ExecutionOperationContract executionOperationContract = this;
        synchronized (executionOperationContract) {
            if (!this.isNameComputed()) {
                this.getName();
            }
            return this.exceptionTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term getSelfTerm() throws ProofInputException {
        ExecutionOperationContract executionOperationContract = this;
        synchronized (executionOperationContract) {
            if (!this.isNameComputed()) {
                this.getName();
            }
            return this.selfTerm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableList<Term> getContractParams() throws ProofInputException {
        ExecutionOperationContract executionOperationContract = this;
        synchronized (executionOperationContract) {
            if (!this.isNameComputed()) {
                this.getName();
            }
            return this.contractParams;
        }
    }

    @Override
    public String getFormatedResultTerm() throws ProofInputException {
        Term resultTerm = this.getResultTerm();
        return resultTerm != null ? this.formatTerm(resultTerm, this.getServices()) : null;
    }

    @Override
    public String getFormatedExceptionTerm() throws ProofInputException {
        Term exceptionTerm = this.getExceptionTerm();
        return exceptionTerm != null ? this.formatTerm(exceptionTerm, this.getServices()) : null;
    }

    @Override
    public String getFormatedSelfTerm() throws ProofInputException {
        Term selfTerm = this.getSelfTerm();
        return selfTerm != null ? this.formatTerm(selfTerm, this.getServices()) : null;
    }

    @Override
    public String getFormatedContractParams() throws ProofInputException {
        ImmutableList<Term> contractParams = this.getContractParams();
        if (contractParams != null && !contractParams.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            boolean afterFirst = false;
            for (Term term : contractParams) {
                if (afterFirst) {
                    sb.append(", ");
                } else {
                    afterFirst = true;
                }
                sb.append(this.formatTerm(term, this.getServices()));
            }
            return sb.toString();
        }
        return null;
    }

    protected Term searchResultTerm(FunctionalOperationContract contract, UseOperationContractRule.Instantiation inst, Services services) {
        Term resultTerm = null;
        if (contract.hasResultVar()) {
            LocationVariable resultVar = ExecutionOperationContract.extractResultVariableFromPostBranch(this.getProofNode(), services);
            if (resultVar == null) {
                resultVar = UseOperationContractRule.computeResultVar((UseOperationContractRule.Instantiation)inst, (TermServices)services);
            }
            resultTerm = services.getTermBuilder().var((ProgramVariable)resultVar);
        }
        return resultTerm;
    }

    protected static LocationVariable extractResultVariableFromPostBranch(Node node, Services services) {
        Term postModality = SymbolicExecutionUtil.posInOccurrenceInOtherNode(node, node.getAppliedRuleApp().posInOccurrence(), node.child(0));
        MethodFrame mf = JavaTools.getInnermostMethodFrame((JavaBlock)(postModality = TermBuilder.goBelowUpdates((Term)postModality)).javaBlock(), (Services)services);
        SourceElement firstElement = NodeInfo.computeActiveStatement((SourceElement)mf.getFirstElement());
        if (!(firstElement instanceof CopyAssignment)) {
            return null;
        }
        CopyAssignment assignment = (CopyAssignment)firstElement;
        ProgramElement rightChild = assignment.getChildAt(1);
        if (!(rightChild instanceof LocationVariable)) {
            return null;
        }
        return (LocationVariable)rightChild;
    }

    @Override
    public Contract getContract() {
        return ((AbstractContractRuleApp)this.getProofNode().getAppliedRuleApp()).getInstantiation();
    }

    @Override
    public IProgramMethod getContractProgramMethod() {
        Contract contract = this.getContract();
        if (contract instanceof OperationContract) {
            return ((OperationContract)contract).getTarget();
        }
        return null;
    }

    @Override
    public String getElementType() {
        return "Operation Contract";
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public boolean isPreconditionComplied() {
        boolean complied = false;
        if (this.getProofNode().childrenCount() >= 3) {
            complied = this.getProofNode().child(2).isClosed();
        }
        return complied;
    }

    @Override
    public boolean hasNotNullCheck() {
        return this.getProofNode().childrenCount() >= 4;
    }

    @Override
    public boolean isNotNullCheckComplied() {
        if (this.hasNotNullCheck()) {
            return this.getProofNode().child(3).isClosed();
        }
        return false;
    }
}

