/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.NodeInfo;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionStart;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class ExecutionStart
extends AbstractExecutionNode<SourceElement>
implements IExecutionStart {
    private ImmutableList<IExecutionTermination> terminations = ImmutableSLList.nil();

    public ExecutionStart(ITreeSettings settings, Node proofNode) {
        super(settings, proofNode);
    }

    @Override
    protected String lazyComputeName() {
        return "<start>";
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        return "Start";
    }

    @Override
    public ImmutableList<IExecutionTermination> getTerminations() {
        return this.terminations;
    }

    public void addTermination(IExecutionTermination termination) {
        if (termination != null) {
            this.terminations = this.terminations.append((Object)termination);
        }
    }

    @Override
    protected PosInOccurrence lazyComputeModalityPIO() {
        return SymbolicExecutionUtil.findModalityWithMaxSymbolicExecutionLabelId(this.getProofNode().sequent());
    }

    @Override
    public SourceElement getActiveStatement() {
        Term modalityTerm = this.getModalityPIO().subTerm();
        SourceElement firstStatement = modalityTerm.javaBlock().program().getFirstElement();
        return NodeInfo.computeActiveStatement((SourceElement)firstStatement);
    }

    public void removeTermination(IExecutionTermination termination) {
        this.terminations = this.terminations.removeAll((Object)termination);
    }
}

