/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.SourceElement;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.sort.NullSort;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionTermination;
import de.uka.ilkd.key.symbolic_execution.model.ITreeSettings;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionNode;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class ExecutionTermination
extends AbstractExecutionNode<SourceElement>
implements IExecutionTermination {
    private final IProgramVariable exceptionVariable;
    private Sort exceptionSort;
    private IExecutionTermination.TerminationKind terminationKind;

    public ExecutionTermination(ITreeSettings settings, Node proofNode, IProgramVariable exceptionVariable, IExecutionTermination.TerminationKind terminationKind) {
        super(settings, proofNode);
        this.exceptionVariable = exceptionVariable;
        this.terminationKind = terminationKind;
    }

    @Override
    protected String lazyComputeName() {
        switch (this.getTerminationKind()) {
            case EXCEPTIONAL: {
                return "<uncaught " + this.exceptionSort + ">";
            }
            case LOOP_BODY: {
                return "<loop body end>";
            }
            case BLOCK_CONTRACT_NORMAL: {
                return "<block contract end>";
            }
            case BLOCK_CONTRACT_EXCEPTIONAL: {
                return "<block contract uncaught " + this.exceptionSort + ">";
            }
        }
        return "<end>";
    }

    @Override
    public IProgramVariable getExceptionVariable() {
        return this.exceptionVariable;
    }

    @Override
    public IExecutionTermination.TerminationKind getTerminationKind() {
        if (this.terminationKind == null) {
            this.terminationKind = this.isBlockContractTermination() ? (this.isExceptionalTermination() ? IExecutionTermination.TerminationKind.BLOCK_CONTRACT_EXCEPTIONAL : IExecutionTermination.TerminationKind.BLOCK_CONTRACT_NORMAL) : (this.isExceptionalTermination() ? IExecutionTermination.TerminationKind.EXCEPTIONAL : IExecutionTermination.TerminationKind.NORMAL);
        }
        return this.terminationKind;
    }

    protected boolean isBlockContractTermination() {
        return SymbolicExecutionUtil.isBlockContractValidityBranch(this.getModalityPIO());
    }

    protected boolean isExceptionalTermination() {
        Sort sort = this.getExceptionSort();
        return sort != null && !(sort instanceof NullSort);
    }

    @Override
    public Sort getExceptionSort() {
        if (this.exceptionSort == null) {
            this.exceptionSort = SymbolicExecutionUtil.lazyComputeExceptionSort(this.getProofNode(), this.exceptionVariable);
        }
        return this.exceptionSort;
    }

    @Override
    protected IExecutionConstraint[] lazyComputeConstraints() {
        return SymbolicExecutionUtil.createExecutionConstraints(this);
    }

    @Override
    public String getElementType() {
        switch (this.getTerminationKind()) {
            case EXCEPTIONAL: {
                return "Exceptional Termination";
            }
            case LOOP_BODY: {
                return "Loop Body Termination";
            }
            case BLOCK_CONTRACT_NORMAL: {
                return "Block Contract Termination";
            }
            case BLOCK_CONTRACT_EXCEPTIONAL: {
                return "Block Contract Exceptional Termination";
            }
        }
        return "Termination";
    }

    @Override
    public boolean isBranchVerified() {
        if (IExecutionTermination.TerminationKind.BLOCK_CONTRACT_NORMAL.equals((Object)this.terminationKind) || IExecutionTermination.TerminationKind.BLOCK_CONTRACT_EXCEPTIONAL.equals((Object)this.terminationKind)) {
            return SymbolicExecutionUtil.lazyComputeIsAdditionalBranchVerified(this.getProofNode());
        }
        return SymbolicExecutionUtil.lazyComputeIsMainBranchVerified(this.getProofNode());
    }
}

