/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.ClassType;
import de.uka.ilkd.key.java.abstraction.Field;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.abstraction.Type;
import de.uka.ilkd.key.java.declaration.ArrayDeclaration;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionConstraint;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionValue;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionAllArrayIndicesVariable;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.LinkedList;
import java.util.Set;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.java.ArrayUtil;

public class ExecutionValue
extends AbstractExecutionValue {
    private final boolean valueUnknown;
    private final String valueString;
    private final String typeString;
    private final String conditionString;
    private IExecutionVariable[] childVariables;

    public ExecutionValue(Node proofNode, ExecutionVariable variable, boolean valueUnknown, Term value, String valueString, String typeString, Term condition, String conditionString) {
        super(variable.getSettings(), proofNode, variable, condition, value);
        this.valueUnknown = valueUnknown;
        this.valueString = valueString;
        this.typeString = typeString;
        this.conditionString = conditionString;
    }

    @Override
    public boolean isValueUnknown() throws ProofInputException {
        return this.valueUnknown;
    }

    @Override
    public String getValueString() throws ProofInputException {
        return this.valueString;
    }

    @Override
    public String getTypeString() throws ProofInputException {
        return this.typeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExecutionVariable[] getChildVariables() throws ProofInputException {
        ExecutionValue executionValue = this;
        synchronized (executionValue) {
            if (this.childVariables == null) {
                this.childVariables = this.lazyComputeChildVariables();
            }
            return this.childVariables;
        }
    }

    protected IExecutionVariable[] lazyComputeChildVariables() throws ProofInputException {
        LinkedList<ExecutionVariable> children;
        block14: {
            KeYJavaType keyType;
            Sort valueSort;
            children = new LinkedList<ExecutionVariable>();
            if (this.isDisposed()) break block14;
            Services services = this.getServices();
            Term value = this.getValue();
            if (value != null && !this.isValueUnknown() && (valueSort = value.sort()) != services.getJavaInfo().getNullType().getSort() && (keyType = services.getJavaInfo().getKeYJavaType(valueSort)) != null) {
                Type javaType = keyType.getJavaType();
                if (javaType instanceof ArrayDeclaration) {
                    ArrayDeclaration ad = (ArrayDeclaration)javaType;
                    Set<IProgramVariable> pvs = SymbolicExecutionUtil.getProgramVariables(ad.length());
                    if (pvs.size() == 1) {
                        ExecutionVariable lengthVariable = new ExecutionVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, pvs.iterator().next(), this.getVariable().getAdditionalCondition());
                        children.add(lengthVariable);
                        Object[] lengthValues = lengthVariable.getValues();
                        if (!ArrayUtil.isEmpty((Object[])lengthValues)) {
                            for (Object lengthValue : lengthValues) {
                                try {
                                    int length = this.getSettings().isUsePrettyPrinting() ? Integer.valueOf(((ExecutionValue)lengthValue).getValueString()) : Integer.valueOf(SymbolicExecutionUtil.formatTerm(((AbstractExecutionValue)lengthValue).getValue(), services, false, true));
                                    for (int i = 0; i < length; ++i) {
                                        Term indexTerm = services.getTermBuilder().zTerm((long)i);
                                        ExecutionVariable childI = new ExecutionVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, indexTerm, (ExecutionValue)lengthValue, this.getVariable().getAdditionalCondition());
                                        children.add(childI);
                                    }
                                }
                                catch (NumberFormatException e) {
                                    ExecutionAllArrayIndicesVariable arrayStarVariable = new ExecutionAllArrayIndicesVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, (IProgramVariable)value.op(), this.getVariable().getAdditionalCondition());
                                    children.add(arrayStarVariable);
                                }
                            }
                        } else {
                            ExecutionAllArrayIndicesVariable arrayStarVariable = new ExecutionAllArrayIndicesVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, (IProgramVariable)value.op(), this.getVariable().getAdditionalCondition());
                            children.add(arrayStarVariable);
                        }
                    } else {
                        ExecutionAllArrayIndicesVariable arrayStarVariable = new ExecutionAllArrayIndicesVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, (IProgramVariable)value.op(), this.getVariable().getAdditionalCondition());
                        children.add(arrayStarVariable);
                    }
                } else if (javaType instanceof ClassType) {
                    ImmutableList fields = ((ClassType)javaType).getAllFields(services);
                    for (Field field : fields) {
                        ImmutableList vars = services.getJavaInfo().getAllAttributes(field.getFullName(), keyType);
                        for (ProgramVariable var : vars) {
                            if (var.isImplicit() || var.isStatic()) continue;
                            children.add(new ExecutionVariable(this.getVariable().getParentNode(), this.getVariable().getProofNode(), this.getVariable().getModalityPIO(), this, field.getProgramVariable(), this.getVariable().getAdditionalCondition()));
                        }
                    }
                }
            }
        }
        return children.toArray(new IExecutionVariable[children.size()]);
    }

    @Override
    public String getConditionString() throws ProofInputException {
        return this.conditionString;
    }

    @Override
    public ExecutionVariable getVariable() {
        return (ExecutionVariable)super.getVariable();
    }

    @Override
    protected IExecutionConstraint[] getNodeConstraints() {
        return this.getVariable().getParentNode().getConstraints();
    }
}

