/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.symbolic_execution.model.IExecutionNode;
import de.uka.ilkd.key.symbolic_execution.model.impl.AbstractExecutionVariable;
import de.uka.ilkd.key.symbolic_execution.model.impl.ExecutionValue;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionSideProofUtil;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.key_project.util.collection.ImmutableList;

public class ExecutionVariable
extends AbstractExecutionVariable {
    private final IExecutionNode<?> parentNode;
    private final ExecutionValue lengthValue;
    private ExecutionValue[] values;

    public ExecutionVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, IProgramVariable programVariable, Term additionalCondition) {
        this(parentNode, proofNode, modalityPIO, null, programVariable, additionalCondition);
    }

    public ExecutionVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, ExecutionValue parentValue, IProgramVariable programVariable, Term additionalCondition) {
        super(parentNode.getSettings(), proofNode, programVariable, parentValue, null, additionalCondition, modalityPIO);
        assert (programVariable != null);
        assert (modalityPIO != null);
        this.parentNode = parentNode;
        this.lengthValue = null;
    }

    public ExecutionVariable(IExecutionNode<?> parentNode, Node proofNode, PosInOccurrence modalityPIO, ExecutionValue parentValue, Term arrayIndex, ExecutionValue lengthValue, Term additionalCondition) {
        super(parentNode.getSettings(), proofNode, null, parentValue, arrayIndex, additionalCondition, modalityPIO);
        assert (modalityPIO != null);
        this.parentNode = parentNode;
        this.lengthValue = lengthValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionValue[] getValues() throws ProofInputException {
        ExecutionVariable executionVariable = this;
        synchronized (executionVariable) {
            if (this.values == null) {
                this.values = this.lazyComputeValues();
            }
            return this.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutionValue[] lazyComputeValues() throws ProofInputException {
        InitConfig initConfig = this.getInitConfig();
        if (initConfig != null) {
            SymbolicExecutionUtil.SiteProofVariableValueInput sequentToProve;
            ProofEnvironment sideProofEnv = SymbolicExecutionSideProofUtil.cloneProofEnvironmentWithOwnOneStepSimplifier(initConfig, true);
            Services services = sideProofEnv.getServicesForEnvironment();
            TermBuilder tb = services.getTermBuilder();
            Term siteProofSelectTerm = null;
            Term siteProofCondition = this.getAdditionalCondition() != null ? this.getAdditionalCondition() : tb.tt();
            if (this.getParentValue() != null || SymbolicExecutionUtil.isStaticVariable(this.getProgramVariable())) {
                siteProofSelectTerm = this.createSelectTerm();
                if (this.getParentValue() != null) {
                    siteProofCondition = tb.and(siteProofCondition, this.getParentValue().getCondition());
                }
                if (this.lengthValue != null) {
                    siteProofCondition = tb.and(siteProofCondition, this.lengthValue.getCondition());
                }
                sequentToProve = SymbolicExecutionUtil.createExtractTermSequent(services, this.getProofNode(), this.getModalityPIO(), siteProofCondition, siteProofSelectTerm, true);
            } else {
                sequentToProve = SymbolicExecutionUtil.createExtractVariableValueSequent(services, this.getProofNode(), this.getModalityPIO(), siteProofCondition, this.getProgramVariable());
            }
            ApplyStrategyInfo info = SymbolicExecutionSideProofUtil.startSideProof(this.getProof(), sideProofEnv, sequentToProve.getSequentToProve(), "METHOD_NONE", "LOOP_NONE", "QUERY_OFF", "SPLITTING_DELAYED");
            try {
                ExecutionValue[] executionValueArray = this.instantiateValuesFromSideProof(initConfig, services, tb, info, sequentToProve.getOperator(), siteProofSelectTerm, siteProofCondition);
                return executionValueArray;
            }
            finally {
                SymbolicExecutionSideProofUtil.disposeOrStore("Value computation on node " + this.getProofNode().serialNr(), info);
            }
        }
        return null;
    }

    protected ExecutionValue[] instantiateValuesFromSideProof(InitConfig initConfig, Services services, TermBuilder tb, ApplyStrategyInfo info, Operator resultOperator, Term siteProofSelectTerm, Term siteProofCondition) throws ProofInputException {
        ArrayList<ExecutionValue> result = new ArrayList<ExecutionValue>(info.getProof().openGoals().size());
        LinkedHashMap<Term, List<Goal>> valueMap = new LinkedHashMap<Term, List<Goal>>();
        LinkedList<Goal> unknownValues = new LinkedList<Goal>();
        this.groupGoalsByValue((ImmutableList<Goal>)info.getProof().openGoals(), resultOperator, siteProofSelectTerm, siteProofCondition, valueMap, unknownValues, services);
        for (Map.Entry valueEntry : valueMap.entrySet()) {
            Term value = (Term)valueEntry.getKey();
            if (!this.isValidValue(value)) continue;
            String valueString = this.formatTerm(value, services);
            String typeString = value.sort().toString();
            Term condition = this.computeValueCondition(tb, (List)valueEntry.getValue(), initConfig);
            String conditionString = null;
            if (condition != null) {
                conditionString = this.formatTerm(condition, services);
            }
            result.add(new ExecutionValue(this.getProofNode(), this, false, value, valueString, typeString, condition, conditionString));
        }
        if (!unknownValues.isEmpty()) {
            Term condition = this.computeValueCondition(tb, unknownValues, initConfig);
            String conditionString = null;
            if (condition != null) {
                conditionString = this.formatTerm(condition, services);
            }
            result.add(new ExecutionValue(this.getProofNode(), this, true, null, null, null, condition, conditionString));
        }
        return result.toArray(new ExecutionValue[result.size()]);
    }

    protected boolean isValidValue(Term value) {
        return true;
    }

    protected void groupGoalsByValue(ImmutableList<Goal> goals, Operator operator, Term siteProofSelectTerm, Term siteProofCondition, Map<Term, List<Goal>> valueMap, List<Goal> unknownValues, Services services) throws ProofInputException {
        for (Goal goal : goals) {
            Term value = SymbolicExecutionSideProofUtil.extractOperatorValue(goal, operator);
            assert (value != null);
            value = SymbolicExecutionUtil.replaceSkolemConstants(goal.sequent(), value, services);
            boolean unknownValue = false;
            if (siteProofSelectTerm != null) {
                unknownValue = SymbolicExecutionUtil.isNullSort(value.sort(), services) ? SymbolicExecutionUtil.isNull(this.getProofNode(), siteProofCondition, siteProofSelectTerm) : SymbolicExecutionUtil.isNotNull(this.getProofNode(), siteProofCondition, siteProofSelectTerm);
            }
            if (unknownValue) {
                unknownValues.add(goal);
                continue;
            }
            List<Goal> valueList = valueMap.get(value);
            if (valueList == null) {
                valueList = new LinkedList<Goal>();
                valueMap.put(value, valueList);
            }
            valueList.add(goal);
        }
    }

    protected Term computeValueCondition(TermBuilder tb, List<Goal> valueGoals, InitConfig initConfig) throws ProofInputException {
        if (!valueGoals.isEmpty()) {
            LinkedList<Term> pathConditions = new LinkedList<Term>();
            Proof proof = null;
            for (Goal valueGoal : valueGoals) {
                pathConditions.add(SymbolicExecutionUtil.computePathCondition(valueGoal.node(), this.getSettings().isSimplifyConditions(), false));
                proof = valueGoal.node().proof();
            }
            Term comboundPathCondition = tb.or(pathConditions);
            if (this.getSettings().isSimplifyConditions()) {
                comboundPathCondition = SymbolicExecutionUtil.simplify(initConfig, proof, comboundPathCondition);
            }
            comboundPathCondition = SymbolicExecutionUtil.improveReadability(comboundPathCondition, initConfig.getServices());
            return comboundPathCondition;
        }
        return tb.tt();
    }

    @Override
    public Term createSelectTerm() {
        return SymbolicExecutionUtil.createSelectTerm(this);
    }

    @Override
    public ExecutionValue getParentValue() {
        return (ExecutionValue)super.getParentValue();
    }

    public IExecutionNode<?> getParentNode() {
        return this.parentNode;
    }

    public ExecutionValue getLengthValue() {
        return this.lengthValue;
    }
}

