/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.object_model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.symbolic_execution.object_model.IModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicAssociation;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicObject;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.AbstractElement;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class SymbolicAssociation
extends AbstractElement
implements ISymbolicAssociation {
    private final Services services;
    private final Term arrayIndex;
    private final Term arrayStartIndex;
    private final Term arrayEndIndex;
    private final IProgramVariable programVariable;
    private final ISymbolicObject target;
    private final Term condition;

    public SymbolicAssociation(Services services, Term arrayIndex, ISymbolicObject target, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (target != null);
        this.services = services;
        this.programVariable = null;
        this.arrayIndex = arrayIndex;
        this.target = target;
        this.condition = condition;
        this.arrayStartIndex = null;
        this.arrayEndIndex = null;
    }

    public SymbolicAssociation(Services services, Term arrayIndex, Term arrayStartIndex, Term arrayEndIndex, ISymbolicObject target, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (target != null);
        this.services = services;
        this.programVariable = null;
        this.arrayIndex = arrayIndex;
        this.target = target;
        this.condition = condition;
        this.arrayStartIndex = arrayStartIndex;
        this.arrayEndIndex = arrayEndIndex;
    }

    public SymbolicAssociation(Services services, IProgramVariable programVariable, ISymbolicObject target, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (programVariable != null);
        assert (target != null);
        this.services = services;
        this.programVariable = programVariable;
        this.target = target;
        this.arrayIndex = null;
        this.condition = condition;
        this.arrayStartIndex = null;
        this.arrayEndIndex = null;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer();
        if (this.isArrayRange()) {
            sb.append("[");
            if (this.getArrayStartIndex() != null) {
                sb.append(this.getArrayIndexString());
                sb.append(" >= ");
                sb.append(this.getArrayStartIndexString());
            }
            if (this.getArrayStartIndex() != null && this.getArrayEndIndex() != null) {
                sb.append(" and ");
            }
            if (this.getArrayEndIndex() != null) {
                sb.append(this.getArrayIndexString());
                sb.append(" <= ");
                sb.append(this.getArrayEndIndexString());
            }
            sb.append("]");
        } else if (this.isArrayIndex()) {
            sb.append("[");
            sb.append(this.getArrayIndexString());
            sb.append("]");
        } else {
            sb.append(this.getProgramVariableString());
        }
        if (this.condition != null && this.condition.op() != Junctor.TRUE) {
            sb.append(" {");
            sb.append(this.getConditionString());
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public boolean isArrayIndex() {
        return this.arrayIndex != null && (this.arrayStartIndex == null || this.arrayEndIndex == null);
    }

    public boolean isArrayRange() {
        return this.arrayStartIndex != null && this.arrayEndIndex != null;
    }

    @Override
    public Term getArrayIndex() {
        return this.arrayIndex;
    }

    @Override
    public IProgramVariable getProgramVariable() {
        return this.programVariable;
    }

    @Override
    public String getProgramVariableString() {
        return SymbolicExecutionUtil.getDisplayString(this.programVariable);
    }

    @Override
    public ISymbolicObject getTarget() {
        return this.target;
    }

    public String toString() {
        return "Association " + this.getName() + " to " + this.getTarget();
    }

    @Override
    public Term getCondition() {
        return this.condition;
    }

    @Override
    public String getConditionString() {
        return this.condition != null ? this.formatTerm(this.condition, this.services) : null;
    }

    @Override
    public String getArrayIndexString() {
        return this.arrayIndex != null ? this.formatTerm(this.arrayIndex, this.services) : null;
    }

    public Term getArrayStartIndex() {
        return this.arrayStartIndex;
    }

    public String getArrayStartIndexString() {
        return this.arrayStartIndex != null ? this.formatTerm(this.arrayStartIndex, this.services) : null;
    }

    public Term getArrayEndIndex() {
        return this.arrayEndIndex;
    }

    public String getArrayEndIndexString() {
        return this.arrayEndIndex != null ? this.formatTerm(this.arrayEndIndex, this.services) : null;
    }
}

