/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.object_model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.symbolic_execution.object_model.IModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicEquivalenceClass;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.AbstractElement;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.key_project.util.java.CollectionUtil;
import org.key_project.util.java.IFilter;

public class SymbolicEquivalenceClass
extends AbstractElement
implements ISymbolicEquivalenceClass {
    private final Services services;
    private ImmutableList<Term> terms;

    public SymbolicEquivalenceClass(Services services, IModelSettings settings) {
        this(services, (ImmutableList<Term>)ImmutableSLList.nil(), settings);
    }

    public SymbolicEquivalenceClass(Services services, ImmutableList<Term> terms, IModelSettings settings) {
        super(settings);
        this.services = services;
        this.terms = terms;
    }

    @Override
    public ImmutableList<Term> getTerms() {
        return this.terms;
    }

    public void addTerm(Term term) {
        this.terms = this.terms.append((Object)OriginTermLabel.removeOriginLabels((Term)term, (Services)this.services));
    }

    @Override
    public boolean containsTerm(Term term) {
        return this.terms.contains((Object)OriginTermLabel.removeOriginLabels((Term)term, (Services)this.services));
    }

    @Override
    public ImmutableList<String> getTermStrings() {
        ImmutableSLList strings = ImmutableSLList.nil();
        for (Term term : this.terms) {
            strings = strings.append((Object)this.formatTerm(term, this.services));
        }
        return strings;
    }

    @Override
    public Term getRepresentative() {
        final HeapLDT heapLDT = this.services.getTypeConverter().getHeapLDT();
        Term nullTerm = (Term)CollectionUtil.search(this.terms, (IFilter)new IFilter<Term>(){

            public boolean select(Term element) {
                return element.op() == heapLDT.getNull();
            }
        });
        if (nullTerm != null) {
            return nullTerm;
        }
        Term representative = (Term)CollectionUtil.search(this.terms, (IFilter)new IFilter<Term>(){

            public boolean select(Term element) {
                return element.op() instanceof IProgramVariable;
            }
        });
        return representative != null ? representative : (Term)this.terms.head();
    }

    @Override
    public String getRepresentativeString() {
        Term representative = this.getRepresentative();
        if (representative != null) {
            return this.formatTerm(representative, this.services);
        }
        return null;
    }

    public String toString() {
        return "Equivalence Class " + this.getTermStrings();
    }
}

