/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.symbolic_execution.object_model.impl;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.Junctor;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.symbolic_execution.object_model.IModelSettings;
import de.uka.ilkd.key.symbolic_execution.object_model.ISymbolicValue;
import de.uka.ilkd.key.symbolic_execution.object_model.impl.AbstractElement;
import de.uka.ilkd.key.symbolic_execution.util.SymbolicExecutionUtil;

public class SymbolicValue
extends AbstractElement
implements ISymbolicValue {
    private final Services services;
    private final Term arrayIndex;
    private final Term arrayStartIndex;
    private final Term arrayEndIndex;
    private final IProgramVariable programVariable;
    private final Term value;
    private final Term condition;

    public SymbolicValue(Services services, Term arrayIndex, Term value, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (arrayIndex != null);
        this.services = services;
        this.programVariable = null;
        this.arrayIndex = arrayIndex;
        this.value = value;
        this.condition = condition;
        this.arrayStartIndex = null;
        this.arrayEndIndex = null;
    }

    public SymbolicValue(Services services, Term arrayIndex, Term arrayStartIndex, Term arrayEndIndex, Term value, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (arrayIndex != null);
        this.services = services;
        this.programVariable = null;
        this.arrayIndex = arrayIndex;
        this.value = value;
        this.condition = condition;
        this.arrayStartIndex = arrayStartIndex;
        this.arrayEndIndex = arrayEndIndex;
    }

    public SymbolicValue(Services services, IProgramVariable programVariable, Term value, Term condition, IModelSettings settings) {
        super(settings);
        assert (services != null);
        assert (programVariable != null);
        this.services = services;
        this.programVariable = programVariable;
        this.value = value;
        this.arrayIndex = null;
        this.condition = condition;
        this.arrayStartIndex = null;
        this.arrayEndIndex = null;
    }

    @Override
    public String getName() {
        StringBuffer sb = new StringBuffer();
        if (this.isArrayRange()) {
            sb.append("[");
            if (this.getArrayStartIndex() != null) {
                sb.append(this.getArrayIndexString());
                sb.append(" >= ");
                sb.append(this.getArrayStartIndexString());
            }
            if (this.getArrayStartIndex() != null && this.getArrayEndIndex() != null) {
                sb.append(" and ");
            }
            if (this.getArrayEndIndex() != null) {
                sb.append(this.getArrayIndexString());
                sb.append(" <= ");
                sb.append(this.getArrayEndIndexString());
            }
            sb.append("]");
        } else if (this.isArrayIndex()) {
            sb.append("[");
            sb.append(this.getArrayIndexString());
            sb.append("]");
        } else {
            sb.append(this.getProgramVariableString());
        }
        if (this.condition != null && this.condition.op() != Junctor.TRUE) {
            sb.append(" {");
            sb.append(this.getConditionString());
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public boolean isArrayIndex() {
        return this.arrayIndex != null && (this.arrayStartIndex == null || this.arrayEndIndex == null);
    }

    public boolean isArrayRange() {
        return this.arrayStartIndex != null && this.arrayEndIndex != null;
    }

    @Override
    public Term getArrayIndex() {
        return this.arrayIndex;
    }

    @Override
    public IProgramVariable getProgramVariable() {
        return this.programVariable;
    }

    @Override
    public String getProgramVariableString() {
        return SymbolicExecutionUtil.getDisplayString(this.programVariable);
    }

    @Override
    public Term getValue() {
        return this.value;
    }

    @Override
    public String getValueString() {
        return this.formatTerm(this.value, this.services);
    }

    @Override
    public Sort getType() {
        return this.value != null ? this.value.sort() : null;
    }

    @Override
    public String getTypeString() {
        Sort sort = this.getType();
        return sort != null ? sort.toString() : null;
    }

    public String toString() {
        return "Value of " + this.getName() + " is " + this.getValueString();
    }

    @Override
    public Term getCondition() {
        return this.condition;
    }

    @Override
    public String getConditionString() {
        return this.condition != null ? this.formatTerm(this.condition, this.services) : null;
    }

    @Override
    public String getArrayIndexString() {
        return this.arrayIndex != null ? this.formatTerm(this.arrayIndex, this.services) : null;
    }

    public Term getArrayStartIndex() {
        return this.arrayStartIndex;
    }

    public String getArrayStartIndexString() {
        return this.arrayStartIndex != null ? this.formatTerm(this.arrayStartIndex, this.services) : null;
    }

    public Term getArrayEndIndex() {
        return this.arrayEndIndex;
    }

    public String getArrayEndIndexString() {
        return this.arrayEndIndex != null ? this.formatTerm(this.arrayEndIndex, this.services) : null;
    }
}

